import { NgModule } from "@angular/core";
import { RouterModule, Routes } from "@angular/router";
import { EmployeeOperationMainComponent } from "./employee-operation-main/employee-operation-main.component";
import { ConstantURLs } from "../../shared/models/constants/constant-URL";
import { HereMapComponent } from "./maps/here-map/here-map.component";
import { AuthGuard } from '../../core/auth/auth.gurad';


const employeeRouting: Routes = [
  {
    path: "",
    component: EmployeeOperationMainComponent,
    children: [
      {
        path: ConstantURLs.mapsTrackingURL,
        canActivate: [AuthGuard],
        component: HereMapComponent
      }, {
        path: ConstantURLs.endorsementURL,
        canActivate: [AuthGuard],
        component: HereMapComponent
      },
      { path: '', redirectTo: '/' + ConstantURLs.employeeOperationURL + '/' + ConstantURLs.employeeKeysURL, pathMatch: 'full' }
    ]
  }
];
@NgModule({
  imports: [RouterModule.forChild(employeeRouting)],
  exports: [RouterModule]
})
export class EmployeeOperationRoutingModule { }
