import { NgModule } from "@angular/core";
import { CommonModule } from "@angular/common";
import { ReactiveFormsModule, FormsModule } from "@angular/forms";
import { EmployeeOperationRoutingModule } from "./employee-operation-routing.module";
import { SharedModule } from "../../shared/shared.module";
import { NgbModule } from "@ng-bootstrap/ng-bootstrap";
import { TranslateModule } from "@ngx-translate/core";
import { NgSelectModule } from "@ng-select/ng-select";
import { AvatarModule } from "ngx-avatar";
import { NgxTimerModule } from "ngx-timer";

import { NgOptionHighlightModule } from "@ng-select/ng-option-highlight";

import { NgxGalleryModule } from "@kolkov/ngx-gallery";
import { AngularMultiSelectModule } from "angular2-multiselect-dropdown";
import { NgMultiSelectDropDownModule } from "ng-multiselect-dropdown";
import { HereMapComponent } from "./maps/here-map/here-map.component";
import { ModalBasicComponent } from "./maps/modal-basic/modal-basic.component";
import { EmployeeOperationMainComponent } from "./employee-operation-main/employee-operation-main.component";


@NgModule({
  declarations: [
    HereMapComponent,
    ModalBasicComponent,
    EmployeeOperationMainComponent
  ],
  imports: [
    CommonModule,
    FormsModule,
    ReactiveFormsModule,
    EmployeeOperationRoutingModule,
    SharedModule,
    NgbModule,
    NgSelectModule,
    AvatarModule,
    NgxTimerModule,
    NgOptionHighlightModule,
    NgxGalleryModule,
    TranslateModule.forChild(),
    AngularMultiSelectModule,
    NgMultiSelectDropDownModule,
  ],
  exports: [],
})
export class EmployeeOperationModule { }
