import { Component, OnInit, ViewChild, ElementRef, NgModule, Renderer2, OnDestroy, AfterViewInit } from '@angular/core';
import { HereMapService } from '../here-maps.service';
import { EmployeeTrackingModel } from '../../../../shared/models/tracking/employeeTracking.model';
import { CoreSession } from '../../../../core/core.session';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { ModalBasicComponent } from '../modal-basic/modal-basic.component';
import { FormGroup, FormControl } from '@angular/forms';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { TranslateService } from '@ngx-translate/core';
import { HttpErrorResponse } from '@angular/common/http';
import { ConnectionService } from 'ng-connection-service';
import * as L from 'leaflet';
import { latLng } from 'leaflet';
import * as leaflet from 'leaflet';

declare var H: any;
var map;
//var marker;
var markerList = [];
// @NgModule({
//   declarations: [
//     HereMapComponent
//   ],
//   imports: [
//     NgbModule//.forRoot()
//   ]
// })

@Component({
  selector: 'app-here-map',
  templateUrl: './here-map.component.html',
  styleUrls: ['./here-map.component.css']
})
export class HereMapComponent implements OnInit, OnDestroy, AfterViewInit {
  private ui: any;
  private platform: any;
  private map: any;
  private vehiclesList: EmployeeTrackingModel[] = [];
  private icon: any;
  private marker: any;
  private markersGroup: any;
  public employeeDetails: any;
  public empId: any;
  public empDescription: any;
  public EmployeeDescription: string = "Select Employee";
  public top: number;
  isEmpOnHover: boolean = false;
  isFilterOpened = false;
  filterForm: FormGroup = new FormGroup({});
  selectedEmployeeId: any;
  showSlider = false;
  showVanRouteData = false;
  latitude: string | any;
  longitude: string | any;
  options: any;
  @ViewChild("content") content: ModalBasicComponent;

  @ViewChild("map", { static: true })
  public mapElement: ElementRef;

  @ViewChild("empName", { static: true }) empNameElement: ElementRef;
  mapServiceUnavailable: boolean = false;

  // The scripts below are dynamically added to HTML body to configure Here Maps Services.
  scripts = [
    { 'src': 'https://js.api.here.com/v3/3.0/mapsjs-core.js', 'type': 'text/javascript', 'charset': 'utf-8' },
    { 'src': 'https://js.api.here.com/v3/3.0/mapsjs-service.js', 'type': 'text/javascript', 'charset': 'utf-8' },
    { 'src': 'https://js.api.here.com/v3/3.0/mapsjs-places.js', 'type': 'text/javascript', 'charset': 'utf-8' },
    { 'src': 'https://js.api.here.com/v3/3.0/mapsjs-mapevents.js', 'type': 'text/javascript', 'charset': 'utf-8' },
    { 'src': 'https://js.api.here.com/v3/3.0/mapsjs-ui.js', 'type': 'text/javascript', 'charset': 'utf-8' },
  ];
  networkConnectionStateSubscription;
  resourcesLoaded: boolean = false;
  public constructor(private hereMapService: HereMapService,
    private coreSession: CoreSession,
    private renderer: Renderer2,
    private translateService: TranslateService,
    private connectionService: ConnectionService) {
    if (navigator.onLine) { // if internet is connected
      // var i = 0;
      // this.prepareMapServices(i);
      //this.checkHereServiceAvailability();
    } else { // if no internet connection, do not load map, display network error message.
      this.mapServiceUnavailable = true;
    }
  }
  ngAfterViewInit(): void {
    this.initFilterForm();
    this.afterViewInit();
  }

  checkHereServiceAvailability() {

    this.hereMapService.checkHereMapsAvailability().subscribe(response => {

      if (response && response.status >= 0 && response.data) {
        var i = 0;
        this.prepareMapServices(i);
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant('Error occured at "js.api.here.com"'));
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant('Error occured at "js.api.here.com"'));
    });
  }

  prepareMapServices(startIdx: number) {

    var loadNextSource = true;
    this.loadScript(this.scripts[startIdx]['src'], this.scripts[startIdx]['type'], this.scripts[startIdx]['charset'], 'src' + (startIdx + 1).toString()
    ).then(() => { // loaded successfully

      // console.log( this.scripts[startIdx]['src'], ' Loaded, H: ', H);
      if (loadNextSource) {
        if ((startIdx + 1) < this.scripts.length) {
          startIdx++;
          this.prepareMapServices(startIdx);
        } else {
          this.afterResourcesLoad();
        }
      }
    }, () => { // not loaded

      loadNextSource = false;
      this.mapServiceUnavailable = true;
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant('A network error occured, map services are currently unavailable.'));
    });
  }

  loadScript(src: string, type: string, charset: string, id: string) {

    return new Promise((resolve, reject) => {
      if (!document.getElementById(id)) {
        const script = document.createElement('script')
        script.type = type;
        script.charset = charset;
        script.id = id;
        script.onload = resolve;
        script.onerror = reject;
        script.src = src;
        document.getElementsByTagName('body')[0].appendChild(script);
      } else {
        resolve(null);
      }
    })
  }

  afterResourcesLoad() {
    this.resourcesLoaded = true;

    this.checkMapResources().then(() => { // map source exists
      // console.log('RESOLVED');

      // setTimeout(() => {

      if (!this.mapServiceUnavailable
        && H && H != undefined && H.service && H.service != undefined
      ) {
        this.coreSession.ModalLoading.Show();
        this.platform = new H.service.Platform({
          useCIT: true,
          app_id: "SXw9u0a2JdpTuPzuWYss",
          app_code: "Yp92GERdCKl1PHmcUnBHjw",
          useHTTPS: true
        });

        // this.initFilterForm();
        this.prepareMapVehicles();
        setTimeout(() => {
          window.location.reload();
        }, 180000);
      } else {  // map source does not exist

        this.mapServiceUnavailable = true;
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant('A network error occured, map services are currently unavailable.'));
      }
      this.afterViewInit();
      // }, 1);
    }).catch((err) => {/*console.log('catch',err)*/; this.mapServiceUnavailable = true;
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant('A network error occured, map services are currently unavailable.'));
    });
  }

  checkMapResources() {
    var promise = new Promise<void>((resolve, reject) => {
      // setTimeout(() => {
      if (this.checkLoadedScripts()) {

        resolve();
      } else {

        reject();
      }
      // }, 1);
    });
    return promise;
  }
  public checkLoadedScripts(): boolean {
    var result = true;
    var i = 0;
    this.scripts.forEach(s => {
      if (document.getElementById('src' + (i + 1).toString())) {
        // console.log('element Exists ', document.getElementById('src'+(i + 1).toString()))
      } else {
        result = false;
      }
      i++;
    });
    return result;
  }

  public ngOnInit() {
    if (this.mapServiceUnavailable) {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant('A network error occured, map services are currently unavailable.'));
    }
    this.initFilterForm();
    this.subscribeToConnectionState();
    // this.coreSession.ModalLoading.Show();
    // this.platform = new H.service.Platform({
    //   useCIT: true,
    //   app_id: "SXw9u0a2JdpTuPzuWYss",
    //   app_code: "Yp92GERdCKl1PHmcUnBHjw",
    //   useHTTPS: true
    // });

    // this.initFilterForm();
    // this.prepareMapVehicles();
  }

  ngOnDestroy(): void {
    if (this.networkConnectionStateSubscription) this.networkConnectionStateSubscription.unsubscribe();
  }

  subscribeToConnectionState() {
    this.networkConnectionStateSubscription =
      this.connectionService.monitor().subscribe(isConnected => {
        // console.log('internet connection -> here - maps component')
        // this.coreSession.isInternetConnected = isConnected;
        if (isConnected) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgConnectionRestoredRefresh));
          this.enableScreen();
        }
        else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgChattingNetworkError));
          this.disableScreen();
        }
      });
    // this.networkConnectionStateSubscription =
    //   this.coreSession.connectionState.subscribe((isConnected) => {
    //     if(!isConnected) {
    //       this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgMapsNetworkError));
    //       this.disableScreen();
    //     } else {
    //       this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgConnectionRestoredRefresh));
    //       this.enableScreen();
    //     }
    //   });
  }

  disableScreen() {
    this.mapServiceUnavailable = true;
    this.resourcesLoaded = false;
    this.close();
  }
  enableScreen() {
    this.mapServiceUnavailable = false;
  }


  public afterViewInit() {

    var thisComponent = this;
    this.resourcesLoaded = true;
    // function onEachFeature() {
    //   map.on('click', function (e) {
    //     if (marker) {
    //       map.removeLayer(marker);
    //     }
    //     debugger;
    //     this.latitude = e.latlng.lat;
    //     this.longitude = e.latlng.lng;
    //     marker = new L.marker([this.latitude, this.longitude], markerOptions).addTo(map);
    //   });
    // }
    if (!this.latitude || !this.longitude) {
      this.latitude = '31.959025';
      this.longitude = '35.905618';
    }

    if (map != undefined) map.remove();
    this.options = {
      center: latLng(this.latitude, this.longitude),
      zoom: 14,
      // minZoom: 15,
      // maxZoom: 17,
      zoomControl: true,
    };
    this.prepareMapVehicles();
    map = new leaflet.map('mapId', this.options);
    var layer = new L.TileLayer('http://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', { maxZoom: 19 }, { attribution: "Map data ..." });
    map.addLayer(layer);
  }
  prepareMapVehicles() {
    markerList = [];
    this.hereMapService.getVehicleLocations(this.selectedEmployeeId).subscribe(result => {
      this.vehiclesList = result;
      if (this.vehiclesList && this.vehiclesList.length > 0) {
        for (var i = 0; i < this.vehiclesList.length; i++) {
          var iconOptions = {
            iconUrl: this.coreSession.baseURL + 'assets/img/van-2.png',
            iconSize: [30, 30]
          }
          // Creating a custom icon
          var customIcon = L.icon(iconOptions);
          var markerOptions = {
            title: this.vehiclesList[i].employeeID.toString() + '-' + this.vehiclesList[i].description.toString(),
            clickable: true,
            draggable: false,
            icon: customIcon,
            someCustomProperty: this.vehiclesList[i]
          }

          var marker = L.marker([this.vehiclesList[i].gpsLatitude, this.vehiclesList[i].gpsLongitude], markerOptions).on('click', this.onClick.bind(this));
          marker.addTo(map);
          //var group = new L.featureGroup(marker);
          //map.fitBounds(group.getBounds());
          markerList.push(marker);
          var featureGroup = L.featureGroup(markerList).addTo(map);
          map.fitBounds(featureGroup.getBounds());
        }
        // marker.addLayers(markerList);

        // marker.on('click', function () { // called when the specific marker is added to the map
        //   debugger;
        //   console.log('click');
        //   this.showSlider = true;
        // });
        // featureGroup.on("click", function (event) {

        //   // do some stuff…
        // }).addto(map);

        marker.addTo(map);
      }
      //   this.icon = new H.map.Icon(this.coreSession.baseURL + 'assets/img/van-2.png');
      //   this.markersGroup = new H.map.Group();

      //   for (let i = 0; i < this.vehiclesList.length; i++) {
      //     this.dropMarker({ "lat": this.vehiclesList[i].gpsLatitude, "lng": this.vehiclesList[i].gpsLongitude }, this.vehiclesList[i].employeeID.toString() + '-' + this.vehiclesList[i].description.toString());
      //   }
      //   this.map.setViewBounds(this.markersGroup.getBounds());
      //   this.map.addObject(this.markersGroup);
      // }
      this.coreSession.ModalLoading.Hide();
    });
  }
  private onClick(e) {
    //this.employeeDetails = e.target.P;
    let splittedEmpDetails = e.target.options.someCustomProperty;//this.employeeDetails.toString().split('-');

    this.empId = splittedEmpDetails.employeeID;
    this.empDescription = splittedEmpDetails.description;
    // if (!this.mapServiceUnavailable && this.resourcesLoaded) {
    this.showVanRouteDataSlider();
    // } else if (this.mapServiceUnavailable) {
    //   this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgMapsNetworkError));
    // } else if (!this.resourcesLoaded) {
    //   this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgRefreshPage));
    // }
  }
  // prepareMapVehiclesLeaflet() {
  //   this.hereMapService.getVehicleLocations(this.selectedEmployeeId).subscribe(result => {
  //     this.vehiclesList = result;
  //     if (this.vehiclesList && this.vehiclesList.length > 0) {


  //       for (var i = 0; i < this.vehiclesList.length; i++) {
  //         var item = this.vehiclesList[i];

  //         marker = new L.marker([this.vehiclesList[i].gpsLatitude, this.vehiclesList[i].gpsLongitude], {
  //           icon: this.coreSession.baseURL + 'assets/img/van-2.png'
  //         }).bindPopup(item[1]);

  //         markerList.push(marker);
  //       }

  //       marker.addLayers(markerList);


  //       this.icon = new H.map.Icon(this.coreSession.baseURL + 'assets/img/van-2.png');
  //       this.markersGroup = new H.map.Group();

  //       for (let i = 0; i < this.vehiclesList.length; i++) {
  //         this.dropMarker({ "lat": this.vehiclesList[i].gpsLatitude, "lng": this.vehiclesList[i].gpsLongitude }, this.vehiclesList[i].employeeID.toString() + '-' + this.vehiclesList[i].description.toString());
  //       }
  //     }
  //     this.coreSession.ModalLoading.Hide();
  //   });
  // }

  private dropMarker(coordinates: any, description: string) {
    this.marker = new H.map.Marker(coordinates, { icon: this.icon });

    this.marker.setData(description);
    this.markersGroup.addObject(this.marker);

    this.marker.addEventListener('pointerenter', event => {
      this.EmployeeDescription = event.target.P.split('-')[1];
      this.isEmpOnHover = true;

      this.renderer.setStyle(this.empNameElement.nativeElement, 'background', '#12344d');
      this.renderer.setStyle(this.empNameElement.nativeElement, 'color', 'white');
      this.renderer.setStyle(this.empNameElement.nativeElement, 'border-radius', '10px');
      this.renderer.setStyle(this.empNameElement.nativeElement, 'padding', '10px');
      this.renderer.setStyle(this.empNameElement.nativeElement, 'position', 'absolute');
      this.renderer.setStyle(this.empNameElement.nativeElement, 'z-index', '9000000');
      this.renderer.setStyle(this.empNameElement.nativeElement, 'left', (event.originalEvent.x - 58) + 'px');
      this.renderer.setStyle(this.empNameElement.nativeElement, 'top', (event.originalEvent.y - 40) + 'px');

    }, false);

    this.marker.addEventListener('pointerleave', event => {
      ("just left the position = ");
      this.isEmpOnHover = false;
    }, false);

    this.marker.addEventListener('tap', event => {
      this.employeeDetails = event.target.P;
      let splittedEmpDetails = this.employeeDetails.toString().split('-');

      this.empId = splittedEmpDetails[0];
      this.empDescription = splittedEmpDetails[1];
      if (!this.mapServiceUnavailable && this.resourcesLoaded) {
        this.showVanRouteDataSlider();
      } else if (this.mapServiceUnavailable) {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgMapsNetworkError));
      } else if (!this.resourcesLoaded) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgRefreshPage));
      }
    }, false);
  }

  showVanRouteDataSlider() {
    this.showVanRouteData = true;
    this.showSlider = true;
  }

  close() {
    this.coreSession.SetTitle('Admin Settings');
    this.showSlider = false;
    this.showVanRouteData = false;
  }

  createInfoBubble(map) {
    // Create info bubble
    // var bubble = new H.ui.InfoBubble({ lng: 13.4, lat: 52.51 }, {
    //   content: '<b>Hello World!</b>'
    // });
    // // Add info bubble to the UI:
    // this.ui.addBubble(bubble);
  }
  toggleFilter() {
    this.isFilterOpened = !this.isFilterOpened;
  }

  onCloseFilter() {
    this.isFilterOpened = false;
  }

  onReset() {
    this.filterForm.reset();
    this.filterForm.get("creationDate").setValue([new Date(), new Date()]);
    this.onFind();
  }

  onFind() {
    markerList = [];
    if (this.filterForm.invalid) return;
    if (this.filterForm.invalid) return;
    // if (this.mapServiceUnavailable) {
    //   this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgMapsNetworkError));
    //   return
    // }
    // if (!this.resourcesLoaded) {
    //   this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgRefreshPage));
    //   return
    // }
    this.selectedEmployeeId = this.filterForm.value.employeeId === null
      || this.filterForm.value.employeeId === "" ? -1 : this.filterForm.value.employeeId

    map.eachLayer((layer) => {
      if (layer instanceof L.Marker) {
        map.removeLayer(layer);
      }
    });
    // if (this.markersGroup)
    //   this.map.removeObject(this.markersGroup);
    this.prepareMapVehicles();
  }

  initFilterForm() {
    this.filterForm = new FormGroup({
      tripCode: new FormControl(),
      statusId: new FormControl(),
      employeeId: new FormControl(),
      creationDate: new FormControl(
        [new Date(), new Date()],
      )
    });
  }
}
