import { Component, OnInit, ViewChild, Input, ElementRef, NgModule } from '@angular/core';

import { NgbModal, ModalDismissReasons, NgbModalConfig, NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { HereMapComponent } from '../here-map/here-map.component';
import { HereMapService } from '../here-maps.service';
import { EmployeeTrackingModel } from '../../../../shared/models/tracking/employeeTracking.model';
import { CoreSession } from '../../../../core/core.session';
declare var H: any;

@Component({
  selector: 'app-modal-basic',
  templateUrl: './modal-basic.component.html',
  styleUrls: ['./modal-basic.component.css']
})
export class ModalBasicComponent implements OnInit {
  private ui: any;
  private platform: any;
  private map: any;
  private vehiclesList: EmployeeTrackingModel[] = [];
  isMapVisible: boolean = false;
  closeResult: string;
  @ViewChild("content", { static: true }) content: NgbModal;

  @Input()
  public appId: any;

  @Input()
  public appCode: any;

  @Input()
  public lat: any;

  @Input()
  public lng: any;

  @Input()
  public width: any;

  @Input()
  public height: any;

  ngOnInit() {
    this.platform = new H.service.Platform({
      useCIT: true,
      app_id: this.appId,
      app_code: this.appCode,
      useHTTPS: true
    });
  }
  constructor(private modalService: NgbModal,
    private hereMapService: HereMapService,
    private coreSession: CoreSession,
    config: NgbModalConfig) { }

  public showDialog() {
    this.isMapVisible = false;
    this.modalService.open(this.content, {
      centered: true,
      size: "lg",
      backdrop: 'static'
    });

    let defaultLayers = this.platform.createDefaultLayers();

    this.map = new H.Map(
      document.getElementById("mapId"),
      defaultLayers.normal.map
    );
    window.addEventListener('resize', () => this.map.getViewPort().resize());
    let behavior = new H.mapevents.Behavior(new H.mapevents.MapEvents(this.map));
    this.ui = H.ui.UI.createDefault(this.map, defaultLayers);

    // this.modalService.open(this.content, { centered: true, size: "lg" });
    this.prepareMapVehicles();

    this.isMapVisible = true;
  }
  close() {
    this.modalService.dismissAll();
  }

  prepareMapVehicles() {
    this.hereMapService.getVehicleLocations(-1).subscribe(result => {
      this.vehiclesList = result;
      (this.vehiclesList);
      if (this.vehiclesList && this.vehiclesList.length > 0) {
        for (let i = 0; i < this.vehiclesList.length; i++) {
          this.dropMarker({ "lat": this.vehiclesList[i].gpsLatitude, "lng": this.vehiclesList[i].gpsLongitude }, this.vehiclesList[i].description.toString());
        }
      }
    });
  }
  private dropMarker(coordinates: any, description: string) {
    let icon = new H.map.Icon(this.coreSession.baseURL + 'assets/img/shop-2.png');
    let marker = new H.map.Marker(coordinates, { icon: icon });

    marker.setData(description);
    marker.addEventListener('pointerenter', event => {
      let bubble = new H.ui.InfoBubble(event.target.getPosition(), {
        description
      });
      this.ui.addBubble(bubble);

      (this.ui);

    }, false);
    this.map.addObject(marker);

    marker.addEventListener('pointerleave', event => {
      ("LEFT AND DATA OS : " + description);
    }, false);

    marker.addEventListener('tap', event => {
      // this.goToLink("http://localhost:55807/employee-operation/customer-map");
      // this.router.navigate(['/' + ConstantURLs.employeeOperationURL + '/' + "customer-map"]);
    }, false);
  }
}
