import { Component, OnInit, Input, ViewChild, ElementRef, Renderer2, AfterViewInit } from '@angular/core';
import { EmployeeTrackingModel } from '../../../../shared/models/tracking/employeeTracking.model';
import { NgbModal, NgbModalConfig } from '@ng-bootstrap/ng-bootstrap';
import { HereMapService } from '../here-maps.service';
import { CoreSession } from '../../../../core/core.session';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { FormGroup, FormControl } from '@angular/forms';
import { DateTimeModel } from '../../../../shared/models/dateTimeModel/date-time.model';
import { IDateTimePickerProperties } from '../../../../shared/models/dateTimeModel/date-time-properties.interface';
import { EmployeeRouteDetails } from '../../../../shared/models/tracking/employeeRouteDetails.model';
import { EmployeeVanItemDetails } from '../../../../shared/models/tracking/employeeVanItemDetails.model';
import { CustomerTrackingModel } from '../../../../shared/models/tracking/customerTracking.model';
import * as L from 'leaflet';
import { latLng } from 'leaflet';

var map;

@Component({
  selector: 'app-route-map',
  templateUrl: './route-map.component.html',
  styleUrls: ['./route-map.component.css']
})
export class RouteMapComponent implements OnInit, AfterViewInit {
  markers: any[] = [];
  isLanguageArabic: boolean = false;
  isFilterOpened = false;
  filterForm: FormGroup = new FormGroup({});
  fromToDate: DateTimeModel[];
  creationDate: DateTimeModel;
  selectedEmployeeId: any;
  fromDate: DateTimeModel = null;
  creationDateProperties: IDateTimePickerProperties = {
    label: "Desc_Date",
    formControlName: "creationDate",
    isCalendarOnly: true,
  };

  navLinks: any[];
  indexCounter: number = -1;
  navBarSelectedIndex: number = 0;
  customerDescription: string;
  isCustomerOnHover: boolean = false;

  itemDetails: EmployeeVanItemDetails[] = []
  routeDetails: EmployeeRouteDetails = new EmployeeRouteDetails;
  vanDetails: any;
  // private map: any;
  private vehiclesList: EmployeeTrackingModel[] = [];
  private customersList: CustomerTrackingModel[] = [];
  private routeLngAndLat: EmployeeTrackingModel[] = [];
  // private MarkersGroup: any;
  isMapVisible: boolean = false;
  closeResult: string;

  @ViewChild("map", { static: true })
  public mapElement: ElementRef;

  @ViewChild("customerName", { static: true }) customerNameElement: ElementRef;

  @Input()
  public appId: any;

  @Input()
  public appCode: any;

  @Input()
  public lat: any;

  @Input()
  public lng: any;

  @Input()
  public width: any;

  @Input()
  public height: any;

  @Input()
  public empDescription: any;

  vanDescription: any;

  @Input()
  public empId: any;
  latitude: string | any;
  longitude: string | any;
  options: any;
  routePolyline: any;

  ngOnInit() {
    this.prepareNavigation();
    this.initFilterForm();
    this.navLinks[0].isActive = true;

    if (this.coreSession.selectedLanguageId === 2) {
      ("arabic");

      this.isLanguageArabic = true;
    }
    // this.platform = new H.service.Platform({
    //   useCIT: true,
    //   app_id: this.appId,
    //   app_code: this.appCode,
    //   useHTTPS: true
    // });
  }
  ngAfterViewInit() {

    var thisComponent = this;
    if (!this.latitude || !this.longitude) {
      this.latitude = '31.959025';
      this.longitude = '35.905618';
    }

    if (map != undefined) map.remove();

    this.options = {
      center: latLng(this.latitude, this.longitude),
      zoom: 14,
      // minZoom: 10,
      // maxZoom: 100,
      zoomControl: true,
    };

    this.prepareMapCustomers();
    this.prepareMapVehicles();
    this.getRouteLngAndLat();
    this.prepareRouteDetails();
    this.prepareItemDetails();
    this.GetVanDetails();

    map = new L.map(this.mapElement.nativeElement, this.options);
    var layer = new L.TileLayer('http://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', { maxZoom: 19 }, { attribution: "Map data ..." });
    map.addLayer(layer);

  }

  constructor(private modalService: NgbModal,
    private hereMapService: HereMapService,
    private coreSession: CoreSession,
    config: NgbModalConfig,
    private sessionDataProvider: SessionDataProvider,
    private renderer: Renderer2) { }

  initFilterForm() {
    this.filterForm = new FormGroup({
      tripCode: new FormControl(),
      statusId: new FormControl(),
      employeeId: new FormControl(),
      creationDate: new FormControl(new Date())
    });
  }
  prepareMapVehicles() {
    this.coreSession.ModalLoading.Show();

    this.hereMapService.getVehicleLocations(this.empId).subscribe(result => {
      this.vehiclesList = result;
      if (this.vehiclesList && this.vehiclesList.length > 0) {
        var vehicleMarkersGroup = [];
        for (var i = 0; i < this.vehiclesList.length; i++) {
          var iconOptions = {
            iconUrl: this.coreSession.baseURL + 'assets/img/van-3.png',
            iconSize: [30, 30]
          }
          // Creating a custom icon
          var customIcon = L.icon(iconOptions);
          var markerOptions = {
            title: this.vehiclesList[i].employeeID.toString() + '-' + this.vehiclesList[i].description.toString(),
            clickable: true,
            draggable: false,
            icon: customIcon,
            someCustomProperty: this.vehiclesList[i]
          }

          var marker = L.marker([this.vehiclesList[i].gpsLatitude, this.vehiclesList[i].gpsLongitude], markerOptions).addTo(map);
          vehicleMarkersGroup.push(marker);
        }
        var featureGroup = L.featureGroup(vehicleMarkersGroup).addTo(map);
        map.fitBounds(featureGroup.getBounds());
        marker.addTo(map);
      }
      this.coreSession.ModalLoading.Hide();
    });
  }
  prepareMapCustomers() {
    this.coreSession.ModalLoading.Show();

    this.hereMapService.getVanRouteCustomers(this.empId, this.fromDate).subscribe(result => {
      this.customersList = result;

      if (this.customersList && this.customersList.length > 0) {
        // Create a Leaflet feature group to hold customer markers
        const customerMarkersGroup = L.featureGroup();

        for (let i = 0; i < this.customersList.length; i++) {
          const customer = this.customersList[i];

          // Create HTML for the marker icon
          const iconHtml = `
          <div class="store-icon">
              <img src="${this.coreSession.baseURL + 'assets/img/shop-2.png'}" width="50" height="50">
              <svg width="50" height="35" xmlns="http://www.w3.org/2000/svg">
                  <rect stroke="black" fill="black" opacity="0.6" x="1" y="1" rx="10" ry="10" width="38" height="25" />
                  <text textLength="45" x="20" y="21" font-size="8pt" font-family="Arial" text-anchor="middle" fill="white">
                      ${customer.sequence}
                  </text>
              </svg>
          </div>
      `;

          // Create a custom DivIcon
          const customIcon = L.divIcon({
            html: iconHtml,
            className: 'custom-icon',
            iconSize: [50, 65], // Adjust icon size to accommodate sequence icon
            iconAnchor: [25, 65] // Position anchor below the sequence icon
          });

          // Create a marker for each customer with custom icon
          const customerMarker = L.marker([customer.gpsLatitude, customer.gpsLongitude], {
            icon: customIcon
          }); // Add popup with customer description

          // Bind tooltip to show customer name on hover
          customerMarker.bindTooltip(customer.description.toString(), { direction: 'top', offset: [0, -30] });

          // Add marker to the customer markers group
          customerMarkersGroup.addLayer(customerMarker);
          this.markers.push(customerMarker);

        }

        // Add customer markers group to the map
        map.addLayer(customerMarkersGroup);
        // Fit the map view to the bounds of the customer markers group
        map.fitBounds(customerMarkersGroup.getBounds());
      }

      this.coreSession.ModalLoading.Hide();
    });
  }
  prepareRouteDetails() {
    this.coreSession.ModalLoading.Show();

    this.hereMapService.getEmployeeRouteDetails(this.empId, this.fromDate).subscribe(result => {
      this.routeDetails = result;
      if (this.routeDetails) {
      }
      this.coreSession.ModalLoading.Hide();
    });
  }
  prepareItemDetails() {
    this.coreSession.ModalLoading.Show();

    this.hereMapService.getEmployeeItemDetails(this.empId, this.fromDate).subscribe(result => {
      this.itemDetails = result;
      if (this.itemDetails) {
      }
      this.coreSession.ModalLoading.Hide();
    });
  }
  // getRouteLngAndLat() {
  //   debugger;
  //   this.coreSession.ModalLoading.Show();
  //   this.hereMapService.getLngAndLat(this.empId, this.fromDate).subscribe(result => {
  //     debugger
  //     this.routeLngAndLat = result;
  //     ("Route Res");
  //     (this.routeLngAndLat);
  //     if (this.routeLngAndLat && this.routeLngAndLat.length > 0) {
  //       this.routePolyLineGroup = new H.map.Group();
  //       for (let i = 0; i < this.routeLngAndLat.length; i++) {
  //         if (i + 1 < this.routeLngAndLat.length) {
  //           let point0 = this.routeLngAndLat[i].gpsLatitude + ',' + this.routeLngAndLat[i].gpsLongitude;
  //           let point1 = this.routeLngAndLat[i + 1].gpsLatitude + ',' + this.routeLngAndLat[i + 1].gpsLongitude;
  //           this.calculateRouteFromAtoB(this.platform, point0, point1);
  //         }
  //         if (i === 0) {
  //         }
  //       }
  //       this.map.addObject(this.routePolyLineGroup);
  //     }
  //     this.coreSession.ModalLoading.Hide();
  //   });
  // }
  getRouteLngAndLat() {
    this.coreSession.ModalLoading.Show();
    this.hereMapService.getLngAndLat(this.empId, this.fromDate).subscribe(result => {
      this.routeLngAndLat = result;
      ("Route Res");
      (this.routeLngAndLat);
      if (this.routeLngAndLat && this.routeLngAndLat.length > 0) {
        for (let i = 0; i < this.routeLngAndLat.length; i++) {
          if (i + 1 < this.routeLngAndLat.length) {
            const point0 = L.latLng(this.routeLngAndLat[i].gpsLatitude, this.routeLngAndLat[i].gpsLongitude);
            const point1 = L.latLng(this.routeLngAndLat[i + 1].gpsLatitude, this.routeLngAndLat[i + 1].gpsLongitude);
            const directionPolyline = L.polyline([point0, point1], { color: 'rgba(0, 128, 255, 0.7)', weight: 4 });
            directionPolyline.addTo(map);
            this.markers.push(directionPolyline);
          }
          if (i === 0) {
          }
        }
        // this.routePolyline = map.polyline(latlngs, { color: 'blue' }).addTo(map);
        // map.fitBounds(this.routePolyline.getBounds());
      }
      this.coreSession.ModalLoading.Hide();
    });
  }

  GetVanDetails() {
    this.coreSession.ModalLoading.Show();

    this.hereMapService.getVanDetails(this.empId).subscribe(result => {
      this.vanDetails = result;
      this.vanDescription = this.vanDetails.vehicleName;

    });
  }
  //if type 1 : Customers
  //if type 2 : Vehicle
  //if type 3 : route
  // private dropMarker(gpsLatitude: any, gpsLongitude: any, description: string, type: number) {
  //   this.marker = new H.map.Marker({ "lat": gpsLatitude, "lng": gpsLongitude }, { icon: this.icon });

  //   this.marker.setData(description);
  //   if (type === 1) {
  //     this.sequenceMarker = new H.map.Marker({ "lat": gpsLatitude, "lng": gpsLongitude }, { icon: this.sequenceIcon });
  //     this.sequenceMarker.setData(description);
  //     this.marker.addEventListener('pointerenter', event => {
  //       this.isCustomerOnHover = true;

  //       this.customerDescription = event.target.P;

  //       this.renderer.setStyle(this.customerNameElement.nativeElement, 'background', '#12344d');
  //       this.renderer.setStyle(this.customerNameElement.nativeElement, 'color', 'white');
  //       this.renderer.setStyle(this.customerNameElement.nativeElement, 'border-radius', '15px');
  //       this.renderer.setStyle(this.customerNameElement.nativeElement, 'padding', '10px');
  //       this.renderer.setStyle(this.customerNameElement.nativeElement, 'position', 'absolute');
  //       this.renderer.setStyle(this.customerNameElement.nativeElement, 'z-index', '9000000');
  //       this.renderer.setStyle(this.customerNameElement.nativeElement, 'left', (event.originalEvent.x - 105) + 'px');
  //       this.renderer.setStyle(this.customerNameElement.nativeElement, 'top', (event.originalEvent.y - 70) + 'px');
  //     }, false);
  //     this.marker.addEventListener('pointerleave', event => {
  //       this.isCustomerOnHover = false;
  //     }, false);

  //     this.sequenceMarker.addEventListener('pointerenter', event => {
  //       this.isCustomerOnHover = true;

  //       this.customerDescription = event.target.P;
  //       (event.originalEvent.x);

  //       this.renderer.setStyle(this.customerNameElement.nativeElement, 'background', '#12344d');
  //       this.renderer.setStyle(this.customerNameElement.nativeElement, 'color', 'white');
  //       this.renderer.setStyle(this.customerNameElement.nativeElement, 'border-radius', '15px');
  //       this.renderer.setStyle(this.customerNameElement.nativeElement, 'padding', '10px');
  //       this.renderer.setStyle(this.customerNameElement.nativeElement, 'position', 'absolute');
  //       this.renderer.setStyle(this.customerNameElement.nativeElement, 'z-index', '9000000');
  //       if (this.coreSession.selectedLanguageId === 2) {
  //         this.renderer.setStyle(this.customerNameElement.nativeElement, 'right', '0px');
  //       } else {
  //         this.renderer.setStyle(this.customerNameElement.nativeElement, 'left', '0px');
  //       }
  //       this.renderer.setStyle(this.customerNameElement.nativeElement, 'top', '0px');
  //     }, false);
  //     this.sequenceMarker.addEventListener('pointerleave', event => {
  //       this.isCustomerOnHover = false;
  //     }, false);
  //     this.customerMarkersGroup.addObject(this.marker);
  //     this.sequenceMarkersGroup.addObject(this.sequenceMarker);

  //   } else if (type === 2) {
  //     this.vehicleMarkersGroup.addObject(this.marker);
  //   }
  // }

  // calculateRouteFromAtoB(platform, point0: string, point1: string) {
  //   var router = platform.getRoutingService(),
  //     routeRequestParams = {
  //       mode: 'balanced;truck',
  //       representation: 'display',
  //       routeattributes: 'waypoints,summary,shape,legs',
  //       maneuverattributes: 'direction,action',
  //       waypoint0: point0,
  //       waypoint1: point1
  //     };


  //   router.calculateRoute(
  //     routeRequestParams,
  //     Success => {
  //       var route = Success.response.route[0];

  //       var lineString = new H.geo.LineString(),
  //         routeShape = route.shape;

  //       routeShape.forEach(function (point) {
  //         var parts = point.split(',');
  //         lineString.pushLatLngAlt(parts[0], parts[1]);
  //       });

  //       this.routePolyLine = new H.map.Polyline(lineString, {
  //         style: {
  //           lineWidth: 4,
  //           strokeColor: 'rgba(0, 128, 255, 0.7)'
  //         }
  //       });

  //       this.routePolyLineGroup.addObject(this.routePolyLine);
  //     },
  //     this.onError
  //   );
  // }

  onError(error) {
    ("ERROR");

    alert('Can\'t reach the remote server');
  }

  onSuccess(result) {
    var route = result.response.route[0];

    this.addRouteShapeToMap(route);
    // this.addManueversToMap(route);

    // this.addWaypointsToPanel(route.waypoint);
    // this.addManueversToPanel(route);
    // this.addSummaryToPanel(route.summary);
    // ... etc.
  }

  addRouteShapeToMap(route) {
  }

  prepareNavigation() {
    this.navLinks = [
      {
        label: "Desc_Route_Details",
        index: 0,
        isActive: false,
      },
      {
        label: "Desc_Item_Details",
        index: 1,
        isActive: false,
      }
    ];
  }
  ChangeDataView(index: number) {
    this.navLinks.forEach(a => a.isActive = false);
    this.navBarSelectedIndex = index;
    this.navLinks[index].isActive = true;
  }
  toggleFilter() {
    this.isFilterOpened = !this.isFilterOpened;
  }

  onCloseFilter() {
    this.isFilterOpened = false;
  }

  // Function to remove markers
  removeAllMarkers(): void {
    this.markers.forEach(marker => {
      map.removeLayer(marker); // Remove marker from the map
    });
    this.markers = []; // Clear the array
  }

  // onReset() {
  //   this.creationDate = null;
  //   this.fromToDate = [];
  //   this.filterForm.reset();
  //   this.filterForm.get("creationDate").setValue(new Date());
  //   this.onFind();
  // }

  onFind(result) {
    if (this.filterForm.invalid) return;

    this.selectedEmployeeId = this.filterForm.value.employeeId === null
      || this.filterForm.value.employeeId === "" ? -1 : this.filterForm.value.employeeId;

    if (result.transactionDate) {
      this.fromDate = result.transactionDate;
    } else {
      this.fromDate = null;
    }
    // Remove sequence markers
    this.removeAllMarkers();

    this.prepareMapCustomers();
    this.getRouteLngAndLat();
    this.prepareRouteDetails();
    this.prepareItemDetails();
    this.GetVanDetails();
  }

  onCreationDateSelected(dateList) {
    if (dateList) {
      this.fromToDate = dateList;
    }
  }

  public get creationDateFilter() {
    return this.filterForm.get("creationDate");
  }

  getCursorPosition() {
    var sel, range;
    sel = window.getSelection();
    if (sel.getRangeAt && sel.rangeCount) {
      return sel.getRangeAt(0);
    }
  }
  insertTextAtPosition(text) {
    this.getCursorPosition().insertNode(document.createTextNode(text));
  }
}
