import { Component, OnInit, Inject } from '@angular/core';
import { AuthService } from '../../core/auth/auth.service';
import { SessionDataProvider } from '../../core/session-data-provider.service';
import { OrderService } from '../order/order.service';
import { CoreSession } from '../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../shared/models/constants/constant-message';

@Component({
  selector: 'app-home',
  templateUrl: './home.component.html',
  styleUrls: ['./home.component.css']
})
export class HomeComponent implements OnInit {
  constructor(private authService: AuthService,private sessionDataProvider:SessionDataProvider
,  private orderService: OrderService,
private coreSession: CoreSession,
private translateService: TranslateService

  ) {
  }
  overallPath:any
  PendingOrderPath:any
  readyToDeliveyPath:any
  deliveredPath:any
  legendItems: any[] = [];
  ngOnInit() {
    if (this.sessionDataProvider.allMenusAvailable.filter(x => x.menuId=='200').length == 1){
      this.initBarOptions();
      this.initPieOptions();
      this.populateDashboardsData();
    }
    else{
      this.authService.navigateToHomeScreen();
    }

    this.overallPath= this.coreSession.baseURL + "assets/img/users-img/overAllOrder.jpg"

    this.PendingOrderPath = this.coreSession.baseURL + "assets/img/users-img/PendingOrder.jpg"
    this.readyToDeliveyPath = this.coreSession.baseURL + "assets/img/users-img/readyToDelivey.jpg"
    this.deliveredPath = this.coreSession.baseURL + "assets/img/users-img/delivered.jpg"



  }
  isToday = false;
  isMonthly = true;
  isAnnual = false;

  pieOptions: any = {};
  barOptions: any = {};

  pieOptionsData: any = {};
  barOptionsData: any = {};

  dashboardsData: any = {};

  overAllOrders: any = {};
  allPendingOrders: any = {};
  readyToDelivery: any = {};
  deliveredOrders: any = {};
  populateDashboardsData() {
    this.coreSession.ModalLoading.Show();
    this.orderService
      .getDashboardData(this.isToday, this.isMonthly, this.isAnnual)
      .subscribe(
        response => {
          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            this.fillDashboardsData(response.data);
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        },
        error => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );
  }

  onTodayClick() {
    this.isToday = true;
    this.isMonthly = false;
    this.isAnnual = false;
    this.populateDashboardsData();
  }

  onMonthlyClick() {
    this.isToday = false;
    this.isMonthly = true;
    this.isAnnual = false;
    this.populateDashboardsData();
  }

  onAnnualClick() {
    this.isToday = false;
    this.isMonthly = false;
    this.isAnnual = true;
    this.populateDashboardsData();
  }

  initBarOptions() {
    this.barOptions = {
      backgroundColor: "#FFF",
      color: ["#3398DB"],
      title: {
        text: this.translateService.instant('Desc_Top_Items_Order'),
        left: "center",
        top: 20,
        textStyle: {
          color: "#2b3643"
        }
      },
      tooltip: {
        trigger: "axis",
        axisPointer: {
          type: "cross"
        }
      },
      grid: {
        left: "3%",
        right: "4%",
        bottom: "3%",
        containLabel: true
      },
      xAxis: {
        type: "category",
        boundaryGap: false,  // Important for the smooth line chart to avoid gaps
        axisTick: {
          alignWithLabel: true
        }
      },
      yAxis: {
        type: "value"
      },
      series: [
        {
          name: "Quantity",
          type: "line",  // Change to 'line' for a line chart
          smooth: true,  // Enable smooth line
          data: []  // This will be populated dynamically
        }
      ],
      toolbox: {
        show: true,
        showTitle: false,
        feature: {
          saveAsImage: {
            show: true,
            title: "Save As Image"
          }
        }
      }
    };
  }

  initPieOptions() {
    this.pieOptions = {
      backgroundColor: "#FFF",
      color: ["#17B294", "#FB8477", "#7A89FE", "#FF9431","#455269","#232859"],  // Define colors here
      title: {
        text: this.translateService.instant('Desc_Order_Per_Status'),
        left: "center",
        top: 20,
        textStyle: {
          color: "#2b3643"
        }
      },
      tooltip: {
        trigger: "item",
        formatter: "{a} <br/>{b} : {c} ({d}%)"
      },
      series: [
        {
          name: "Orders",
          type: "pie",
          radius: ["40%", "70%"],
          center: ["50%", "50%"],
          avoidLabelOverlap: false,
          label: {
            show: false,
            position: 'center'
          },
          emphasis: {
            label: {
              show: true,
              fontSize: '20',
              fontWeight: 'bold'
            }
          },
          labelLine: {
            show: false
          },
          itemStyle: {
            emphasis: {
              shadowBlur: 10,
              shadowOffsetX: 0,
              shadowColor: "rgba(0, 0, 0, 0.5)"
            }
          },
          animationType: "scale",
          animationEasing: "elasticOut",
          animationDelay: function(idx) {
            return Math.random() * 200;
          },
          data: []  // This will be populated dynamically
        }
      ]
    };
  }

  fillDashboardsData(data) {

    this.overAllOrders = data.overAllOrders;
    this.allPendingOrders = data.currentPending;
    this.readyToDelivery = data.readyToDelivery;
    this.deliveredOrders = data.deliveredOrders;
    // update series data:
    this.barOptionsData = {
      xAxis: [
        {
          data: data.topItems.xAxis
        }
      ],
      series: [
        {
          data: data.topItems.yAxis
        }
      ]
    };
    this.pieOptionsData = {
      series: [
        {
          data: data.orderByStatus
        }
      ]
    };
    // Calculate the total for percentage calculation
  // Calculate the total for percentage calculation
  const total = data.orderByStatus.reduce((sum, item) => sum + item.value, 0);

  // Prepare legend items with color, name, and percentage
  this.legendItems = data.orderByStatus.map((item, index) => ({
    name: item.name,
    color: this.pieOptions.series[0].itemStyle.color ? this.pieOptions.series[0].itemStyle.color[index] : this.pieOptions.color[index],
    percentage: ((item.value / total) * 100).toFixed(2)
  }));
}
}
