import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { AuthGuard } from '../../../core/auth/auth.gurad';
import { ConstantURLs } from '../../../shared/models/constants/constant-URL';
import { CustomeMobileViewMainComponent } from './custome-mobile-view-main/custome-mobile-view-main.component';
import { GoldenMinuteControlComponent } from './golden-minute-control/golden-minute-control.component';

const CustomeMobileViewRouting: Routes = [
  {
    
    path: '',
    component: CustomeMobileViewMainComponent,
    canActivate: [AuthGuard],
     children:[
       {
         path: ConstantURLs.goldenMinuteControl,
         component: GoldenMinuteControlComponent,
         canActivate: [AuthGuard]
       },
       {
        path: '',
        canActivate: [AuthGuard],
        redirectTo: '/' + ConstantURLs.dataDefinitionURL + '/' + ConstantURLs.customeMobileViewURL + '/' + ConstantURLs.goldenMinuteControl,
        pathMatch: 'full'
      }
     ]
  }
];
  @NgModule({
    imports: [RouterModule.forChild(CustomeMobileViewRouting)],
    exports: [RouterModule]
  })
  export class CustomeMobileViewRoutingModule {
    
  }