import { HttpClient, HttpHeaders } from "@angular/common/http";
import { Inject, Injectable } from "@angular/core";
import { CoreSession } from "../../../core/core.session";
import { ResponseModel } from "../../../shared/models/api-models/api-models";

@Injectable({
  providedIn: "root",
})
export class CustomeMobileViewService {
  private url = "";
  httpOptions;


  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "CustomeMobileView";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
        Authorization: "my-auth-token",
      }),
    };
  }

  getGMGroupsData(securityGroupId: number) {
    const urlValue: string = this.url + "/GetGMGroupsData";
    return this.http.post<any>(urlValue, securityGroupId)
      .map((response) => {
        // const res = new ResponseModel();
        // res.data = response['data'];
        // res.message = response['message'];
        // res.status = response['status'];
        return response.data;
      });
  }

  getGMGroupData(GroupID: number) {
    const urlValue: string = this.url + "/GetGMGroupData";
    return this.http.post<ResponseModel>(urlValue, GroupID)
      .map((response) => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      });
  }

  getFieldsData(GroupID: number) {
    const urlValue: string = this.url + "/GetFieldsData";
    return this.http.post<ResponseModel>(urlValue, GroupID)
      .map((response) => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      });
  }

  getFieldData(FieldId: number) {
    const urlValue: string = this.url + "/GetFieldData";
    return this.http.post<ResponseModel>(urlValue, FieldId)
      .map((response) => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      });
  }

  getBubblesMenu(securityGroupId: number) {
    const urlValue: string = this.url + "/GetBubblesMenu";
    return this.http.post<any>(urlValue, securityGroupId)
      .map((response) => {
        return response;
      });
  }

  InsertGMGroup(data: any) {
    const urlValue: string = this.url + "/InsertGMGroup";
    return this.http.post<ResponseModel>(urlValue, JSON.stringify(data), this.httpOptions)
      .map((response) => {
        const result = new ResponseModel();
        result.data = response["data"];
        result.message = response["message"];
        result.status = response["status"];
        return result;
      });
  }

  testQuery(query: string, columnsCount: number = 1, additionalParameter: string = '' , checkColumnsName : boolean = false) {
    const urlValue: string = this.url + "/TestQuery";
    let data = { query: query, columnsCount: columnsCount , additionalParameter: additionalParameter , checkColumnsName : checkColumnsName};
    return this.http.post<any>(urlValue, JSON.stringify(data), this.httpOptions)
      .map((response) => {
        const result = new ResponseModel();
        result.data = response["data"];
        result.message = response["message"];
        result.status = response["status"];
        return result;
      });
  }
  saveFieldToDB(data: any) {
    const urlValue: string = this.url + "/InsertGMField";
    return this.http
      .post<any>(urlValue, JSON.stringify(data), this.httpOptions)
      .map((response) => {
        return response;
      });
  }

  UpdateGMGroup(data: any) {
    const urlValue: string = this.url + "/UpdateGMGroup";
    return this.http
      .post<any>(urlValue, JSON.stringify(data), this.httpOptions)
      .map((response) => {
        return response;
      });
  }
  InsertGoldenMinuteGroup(data: any) {
    const urlValue: string = this.url + "/InsertGoldenMinuteGroup";
    return this.http
      .post<any>(urlValue, JSON.stringify(data), this.httpOptions)
      .map((response) => {
        return response;
      });
  }

  DeleteGroup(data: any) {
    const urlValue: string = this.url + "/DeleteGroup";
    return this.http
      .post<any>(urlValue, JSON.stringify(data), this.httpOptions)
      .map((response) => {
        return response;
      });
  }

  DeleteField(data: any) {
    const urlValue: string = this.url + "/DeleteField";
    return this.http
      .post<any>(urlValue, JSON.stringify(data), this.httpOptions)
      .map((response) => {
        return response;
      });
  }

  UpdateField(data: any) {
    const urlValue: string = this.url + "/UpdateField";
    return this.http
      .post<any>(urlValue, JSON.stringify(data), this.httpOptions)
      .map((response) => {
        return response;
      });
  }

  getParametersList() {
    const urlValue: string = this.url + "/GetParametersList";
    return this.http.post<ResponseModel>(urlValue, "").map((response) => {
      return response;
    });
  }
}
