import { Component, OnInit } from '@angular/core';
import { Subject } from 'rxjs';
import { CoreSession } from '../../../../core/core.session';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { MenuActions } from '../../../../shared/models/enums/menu-actions-enum';
import { RowOperation } from '../../../../shared/models/enums/shared-table-operation.enum';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { MasterDataService } from '../../master-data.service';
import { SettingsService } from '../../../admin-settings/settings.service'
import { SecurityGroupManagementService } from '../../../../shared/services/settings/security-group-management.service';

@Component({
  selector: 'app-golden-minute-control',
  templateUrl: './golden-minute-control.component.html',
  styleUrls: ['./golden-minute-control.component.css']
})
export class GoldenMinuteControlComponent implements OnInit {

  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  tableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    isOnline: false,
    showSearch: true,
    showSearchBtn: false,
    showNewBtn: false,
    isMultiSelection: false,


    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      {
        title: 'Desc_Security_Group_Name',
        key: 'securityGroupName',
        isSortable: true,
        width: '50%'
      },
      {
        title: 'Desc_Vendor',
        key: 'organizationNameCode',
        isSortable: true,
        width: '50%'
      },
    ]
  };
  isEditMode = false;
  employeeIdSignature = null;
  securityGroupId: number = -1;
  showEntrySlider = false;
  saveSubject: Subject<void> = new Subject<void>();

  constructor(
    public coreSession: CoreSession,
    private masterDataService: MasterDataService,
    private securityGroupManagementService: SecurityGroupManagementService) {
  }

  ngOnInit() {
    this.coreSession.SetTitle('Golden Minute Control');
    this.manageActions();
    this.populateGMSecurityGroupList();
  }
  manageActions() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.goldenMinuteControl, MenuActions.Edit)) {
      this.tableData.rowOperations.push({
        operation: RowOperation.edit,
        title: "Desc_Manage",
        icon: "fa fa-cogs",
        color: "#12344d"
      });
    }
  }

  populateGMSecurityGroupList() {
    this.coreSession.ModalLoading.Show();

    this.securityGroupManagementService.getAllAvailableSecurityGroups().subscribe(result => {
      this.coreSession.ModalLoading.Hide();
      this.dataSource = {
        data: result.data,
        totalItems: result.data.length
      };
    });
  }

  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.edit:
        this.editGoldenMinute(event.object);
        break;
    }
  }

  editGoldenMinute(securityGroup: any) {
    this.securityGroupId = securityGroup.securityGroupId;
    this.isEditMode = true;
    this.showEntrySlider = true;
  }

  closeGMEntrySlider() {
    this.securityGroupId = -1;
    this.showEntrySlider = false;
    this.isEditMode = false;
    this.coreSession.SetTitle('Golden Minute Control');
  }

  onGMControlSaveClick() {
    this.saveSubject.next()
  }

  closeSlider() {
    this.showEntrySlider = false;
  }

  afterSaveGM() {
    this.closeSlider();
  }
}
