import { HttpErrorResponse } from "@angular/common/http";
import {
  Component,
  EventEmitter,
  Input,
  OnDestroy,
  OnInit,
  Output,
  ViewChild,
} from "@angular/core";
import {
  FormBuilder,
  FormControl,
  FormGroup,
  Validators,
} from "@angular/forms";
import {
  NgbModal,
  NgbModalConfig,
  NgbModalRef,
} from "@ng-bootstrap/ng-bootstrap";
import { TranslateService } from "@ngx-translate/core";
import { Observable } from "rxjs";
import { CoreSession } from "../../../../core/core.session";
import { ConstantMessages } from "../../../../shared/models/constants/constant-message";
import { DialogMode } from "../../../../shared/models/enums/dialog-mode.enum";
import { DialogResult } from "../../../../shared/models/enums/dialog-result.enum";
import { GlobalErrors } from "../../../../shared/models/enums/globalErrors";
import { RowOperation } from "../../../../shared/models/enums/shared-table-operation.enum";
import { IDisplayMultiText } from "../../../../shared/models/display-multi-text/diplay-multi-text.interface";
import { ITextInput } from "../../../../shared/models/shared-table/custom-list.interface";
import { SharedTableResult } from "../../../../shared/models/shared-table/shared-table-result.interface";
import { ITableProperties } from "../../../../shared/models/shared-table/table-properties.interface";
import { CustomeMobileViewService } from "../custome-mobile-view.service";
import * as cloneDeep from "lodash/cloneDeep";

@Component({
  selector: "app-golden-minute-entry",
  templateUrl: "./golden-minute-entry.component.html",
  styleUrls: ["./golden-minute-entry.component.css"],
})
export class GoldenMinuteEntryComponent implements OnInit, OnDestroy {
  saveBtnSubscription: any;
  isViewMode: boolean = false;
  displayMultiTextSettings = {
    formTitle: "Fields",
    showLimit: 6,
  };

  modalRef: NgbModalRef;
  navLinks: any[];
  navBarSelectedIndex: number = 0;
  //input
  @Input() securityGroupId: number = -1;
  @Input() isNewEntry: boolean = true;
  @Input() saveEvent: Observable<void>;
  @Input() saveField: Observable<void>;

  //output
  @Output() onSaveCompleted = new EventEmitter();

  //dialogs
  @ViewChild("AddEditGMGroupDialog", { static: true })
  AddEditGMGroupDialog: NgbModal;
  @ViewChild("AddEditFieldDialog", { static: true })
  AddEditFieldDialog: NgbModal;

  //Bubbles
  Bubbles: any[] = [];
  BubblesVisible: any[] = [];
  BubblesForm: FormGroup;
  isShowBubbleButton: boolean = false;
  BubblesdataSource: SharedTableResult = {
    data: [],
    totalItems: 0,
  };
  BubblesfieldDropdownSettings = {
    singleSelection: false,
    idField: "fieldID",
    textField: "description",
    selectAllText: "Desc_Select_All",
    unSelectAllText: "Desc_Select_All",
    searchPlaceholderText: "",
    allowSearchFilter: false,
    itemsShowLimit: 7,
  };
  InitializeBubblesemplateForm() {
    this.BubblesForm.get("BubblesControl").setValue(this.BubblesVisible);
    this.BubblesForm.get("ShowBubbleButtonControl").setValue(
      this.isShowBubbleButton
    );
  }

  ifShowBubbleButton() {
    if (this.isShowBubbleButton) {
      var filter = {
        securityGroupId: this.securityGroupId,
      };
      this.customeMobileViewService.getBubblesMenu(this.securityGroupId).subscribe(
        (result) => {
          this.Bubbles = result.data;
          this.BubblesVisible = this.Bubbles.filter((x) => x.isVisible == true);
          this.BubblesdataSource = {
            data: this.BubblesVisible,
            totalItems: this.BubblesVisible.length,
          };
          this.InitializeBubblesemplateForm();
        },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }
      );
    }
  }

  onCheckAllChange() {
    this.isShowBubbleButton = !this.isShowBubbleButton;
    if (!this.isShowBubbleButton) {
      this.Bubbles = [];
      this.BubblesdataSource = {
        data: [],
        totalItems: 0,
      };
      this.BubblesVisible = [];
      this.InitializeBubblesemplateForm();
    } else {
      this.ifShowBubbleButton();
    }
  }

  onSelectBubble(event: any) {
    this.Bubbles.find((x) => x.fieldID == event.fieldID).isVisible = true;
    this.BubblesVisible = this.Bubbles.filter((x) => x.isVisible == true);
    this.BubblesdataSource = {
      data: this.BubblesVisible,
      totalItems: this.BubblesVisible.length,
    };
    this.InitializeBubblesemplateForm();
  }

  onDeselectBubble(event: any) {
    if (this.BubblesVisible.length == 1) {
      this.onCheckAllChange();
    } else {
      this.Bubbles.find((x) => x.fieldID == event.fieldID).isVisible = false;
      this.BubblesVisible = this.Bubbles.filter((x) => x.isVisible == true);
      this.BubblesdataSource = {
        data: this.BubblesVisible,
        totalItems: this.BubblesVisible.length,
      };
      this.InitializeBubblesemplateForm();
    }
  }

  onSelectBubbleAll() {
    for (var i = 0; i < this.Bubbles.length; i++) {
      this.Bubbles[i].isVisible = true;
    }
    this.BubblesVisible = this.Bubbles.filter((x) => x.isVisible == true);
    this.BubblesdataSource = {
      data: this.BubblesVisible,
      totalItems: this.BubblesVisible.length,
    };
    this.InitializeBubblesemplateForm();
  }

  onDeselectBubbleAll() {
    this.onCheckAllChange();
  }

  //GMGroups
  GMGroups: any[] = [];
  GMGroupsVisible: any[] = [];
  GmForm: FormGroup;
  isEditGroup: boolean = false;
  GmGroupedataSource: SharedTableResult = {
    data: [],
    totalItems: 0,
  };
  GMGroupsDropdownSettings = {
    singleSelection: false,
    idField: "groupID",
    textField: "description",
    selectAllText: "Desc_Select_All",
    unSelectAllText: "Desc_Select_All",
    searchPlaceholderText: "",
    allowSearchFilter: false,
    itemsShowLimit: 7,
  };

  initGMGroupsAndBubbelsForm() {
    this.GmForm = this.formBuilder.group({
      GMGroupControl: new FormControl(),
    });

    this.BubblesForm = this.formBuilder.group({
      BubblesControl: new FormControl(),
      ShowBubbleButtonControl: new FormControl(),
    });
  }

  GMGroupsTabelData: ITableProperties = {
    pageSize: 25,
    showPaginator: false,
    showSearch: false,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: false,
    isAllowDragDrop: true,
    multiSelectionOperations: [],
    isMultiSelectionDialog: true,
    columns: [
      {
        title: "Desc_Group_Name",
        key: "description",
        isSortable: false,
        width: "20%",
      },
      {
        title: "Desc_Fields",
        key: "goldenMinuteFileds",
        isSortable: false,
        width: "80%",
        isMultiSelectDialog: true,
      },
    ],
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: "Desc_Delete",
        icon: "fa-solid fa-trash",
        color: "#f1685e",
        showWhenKeyValueFalse: true,
        showHideOptionPerLine: true,
        controlKeyName: "isBuiltIn",
      },
      {
        operation: RowOperation.add,
        title: "Desc_Add_Field",
        icon: "fa fa-plus",
        color: "#66bb6d",
      },
      {
        operation: RowOperation.edit,
        title: "Desc_Edit",
        icon: "fa-regular fa-pen-to-square",
        color: "#12344d",
      },
    ],
  };

  InitializeGMGroupTemplateForm() {
    this.GmForm.get("GMGroupControl").setValue(this.GMGroupsVisible);
  }
  InitializeGMGroupFieldsTemplateForm() {
    this.GMGroupAddEditForm.get("fields").setValue(this.visiblefields);
  }

  getGMGroupsData() {
    var filter = {
      securityGroupId: this.securityGroupId,
    };
    this.customeMobileViewService.getGMGroupsData(this.securityGroupId).subscribe(
      (result) => {
        this.GMGroups = result;

        var value = this.GMGroups.find(
          (x) => x.groupID == 14 && x.isVisible == true
        );
        if (value !== undefined) {
          this.isShowBubbleButton = true;
        }
        this.GMGroups = this.GMGroups.filter((x) => x.groupID != 14);
        this.GMGroupsVisible = this.GMGroups.filter(
          (x) => x.isVisible == true && x.groupID != 14
        );

        this.GmGroupedataSource = {
          data: this.GMGroupsVisible,
          totalItems: this.GMGroupsVisible.length,
        };
        this.sortGMGroupArray();
        var originalData = cloneDeep(this.GMGroups);
        this.GMGroups = [];
        this.GMGroups = originalData;
        this.ifShowBubbleButton();
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }

  selectedGMGroup: any = null;
  onGmGroupRowOperation(event: any) {
    this.selectedGMGroup = event;
    this.isEditGroup = true;

    switch (event.operation) {
      case RowOperation.edit:
        this.addEditGroup(event);
        break;
      case RowOperation.add:
        this.addField(event);
        break;
      case RowOperation.delete:
        this.DeleteGroup(event);
        break;
    }
  }
  //sort
  sortGMGroupArray() {
    this.GMGroups = this.GMGroups.sort((a, b) =>
      a.sequence > b.sequence
        ? 1
        : a.sequence === b.sequence
          ? a.description > b.description
            ? 1
            : -1
          : -1
    );

    this.GMGroupsVisible = this.GMGroups.filter(
      (x) => x.isVisible == true
    ).sort((a, b) =>
      a.sequence > b.sequence
        ? 1
        : a.sequence === b.sequence
          ? a.description > b.description
            ? 1
            : -1
          : -1
    );
    this.GmGroupedataSource = {
      data: this.GMGroupsVisible,
      totalItems: this.GMGroupsVisible.length,
    };

    this.InitializeGMGroupTemplateForm();
  }

  onSelectGmGroup(event: any) {
    this.GMGroups.find((x) => x.groupID == event.groupID).isVisible = true;
    if (this.GMGroups.find((x) => x.groupID == event.groupID).sequence == -1) {
      var sec = 1;
      if (this.GMGroupsVisible.length > 0)
        sec =
          this.GMGroupsVisible[this.GMGroupsVisible.length - 1].sequence + 1;
    }
    this.GMGroups.find((x) => x.groupID == event.groupID).sequence = sec;
    this.sortGMGroupArray();
  }

  onDeselectGmGroup(event: any) {
    this.GMGroups.find((x) => x.groupID == event.groupID).isVisible = false;
    this.GMGroups.find((x) => x.groupID == event.groupID).sequence = 50000000;
    this.GMGroupsVisible = this.GMGroups.filter((x) => x.isVisible == true);
    this.GmGroupedataSource = {
      data: this.GMGroupsVisible,
      totalItems: this.GMGroupsVisible.length,
    };
    this.sortGMGroupArray();
  }

  onSelectGmGroupAll() {
    for (var i = 0; i < this.GMGroups.length; i++) {
      this.GMGroups[i].isVisible = true;
      if (this.GMGroups[i].sequence == -1) {
        var sec = 1;
        if (this.GMGroupsVisible.length > 0) {
          sec =
            this.GMGroupsVisible[this.GMGroupsVisible.length - 1].sequence + 1;
        }
        this.GMGroups.find(
          (x) => x.groupID == this.GMGroups[i].groupID
        ).sequence = sec;
        var x = this.GMGroupsVisible.filter(
          (x) => x.groupID == this.GMGroups[i].groupID
        );
        if (x.length == 0) {
          this.GMGroupsVisible.push(this.GMGroups[i]);
        }
      }
    }
    this.GmGroupedataSource = {
      data: this.GMGroupsVisible,
      totalItems: this.GMGroupsVisible.length,
    };
    this.sortGMGroupArray();
  }

  onDeselectGmGroupAll() {
    for (var i = 0; i < this.GMGroups.length; i++) {
      this.GMGroups[i].isVisible = false;
      this.GMGroups[i].sequence = 50000000;
    }
    this.GMGroupsVisible = this.GMGroups.filter((x) => x.isVisible == true);
    this.GmGroupedataSource = {
      data: this.GMGroupsVisible,
      totalItems: this.GMGroupsVisible.length,
    };
    this.sortGMGroupArray();
  }

  onGMDragDrop(event: any) {
    var sequence = 1;
    this.GmGroupedataSource.data.forEach((x, index) => {
      x.sequence = sequence;
      sequence++;
    });
    this.sortGMGroupArray();
  }
  onSaveGMControl() {
    let GMFilter = {
      Bubbles: this.Bubbles,
      GoldenMinuteGroupes: this.GMGroups,
      isShowBubbleButton: this.isShowBubbleButton,
      securityGroupId: this.securityGroupId,
    };
    this.customeMobileViewService.InsertGMGroup(GMFilter).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status >= 0) {
          this.onSaveCompleted.emit();

          this.coreSession.showSuccess(
            this.translateService.instant(ConstantMessages.SuccessCaption),
            this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly)
          );
        } else {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }

      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }
  //Fields
  isEditField: boolean = false;
  FieldDropdownSettings = {
    singleSelection: false,
    idField: "fieldID",
    textField: "description",
    selectAllText: "Desc_Select_All",
    unSelectAllText: "Desc_Select_All",
    searchPlaceholderText: "",
    allowSearchFilter: false,
    itemsShowLimit: 3,
  };

  FieldsTabelData: ITableProperties = {
    pageSize: 100,
    showPaginator: false,
    showSearch: false,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: false,
    isAllowDragDrop: true,
    rowOperations: [
      {
        operation: RowOperation.edit,
        title: "Desc_Edit",
        icon: "fa-regular fa-pen-to-square",
        color: "#12344d",
      },
      {
        operation: RowOperation.delete,
        title: "Desc_Delete",
        icon: "fa-solid fa-trash",
        color: "#f1685e",
        showWhenKeyValueFalse: true,
        showHideOptionPerLine: true,
        controlKeyName: "isBuiltIn",
      },
    ],
    multiSelectionOperations: [],
    columns: [
      {
        title: "Desc_Field_Name",
        key: "description",
        isSortable: false,
        width: "100%",
      },
    ],
  };

  //Navigator
  ChangeDataView(index: number) {
    this.navLinks.forEach((a) => (a.isActive = false));
    this.navBarSelectedIndex = index;
    this.navLinks[index].isActive = true;
  }
  prepareNavigation() {
    this.navLinks = [
      {
        label: "Desc_Main_Groups",
        index: 0,
        isActive: false,
        hidden: false,
        disable: false,
      },
      {
        label: "Desc_Bubbles",
        index: 1,
        isActive: false,
        hidden: false,
        disable: false,
      },
    ];
  }

  //constructor
  constructor(
    private customeMobileViewService: CustomeMobileViewService,
    private translateService: TranslateService,
    private formBuilder: FormBuilder,
    private coreSession: CoreSession,
    private modalService: NgbModal,
    private config: NgbModalConfig
  ) { }

  //ngOnInit
  ngOnInit() {
    this.getParametersList();
    this.prepareNavigation();
    this.navLinks[0].isActive = true;
    this.coreSession.SetTitle("Manage Golden Minute");
    this.GMGroupsDropdownSettings.unSelectAllText = this.translateService.instant(
      "Desc_UnSelect_All"
    );
    this.GMGroupsDropdownSettings.selectAllText = this.translateService.instant(
      "Desc_Select_All"
    );
    this.BubblesfieldDropdownSettings.unSelectAllText = this.translateService.instant(
      "Desc_UnSelect_All"
    );
    this.BubblesfieldDropdownSettings.selectAllText = this.translateService.instant(
      "Desc_Select_All"
    );
    this.FieldDropdownSettings.unSelectAllText = this.translateService.instant(
      "Desc_UnSelect_All"
    );
    this.FieldDropdownSettings.selectAllText = this.translateService.instant(
      "Desc_Select_All"
    );
    this.subscribeSaveClick();
    this.initGMGroupsAndBubbelsForm();
    this.getGMGroupsData();
  }

  //save
  subscribeSaveClick() {
    this.saveBtnSubscription = this.saveEvent.subscribe(() => {
      this.onSaveGMControl();
    });
  }

  //ngOnDestroy
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
    this.config.backdrop = true;
    this.config.keyboard = true;
  }

  //GMDilog
  GMGroupAddEditForm: FormGroup;
  GMNameInput: ITextInput = {
    formControlName: "GMName",
    placeHolder: "Desc_Group_Name",
    label: "Desc_Group_Name",
    isRequierd: true,
  };

  //FieldDilog
  FieldAddEditForm: FormGroup;
  FieldNameInput: ITextInput = {
    formControlName: "FieldName",
    placeHolder: "Desc_Field_Name",
    label: "Desc_Field_Name",
    isRequierd: true,
  };

  fieldOldDescription: any = [];
  addField(event: any) {
    this.isEditField = false;
    this.fieldOldDescription = null;
    this.FieldAddEditForm = new FormGroup({
      FieldName: new FormControl(
        { value: "", disabled: this.isViewMode },
        Validators.required
      ),
      descriptionLanguages: new FormControl([]),
      query: new FormControl(null, Validators.required),
    });
    this.disabled = "";
    this.modalRef = this.modalService.open(this.AddEditFieldDialog, {
      centered: true,
      size: "md",
    });
    return this.modalRef.result.then(
      (result) => { },
      (resaon) => {
        return DialogResult.None;
      }
    );
  }

  FieldData: any;
  disabled: string = "";
  EditField(event: any) {
    this.fieldOldDescription = null;
    this.FieldAddEditForm = new FormGroup({
      FieldName: new FormControl(
        { value: "", disabled: this.isViewMode },
        Validators.required
      ),
      descriptionLanguages: new FormControl([]),
      query: new FormControl(
        null,
        event.object.isBuiltIn ? null : Validators.required
      ),
    });
    if (this.isEditField) {
      this.customeMobileViewService
        .getFieldData(event.object.fieldID)
        .subscribe((result) => {
          this.FieldData = result.data;
          this.fieldOldDescription = this.FieldData.descriptionLanguages;
          this.FieldAddEditForm.get("FieldName").setValue(
            this.FieldData.description
          );

          if (!event.object.isBuiltIn) {
            this.FieldAddEditForm.get("query").setValue(this.FieldData.query);
            this.disabled = "";
          } else {
            this.disabled = "disabled";
          }
          this.modalRef = this.modalService.open(this.AddEditFieldDialog, {
            centered: true,
            size: "md",
          });
          return this.modalRef.result.then(
            (result) => { },
            (resaon) => {
              return DialogResult.None;
            }
          );
        });
    }
  }

  closeDialog() {
    this.modalService.dismissAll();
  }

  oldDescription: any = [];
  GMGroupData: any = [];
  GMGroupFieldsData: any = [];
  visiblefields: any = [];
  visiblefieldsDataSource: SharedTableResult = {
    data: [],
    totalItems: 0,
  };
  addEditGroup(event: any) {
    if (!event) {
      this.isEditGroup = false;
    } else {
      this.isEditGroup = true;
    }
    this.GMGroupAddEditForm = new FormGroup({
      GMName: new FormControl(
        { value: "", disabled: this.isViewMode },
        Validators.required
      ),
      descriptionLanguages: new FormControl([]),
      fields: new FormControl(),
    });

    if (!this.isEditGroup) {
      this.oldDescription = null;
      this.customeMobileViewService.getFieldsData(-1).subscribe((result) => {
        this.GMGroupFieldsData = result.data;
        this.visiblefields = [];
        this.visiblefieldsDataSource = {
          data: this.visiblefields,
          totalItems: this.visiblefields.length,
        };
        this.modalService
          .open(this.AddEditGMGroupDialog, { centered: true, size: "md" })
          .result.then((result) => { });
      });
    } else {
      this.customeMobileViewService
        .getGMGroupData(event.object.groupID)
        .subscribe((result) => {
          this.GMGroupData = result.data;
          this.oldDescription = this.GMGroupData.descriptionLanguages;
          this.GMGroupAddEditForm.get("GMName").setValue(
            this.GMGroupData.description
          );
          this.GMGroupFieldsData = this.GMGroupData.goldenMinuteFileds;
          this.visiblefields = this.GMGroupFieldsData.filter(
            (x) => x.isVisible == true
          );
          this.visiblefieldsDataSource = {
            data: this.visiblefields,
            totalItems: this.visiblefields.length,
          };
          this.GMGroupAddEditForm.get("fields").setValue(this.visiblefields);
          this.modalService
            .open(this.AddEditGMGroupDialog, { centered: true, size: "md" })
            .result.then((result) => { });
        });
    }
  }
  DeleteGroup(event: any) {
    var data = {
      groupID: event.object.groupID,
    };
    this.coreSession.ModalDialog.ShowMessage(
      this.translateService.instant(ConstantMessages.MsgDeleteConfirmation),
      DialogMode.YesNo,
      this.translateService.instant(ConstantMessages.WarningCaption)
    ).then((res: DialogResult) => {
      if (res === DialogResult.Yes) {
        if (event.object.isBuiltIn) {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(
              ConstantMessages.DescMsgCantDeleteBuiltInGroupsAndFields
            )
          );
        } else {
          this.customeMobileViewService
            .DeleteGroup(data)
            .subscribe((result) => {
              this.getGMGroupsData();
              this.coreSession.showSuccess(
                this.translateService.instant(ConstantMessages.SuccessCaption),
                this.translateService.instant(
                  ConstantMessages.MsgDeletedSuccessfully
                )
              );
            });
        }
      }
    });
  }
  otherGMLanguages: any[] = [];
  onOtherLanguagesTextSubmittedForGM(event: any) {
    this.otherGMLanguages = event;
    this.GMGroupAddEditForm.get("descriptionLanguages").setValue(
      this.otherGMLanguages
    );
  }

  otherGMLanguagess: any[] = [];
  onOtherLanguagesTextSubmittedForField(event: any) {
    this.otherGMLanguagess = event;
    this.FieldAddEditForm.get("descriptionLanguages").setValue(
      this.otherGMLanguagess
    );
  }
  saveAddEditField() {
    if (this.FieldAddEditForm.invalid) {
      this.coreSession.showError(
        this.translateService.instant(ConstantMessages.ErrorCaption),
        this.translateService.instant(ConstantMessages.MsgFillMandatory)
      );
    } else {
      let descriptions: any = [];
      if (this.FieldAddEditForm.get("descriptionLanguages").value.length != 0) {
        descriptions = this.FieldAddEditForm.get("descriptionLanguages").value;
        let index = descriptions.findIndex(
          (x) => x.languageId === this.coreSession.selectedLanguageId
        );
        if (index == -1) {
          descriptions.push({
            languageId: this.coreSession.selectedLanguageId,
            description: this.FieldAddEditForm.get("FieldName").value,
          });
        } else {
          descriptions[index].description = this.FieldAddEditForm.get(
            "FieldName"
          ).value;
        }
      }

      if (this.isEditField) {
        if (!this.isEditGroup) {
          this.selectedGMGroup = null;
        }
        if (
          !this.selectedField.object.isBuiltIn &&
          (this.FieldAddEditForm.get("query").value == null ||
            this.FieldAddEditForm.get("query").value == "")
        ) {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            ConstantMessages.DescAddQueryMsg
          );
        } else {
          let query = this.FieldAddEditForm.get("query").value
            ? this.FieldAddEditForm.get("query").value
            : "";
          if (query != "") {
            query = this.trimQuery(query);
            this.customeMobileViewService.testQuery(query).subscribe(
              (result) => {
                if (result.data == GlobalErrors.Error) {
                  this.coreSession.showError(
                    this.translateService.instant(
                      ConstantMessages.ErrorCaption
                    ),
                    this.translateService.instant(result.message)
                  );
                } else if (result.data == GlobalErrors.NotInitialized) {
                  this.coreSession.showWarrning(
                    this.translateService.instant(
                      ConstantMessages.WarningCaption
                    ),
                    this.translateService.instant(result.message)
                  );
                } else if (result.data == GlobalErrors.Success) {
                  let params = {
                    fieldID: this.selectedField
                      ? this.selectedField.object.fieldID
                      : -1,
                    descriptionLanguages: descriptions,
                    Query: query,
                  };
                  this.customeMobileViewService
                    .UpdateField(params)
                    .subscribe((result) => {
                      this.getGMGroupsData();
                      this.GMGroupFieldsData.find(
                        (x) => x.fieldID == this.selectedField.object.fieldID
                      ).descriptionLanguages = descriptions;
                      this.GMGroupFieldsData.find(
                        (x) => x.fieldID == this.selectedField.object.fieldID
                      ).description = descriptions.find(
                        (x) =>
                          x.languageId == this.coreSession.selectedLanguageId
                      ).description;

                      this.sortGMFieldArray();
                      var originalData = cloneDeep(this.GMGroupFieldsData);
                      this.GMGroupFieldsData = [];
                      this.GMGroupFieldsData = originalData;
                      this.modalRef.close();
                      this.coreSession.showSuccess(
                        this.translateService.instant(
                          ConstantMessages.SuccessCaption
                        ),
                        this.translateService.instant(
                          ConstantMessages.MsgSavedSuccessfuly
                        )
                      );
                    });
                }
              },
              (error: HttpErrorResponse) => {
                this.coreSession.ModalLoading.Hide();
                this.coreSession.showError(
                  this.translateService.instant(ConstantMessages.ErrorCaption),
                  this.translateService.instant(ConstantMessages.ErrorHappened)
                );
              }
            );
          } else {
            var params = {
              fieldID: this.selectedField.object.fieldID,
              query: this.FieldAddEditForm.get("query").value,
              descriptionLanguages: descriptions,
            };
            this.customeMobileViewService
              .UpdateField(params)
              .subscribe((result) => {
                this.getGMGroupsData();
                this.GMGroupFieldsData.find(
                  (x) => x.fieldID == this.selectedField.object.fieldID
                ).descriptionLanguages = descriptions;
                this.GMGroupFieldsData.find(
                  (x) => x.fieldID == this.selectedField.object.fieldID
                ).description = descriptions.find(
                  (x) => x.languageId == this.coreSession.selectedLanguageId
                ).description;
                this.sortGMFieldArray();
                var originalData = cloneDeep(this.GMGroupFieldsData);
                this.GMGroupFieldsData = [];
                this.GMGroupFieldsData = originalData;
                this.modalRef.close();

                this.coreSession.showSuccess(
                  this.translateService.instant(
                    ConstantMessages.SuccessCaption
                  ),
                  this.translateService.instant(
                    ConstantMessages.MsgSavedSuccessfuly
                  )
                );
              });
          }
        }
      } else {
        if (!this.isEditGroup) {
          this.selectedGMGroup = null;
        }
        let query = this.FieldAddEditForm.get("query").value;
        query = this.trimQuery(query);
        this.customeMobileViewService.testQuery(query).subscribe(
          (result) => {
            if (result.data == GlobalErrors.Error) {
              this.coreSession.showError(
                this.translateService.instant(ConstantMessages.ErrorCaption),
                this.translateService.instant(result.message)
              );
            } else if (result.data == GlobalErrors.NotInitialized) {
              this.coreSession.showWarrning(
                this.translateService.instant(ConstantMessages.WarningCaption),
                this.translateService.instant(result.message)
              );
            } else if (result.data == GlobalErrors.Success) {
              let params = {
                securityGroupId: this.securityGroupId,
                GroupId: this.selectedGMGroup
                  ? this.selectedGMGroup.object.groupID
                  : -1,
                descriptionLanguages: descriptions,
                Query: query,
              };
              this.customeMobileViewService
                .saveFieldToDB(params)
                .subscribe((result) => {
                  this.getGMGroupsData();

                  //  if(params.GroupId == -1){
                  let newField = result["data"];
                  newField.isVisible = true;
                  newField.sequence =
                    this.visiblefields.length > 0
                      ? this.visiblefields[this.visiblefields.length - 1]
                        .sequence + 1
                      : 1;
                  this.GMGroupFieldsData.push(newField);
                  //  }
                  var originalData = cloneDeep(this.GMGroupFieldsData);
                  this.GMGroupFieldsData = [];
                  this.GMGroupFieldsData = originalData;

                  this.modalRef.close();
                  this.coreSession.showSuccess(
                    this.translateService.instant(
                      ConstantMessages.SuccessCaption
                    ),
                    this.translateService.instant(
                      ConstantMessages.MsgSavedSuccessfuly
                    )
                  );
                  this.sortGMFieldArray();
                });
            }
          },
          (error: HttpErrorResponse) => {
            this.coreSession.ModalLoading.Hide();
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              this.translateService.instant(ConstantMessages.ErrorHappened)
            );
          }
        );
      }
    }
  }

  saveAddEditGroup() {
    if (this.GMGroupAddEditForm.invalid) {
      this.coreSession.showError(
        this.translateService.instant(ConstantMessages.ErrorCaption),
        this.translateService.instant(ConstantMessages.ErrorHappened)
      );
    } else {
      let descriptions: any = [];
      if (
        this.GMGroupAddEditForm.get("descriptionLanguages").value.length != 0
      ) {
        descriptions = this.GMGroupAddEditForm.get("descriptionLanguages")
          .value;
        let index = descriptions.findIndex(
          (x) => x.languageId === this.coreSession.selectedLanguageId
        );
        if (index == -1) {
          descriptions.push({
            languageId: this.coreSession.selectedLanguageId,
            description: this.GMGroupAddEditForm.get("GMName").value,
          });
        } else {
          descriptions[index].description = this.GMGroupAddEditForm.get(
            "GMName"
          ).value;
        }
      }
      if (this.isEditGroup) {
        //update
        if (this.GMGroupAddEditForm.invalid) {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        } else {
          let params = {
            securityGroupId: this.securityGroupId,
            GroupId: this.selectedGMGroup.object.groupID,
            descriptionLanguages: descriptions,
            goldenMinuteFileds: this.GMGroupFieldsData,
          };
          this.customeMobileViewService.UpdateGMGroup(params).subscribe(
            (response) => {
              this.isEditGroup = false;
              this.getGMGroupsData();
              this.closeDialog();
              this.coreSession.showSuccess(
                this.translateService.instant(ConstantMessages.SuccessCaption),
                this.translateService.instant(
                  ConstantMessages.MsgSavedSuccessfuly
                )
              );
            },
            (error: HttpErrorResponse) => {
              this.coreSession.ModalLoading.Hide();
              this.coreSession.showError(
                this.translateService.instant(ConstantMessages.ErrorCaption),
                this.translateService.instant(ConstantMessages.ErrorHappened)
              );
            }
          );
        }
      } else {
        // insert
        let params = {
          securityGroupId: this.securityGroupId,
          GroupId: this.selectedGMGroup
            ? this.selectedGMGroup.object.groupID
            : -1,
          descriptionLanguages: descriptions,
          goldenMinuteFileds: this.GMGroupFieldsData,
        };
        this.customeMobileViewService.InsertGoldenMinuteGroup(params).subscribe(
          (response) => {
            this.getGMGroupsData();

            this.closeDialog();

            this.coreSession.showSuccess(
              this.translateService.instant(ConstantMessages.SuccessCaption),
              this.translateService.instant(
                ConstantMessages.MsgSavedSuccessfuly
              )
            );
          },
          (error: HttpErrorResponse) => {
            this.coreSession.ModalLoading.Hide();
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              this.translateService.instant(ConstantMessages.ErrorHappened)
            );
          }
        );
      }
    }
  }

  //Menu
  isRightClickMenu: boolean = false;
  container = document.querySelector(".container");
  menu = document.querySelector(".menu") as HTMLElement;
  onQueryRightClick(e: MouseEvent) {
    this.menu = document.querySelector(".menu") as HTMLElement;
    this.menu.style.visibility = "";
    const target = e.target as HTMLTextAreaElement;
    let container = target.getBoundingClientRect();
    let X = e.clientX - container.left;
    let Y = e.clientY - container.top;

    this.drawMenu(X, Y);

    e.preventDefault();
  }
  // Context Menu Popup

  // Draw Menu
  drawMenu(mouseX, mouseY) {
    let menu = document.querySelector(".menu") as HTMLElement;
    this.menu = menu;
    menu.style.top = mouseY.toString() + "px";
    menu.style.left = mouseX.toString() + "px";
    menu.style.visibility = "visible";
  }

  hideMenu() {
    (this.menu as HTMLElement).style.visibility = "";
  }

  onSelectItem(str: string) {
    let query = this.FieldAddEditForm.get("query").value;
    if (query == "" || query == undefined) {
      query = str;
      this.FieldAddEditForm.get("query").setValue(query);
    } else {
      let selectionStart = (document.querySelector(
        ".rightClickTextArea"
      ) as HTMLInputElement).selectionStart;
      let selectionEnd = (document.querySelector(
        ".rightClickTextArea"
      ) as HTMLInputElement).selectionEnd;
      let q =
        this.FieldAddEditForm.get("query").value.slice(0, selectionStart) +
        str +
        this.FieldAddEditForm.get("query").value.slice(selectionEnd);
      this.FieldAddEditForm.get("query").setValue(q);
    }

    this.hideMenu();
  }

  parametersList: any;
  getParametersList() {
    this.customeMobileViewService.getParametersList().subscribe(
      (response) => {
        this.parametersList = response;
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }

  onSelectGmField(event: any) {
    var sequence = 1;
    let field: any = this.GMGroupFieldsData.find(
      (x) => x.fieldID == event.fieldID
    );
    if (field.isUsed) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgUsedField)
      );
      this.GMGroupAddEditForm.get("fields").setValue(this.visiblefields);
      return;
    }
    this.GMGroupFieldsData.forEach((x, index) => {
      if (x.sequence != -1 && x.sequence != 50000000) {
        x.sequence = sequence;
        sequence++;
      }
    });
    field.sequence = sequence;
    field.isVisible = true;
    this.sortGMFieldArray();
  }
  onDeselectGmField(event: any) {
    this.GMGroupFieldsData.find(
      (x) => x.fieldID == event.fieldID
    ).sequence = 50000000;
    this.GMGroupFieldsData.find(
      (x) => x.fieldID == event.fieldID
    ).isVisible = false;
    var sequence = 1;
    this.GMGroupFieldsData.forEach((x, index) => {
      if (x.sequence != -1 && x.sequence != 50000000) {
        x.sequence = sequence;
        sequence++;
      }
    });
    this.sortGMFieldArray();
  }
  onDeselectGmFieldAll() {
    this.GMGroupFieldsData.forEach((x, index) => {
      x.sequence = 50000000;
      x.isVisible = false;
    });
    this.sortGMFieldArray();
  }
  onSelectGmFieldAll() {
    var sequence = 1;
    if (this.visiblefields.length > 0) {
      sequence =
        this.GMGroupFieldsData[this.visiblefields.length - 1].sequence + 1;
    }
    this.GMGroupFieldsData.forEach((x, index) => {
      if (x.sequence == 50000000 || x.sequence == -1) {
        x.sequence = sequence;
        x.isVisible = true;
        sequence++;
      }
    });
    this.sortGMFieldArray();
  }
  onDragDropField(event: any) {
    var sequence = 1;
    this.visiblefieldsDataSource.data.forEach((x, index) => {
      if (x.sequence != -1 && x.sequence != 50000000) {
        x.sequence = sequence;
        sequence++;
        this.GMGroupFieldsData.find((y) => y.fieldID == x.fieldID).sequence =
          x.sequence;
      }
    });
    var originalData = cloneDeep(this.GMGroupFieldsData);
    this.GMGroupFieldsData = [];
    this.GMGroupFieldsData = originalData;
    this.sortGMFieldArray();
  }

  trimQuery(query: any) {
    query = query.trim();
    query = query.replace("\r", " ");
    query = query.replace("\n", " ");
    query = query.replace("\r\n", " ");
    return query;
  }

  selectedField: any = {};
  onFieldsTabelDataRowOperation(event: any) {
    this.selectedField = event;
    this.isEditField = true;
    switch (event.operation) {
      case RowOperation.edit:
        this.EditField(event);
        break;
      case RowOperation.delete:
        this.deleteField(event);
        break;
    }
  }

  deleteField(event: any) {
    this.coreSession.ModalDialog.ShowMessage(
      this.translateService.instant(ConstantMessages.MsgDeleteConfirmation),
      DialogMode.YesNo,
      this.translateService.instant(ConstantMessages.WarningCaption)
    ).then((res: DialogResult) => {
      if (res === DialogResult.Yes) {
        if (event.object.isBuiltIn) {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(
              ConstantMessages.DescMsgCantDeleteBuiltInGroupsAndFields
            )
          );
        } else {
          //delete
          let data = {
            fieldID: this.selectedField.object.fieldID,
          };
          this.customeMobileViewService.DeleteField(data).subscribe(
            (result) => {
              this.GMGroupFieldsData = this.GMGroupFieldsData.filter(
                (x) => x.fieldID !== data.fieldID
              );
              this.getGMGroupsData();
              this.sortGMFieldArray();
              this.coreSession.showSuccess(
                this.translateService.instant(ConstantMessages.SuccessCaption),
                this.translateService.instant(
                  ConstantMessages.MsgDeletedSuccessfully
                )
              );
            },
            (error: HttpErrorResponse) => {
              this.coreSession.ModalLoading.Hide();
              this.coreSession.showError(
                this.translateService.instant(ConstantMessages.ErrorCaption),
                this.translateService.instant(ConstantMessages.ErrorHappened)
              );
            }
          );
        }
      }
    });
  }

  //sort2
  sortGMFieldArray() {
    this.GMGroupFieldsData = this.GMGroupFieldsData.sort((a, b) =>
      a.sequence > b.sequence
        ? 1
        : a.sequence === b.sequence
          ? a.description > b.description
            ? 1
            : -1
          : -1
    );

    this.visiblefields = this.GMGroupFieldsData.filter(
      (x) => x.isVisible == true
    ).sort((a, b) =>
      a.sequence > b.sequence
        ? 1
        : a.sequence === b.sequence
          ? a.description > b.description
            ? 1
            : -1
          : -1
    );
    this.visiblefieldsDataSource = {
      data: this.visiblefields,
      totalItems: this.visiblefields.length,
    };
    this.InitializeGMGroupFieldsTemplateForm();
  }
}
