import { HttpErrorResponse } from '@angular/common/http';
import { Component, EventEmitter, Input, OnInit, ViewChild } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { TranslateService } from '@ngx-translate/core';
import { Subject } from 'rxjs/Rx';
import { CoreSession } from '../../../../core/core.session';
import { ResponseModel } from '../../../../shared/models/api-models/api-models';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { DialogMode } from '../../../../shared/models/enums/dialog-mode.enum';
import { DialogResult } from '../../../../shared/models/enums/dialog-result.enum';
import { MenuActions } from '../../../../shared/models/enums/menu-actions-enum';
import { MultiSelectionOperation, RowOperation } from '../../../../shared/models/enums/shared-table-operation.enum';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { CustomerService } from '../../../../shared/services/data-definition/customer/customers.service';
import * as cloneDeep from 'lodash/cloneDeep';
import { CustomerBlockedOperationService } from '../../../../shared/services/data-definition/customer/customer-blocked-operation.service';
import { GeneralFilter } from '../../../../shared/models/general/generalFilter.model';
import { NgbModal, NgbModalConfig, NgbModalRef } from '@ng-bootstrap/ng-bootstrap';
import { CustomerOrderLimitService } from '../../../../shared/services/data-definition/customer/customer-order-limit.service';
import { CommonButtonStyles } from '../../../../shared/models/enums/common-button-styles.enum';

@Component({
  selector: 'app-customer-blocked-operations-list',
  templateUrl: './customer-blocked-operations-list.component.html',
  styleUrls: ['./customer-blocked-operations-list.component.css']
})
export class CustomerBlockedOperationsListComponent implements OnInit {

  @ViewChild("EditCustomerBlockedOperations", { static: true })
  EditCustomerBlockedOperations: NgbModal;
  @Input('mode') mode: number = 1; //1: blocked operation, 2: order limit
  modalRef: NgbModalRef;
  saveSubject: Subject<void> = new Subject<void>();
  dataSource: SharedTableResult = { totalItems: 0, data: [] };
  newAddedCustomerList: any = [];
  selectedCustomerBlockedOperations: any = {};
  selectedCustomerOrderLimit: any = {};
  dialogHeader: any;
  territoryId: number = -1;
  BlockedcustomerOperationFilterForm: FormGroup;
  BlockedcustomerOperationDialogForm: FormGroup;
  allGroupsList: any = [];
  selectedRow: any;
  selectedCustomerOutletName = "";
  selectedCustomer = "";
  selectedOutlet = "";
  blockedOpertionsList: any = [];
  selectedGroup: any;
  addBlockedcustomerOperationForm: FormGroup;
  resetValues: EventEmitter<boolean> = new EventEmitter();
  CusromerOperationList: any = [];
  allowAdd: boolean;
  customerOrderList: any[] = [];
  multiSelectDropdownSettings = {
    singleSelection: false,
    idField: 'operationId',
    textField: 'description',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    itemsShowLimit: 5,
    disabled: true,
  };

  ddlGroupSettings = {
    singleSelection: false,
    idField: 'groupId',
    textField: 'groupCodeName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    itemsShowLimit: 2,
  };

  dropdownCusromerOperationSettings = {
    singleSelection: false,
    idField: 'operationId',
    textField: 'description',
    selectAllText: 'Select All',
    unSelectAllText: 'UnSelect All',
    position: 'top',
    allowSearchFilter: false,
    itemsShowLimit: 5
  };

  generalFilter: GeneralFilter = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: this.coreSession.pageSize
    },
    customerId: -1,
    territoryId: -1,
    routeId: -1,
  };

  TableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    isOnline: false,
    showSearch: true,
    showSearchBtn: true,
    showNewBtn: false,
    isMultiSelection: false,
    openFilterDirectly: false,
    buttonsZeroPadding: true,
    rowOperations: [
    ],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Customer', key: 'customer', isSortable: true, width: '20%' },
      { title: 'Desc_Outlet', key: 'outlet', isSortable: true, width: '20%' },
      { title: 'Desc_Group', key: 'group', isSortable: true, width: '20%' },
    ]
  };

  constructor(
    private config: NgbModalConfig,
    private modalService: NgbModal,
    private customerService: CustomerService,
    private customerBlockedOperationService: CustomerBlockedOperationService,
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private customerOrderLimitService: CustomerOrderLimitService) { }

  ngOnInit() {
    this.initForm();
    this.manageActions();
    this.initCustomerBlockedOperationsOrderLimitDialogForm();
    if (this.mode == 1) {
      this.TableData.columns.push({ title: 'Desc_Customer_Operations', isEditable: true, key: 'blokedOperation', isSortable: false, width: '40%', isMultiSelect: true });
      this.populateCustomerBlockedOperationsList();
      this.populateCustomerBlockedOperations();
      this.allowAdd = this.coreSession.checkActivitiesAvailability(ConstantURLs.CustomerBlockedOperationsURL, MenuActions.Add);

      this.multiSelectDropdownSettings.unSelectAllText = this.translateService.instant("Desc_UnSelect_All");
      this.multiSelectDropdownSettings.selectAllText = this.translateService.instant("Desc_Select_All");
      this.CusromerOperationList[0] = { operationId: 1, description: 'Sales' };
      this.CusromerOperationList[1] = { operationId: 2, description: 'Returns' };
    } else if (this.mode == 2) {
      this.TableData.isMultiSelection = true;
      this.TableData.columns.push({ title: 'Desc_Limit', isEditable: false, key: 'limit', isSortable: false, numberOfDigits: true, width: '40%' });
      this.TableData.multiSelectionOperations.push({ operation: MultiSelectionOperation.delete, title: 'Desc_Delete', icon: 'fa-solid fa-trash', color: '#f1685e', style: CommonButtonStyles.Negative.valueOf() });
      this.populateCustomerOrderLimitList();
      this.allowAdd = this.coreSession.checkActivitiesAvailability(ConstantURLs.customerOrderLimitURL, MenuActions.Add);
    }
    this.populateCustomerGroups();
    this.dropdownCusromerOperationSettings.unSelectAllText = this.translateService.instant("Desc_UnSelect_All");
    this.dropdownCusromerOperationSettings.selectAllText = this.translateService.instant("Desc_Select_All");

    this.ddlGroupSettings.unSelectAllText = this.translateService.instant("Desc_UnSelect_All");
    this.ddlGroupSettings.selectAllText = this.translateService.instant("Desc_Select_All");
  }

  //table
  onRowOperation(event: any) {
    this.selectedRow = event.object;
    switch (event.operation) {
      case RowOperation.delete:
        (event.object);
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption))
          .then(
            (result: DialogResult) => {
              if (result === DialogResult.Yes) {
                if (this.mode == 1) {
                  this.deleteCustomerBlockedOperationList(event.object);
                } else if (this.mode == 2) {
                  this.deleteCustomerOrderLimitList([event.object]);
                }

              }
            }
          );
        break;
      case RowOperation.edit:
        if (this.mode == 1) {
          this.selectedCustomerBlockedOperations = cloneDeep(event.object);
          this.EditCustomerBlockedOperationOrderLimitList(this.selectedCustomerBlockedOperations);
        } else if (this.mode == 2) {
          this.selectedCustomerOrderLimit = cloneDeep(event.object);
          this.EditCustomerBlockedOperationOrderLimitList(this.selectedCustomerOrderLimit);
        }
        break;
    }
  }

  //table
  manageActions() {
    if (this.mode == 1) {
      if (this.coreSession.checkActivitiesAvailability(ConstantURLs.CustomerBlockedOperationsURL, MenuActions.Delete)) {
        this.TableData.rowOperations.push({
          operation: RowOperation.delete,
          title: 'Desc_Delete',
          icon: 'fa-solid fa-trash',
          color: '#f1685e'
        });
      }

      if (this.coreSession.checkActivitiesAvailability(ConstantURLs.CustomerBlockedOperationsURL, MenuActions.Edit)) {
        this.TableData.rowOperations.push({
          operation: RowOperation.edit,
          title: "Desc_Edit",
          icon: "fa-regular fa-pen-to-square",
          color: "#12344d"
        });
      }
    } else if (this.mode == 2) {
      if (this.coreSession.checkActivitiesAvailability(ConstantURLs.customerOrderLimitURL, MenuActions.Delete)) {
        this.TableData.rowOperations.push({
          operation: RowOperation.delete,
          title: 'Desc_Delete',
          icon: 'fa-solid fa-trash',
          color: '#f1685e'
        });
      }

      if (this.coreSession.checkActivitiesAvailability(ConstantURLs.customerOrderLimitURL, MenuActions.Edit)) {
        this.TableData.rowOperations.push({
          operation: RowOperation.edit,
          title: "Desc_Edit",
          icon: "fa-regular fa-pen-to-square",
          color: "#12344d"
        });
      }
    }
  }

  initForm() {
    this.BlockedcustomerOperationFilterForm = new FormGroup({
      customerId: new FormControl(null),
      territoryId: new FormControl(null),
      routeId: new FormControl(null),
    });

    this.addBlockedcustomerOperationForm = new FormGroup({
      customerId: new FormControl(null),
      outletId: new FormControl(null),
      blokedOperation: new FormControl([], this.mode == 1 ? Validators.required : Validators.nullValidator),
      groupId: new FormControl(null),
      territoryId: new FormControl(null),
      routeId: new FormControl(null),
      limit: new FormControl(null, this.mode == 2 ? Validators.required : Validators.nullValidator),
    });
  }

  initCustomerBlockedOperationsOrderLimitDialogForm() {
    this.BlockedcustomerOperationDialogForm = new FormGroup({
      blokedOperation: new FormControl([], this.mode == 1 ? Validators.required : Validators.nullValidator),
      customerId: new FormControl(null),
      groupId: new FormControl(null),
      outletId: new FormControl(null),
      limit: new FormControl(null, this.mode == 2 ? Validators.required : Validators.nullValidator),
    });
  }
  //filter
  applySerachFilterOnFind() {
    this.generalFilter.customListFilter.page = 0;
    this.generalFilter.customListFilter.pageSize = this.TableData.pageSize;
    this.generalFilter.customerId = this.BlockedcustomerOperationFilterForm.get('customerId').value == null ? -1 : this.BlockedcustomerOperationFilterForm.get('customerId').value,
      this.generalFilter.territoryId = this.BlockedcustomerOperationFilterForm.get('territoryId').value == null ? -1 : this.BlockedcustomerOperationFilterForm.get('territoryId').value,
      this.generalFilter.routeId = this.BlockedcustomerOperationFilterForm.get('routeId').value == null ? -1 : this.BlockedcustomerOperationFilterForm.get('routeId').value;
    if (this.mode == 1)
      this.populateCustomerBlockedOperationsList();
    else if (this.mode == 2)
      this.populateCustomerOrderLimitList();
  }

  onReset() {
    this.BlockedcustomerOperationFilterForm.reset();
  }

  onTableFilterChanged(query: any) {
    this.generalFilter.customListFilter = query;
    if (this.mode == 1) {
      this.populateCustomerBlockedOperationsList();
    } else if (this.mode == 2) {
      this.populateCustomerOrderLimitList();
    }
  }

  resetForm() {
    this.addBlockedcustomerOperationForm.get('customerId').setValue(null);
    this.addBlockedcustomerOperationForm.get('outletId').setValue(null);
    this.addBlockedcustomerOperationForm.get('blokedOperation').setValue([]);
    this.addBlockedcustomerOperationForm.get('groupId').setValue(null);
    this.addBlockedcustomerOperationForm.get('territoryId').setValue(null);
    this.addBlockedcustomerOperationForm.get('routeId').setValue(null);
    this.addBlockedcustomerOperationForm.get('limit').setValue(null);
    if (this.mode == 1) {
      var originalData = cloneDeep(this.blockedOpertionsList);
      this.blockedOpertionsList = [];
      this.blockedOpertionsList = originalData;
    } else if (this.mode == 2) {
      var originalData = cloneDeep(this.customerOrderList);
      this.blockedOpertionsList = [];
      this.customerOrderList = originalData;
    }
  }

  //populate
  populateCustomerBlockedOperationsList() {
    this.coreSession.ModalLoading.Show();
    this.customerBlockedOperationService.getCustomerBlokedOperationData(this.generalFilter).subscribe(
      (response: ResponseModel) => {
        this.coreSession.ModalLoading.Hide();
        this.dataSource = response.data;
        if (this.dataSource.totalItems == 0 && this.dataSource.data == null) {
          this.dataSource.data = [];
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  populateCustomerOrderLimitList() {
    this.coreSession.ModalLoading.Show();
    this.customerOrderLimitService.getCustomerOrderLimitData(this.generalFilter).subscribe(
      (response: ResponseModel) => {
        this.coreSession.ModalLoading.Hide();
        this.dataSource = response.data;
        this.customerOrderList = this.dataSource.data;
        if (this.dataSource.totalItems == 0 && this.dataSource.data == null) {
          this.dataSource.data = [];
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  //populate
  populateCustomerGroups() {
    this.coreSession.ModalLoading.Show();
    this.customerService.getAllCustomerGroups('').subscribe(
      (response: ResponseModel) => {
        this.coreSession.ModalLoading.Hide();
        this.allGroupsList = response.data;
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

  //populate
  populateCustomerBlockedOperations() {
    this.coreSession.ModalLoading.Show();
    this.customerBlockedOperationService.getCustomerBlockedOperations().subscribe(
      (response: ResponseModel) => {
        this.coreSession.ModalLoading.Hide();
        this.blockedOpertionsList = response.data;
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

  //on select customer
  onCustomerChange($event) {
    this.selectedCustomerOutletName = $event.customerName;
    this.selectedCustomer = $event.customerCodeName;
  }

  //on select outlet
  onChangeOutlet($event) {
    this.selectedCustomerOutletName += " - " + $event.outletName;
    this.selectedOutlet = $event.customerCode + ' - ' + $event.outletName;
  }

  //on select group
  onChangeGroup($event) {
    this.selectedGroup = $event.groupCodeName;
  }


  //add Customer Blocked Operations / order limit to List
  addCustomerBlockedOperationsList() {
    this.addBlockedcustomerOperationForm.markAllAsTouched();
    if (this.addBlockedcustomerOperationForm.valid) {

      if (this.addBlockedcustomerOperationForm.get("customerId").value != null &&
        this.addBlockedcustomerOperationForm.get("outletId").value != null ||
        this.addBlockedcustomerOperationForm.get("groupId").value != null) {

        if (this.addBlockedcustomerOperationForm.get("customerId").value && this.addBlockedcustomerOperationForm.get("outletId").value) {
          this.addCusromerOperationRow(this.addBlockedcustomerOperationForm.get("customerId").value, this.addBlockedcustomerOperationForm.get("outletId").value, -1);
        }
        if (this.addBlockedcustomerOperationForm.get("groupId").value) {
          this.addCusromerOperationRow(-1, -1, this.addBlockedcustomerOperationForm.get("groupId").value);
        }
        this.resetForm();
        if (this.newAddedCustomerList != 0 && this.mode == 1) {
          this.saveCustomerBlockedOperationsListChanges();
        }
        else if (this.newAddedCustomerList != 0 && this.mode == 2) {
          this.saveCustomerOrderLimitListChanges();
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgSelectCutomerOrGroup));
      }

    }
    else {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
    }
  }

  addCusromerOperationRow(customerId: number, outletID: number, groupID: number) {
    let obj: any;
    if (this.mode == 1) {
      obj = {
        blokedOperation: this.addBlockedcustomerOperationForm.get("blokedOperation").value,
        customer: customerId != -1 ? this.selectedCustomer : '---',
        customerID: customerId,
        group: groupID != -1 ? this.selectedGroup : '---',
        groupID: groupID,
        outlet: outletID != -1 ? this.selectedOutlet : '---',
        outletID: outletID
      }
    } else if (this.mode == 2) {
      obj = {
        limit: +this.addBlockedcustomerOperationForm.get("limit").value,
        customer: customerId != -1 ? this.selectedCustomer : '---',
        customerID: customerId,
        group: groupID != -1 ? this.selectedGroup : '---',
        groupID: groupID,
        outlet: outletID != -1 ? this.selectedOutlet : '---',
        outletID: outletID,
      }
    }
    if (obj.customerID != -1 && obj.outletID != -1 && this.dataSource.totalItems > 0 && this.dataSource.data.find(x => x.customerID == obj.customerID && x.outletID == obj.outletID)) {
      if (this.mode == 1)
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.Desc_Msg_Customer_Outlet_Blocked_Operation_Exist))
      else if (this.mode == 2)
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgCustomerOutletOrderLimitExists));
    }
    else if (obj.groupID != -1 && this.dataSource.totalItems > 0 && this.dataSource.data.find(x => x.groupID == obj.groupID)) {
      if (this.mode == 1)
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.Desc_Msg_Group_Blocked_Operation_Exist));
      else if (this.mode == 2)
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgCustomerGroupOrderLimitExists));
    } else {
      this.newAddedCustomerList.push(obj);
    }
  }

  //Delete Customer Blocked Operations from saved List
  deleteCustomerBlockedOperationList(selectedRow) {
    this.coreSession.ModalLoading.Show();
    this.customerBlockedOperationService.deleteCustomerBlokedOperation(selectedRow).subscribe(
      (response: any) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgDeletedSuccessfully));
          this.populateCustomerBlockedOperationsList();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      });
  }
  deleteCustomerOrderLimitList(selectedRows) {
    this.coreSession.ModalLoading.Show();
    this.customerOrderLimitService.deleteCustomerOrderLimit(selectedRows).subscribe(
      (response: any) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgDeletedSuccessfully));
          this.populateCustomerOrderLimitList();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      });
  }
  //Edit Dialog
  EditCustomerBlockedOperationOrderLimitList(data: any) {
    if (this.mode == 1) {
      let blockedOp = data.blokedOperation;
      this.BlockedcustomerOperationDialogForm.get("blokedOperation").setValue(blockedOp);
    } else if (this.mode == 2) {
      let orderLimit = data.limit;
      this.BlockedcustomerOperationDialogForm.get("limit").setValue(orderLimit);
    }
    this.config.backdrop = "static";
    this.modalRef = this.modalService.open(this.EditCustomerBlockedOperations, {
      centered: true,
    });
    this.config.backdrop = true;
    if (data.customerID != -1) {
      this.dialogHeader = data.customer
    } else {
      this.dialogHeader = data.group
    }
  }

  onCloseCustomerBlockedOperation() {
    this.modalRef.dismiss();
    this.BlockedcustomerOperationDialogForm.reset();
  }

  updateCustomerBlockedOperation() {
    this.BlockedcustomerOperationDialogForm.get("customerId").setValue(this.selectedCustomerBlockedOperations.customerID);
    this.BlockedcustomerOperationDialogForm.get("groupId").setValue(this.selectedCustomerBlockedOperations.groupID);
    this.BlockedcustomerOperationDialogForm.get("outletId").setValue(this.selectedCustomerBlockedOperations.outletID);
    this.coreSession.ModalLoading.Show();
    this.customerBlockedOperationService.updateCustomerBlokedOperation(this.BlockedcustomerOperationDialogForm.value).subscribe(
      (response: any) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly));
        this.populateCustomerBlockedOperationsList();
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
    this.onCloseCustomerBlockedOperation();
    this.onReset();
  }
  updateCustomerOrderLimit() {
    this.BlockedcustomerOperationDialogForm.get("customerId").setValue(this.selectedCustomerOrderLimit.customerID);
    this.BlockedcustomerOperationDialogForm.get("groupId").setValue(this.selectedCustomerOrderLimit.groupID);
    this.BlockedcustomerOperationDialogForm.get("outletId").setValue(this.selectedCustomerOrderLimit.outletID);
    var limit = +this.BlockedcustomerOperationDialogForm.get("limit").value;
    this.BlockedcustomerOperationDialogForm.get("limit").setValue(limit);
    this.coreSession.ModalLoading.Show();
    this.customerOrderLimitService.updateCustomerOrderLimit(this.BlockedcustomerOperationDialogForm.value).subscribe(
      (response: any) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly));
        this.populateCustomerOrderLimitList();
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
    this.onCloseCustomerBlockedOperation();
    this.onReset();
  }
  //save Customer Blocked Operations to lisr=t
  saveCustomerBlockedOperationsListChanges() {
    let data = this.newAddedCustomerList;
    this.coreSession.ModalLoading.Show();
    this.customerBlockedOperationService.insertCustomerBlockedOperationList(data).subscribe(
      (response: any) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
        this.populateCustomerBlockedOperationsList();
        this.newAddedCustomerList = []
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.newAddedCustomerList = []
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  // save Customer order list
  saveCustomerOrderLimitListChanges() {
    let data = this.newAddedCustomerList;
    this.coreSession.ModalLoading.Show();
    this.customerOrderLimitService.insertCustomerOrderLimitList(data).subscribe(
      (response: any) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
        this.populateCustomerOrderLimitList();
        this.newAddedCustomerList = []
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.newAddedCustomerList = []
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  onMultiSelectionOperationForCustomerOrderLimit(event: any) {

    switch (event.operation) {
      case MultiSelectionOperation.delete: {
        this.onDeleteSelectedAddedCustomersOrderLimit(event.object);
        break;
      }
    }
  }

  onDeleteSelectedAddedCustomersOrderLimit(selectedCustomersOrderLimitList) {

    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          this.deleteCustomerOrderLimitList(selectedCustomersOrderLimitList);
        }
        this.populateCustomerOrderLimitList();
      });
  }
}


