import { FormControl, FormGroup, Validators, FormArray } from '@angular/forms';
import { Component, OnInit, ViewChild, Output } from '@angular/core';
import { IDateTimePickerProperties } from '../../../../shared/models/dateTimeModel/date-time-properties.interface';
import { DateTimeModel } from '../../../../shared/models/dateTimeModel/date-time.model';
import { CustomerService } from '../../../../shared/services/data-definition/customer/customers.service';
import { CustomerGroupModel } from '../../../../shared/models/customer/customer.group.model';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { Input } from '@angular/core';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { MultiSelectionOperation, RowOperation } from '../../../../shared/models/enums/shared-table-operation.enum';
import { CoreSession } from '../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { DialogResult } from '../../../../shared/models/enums/dialog-result.enum';
import * as cloneDeep from 'lodash/cloneDeep';
import { SelectCustomersComponent } from '../../../../shared/components/customers/select-customers/select-customers.component';
import { DialogMode } from '../../../../shared/models/enums/dialog-mode.enum';
import { SalesRestrictionModel } from '../../../../shared/models/salesRestriction/sales-restriction.model';
import { ICashEntryModel } from '../../../../shared/models/customer/customer-icash.model';
import { Observable } from 'rxjs';
import { MasterDataService } from '../../master-data.service';
import { EventEmitter } from '@angular/core';
import { CommonButtonStyles } from '../../../../shared/models/enums/common-button-styles.enum';
import { stat } from 'fs';
import { ConstantConfigurations } from '../../../../shared/models/constants/constant-configuration';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { CustomerICashService } from '../../../../shared/services/data-definition/customer/customer-icash.service';

@Component({
  selector: 'app-customer-icash-entry',
  templateUrl: './customer-icash-entry.component.html',
  styleUrls: ['./customer-icash-entry.component.css']
})

export class CustomerIcashEntryComponent implements OnInit {

  //#region [Declarations]
  @ViewChild("selectCustomerDialog", { static: true }) selectCustomerDialog: SelectCustomersComponent;
  @Input() icashListObject: any = new Object();
  @Input() isEditMode = false;
  @Output() onSaveCompleted = new EventEmitter();
  iCashEntryModel: ICashEntryModel;
  icashFormEntry: FormGroup;
  @Input() events: Observable<void>;
  selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
  unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
  searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
  allChannelsList: any[] = [];
  allGroupsList: CustomerGroupModel[] = [];
  addedCustomersList: any[] = [];
  copyOfAddedCustomers: any[] = [];
  navLinks: any[];
  detailsList: any[];
  showDefinitionData: boolean = false;
  showAppliedData: boolean = false;
  showSelectCustomersDialog = false;
  isAllCustomersChecked: boolean = false;
  fromToDate: DateTimeModel[];
  saveBtnSubscription: any;
  organizationsList: any[] = [];
  isOrganizationLoading: boolean = false;
  groupSelected: any[];


  DateProperties: IDateTimePickerProperties = {
    label: 'Desc_Date',
    formControlName: 'fromToDate',
    isCalendarOnly: true,
    isRange: true
  };

  ddlGroupSettings = {
    singleSelection: false,
    idField: 'groupId',
    textField: 'groupName',
    selectAllText: this.selectAllText,
    unSelectAllText: this.unSelectAllText,
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: this.searchPlaceholderText,
    itemsShowLimit: 1
  };

  ddlChannelSettings = {
    singleSelection: false,
    idField: 'channelSubChannelIds',
    textField: 'channelSubChannelDescriptions',
    selectAllText: this.selectAllText,
    unSelectAllText: this.unSelectAllText,
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: this.searchPlaceholderText,
    itemsShowLimit: 1
  };

  detailsDataSource: SharedTableResult = {
    totalItems: 0,
    data: [],
  };

  customersDataSource: SharedTableResult = {
    totalItems: 0,
    data: [],
  };

  customersSharedTabel: ITableProperties = {
    pageSize: 50,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: true,
    showNewBtn: true,
    showEditButton: false,
    newBtnCaption: 'Desc_Add',
    rowOperations: [
    ],
    multiSelectionOperations: [{
      operation: MultiSelectionOperation.delete,
      title: 'Desc_Delete',
      icon: 'fa-solid fa-trash',
      color: '#f1685e',
      style: CommonButtonStyles.Negative.valueOf()
    }],
    columns: [
      { title: 'Desc_Customer', key: 'customerCodeName', isSortable: true, width: '50%' },
      { title: 'Desc_Outlet', key: 'outletCodeName', isSortable: true, width: '50%' }
    ]
  };

  detailsSharedTabel: ITableProperties = {
    pageSize: 50,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: false,
    showEditButton: false,
    showNewBtn: true,
    newBtnCaption: 'Desc_Add',
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: 'Desc_Delete', icon: 'fa-solid fa-trash', color: '#f1685e'
      }
    ],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Amount_To_Buy', key: 'amountToBuy', isSortable: false, width: '40%', isEditable: true, numberOfStockDigits: true },
      { title: 'Desc_Amount_To_Get', key: 'amountToGet', isSortable: false, width: '40%', isEditable: true, numberOfStockDigits: true }
    ]
  };

  constructor(
    private customerService: CustomerService,
    private customerICashService: CustomerICashService,
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private masterDataService: MasterDataService,
    private sessionData: SessionDataProvider,
  ) { }
  //#endregion

  //#region  [Events]


  onChangeDate(event) {

    if (this.isEditMode) {
      this.iCashEntryModel.fromToDate = event;
      this.iCashEntryModel.startDate = event[0].date;
      this.iCashEntryModel.endDate = event[1].date;
    } else {
      this.iCashEntryModel.fromToDate = event;
    }

  }

  ngOnInit() {

    this.iCashEntryModel = new ICashEntryModel();
    this.subscribeSaveClick();
    this.initializeForm();
    this.prepareNavigation();
    this.fillOrganizationList();
    this.showDefinitionData = true;
    this.showAppliedData = false;
    this.navLinks[0].isActive = true;
    this.detailsList = [];
    this.groupSelected = [];


    if (this.isEditMode && this.icashListObject.itemListId != -1) {


      this.addedCustomersList = this.icashListObject.appliedCustomers;
      this.detailsDataSource = this.icashListObject.iCashDetailsModel;
      this.fillCustomersList();
      this.iCashEntryModel.iCashListID = this.icashListObject.iCashListID;
      this.icashFormEntry.get("icashCode").setValue(this.icashListObject.iCashCode);
      this.icashFormEntry.get("organizationId").setValue(this.icashListObject.organizationID);
      this.icashFormEntry.get("fromToDate").setValue([this.icashListObject.startDate, this.icashListObject.endDate]);
      this.icashFormEntry.get('channelControl').setValue(this.icashListObject.appliedChannels);
      this.icashFormEntry.get('groupsControl').setValue(this.icashListObject.appliedGroups);
      this.icashFormEntry.get('IsInactive').setValue(this.icashListObject.isInactive);

      if (this.icashListObject.appliedChannels.length == 0 && this.icashListObject.appliedGroups.length == 0 && this.icashListObject.appliedCustomers.length == 0) {
        this.icashFormEntry.get('allCustomers').setValue(true);
        this.navLinks[1].disable = true;
      }

      this.iCashEntryModel.endDate = this.icashListObject.endDate;
      this.iCashEntryModel.startDate = this.icashListObject.startDate;
      this.iCashEntryModel.fromToDate = this.icashListObject.fromToDate;
      this.detailsDataSource = {
        totalItems: this.icashListObject.iCashDetailsModel.length,
        data: this.icashListObject.iCashDetailsModel
      };
    } else {
      this.detailsList.push(
        {
          amountToBuy: Number(0),
          amountToGet: Number(0)
        }
      )
      this.detailsDataSource = {
        totalItems: this.detailsList.length,
        data: this.detailsList
      };
    }


  }

  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.onSaveClick();
    });
  }

  ngOnDestroy(): void {
    this.saveBtnSubscription.unsubscribe();
  }

  onCheckAllCustomers(checkInput) {

    this.isAllCustomersChecked = checkInput.currentTarget.checked;
    this.isAllCustomersChecked ? this.navLinks[1].disable = true : this.navLinks[1].disable = false;

  }

  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        this.onDeleteAppliedCustomer(event.object);
        break;
    }
  }

  onDeleteAppliedCustomer(deletedOutlet: any) {
    var index = this.addedCustomersList.findIndex(x => x.customerId === deletedOutlet.customerId && x.outletId === deletedOutlet.outletId);
    if (index >= 0) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.addedCustomersList.splice(index, 1);
            this.fillCustomersList();
          }
        });
    }
  }

  //#endregion

  //#region [Functions]

  initializeForm() {
    this.icashFormEntry = new FormGroup({
      iCashListID: new FormControl(-1, Validators.required),
      icashCode: new FormControl(null, Validators.required),
      IsInactive: new FormControl(false),
      organizationId: new FormControl([], Validators.required),
      fromToDate: new FormControl([], Validators.required),
      groupsControl: new FormControl([]),
      channelControl: new FormControl([]),
      allCustomers: new FormControl(false),
      iCashDetailsModel: new FormArray([])
    })
  }

  populateChannelsSubChannelsList() {
    this.customerService.GetAllCustomerChannels(null).subscribe(result => {
      this.allChannelsList = result;
    });
  }

  filterChannelsByGroupIDsOnSelectDeSelect(event: any, status: string) {
    this.allChannelsList = [];
    var arrayList = [];
    arrayList.push(event != undefined || event != null ? event.groupId : 0)
    switch (status) {
      case "DeSelect": {

        let index = this.groupSelected.findIndex(x => x == arrayList);
        this.groupSelected.splice(index, 1);
        break;
      }
      case "Select": {
        this.groupSelected.push(arrayList[0]) ;// = arrayList;

        if (this.groupSelected.length > 1) {
          this.groupSelected.join(",");
        }
        break;
      }
    }

    this.customerService.GetAllCustomerChannels(this.groupSelected).subscribe(result => {
      this.allChannelsList = result;
    });
  }

  filterChannelsByGroupIDsAllSelectDeSelect(event: any[], status: string) {
    switch (status) {
      case "onSelectAll": {
        event.forEach(res => {
          this.groupSelected.push(res.groupId);
        })
        this.groupSelected.join(",");
        break;
      }
      case "onDeSelectAll": {
        this.groupSelected=[];
        break;
      }
    }
    this.customerService.GetAllCustomerChannels(this.groupSelected).subscribe(result => {
      this.allChannelsList = result;
    });
  }

  populateGroupsList() {
    this.customerService.getAllCustomerGroups(this.icashFormEntry.get("organizationId").value).subscribe(result => {
      this.allGroupsList = result.data;
    });
  }

  fillCustomersList() {
    this.customersDataSource = {
      totalItems: this.addedCustomersList.length,
      data: this.addedCustomersList
    };
  }

  openSelectCustomersDialog() {

    this.copyOfAddedCustomers = null;
    this.copyOfAddedCustomers = cloneDeep(this.addedCustomersList);
    this.showSelectCustomersDialog = true;
    this.selectCustomerDialog.showDialog(this.icashFormEntry.get("organizationId").value).then(
      (result) => {
        if (result != -1) {
          this.afterAddingSelectedCustomers(result)
        } else {
          this.closeSelectCustomersDialog();
        }
      });
  }

  afterAddingSelectedCustomers(selectedCustomers) {
    this.addedCustomersList = selectedCustomers;
    this.fillCustomersList();
    this.closeSelectCustomersDialog();
  }

  closeSelectCustomersDialog() {
    this.showSelectCustomersDialog = false;
    if (this.isEditMode) {
      this.coreSession.SetTitle('Edit Item List');
    } else {
      this.coreSession.SetTitle('Add Item List');
    }
  }

  addDynamicRow() {
    if (this.isEditMode) {

      this.icashListObject.iCashDetailsModel.push(
        {
          amountToBuy: Number(0),
          amountToGet: Number(0)
        }
      )
    } else {
      this.detailsList.push(
        {
          amountToBuy: Number(0),
          amountToGet: Number(0)
        }
      )
    }
  }

  markAsTouched() {
    this.icashFormEntry.get("icashCode").markAsTouched();
    this.icashFormEntry.get("fromToDate").markAsTouched();
    this.icashFormEntry.get("organizationId").markAsTouched();
  }

  fillEntryObjectAndCheckValidation() {

    this.markAsTouched();
    if (this.icashFormEntry.invalid) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgFillMandatory));
      this.showEntrySection(0);
      return;
    } else {

      this.iCashEntryModel.iCashListID < 0 ? this.iCashEntryModel.iCashListID = -1 : this.iCashEntryModel.iCashListID;
      this.iCashEntryModel.iCashCode = this.icashFormEntry.get('icashCode').value;
      this.iCashEntryModel.isInactive = this.icashFormEntry.get('IsInactive').value;
      this.iCashEntryModel.allCustomers = this.icashFormEntry.get('allCustomers').value;
      this.iCashEntryModel.organizationID = this.icashFormEntry.get("organizationId").value;
      this.iCashEntryModel.appliedGroups = this.icashFormEntry.get('groupsControl').value;
      this.iCashEntryModel.appliedChannels = this.icashFormEntry.get('channelControl').value;
      this.iCashEntryModel.appliedCustomers = this.addedCustomersList;
      if (this.detailsDataSource.data.length > 0) {
        this.detailsDataSource.data.forEach(res => {
          res.amountToBuy = Number(res.amountToBuy);
          res.amountToGet = Number(res.amountToGet);
        })
      } else {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant(ConstantMessages.MsgPleaseFillAllAmountsInTheValueslist));
        return;
      }
      this.iCashEntryModel.iCashDetailsModel = this.detailsDataSource.data;
      if (this.checkDuplicatesAndInvalidValuesInDetails()) {
        return this.iCashEntryModel;
      } else { return; }
    }
  }

  checkDuplicatesAndInvalidValuesInDetails() {
    let isDuplicate = false;
    let chkZeroValue = false;
    this.iCashEntryModel.iCashDetailsModel.forEach((item) => {
      if (this.iCashEntryModel.iCashDetailsModel.
        filter(i => i.amountToBuy === item.amountToBuy).length > 1) {
        isDuplicate = true;
      } else {
        isDuplicate = false;
      }
      if (item.amountToBuy == 0) {
        chkZeroValue = true;
      } else {
        chkZeroValue = false;
      }
    });


    if (isDuplicate) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgYouCantInsertDuplicateNumbers));
      this.showEntrySection(0);
      return false;
    } else if (chkZeroValue) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgPleaseFillAllAmountsInTheValueslist));
      this.showEntrySection(0);
      return false;
    } else if (!isDuplicate && !chkZeroValue) {
      if (!this.iCashEntryModel.allCustomers && ((this.icashFormEntry.value.groupsControl == null || (this.icashFormEntry.value.groupsControl != null && this.icashFormEntry.value.groupsControl.length == 0)) && (this.icashFormEntry.value.channelControl == null || (this.icashFormEntry.value.channelControl != null && this.icashFormEntry.value.channelControl.length == 0)) && (this.customersDataSource.data == null || (this.customersDataSource.data != null && this.customersDataSource.data.length == 0)))) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgApplyItemListToCustomer));
        this.showEntrySection(1);
        return false;
      } else {
        return true;
      }
    }

  }


  onSaveClick() {

    if (this.fillEntryObjectAndCheckValidation() != undefined) {
      this.customerICashService.InsertOrUpdateICashData(this.fillEntryObjectAndCheckValidation(), this.isEditMode).subscribe(
        result => {
          this.coreSession.ModalLoading.Hide();
          if (result.status != null && result.status >= 0) {
            this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
            this.onSaveCompleted.emit();
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), result.message);
          }
        },
        error => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );;

    }
  }

  fillOrganizationList() {

    this.organizationsList = [];
    this.isOrganizationLoading = true;
    this.masterDataService.getOrganizationList().subscribe(result => {
      this.organizationsList = result;
      this.isOrganizationLoading = false;

    });
  }


  onMultiSelectionOperationForCustomers(event: any) {

    switch (event.operation) {
      case MultiSelectionOperation.delete: {
        this.onDeleteSelectedAddedCustomers(event.object);
        break;
      }
    }
  }

  onDeleteSelectedAddedCustomers(selectedCustomersList) {

    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          selectedCustomersList.forEach(customer => {
            var index = this.addedCustomersList.findIndex(x => x.customerId === customer.customerId && x.outletId === customer.outletId);
            if (index >= 0) {
              this.addedCustomersList.splice(index, 1);
            }
          });
        }
        this.fillCustomersList();
      });
  }

  //#endregion

  //#region  Functions [navbar]

  showEntrySection(selectedIndex: number) {

    if (selectedIndex > 0) {
      this.icashFormEntry.get("organizationId").markAsTouched();
      if (this.icashFormEntry.invalid) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
        return;
      }
    }

    this.navLinks.forEach(a => a.isActive = false);
    this.navLinks[selectedIndex].isActive = true;
    if (selectedIndex == 0) {
      this.showDefinitionData = true;
      this.showAppliedData = false;
    } else {
      this.showDefinitionData = false;
      this.showAppliedData = true;
      this.populateChannelsSubChannelsList();
      this.populateGroupsList();

    }
  }

  onRowOperationDetails(event) {


    switch (event.operation) {
      case MultiSelectionOperation.delete: {
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
          (result: DialogResult) => {
            if (result === DialogResult.Yes) {
              if (!this.isEditMode) {
                this.detailsDataSource.data.splice(event.index, 1);
              } else {
                this.detailsDataSource.data.splice(event.index, 1);
              }
            }
          });

      }
        break;
    }


  }

  onChangeOrganization(event: any) {
    if ((this.forceCustomerOrganizationSelection() || this.forceOrganizationFilterForCustomerGroups()) &&
      (this.addedCustomersList && this.addedCustomersList.length > 0) ||
      (this.icashFormEntry.get('groupsControl').value != null && this.icashFormEntry.get('groupsControl').value.length > 0) ||
      (this.icashFormEntry.get('allCustomers').value != null && this.icashFormEntry.get('allCustomers').value.length > 0)
    ) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearInsertedDetailsWarning), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {

            this.icashFormEntry.get('groupsControl').setValue([]);
            this.icashFormEntry.get('channelControl').setValue([]);
            this.addedCustomersList = [];
            this.fillCustomersList();

            if (this.forceOrganizationFilterForCustomerGroups()) {
              this.populateGroupsList();
            }

          }
        });

    }

    if (this.forceOrganizationFilterForCustomerGroups()) {
      this.populateGroupsList();
    }
  }

  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_ICash_Definition',
        index: 0,
        isActive: false
      },
      {
        label: 'Desc_Applied_To_Cap',
        index: 1,
        isActive: false
      }
    ];
  }

  forceOrganizationFilterForCustomerGroups() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.ForceOrganizationFilterForCustomerGroups).toLowerCase() === "true"
  }

  forceCustomerOrganizationSelection() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.ForceCustomerOrganizationSelection).toLowerCase() === "true";
  }

  //#endregion

}
