import { FlatTreeControl, NestedTreeControl } from '@angular/cdk/tree';
import { HttpErrorResponse } from '@angular/common/http';
import { Component, OnInit, ViewChild } from '@angular/core';
import { MatTreeNestedDataSource } from '@angular/material/tree';
import { TranslateService } from '@ngx-translate/core';
import { CoreSession } from '../../../../../core/core.session';
import { ResponseModel } from '../../../../../shared/models/api-models/api-models';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { CustomerService } from '../../../../../shared/services/data-definition/customer/customers.service';
import { BehaviorSubject, Observable, of as observableOf, Subject } from 'rxjs';
import { CustomersHierarchyLevel } from '../../../../../shared/models/enums/customers-hierarchy-level';
import { SharedDialogComponent } from '../../../../../shared/components/shared-dialog/shared-dialog.component';
import { SelectCustomersComponent } from '../../../../../shared/components/customers/select-customers/select-customers.component';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { ITextInput } from '../../../../../shared/models/shared-table/custom-list.interface';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import { TreeNode } from '../../../../../shared/models/tree-model/tree-model';
import { SessionDataProvider } from '../../../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../../../shared/models/constants/constant-configuration';
import { ConstantURLs } from '../../../../../shared/models/constants/constant-URL';
import { MenuActions } from '../../../../../shared/models/enums/menu-actions-enum';
import { CustomerHierarchyService } from '../../../../../shared/services/data-definition/customer/customer-hierarchy.service';
import { NgbModal, NgbModalConfig, NgbModalRef } from '@ng-bootstrap/ng-bootstrap';
import { SharedTableResult } from '../../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../../shared/models/shared-table/table-properties.interface';
import * as cloneDeep from 'lodash/cloneDeep';

@Component({
  selector: 'app-customers-hierarchy-list',
  templateUrl: './customers-hierarchy-list.component.html',
  styleUrls: ['./customers-hierarchy-list.component.css']
})


export class CustomersHierarchyListComponent implements OnInit {

  //#region  [Declarations]

  selectedGroup = -1;
  dataSource: any;
  nestedDataSource: MatTreeNestedDataSource<TreeNode>;
  nestedDataSourceTemp: MatTreeNestedDataSource<TreeNode>;
  nestedTreeControl: NestedTreeControl<TreeNode>;
  dataChange: BehaviorSubject<TreeNode[]> = new BehaviorSubject<TreeNode[]>([]);
  @ViewChild('templateEntry', { static: true }) templateEntry: SharedDialogComponent;
  @ViewChild("selectCustomerDialog", { static: true }) selectCustomerDialog: SelectCustomersComponent;
  @ViewChild("groupAchievmentPromotions", { static: true }) groupAchievmentPromotions: NgbModal;

  saveSubject: Subject<void> = new Subject<void>();
  title = '';
  isEditMode = false;
  entryFormType: CustomersHierarchyLevel = CustomersHierarchyLevel.Channel;
  nodeData: any;
  treeControl = new FlatTreeControl<TreeNode>(node => node.level, node => node.isExpanded);
  channelForm: FormGroup;
  otherLanguages: any[] = [];
  nameFieldProp: ITextInput = {
    formControlName: "name",
    placeHolder: 'Desc_Channel_Name',
    label: 'Desc_Channel_Name',
    isRequierd: true
  };
  searchText = '';
  copyOfAddedCustomers: any[] = [];
  addedCustomersList: any[] = [];
  showSelectCustomersDialog = false;
  groupId = -1;
  expandNode = false;
  selectedNode: any;
  addAction = false;
  deleteAction = false;
  editAction = false;
  selectedChannelId: number = -1;
  selectedSubChannelId: number = -1;
  selectedGroupId: number = -1;
  groupAchievementPromotions: any[] = [];
  includedAchievementPromotions: any[] = [];
  excludedAchievementPromotions: any[] = [];
  modalRef: NgbModalRef;
  sharedTableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: false,
    isOnline: false,
    showSearch: true,
    isMultiSelection: true,
    showEditButton: false,
    rowOperations: [],
    multiSelectionOperations: [],
    specificActionWhenCheckAll: true,
    specificActionWhenCheckRow: true,
    columns: [
      { title: 'Desc_Promotion', key: 'promotionName', isSortable: false, width: '100%' },
    ]
  };
  achievementPromotionsDS: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  nodeEvent: any;
  originalCustomersList: any[] = [];
  deletedCustomersList: any[] = [];
  newCustomersList: any[] = [];
  isThereAnyAchievementPromotions: boolean = false;
  constructor(
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private customerService: CustomerService,
    private customerHierarchyService: CustomerHierarchyService,
    private sessionData: SessionDataProvider,
    private config: NgbModalConfig,
    private modalService: NgbModal,
  ) {
    this.nestedTreeControl = new NestedTreeControl<TreeNode>(this._getChildren);
    this.nestedDataSource = new MatTreeNestedDataSource();
    config.backdrop = true;
  }

  private _getChildren = (node: TreeNode) => { return observableOf(node.children); };

  hasNestedChild = (_: number, nodeData: TreeNode) => { return (nodeData.isParent); };

  isExpandable = (node: TreeNode) => node.isExpanded;

  //#endregion

  //#region [Events]

  ngOnInit() {
    this.initializeForm();
    this.addActions();
    this.populateCustomerHierarchyData();
  }

  onSaveClicked() {
    this.saveSubject.next();
  }

  onCloseClicked() {
    this.templateEntry.Close();
  }

  onFilterChanged() {

    this.coreSession.ModalLoading.Show();
    if (this.searchText) this.searchText = this.searchText.trim();
    this.filterTree();
    if (this.searchText) {
      this.nestedTreeControl.expandAll();
    } else {
      this.nestedTreeControl.collapseAll();
    }
    this.coreSession.ModalLoading.Hide();
  }

  onOtherLanguagesTextSubmitted(event) {
    this.otherLanguages = event;
  }

  onDialogResult(event) {
    if (event && event.saveCLicked) {
      this.onSaveClicked();
    }
  }

  onAddingSuccessfully() {
    this.onCloseClicked();
    this.populateCustomerHierarchyData();
  }

  addNode(event: any) {
    this.isEditMode = false;
    if (event) {
      switch (event.level) {
        case CustomersHierarchyLevel.Channel:
          this.entryFormType = CustomersHierarchyLevel.SubChannel;
          break;
        case CustomersHierarchyLevel.SubChannel:
          this.entryFormType = CustomersHierarchyLevel.Group;
          break;
        case CustomersHierarchyLevel.Group:
          this.entryFormType = CustomersHierarchyLevel.Group;
          break;
      }
      this.nodeData = event;
      this.prepareEntryData(this.entryFormType);
      this.showEntryModal();
      this.expandNode = true;
    }
  }

  editNode(event: any) {
    this.isEditMode = true;
    if (event) {
      this.nodeData = event;
      this.prepareEntryData(event.level)
      this.showEntryModal();
      this.expandNode = true;
    }
  }

  deleteNode(event: any) {

    if (event) {

      var customersHierarchyData =
      {
        channelId: CustomersHierarchyLevel.Channel == event.level ? event.nodeId : CustomersHierarchyLevel.SubChannel == event.level ? event.parentId : -1,
        subChannelId: CustomersHierarchyLevel.SubChannel == event.level ? event.nodeId : CustomersHierarchyLevel.Group == event.level ? event.parentId : -1,
        groupId: CustomersHierarchyLevel.Group == event.level ? event.nodeId : -1,
        code: '',
        organizationId: -1,
        customersHierarchyLevel: event.level,
        isEditMode: false,
        descriptions: []
      }


      this.nodeData = event;
      this.expandNode = true;
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (result: DialogResult) => {
          if (result === DialogResult.Yes) {
            this.coreSession.ModalLoading.Show();
            this.customerHierarchyService.deleteCustomersHierarchyData(customersHierarchyData).subscribe(
              result => {
                this.coreSession.ModalLoading.Hide();
                if (result.status != null && result.status >= 0) {
                  this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgDeletedSuccessfully));
                  this.populateCustomerHierarchyData();
                } else {
                  this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), result.message);
                }
              },
              error => {
                this.coreSession.ModalLoading.Hide();
                this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
              }
            );
          }
        });
    }

  }

  addChannel() {
    this.entryFormType = CustomersHierarchyLevel.Channel;
    if (this.channelForm.valid) {
      var customersHierarchyData =
      {
        channelId: -1,
        subChannelId: -1,
        groupId: -1,
        code: this.channelForm.controls.code.value,
        organizationId: -1,
        customersHierarchyLevel: this.entryFormType,
        isEditMode: false,
        descriptions: this.fillDescriptions()
      }
      this.expandNode = true;
      this.customerHierarchyService.saveUpdateCustomersHierarchyData(customersHierarchyData, this.isEditMode).subscribe(
        result => {
          this.coreSession.ModalLoading.Hide();
          if (result.status != null && result.status >= 0) {
            this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
            this.channelForm.reset();
            this.populateCustomerHierarchyData();
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), result.message);
          }
        },
        error => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );

    } else {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgFillMandatory));
      this.channelForm.markAllAsTouched();
    }
  }

  //#endregion

  //#region [Functions]

  populateCustomerHierarchyData() {

    this.coreSession.ModalLoading.Show();
    this.customerHierarchyService.getCustomerHierarchyData().subscribe(
      (response: ResponseModel) => {
        this.coreSession.ModalLoading.Hide();

        if (response.status != null && response.status >= 0) {
          this.nestedDataSource.data = this.nestedTreeControl.dataNodes = this.nestedDataSourceTemp = response.data;
          if (this.expandNode) {
            this.expandSpecificNode(this.nodeData, this.nestedTreeControl.dataNodes);
          }
        } else {
          this.nestedDataSource.data = [];
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

  prepareEntryData(entryFormType: CustomersHierarchyLevel) {
    switch (entryFormType) {
      case CustomersHierarchyLevel.Channel:
        this.title = this.isEditMode ? 'Desc_Edit_Channel' : 'Desc_Add_Channel';
        this.entryFormType = CustomersHierarchyLevel.Channel;
        break;
      case CustomersHierarchyLevel.SubChannel:
        this.title = this.isEditMode ? 'Desc_Edit_Sub_Channel' : 'Desc_Add_Sub_Channel';
        this.entryFormType = CustomersHierarchyLevel.SubChannel;
        break;
      case CustomersHierarchyLevel.Group:
        this.title = this.isEditMode ? 'Desc_Edit_Group' : 'Desc_Add_New_Group';
        this.entryFormType = CustomersHierarchyLevel.Group;
        break;
    }
  }

  showEntryModal() {
    this.templateEntry.Show(true).then((res) => { });
  }

  initializeForm() {
    this.channelForm = new FormGroup({
      name: new FormControl("", Validators.required),
      code: new FormControl("", Validators.required),
    });
  }

  fillDescriptions() {

    let descriptions = this.otherLanguages;
    let oldValue = descriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId);
    if (oldValue >= 0) descriptions.splice(oldValue, 1)
    if (descriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      descriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.channelForm.controls.name.value
      });
    }
    return descriptions;
  }


  filterTree() {

    let filteredTreeData;
    if (this.searchText) {
      // Filter the tree
      function filter(array, text) {

        const getChildren = (result, object) => {
          if (object.nodeName.toLocaleLowerCase().includes(text.toLocaleLowerCase())) {
            result.push(object);
            return result;
          }
          if (Array.isArray(object.children)) {
            const children = object.children.reduce(getChildren, []);
            if (children.length) result.push({ ...object, children });
          }
          return result;
        };

        return array.reduce(getChildren, []);
      }

      filteredTreeData = filter(this.nestedDataSourceTemp, this.searchText);
    } else {
      // Return the initial tree
      filteredTreeData = this.nestedDataSourceTemp;
    }

    // Build the tree nodes from Json object. The result is a list of `TodoItemNode` with nested
    // file node as children.
    this.nestedDataSource.data = this.nestedTreeControl.dataNodes = filteredTreeData;
    this.coreSession.ModalLoading.Hide();
  }

  expandSpecificNode(node: any, allNodes: any) {


    if (node && (allNodes && allNodes.length > 0)) {
      if (node.level == CustomersHierarchyLevel.Channel) {
        let indexRow = allNodes.findIndex(x => x.dummyCode === node.dummyCode);
        if (indexRow >= 0) {
          this.nestedTreeControl.expand(this.nestedTreeControl.dataNodes[indexRow]);
        }
      } else if (node.level == CustomersHierarchyLevel.SubChannel) {
        let indexRowParent = allNodes.findIndex(x => x.dummyCode === node.dummyCodeParent);
        if (indexRowParent >= 0) {
          this.nestedTreeControl.expand(this.nestedTreeControl.dataNodes[indexRowParent]);
        }
        if (allNodes[indexRowParent].children) {
          let indexRow = allNodes[indexRowParent].children.findIndex(x => x.dummyCode === node.dummyCode);
          this.nestedTreeControl.expand(this.nestedTreeControl.dataNodes[indexRowParent].children[indexRow]);
        }
      } else if (node.level == CustomersHierarchyLevel.Group) {
        let indexRowParent = allNodes.findIndex(x => x.dummyCode === node.dummyCodeChannel);
        if (indexRowParent >= 0) {
          this.nestedTreeControl.expand(this.nestedTreeControl.dataNodes[indexRowParent]);
        }
        if (allNodes[indexRowParent].children) {
          let indexRow = allNodes[indexRowParent].children.findIndex(x => x.dummyCode === node.dummyCodeParent);
          this.nestedTreeControl.expand(this.nestedTreeControl.dataNodes[indexRowParent].children[indexRow]);
        }
      }
    }

  }
  //#endregion

  //#region [Customers Part]

  afterAddingSelectedCustomers(selectedCustomers) {
    this.fillDeletedCustomers(selectedCustomers);
    this.fillNewCustomers(selectedCustomers);
    this.selectedChannelId = -1;
    this.selectedSubChannelId = -1;
    this.selectedGroupId = -1;

    var customers =
    {
      groupId: this.groupId,
      customers: selectedCustomers,
      deletedCustomers: this.deletedCustomersList,
      newCustomers: this.newCustomersList,
      includedAchievementPromotions: this.includedAchievementPromotions,
      excludedAchievementPromotions: this.excludedAchievementPromotions,
      isThereAnyAchievementPromotions: this.isThereAnyAchievementPromotions
    }
    this.coreSession.ModalLoading.Show();
    this.customerHierarchyService.saveCustomersGroup(customers, this.isEditMode).subscribe(
      result => {
        this.coreSession.ModalLoading.Hide();
        if (result.status != null && result.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
          this.closeSelectCustomersDialog();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), result.message);
        }
      },
      error => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );

  }

  fillDeletedCustomers(newCustomersList: any[]) {
    this.deletedCustomersList = [];
    this.originalCustomersList.forEach(oldCustomer => {
      var idx = newCustomersList.findIndex(newCust => newCust.customerId === oldCustomer.customerId && newCust.outletId === oldCustomer.outletId);
      if (idx === -1) {
        // Customer is deleted.
        this.deletedCustomersList.push(oldCustomer);
      }
    });
  }

  fillNewCustomers(newCustomersList: any[]) {
    this.newCustomersList = [];
    newCustomersList.forEach(newCust => {
      var idx = this.originalCustomersList.findIndex(addedCust => newCust.customerId === addedCust.customerId && newCust.outletId === addedCust.outletId);
      if (idx === -1) {
        // Customer is new.
        this.newCustomersList.push(newCust);
      }
    });
  }

  closeSelectCustomersDialog() {
    this.showSelectCustomersDialog = false;
  }

  viewCustomersByGroupNode(event: any) {
    this.nodeEvent = event;
    this.groupId = event.nodeId;
    if (this.groupId > -1) {
      var groupIds = [];
      groupIds.push(this.groupId);
      this.customerService.checkCustomerGroupAchievementPromotions(groupIds).subscribe(response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (response.data && response.data.length > 0) {
            this.isThereAnyAchievementPromotions = true;
            this.groupAchievementPromotions = response.data;
            this.achievementPromotionsDS = {
              data: response.data,
              totalItems: response.data.length
            };
            this.openAchievementPromotionsModal();
          } else {
            // No achievement promotions defined for this group.
            this.isThereAnyAchievementPromotions = false;
            this.afterViewCustomersByGroupNode(event);
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), ConstantMessages.ErrorHappened);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
    }
  }

  afterViewCustomersByGroupNode(event: any) {
    let outletsFilter: any = {
      customListFilter: {
        searchFilter: '',
        page: 0,
        pageSize: 100
      },
      customerGroupId: event.nodeId != undefined ? event.nodeId : -1,
      customerClassId: -1,
      territoryId: -1,
      selectedOraganizationIds: '',
      channelId: -1,
      subChannelId: -1,
      routeId: -1,
      customerTypeId: -1,
      showDefault: false,
      getAllData: true
    }
    this.selectedChannelId = event != undefined && event.channelId != undefined ? event.channelId : -1;
    this.selectedSubChannelId = event != undefined && event.parentId != undefined ? event.parentId : -1;
    this.selectedGroupId = event != undefined && event.nodeId != undefined ? event.nodeId : -1
    let organizationId = this.forceOrganizationFilterForCustomerGroups() ? this.coreSession.CurrentOperator.organizationAccess.includes(event.organizationId) ? event.organizationId : '' : '';
    this.customerService.getOutletsListSharedTable(outletsFilter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.reflectAddedBeforeCustomers(response.data);
        this.showSelectCustomersDialog = true;
        this.selectCustomerDialog.showDialog(organizationId).then(
          (result) => {
            if (result != -1) {
              this.afterAddingSelectedCustomers(result)
            } else {
              this.closeSelectCustomersDialog();
            }
          });



      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });





  }

  reflectAddedBeforeCustomers(dataSource) {
    if (dataSource && dataSource.data && dataSource.data.length > 0) {
      dataSource.data.forEach(newCustomer => {
        var index = this.addedCustomersList.findIndex(addedCustomer => addedCustomer.customerId === newCustomer.customerId && addedCustomer.outletId === newCustomer.outletId);
        if (index >= 0) {
          newCustomer.isChecked = true;
          newCustomer.routesList = this.addedCustomersList[index].routesList;
          newCustomer = this.addedCustomersList[index];
        }
      })
    }
    this.copyOfAddedCustomers = dataSource.data;
    this.originalCustomersList = cloneDeep(dataSource.data);
  }

  forceOrganizationFilterForCustomerGroups() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.ForceOrganizationFilterForCustomerGroups).toLowerCase() === "true"
  }

  addActions() {
    this.addAction = this.coreSession.checkActivitiesAvailability(ConstantURLs.customersHierarchyURL, MenuActions.Add);
    this.editAction = this.coreSession.checkActivitiesAvailability(ConstantURLs.customersHierarchyURL, MenuActions.Edit);
    this.deleteAction = this.coreSession.checkActivitiesAvailability(ConstantURLs.customersHierarchyURL, MenuActions.Delete);
  }

  //#endregion

  //#region [Achievement Promotions Modal]
  onGroupAchievementPromotionsResult() {
    if (this.achievementPromotionsDS.data && this.achievementPromotionsDS.data.length > 0) {
      this.includedAchievementPromotions = this.achievementPromotionsDS.data.filter(x => x.isChecked);
      this.excludedAchievementPromotions = this.achievementPromotionsDS.data.filter(x => !x.isChecked);
    }
    this.closeAchievementPromotionsModal();
    this.afterViewCustomersByGroupNode(this.nodeEvent);
  }

  onGroupAchievementPromotionsCancel() {
    this.closeAchievementPromotionsModal();
  }

  openAchievementPromotionsModal() {
    this.config.backdrop = "static";
    this.modalRef = this.modalService.open(this.groupAchievmentPromotions, {
      centered: true,
    });
    this.config.backdrop = true;
  }

  closeAchievementPromotionsModal() {
    this.modalRef.dismiss();
    this.achievementPromotionsDS = {
      data: [],
      totalItems: 0
    };
  }

  //#endregion

}




