import { HttpClient, HttpHeaders } from "@angular/common/http";
import { Inject, Injectable } from "@angular/core";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../../shared/models/api-models/api-models";
import { SalesDistributionChannelModel } from "../../../../shared/models/customer/sales-distribution-channel.model";
import { GeneralFilter } from "../../../../shared/models/general/generalFilter.model";

@Injectable({
    providedIn: "root"
})
export class SalesDistributionChannelService {
    private url = "";
    private httpOptions;
    constructor(
        private http: HttpClient,
        private coreSession: CoreSession,
        @Inject("BASE_URL") baseUrl: string
    ) {
        this.url = baseUrl + "SalesDistributionChannel/";
        this.httpOptions = {
            headers: new HttpHeaders({
                "Content-Type": "application/json",
                Authorization: "my-auth-token"
            })
        };
    }

    updateSalesDistributionChannel(channel: SalesDistributionChannelModel) {
        const urlValue: string = this.url + 'UpdateSalesDistributionChannel';
        return this.http.post<ResponseModel>(urlValue, channel)
          .map(response => {
            return response;
        });
    }

    insertSalesDistributionChannel(channel: SalesDistributionChannelModel) {
        const urlValue: string = this.url + 'InsertSalesDistributionChannel';
        return this.http.post<ResponseModel>(urlValue, channel)
          .map(response => {
            return response;
        });
    }

    deleteSalesDistributionChannel(channelId: number) {
        const urlValue: string = this.url + 'DeleteSalesDistributionChannel';
        return this.http.post<ResponseModel>(urlValue, channelId)
          .map(response => {
            return response;
        });
    }


    getSalesDistributionChannel(channelId: number) {
        const urlValue: string = this.url + 'GetSalesDistributionChannel';
        return this.http.post<ResponseModel>(urlValue, channelId)
          .map(response => {
            return response;
        });
    }


    getAllSalesDistributionChannel() {

        const urlValue: string = this.url + 'GetAllSalesDistributionChannels';
        return this.http.post<ResponseModel>(urlValue, null)
          .map(response => {
            return response;
        });
    }




}
