import { Component, OnInit } from '@angular/core';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { RowOperation, MultiSelectionOperation } from '../../../../shared/models/enums/shared-table-operation.enum';

@Component({
  selector: 'app-customer-group-list',
  templateUrl: './customer-group-list.component.html',
  styleUrls: ['./customer-group-list.component.css']
})
export class CustomerGroupListComponent implements OnInit {
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  TabelProperties: ITableProperties = {
    pageSize: 100,
    showPaginator: true,
    showSearch: true,
    isOnline: true,
    isMultiSelection: true ,
    rowOperations: [
      {
        operation: RowOperation.delete ,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e'
      }
    ],
    multiSelectionOperations: [

      {
        operation:  MultiSelectionOperation.approve ,
        title: 'Desc_Add',
        icon: 'fa fa-add'
      }
    ],
    columns: [
      {
        title: 'Desc_Group_Code',
        key: 'groupCode',
        isSortable: true,
        width: '40%'
      },
      {
        title: 'Desc_Group_Name',
        key: 'groupName',
        isSortable: true,
        width: '60%'
      }
    ]
  };
  constructor() { }

  ngOnInit() {
  }
  addNewGroup(){

  }
  onRowClicked(event: any){

  }
}
