import { Routes, RouterModule } from '@angular/router';
import { CustomersListComponent } from './customers-list/customers-list.component';
import { CustomersMainComponent } from './customers-main/customers-main.component';
import { CustomersEntryComponent } from './customers-entry/customers-entry.component';
import { NgModule } from '@angular/core';
import { ConstantURLs } from '../../../shared/models/constants/constant-URL';
import { AuthGuard } from '../../../core/auth/auth.gurad';
import { ItemsListsListComponent } from '../items-lists-definition/items-lists-list/items-lists-list.component';
import { CustomerBlockedOperationsListComponent } from '../customer-managment/customer-blocked-operations-list/customer-blocked-operations-list.component';
import { CustomersHierarchyListComponent } from '../customer-managment/customers-hierarchy/customers-hierarchy-list/customers-hierarchy-list.component';

const CustomerRouting: Routes = [
  {
    path: '',
    component: CustomersMainComponent,
    canActivate: [AuthGuard],
    children: [
      {
        path: ConstantURLs.customersURL,
        canActivate: [AuthGuard],
        component: CustomersListComponent
      },
      {
        path: ConstantURLs.customerAddURL,
        canActivate: [AuthGuard],
        component: CustomersEntryComponent
      },
      {
        path: ConstantURLs.customerEditURL + '/:customerIdSignature',
        canActivate: [AuthGuard],
        component: CustomersEntryComponent
      },
      {
        path: ConstantURLs.customerItemsListURL,
        canActivate: [AuthGuard],
        component: ItemsListsListComponent
      },
       {
        path: ConstantURLs.CustomerBlockedOperationsURL,
        canActivate: [AuthGuard],
        component: CustomerBlockedOperationsListComponent
      },
      {
        path: ConstantURLs.customersHierarchyURL,
        canActivate: [AuthGuard],
        component: CustomersHierarchyListComponent,
      },
      {
        path: '',
        canActivate: [AuthGuard],
        redirectTo: '/' + ConstantURLs.dataDefinitionURL + '/' + ConstantURLs.customerURL + '/' + ConstantURLs.customersURL,
        pathMatch: 'full'
      }
    ],
  },
  {
    path: '**',
    canActivate: [AuthGuard],
    component: CustomersListComponent
  }
];
@NgModule({
  imports: [RouterModule.forChild(CustomerRouting)],
  exports: [RouterModule]
})
export class CustomerRoutingModule {

}
