import { NgModule } from "@angular/core";
import { CommonModule } from "@angular/common";
import { ReactiveFormsModule, FormsModule } from "@angular/forms";
import { CustomersListComponent } from "./customers-list/customers-list.component";
import { TranslateModule } from "@ngx-translate/core";
import { CustomersEntryComponent } from "./customers-entry/customers-entry.component";
import { CustomersMainComponent } from "./customers-main/customers-main.component";
import { OutletEntryComponent } from "./outlet-entry/outlet-entry.component";
import { NgbModalModule, NgbModule } from "@ng-bootstrap/ng-bootstrap";
import { CustomerGroupListComponent } from "./customer-group-list/customer-group-list.component";
import { CustomerGroupEntryComponent } from "./customer-group-entry/customer-group-entry.component";
import { CustomerClassEntryComponent } from "./customer-class-entry/customer-class-entry.component";
import { CustomerRoutingModule } from "./customer-routing.module";
import { NgMultiSelectDropDownModule } from "ng-multiselect-dropdown";
import { NgSelectComponent, NgSelectModule } from "@ng-select/ng-select";
import { SharedModule } from "../../../shared/shared.module";
import { CustomerBlockedOperationsListComponent } from "../customer-managment/customer-blocked-operations-list/customer-blocked-operations-list.component";
import { NgOptionHighlightModule } from "@ng-select/ng-option-highlight";
import { MatIconModule } from "@angular/material/icon";
import { MatTreeModule } from "@angular/material/tree";
import { MatButtonModule } from "@angular/material/button";
import { OutletMapComponent } from "./outlet-map/outlet-map.component";
import { CustomersHierarchyListComponent } from "../customer-managment/customers-hierarchy/customers-hierarchy-list/customers-hierarchy-list.component";
import {AgmCoreModule} from '@agm/core'
import { environment } from "./outlet-map/google-map-service/google-map-enviroment";

@NgModule({
  declarations: [
    CustomersListComponent,
    CustomersEntryComponent,
    CustomersMainComponent,
    OutletEntryComponent,
    CustomerGroupListComponent,
    CustomerGroupEntryComponent,
    CustomerBlockedOperationsListComponent,
    OutletMapComponent,
    CustomersHierarchyListComponent,

  ],
  imports: [
    CommonModule,
    ReactiveFormsModule,
    FormsModule,
    SharedModule,
    NgbModalModule,
    CustomerRoutingModule,
    NgMultiSelectDropDownModule,
    NgSelectModule,
    TranslateModule.forChild(),
    NgbModule,
    NgOptionHighlightModule,
    MatIconModule,
    MatTreeModule,
    MatButtonModule,
    AgmCoreModule.forRoot({
      apiKey: environment.googleMapsApiKey
    }),

  ],
  exports: [
    CustomersEntryComponent
  ]
})
export class CustomerModule { }
