import {
  Component,
  OnInit,
  ViewChild,
  EventEmitter,
  Input,
  Output,
} from "@angular/core";
import { FormGroup, FormControl, Validators, NgModel } from "@angular/forms";

import { Observable, Subject, Subscription } from "rxjs/Rx";
import { CustomerService } from "../../../../shared/services/data-definition/customer/customers.service";

import { HttpErrorResponse } from "@angular/common/http";

import { OutletEntryComponent } from "../outlet-entry/outlet-entry.component";

import { ActivatedRoute, Router, Params } from "@angular/router";
import { CustomerModel } from "../../../../shared/models/customer/customer.model";
import { CustomerOutletModel, CustomerStatusModel } from "../../../../shared/models/customer/outlet.model";
import { SharedTableResult } from "../../../../shared/models/shared-table/shared-table-result.interface";
import { ITableProperties } from "../../../../shared/models/shared-table/table-properties.interface";
import {
  RowOperation,
  MultiSelectionOperation,
} from "../../../../shared/models/enums/shared-table-operation.enum";
import { CoreSession } from "../../../../core/core.session";
import { ConstantURLs } from "../../../../shared/models/constants/constant-URL";
import { ResponseModel } from "../../../../shared/models/api-models/api-models";
import { DialogMode } from "../../../../shared/models/enums/dialog-mode.enum";
import { ConstantMessages } from "../../../../shared/models/constants/constant-message";
import { TranslateService } from "@ngx-translate/core";
import { MasterDataService } from "../../master-data.service";
import { DialogResult } from "../../../../shared/models/enums/dialog-result.enum";
import { DataActions } from "../../../../shared/models/enums/data-actions.enum";
import { ConstantConfigurations } from "../../../../shared/models/constants/constant-configuration";
import { SessionDataProvider } from "../../../../core/session-data-provider.service";
import * as cloneDeep from "lodash/cloneDeep";
import { AccountTypes } from "../../../../shared/models/enums/account-types-enum";
import { ConfigurationModel } from "../../../../shared/models/general/configuration.model";
import { ITextInput } from "../../../../shared/models/shared-table/custom-list.interface";
import { TextLanguage } from "../../../../shared/models/general/textLanguage.model";
import { MenuActions } from "../../../../shared/models/enums/menu-actions-enum";
import { CustomerAccountLevel } from "../../../../shared/models/enums/customer-account-level.enum";
import { WebApplication } from "../../../../shared/models/enums/web-application.enum";
import { EmployeeTypes } from "../../../../shared/models/enums/employee-types.enum";
import { ItemService } from "../../../../shared/services/data-definition/product/item.service";
import { DivisionService } from "../../../../shared/services/data-definition/product/division.service";
import { PayerAccountModel } from "../../../../shared/models/customer/payer-account.model";
import { NewCustomerService } from "../../../customer-operation/new-customer/new-customer.service";
import { ShepherdService } from 'angular-shepherd';
import { TourService } from "../../../../shared/shepherd-config/shepherd-config";
import { ComponentVisitService } from "../../../../shared/shepherd-config/trackTour.service";
import { GeneralFilter } from "../../../../shared/models/general/generalFilter.model";
import { SharedDialogComponent } from "../../../../shared/components/shared-dialog/shared-dialog.component";
@Component({
  selector: "app-customers-entry",
  templateUrl: "./customers-entry.component.html",
  styleUrls: ["./customers-entry.component.css"],
})
export class CustomersEntryComponent implements OnInit {
  @ViewChild('DivisionEntryDialog', { static: true }) DivisionEntryDialog: SharedDialogComponent;
  @Output('closeSlider') closeSlider = new EventEmitter();
  @Output('saveClicked') saveClicked = new EventEmitter();

  @Input() saveEvent: Observable<void>;
  @Output() onSaveCompleted = new EventEmitter();
  @Input() customerId: number;
  @Input() isEditMode: boolean = false;
  @Input() isFromNewCustomer: boolean = false;
  @Input() maxCustomerCode: string;

  saveBtnSubscription: any;
  showDetails: boolean = true;
  customerForm: FormGroup;
  isViewMode: boolean = false;
  showEmployee: boolean = false;
  editOutlet: boolean = false;
  showOutletEntry: boolean = false;
  navBarselectedIndex: number = 0;
  currencyDescription: string = "";
  entryTitle = "Desc_New_Customer";
  customerObj: CustomerModel = new CustomerModel();
  showPayAllOutlet = true;
  customerStatusList: CustomerStatusModel[] = [];
  outletObj: CustomerOutletModel;
  selectedIndex: number = -1;
  showModal = false;
  moduleId: number;
  empTypes: EmployeeTypes[];
  customerNameInput: ITextInput = {
    formControlName: "customerName",
    placeHolder: "Desc_Customer_Name",
    label: "Desc_Customer_Name",
    isRequierd: true,
  };
  oldDescription: any[] = [];
  saveSubject: Subject<void> = new Subject<void>();
  @ViewChild("content") outletEntry: OutletEntryComponent;
  shownData: any = {
    MainData: 0,
    AccountData: 1,
    OutletData: 4,
    PackBarcode: 3,
    AccountPayerData: 2
  };
  navLinks: any[];
  urls;
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: [],
  };

  tabelProperties: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    showNewBtn: true,
    isOnline: true,
    isMultiSelection: false,
    rowOperations: [
      {
        operation: RowOperation.Select,
        title: "Desc_Set_Main_Outlet",
        icon: "fa-solid fa-check",
        color: "#28a745",
      },
      {
        operation: RowOperation.delete,
        title: "Desc_Delete",
        icon: "fa-solid fa-trash",
        color: "#f1685e",
        showWhenKeyValueTrue: true,
        showHideOptionPerLine: true,
        controlKeyName: 'isValidDelete'
      },
    ],
    multiSelectionOperations: [],
    columns: [
      {
        title: "Desc_Outlet_Code",
        key: "outletCode",
        isSortable: true,
        width: "30%",
      },
      {
        title: "Desc_Outlet_Name",
        key: "outletName",
        isSortable: true,
        width: "50%",
      },
      { title: "Desc_Phone", key: "phone", isSortable: false, width: "20%" },
    ],
  };

  isDivisionLoading: boolean = false;
  divisionsList: any[] = [];

  ControlTransactionOnDivisionLevel: boolean = false;
  outletAccountForm: FormGroup;
  columns: any[] = [];

  dynamicOutletId: number = -1;
  selectedOutletId: number = -1;
  isloading = true;
  disableCurrency: boolean = false;

  customerAccountEntryForm: FormGroup;
  customerAccountsList: any[] = [];
  selectedOrganization: any;
  selectedCurrency: any;
  ForceCustomerOrganizationSelection: boolean = false;
  ApplyCurrencyPerOrganization: boolean = false;
  accountOutletsList = [];
  payerList: any[] = [];
  ngSelectDropdownSettings: any = {
    bindLabel: 'payerCodeName',
    bindValue: 'payerId',
  };
  searchOutletPattern = null;
  currentOutletAccounts = null;
  currentOutlet = null;
  ControlTransactionDivisionLevel: boolean = false;
  CheckPaymentTermOnCustomerLevel: boolean = false;
  hasPrivilegeOnOnHoldDivision: boolean = false;
  hasPrivilegeOnPaymentTermDivision: boolean = false;
  UsePayerAccount: boolean = false;
  showAddNew = false;
  customerPackBarcodeLevel: number = -1;
  filterForm: FormGroup;
  itemsDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  outletDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  copyOfItemsDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  addedItemsList: any[] = [];
  copyOfAddedItemsList: any[] = [];
  outletPayerList: PayerAccountModel[] = [];
  itemTableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: true,
    showSearchBtn: true,
    isMultiSelection: false,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      {
        title: 'Desc_Item',
        key: 'itemCodeName',
        isSortable: true,
        width: '50%'
      },
      {
        title: 'Desc_UOM',
        key: 'uom',
        isSortable: true,
        width: '20%',
      }
      ,
      {
        title: 'Desc_Barcode',
        key: 'customerPackBarcode',
        isSortable: true,
        width: '30%',
        isEditable: true,
      }
    ]
  };
  itemFilter = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: this.coreSession.pageSize
    },
    divisionId: -1,
    itemCategoryId: -1,
  };
  outletsFilter = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: this.coreSession.pageSize
    },
    divisionId: -1,
    customerId: -1,
  };
  outletTableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: true,
    showSearchBtn: false,
    isMultiSelection: false,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      {
        title: 'Desc_Outlet',
        key: "outletCodeName",
        isSortable: true,
        width: '25%',
      },
    ]
  };
  checkForLanguageDescription: boolean = false;
  checkMandatoryFieldsOnCustomer: boolean = false;
  forceOrganizationFilterForCustomerGroups: boolean = false;
  enableSalesDistributionChannel: boolean = false;
  allowSelectAlternativeWarehouseInFO: boolean = false;
  maxOutletCode: string = '';
  nextMaxOutletCode: string = '';
  newOutletCodeSequence: string;
  NewCustomerCodeSequence: string;
  constructor(
    private customerService: CustomerService,
    public coreSession: CoreSession,
    private route: ActivatedRoute,
    private router: Router,
    private translateService: TranslateService,
    private masterDataService: MasterDataService,
    private divisionService: DivisionService,
    private sessionData: SessionDataProvider,
    private itemService: ItemService,
    private newCustomerService: NewCustomerService,
    private shepherdService: ShepherdService,
    private tourService: TourService,
    private componentVisitService: ComponentVisitService,
  ) {
    this.urls = ConstantURLs;
  }
  private tourStartTimeout: any;

  ngAfterViewInit() {
    this.startTour()
  }

  startTour(forceTour?: boolean) {
    this.tourStartTimeout = setTimeout((data => {

      if (!this.tourService.isFirstTour()) {
        this.showSharedTable = true
      }

        if (!forceTour)
          if (this.tourService.isTourCompletedForComponent('customer-entry')) {
            this.showSharedTable = true
            return;
          }

          if(this.tourService.isFirstTour()||forceTour){

            const elementSelectors = ['#def-customer','#showInactive']
            const titles = [];
            const texts = [];
            for (let index = 0; index < elementSelectors.length; index++) {
          const { title, text } = this.getTitleAndText(index);
          titles.push(title);
          texts.push(text);
        }
        const steps = this.tourService.generateSteps(elementSelectors, titles, texts);
        this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
        this.shepherdService.modal = true;
        this.shepherdService.addSteps(steps);
        this.shepherdService.start();
        this.shepherdService.tourObject.on('complete', () => {

          this.showSharedTable = true

        });
        this.shepherdService.tourObject.on('cancel', () => {

          this.showSharedTable = true

        });
      }


    }), 1000)



  }
  getTitleAndText(index: number): { title: string, text: string } {
    let title = '';
    let text = '';

    switch (index) {
      case 0:
        title = "Desc_Customer";
        text = 'Desc_Def_Customer';
        break;
      case 1:
        title = "Desc_Contacts";
        text = "Desc_content_Contact";
        break;
        case 2:
          title = "Desc_Inactive";
          text = "Desc_Toggle_Shows_Inactive_Outlet";
          break;
      default:
        title = `Step ${index + 1}`;
        text = `Content in default at bottom.`;
    }
    return { title, text };
  }
  private tourSubscription: Subscription;
  ngOnInit() {
    this.tourSubscription = this.tourService.startTourEntry$.subscribe(() => {
      this.startTour(true)
    });
    this.showAddNew = this.coreSession.checkActivitiesAvailability(ConstantURLs.customersURL, MenuActions.Add);
    this.initFilterForm();
    if (!this.isEditMode) {
      this.populateItems();
    }

    this.subscribeSaveClick();
    this.addActions();
    this.ControlTransactionDivisionLevel = this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true"
    this.CheckPaymentTermOnCustomerLevel = this.sessionData.getConfigurationValue(ConstantConfigurations.CheckPaymentTermOnCustomerLevel).toLowerCase() === "true"
    this.UsePayerAccount = this.sessionData.getConfigurationValue(ConstantConfigurations.UsePayerAccount).toLowerCase() === "true"
    this.newOutletCodeSequence = this.sessionData.getConfigurationValue(ConstantConfigurations.NewOutletCodeSequence);
    this.NewCustomerCodeSequence = this.sessionData.getConfigurationValue(ConstantConfigurations.NewCustomerCodeSequence);
    if (this.ControlTransactionDivisionLevel && this.coreSession.checkActivitiesAvailability(ConstantURLs.customersURL, MenuActions.DivisionsPaymentTerm)) {
      this.hasPrivilegeOnPaymentTermDivision = true;
    }
    if (this.ControlTransactionDivisionLevel && this.coreSession.checkActivitiesAvailability(ConstantURLs.customersURL, MenuActions.DivisionsOnHoldStatus)) {
      this.hasPrivilegeOnOnHoldDivision = true;
    }
    this.outletTableData.columns.push(
      {
        title: 'Desc_Payer', key: 'payerId', isSortable: false, isNgSelect: true, isEditable: true, width: '25%', disableInputBasedOnProperty: false, ShowDisabledComboAsInput: true,
        disableInputPropertyName: "isDisabledInput", inputPropertyName: "payerCodeName"
      },
      { title: 'Desc_Credit_Limit', key: 'creditLimit', isSortable: false, width: '15%', numberOfDigits: true },
      { title: 'Desc_Balance', key: 'balance', isSortable: false, width: '15%', numberOfDigits: true });

    if (this.ControlTransactionDivisionLevel) {
      this.outletTableData.columns.push({ title: "Desc_Division", key: "divisionCodeName", isSortable: true, width: "15%" });
    }

    if (!this.UsePayerAccount) {
      this.shownData = {
        MainData: 0,
        AccountData: 1,
        OutletData: 3,
        PackBarcode: 2,
      };
    } else {
      this.shownData = {
        MainData: 0,
        AccountPayerData: 1,
        OutletData: 3,
        PackBarcode: 2,
      };
    }
    this.populateCustomerPayerOutlets();
    this.ForceCustomerOrganizationSelection =
      this.sessionData
        .getConfigurationValue(
          ConstantConfigurations.ForceCustomerOrganizationSelection
        )
        .toLowerCase() === "true";
    this.ApplyCurrencyPerOrganization = this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyCurrencyPerOrganization
    )
      .toLowerCase() === "true";
    if (this.ForceCustomerOrganizationSelection) {
      this.initCustomerAccountEntryForm();
    }
    this.allowSelectAlternativeWarehouseInFO = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowSelectAlternativeWarehouseInFO).toLowerCase() === "true";
    this.checkForLanguageDescription = this.sessionData.getConfigurationValue(ConstantConfigurations.CheckForLanguageDescription).toLowerCase() === 'true';
    this.checkMandatoryFieldsOnCustomer = this.sessionData.getConfigurationValue(ConstantConfigurations.CheckMandatoryFieldsOnCustomer).toLowerCase() === 'true';
    this.forceOrganizationFilterForCustomerGroups = this.sessionData.getConfigurationValue(ConstantConfigurations.ForceOrganizationFilterForCustomerGroups).toLowerCase() === "true";
    this.coreSession.hideCustomerEntrySliderFooter = false;
    this.ControlTransactionOnDivisionLevel =
      this.sessionData
        .getConfigurationValue(
          ConstantConfigurations.ControlTransactionOnDivisionLevel
        )
        .toLowerCase() === "true";
    this.enableSalesDistributionChannel = this.sessionData.getConfigurationValue(ConstantConfigurations.EnableSalesDistributionChannel).toLowerCase() === "true"
    this.empTypes = [];
    this.empTypes.push(EmployeeTypes.Collector);
    this.empTypes.push(EmployeeTypes.Deliveryperson);
    this.empTypes.push(EmployeeTypes.Driver);
    this.empTypes.push(EmployeeTypes.Merchandiser);
    this.empTypes.push(EmployeeTypes.Presales);
    this.empTypes.push(EmployeeTypes.Salesperson);
    this.empTypes.push(EmployeeTypes.VanInCharge);
    if (this.ControlTransactionOnDivisionLevel) {
      this.columns = [
        {
          title: "Desc_Outlet",
          key: "outletCodeName",
          isSortable: true,
          width: "25%",
        },
        {
          title: "Desc_Division",
          key: "divisionCodeName",
          isSortable: true,
          width: "23%",
        },
        {
          title: "Desc_Balance",
          key: "balance",
          isSortable: true,
          width: "23%",
          numberOfDigits: true,
        },
        {
          title: "Desc_Credit_Limit",
          key: "creditLimit",
          isSortable: false,
          width: "23%",
          isEditable: true,
          numberOfDigits: true,
        },
      ];
    } else {
      this.columns = [
        {
          title: "Desc_Outlet",
          key: "outletCodeName",
          isSortable: true,
          width: "34%",
        },
        {
          title: "Desc_Balance",
          key: "balance",
          isSortable: true,
          width: "30%",
          numberOfDigits: true,
        },
        {
          title: "Desc_Credit_Limit",
          key: "creditLimit",
          isSortable: false,
          width: "30%",
          isEditable: true,
          numberOfDigits: true,
        },
      ];
    }
    this.fillDivisionsList();

    // this.subscribeSaveClick();

    this.prepareNavigation();
    this.navLinks[0].isActive = true;
    if (!this.isEditMode) {
      this.coreSession.SetTitle("Add Customer");
      this.isloading = false;
      this.customerForm = new FormGroup({
        headerData: new FormGroup({
          customerName: new FormControl(
            { value: "", disabled: this.isViewMode },
            Validators.required
          ),
          customerCode: new FormControl(
            { value: "", disabled: this.isViewMode || (this.NewCustomerCodeSequence != "") },
            Validators.required
          ),
          currencyId: new FormControl(
            { value: null, disabled: false },
          ),
          customerPhone: new FormControl({
            value: "",
            disabled: this.isViewMode,
          }),
          customerFax: new FormControl({
            value: "",
            disabled: this.isViewMode,
          }),
          street: new FormControl({ value: "", disabled: this.isViewMode }),
          streetNumber: new FormControl({
            value: "",
            disabled: this.isViewMode,
          }),
          email: new FormControl(
            { value: "", disabled: this.isViewMode },
            [Validators.email, Validators.pattern('^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$')]
          ),
          contractNumber: new FormControl({
            value: "",
            disabled: this.isViewMode,
          }),
          descriptionLanguages: new FormControl([]),
          employeeId: new FormControl({ value: null, disabled: true }),
          isDefault: new FormControl({
            value: false,
            disabled: this.dataSource.data.length == 1 ? true : false,
          }),
          allowPayAllOutlets: new FormControl({
            value: false,
            disabled: this.isViewMode
          }),
          exportCustomer: new FormControl({
            value: false,
            disabled: this.isViewMode
          }),
          paymentTermId: new FormControl({
            value: null,
            disabled: this.isViewMode
          },
            (this.CheckPaymentTermOnCustomerLevel ? Validators.required : Validators.nullValidator)),
        }),
      });
      this.oldDescription = null;
      if (!this.ForceCustomerOrganizationSelection) {
        this.addNewEmptyCustomerAccount();
      }
    } else {
      this.coreSession.SetTitle("Edit Customer");
      this.getCustomerData();
    }
    if (this.newOutletCodeSequence != "")
      this.fillnewOutletCodeSequence();
    if (this.NewCustomerCodeSequence != "" && !this.isEditMode) {
      this.customerForm.get('headerData').get('customerCode').setValue(this.maxCustomerCode);
    }
    this.populateCustomerStatus();
  }
  initFilterForm() {
    this.filterForm = new FormGroup({
      itemCategoryId: new FormControl(),
      divisionId: new FormControl(),
    });
  }

  addActions() {
    if (
      this.coreSession.checkActivitiesAvailability(
        ConstantURLs.customersURL,
        MenuActions.Edit
      ) || (this.coreSession.checkActivitiesAvailability(ConstantURLs.newCustomerURL, MenuActions.Approve) && this.isFromNewCustomer)
    ) {
      this.tabelProperties.rowOperations.push({
        operation: RowOperation.edit,
        title: "Desc_Edit",
        icon: "fa-regular fa-pen-to-square",
        color: "#12344d",
      });
    }

    if (
      this.coreSession.checkActivitiesAvailability(
        ConstantURLs.customersURL,
        MenuActions.SetAsInitiative
      )
    ){
      this.tabelProperties.rowOperations.push({
        operation: RowOperation.Activate,
        title: "Desc_Reactivate",
        icon: "fa fa-toggle-on",
        color: '#02b875',
        showWhenKeyValueTrue: true,
        showHideOptionPerLine: true,
        controlKeyName: 'inactive'
      });


      this.tabelProperties.rowOperations.push(
        {
          operation: RowOperation.Deactivate,
          title: 'Desc_Deactivate',
          icon: 'fa-solid fa-ban',
          color: '#f1685e',
          showWhenKeyValueFalse: true,
          showHideOptionPerLine: true,
          controlKeyName: 'inactive'
        });
    }
  }

  onSaveClicked() {
    this.saveClicked.emit();
  }
  onCloseSlider() {
    this.closeSlider.emit();
  }

  getOutletDataFromDB(selectedOutlet: CustomerOutletModel) {
    this.coreSession.ModalLoading.Show();
    this.customerService
      .getOutletData(selectedOutlet.customerId, selectedOutlet.outletId, selectedOutlet.hasPrivilegeOnPaymentTermDivision, selectedOutlet.hasPrivilegeOnOnHoldDivision)
      .subscribe(
        (response: ResponseModel) => {
          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            this.outletObj = response.data;
            this.outletObj.dataAction = selectedOutlet.dataAction; /*DataActions.NoChange;*/
            this.outletObj.isValidDelete =selectedOutlet.isValidDelete

            // get outlet accounts data from customer screen accounts tab
            this.outletObj.accountsList = selectedOutlet.accountsList;

            // read operator data from cashed outlets list
            this.outletObj.operatorId = selectedOutlet.operatorId;
            this.outletObj.operatorName = selectedOutlet.operatorName;
            this.outletObj.operatorPassword = selectedOutlet.operatorPassword;
            this.outletObj.isLockedOperator = selectedOutlet.isLockedOperator;
            this.outletObj.matchWithExistsOperator = selectedOutlet.matchWithExistsOperator;
            this.outletObj.outletAttachments = cloneDeep(selectedOutlet.outletAttachments);

            // cash old values
            this.outletObj.orginalOperatorName = selectedOutlet.operatorName;
            this.outletObj.orginalOperatorPassword = selectedOutlet.operatorPassword;
            this.outletObj.orginalIsLockedOperator = selectedOutlet.isLockedOperator;

            // group and territory values -> if outlet is edited from customers screen override DBs values of groups, routesList
            // with values from UI.
            if (selectedOutlet.dataAction === DataActions.EditFromParent) {
              this.outletObj.groups = selectedOutlet.groups;
              this.outletObj.routesList = selectedOutlet.routesList;
              this.outletObj.salesDistributionChannels = selectedOutlet.salesDistributionChannels;
              this.outletObj.territories = selectedOutlet.territories;
              if (this.allowSelectAlternativeWarehouseInFO) {
                this.outletObj.warehouseId = selectedOutlet.warehouseId;
                this.outletObj.warehouseOrganizationId = selectedOutlet.warehouseOrganizationId;
              }
            }
            if (this.ForceCustomerOrganizationSelection) {
              const custAccount = this.customerAccountsList.filter(acc => acc.dataAction !== DataActions.Delete.valueOf());
              const allOrganizationIds = custAccount.map(account => account.organizationId.toString()).join(',');
              if (this.customerStatusList && this.customerStatusList.length > 0) {
                var customerStatus = this.customerStatusList.filter(status => status.customerStatusId === this.outletObj.customerStatusId);
                if (customerStatus.every(status => !status.organizationId.toString().split(',').some(id => allOrganizationIds.includes(id)))) {
                  this.outletObj.customerStatusId = -1;
                }
              }
            }

            this.editOutlet = true;
            this.coreSession.hideCustomerEntrySliderFooter = true;
            this.showModal = true;
            this.openDivisionEntryDialog()


            // Get updated Outlet Object in case any account was deleted.
            if (this.ForceCustomerOrganizationSelection) {
              var out = this.customerObj.outlets.filter(
                (o) => o.outletId === this.outletObj.outletId && o.outletCode === this.outletObj.outletCode);
              out[0] = this.outletObj;

            }
          } else {
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              response.message
            );
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }
      );
  }
  openDivisionEntryDialog() {
    this.DivisionEntryDialog.Show(true).then((res) => { });
  }
  showInActive:boolean=false
  onShowInactive(){
this.showInActive = !this.showInActive
this.getCustomerData()
  }
  getCustomerData() {
    this.coreSession.ModalLoading.Show();
    this.customerService
      .getCustomerData(this.customerId, this.showInActive)
      .subscribe(
        (response: ResponseModel) => {
          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            this.customerObj = response.data;
            if (this.customerObj.isDefault) {
              this.showPayAllOutlet = false;
            } else {
              this.showPayAllOutlet = true;
            }
            let mainOutletIndex = this.customerObj.outlets.findIndex(
              (o) => o.isMain === true
            );
            if (mainOutletIndex > -1) {
              this.customerObj.outlets[mainOutletIndex].selected = true;
            }
            this.oldDescription = this.customerObj.descriptionLanguages; //this.customerForm.get('headerData').get('descriptionLanguages').value;
            this.oldDescription;
            this.FillCustomerInEditMode();
          } else {
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              response.message
            );
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }
      );
  }
  fillPayerAccountList() {
    this.payerList = [];
    let currencyId = -1;
    this.customerService.getPayerAccountList(currencyId).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.payerList = response.data;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  FillCustomerInEditMode() {
    this.populateItems(true);
    this.isloading = false;
    this.disableCurrency = false;
    this.customerAccountsList = this.customerObj.accountsList;

    if (
      (this.ForceCustomerOrganizationSelection ||
        this.customerAccountsList.findIndex((a) => a.balance != 0) >= 0) &&
      this.customerObj.currencyId != -1
    ) {
      this.disableCurrency = true;
    }
    this.customerForm = new FormGroup({
      headerData: new FormGroup({
        customerName: new FormControl(
          { value: this.customerObj.customerName, disabled: this.isViewMode },
          Validators.required
        ),
        customerCode: new FormControl(
          { value: this.customerObj.customerCode, disabled: this.isViewMode || (this.NewCustomerCodeSequence != "") },
          Validators.required
        ),
        currencyId: new FormControl(
          {
            value:
              this.customerObj.currencyId != -1
                ? this.customerObj.currencyId
                : "",
            disabled: this.disableCurrency,
          },
        ),
        customerPhone: new FormControl({
          value: this.customerObj.phone,
          disabled: this.isViewMode,
        }),
        customerFax: new FormControl({
          value: this.customerObj.fax,
          disabled: this.isViewMode,
        }),
        street: new FormControl({
          value: this.customerObj.streetId,
          disabled: this.isViewMode,
        }),
        streetNumber: new FormControl({
          value: this.customerObj.streetNumber,
          disabled: this.isViewMode,
        }),
        email: new FormControl(
          { value: this.customerObj.email, disabled: this.isViewMode },
          [Validators.email, Validators.pattern('^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$')]
        ),
        contractNumber: new FormControl({
          value: this.customerObj.contractNumber,
          disabled: this.isViewMode,
        }),
        descriptionLanguages: new FormControl(
          this.customerObj.descriptionLanguages
        ),
        employeeId: new FormControl({
          value:
            this.customerObj.employeeId != -1
              ? this.customerObj.employeeId
              : null,
          disabled: this.customerObj.isDefault ? false : true,
        }),
        isDefault: new FormControl({
          value: this.customerObj.isDefault,
          disabled: this.customerObj.outlets.length > 1 ? true : false,
        }),
        allowPayAllOutlets: new FormControl({
          value: this.customerObj.allowPayAllOutlets,
          disabled: this.isViewMode
        }),
        exportCustomer: new FormControl({
          value: this.customerObj.exportCustomer,
          disabled: this.isViewMode
        }),
        paymentTermId: new FormControl({
          value: this.customerObj.paymentTermId != -1 ? this.customerObj.paymentTermId : null,
          disabled: this.isViewMode || !this.CheckPaymentTermOnCustomerLevel
        },
          (this.CheckPaymentTermOnCustomerLevel ? Validators.required : Validators.nullValidator)),
      }),
    });

    this.tabelProperties.showNewBtn =
      this.customerObj.outlets.length >= 1 && this.customerObj.isDefault
        ? false
        : true;
    this.customerForm.value.headerData.customerName = this.customerObj.customerName;
    this.customerForm.value.headerData.customerCode = this.customerObj.customerCode;
    this.customerForm.value.headerData.currencyId = -1;
    this.customerForm.value.headerData.customerPhone = this.customerObj.phone;
    this.customerForm.value.headerData.email = this.customerObj.email;
    this.customerForm.value.headerData.street = this.customerObj.streetId;
    this.customerForm.value.headerData.streetNumber = this.customerObj.streetNumber;
    this.customerForm.value.headerData.contractNumber = this.customerObj.contractNumber;
    this.customerForm.value.headerData.paymentTermId = this.customerObj.paymentTermId > 0 ? this.customerObj.paymentTermId : null;
    this.customerForm.value.headerData.employeeId = this.customerObj.employeeId;
    this.currencyDescription = this.customerObj.currencyDescription;
    if (this.customerObj && this.customerObj.outlets) {
      this.dataSource = {
        totalItems: this.customerObj.outlets.filter(
          (outlet) => outlet.dataAction != DataActions.Delete
        ).length,
        data: this.customerObj.outlets.filter(
          (outlet) => outlet.dataAction != DataActions.Delete
        ),
      };
      this.setOutletAccounts();
    }
    if (this.customerObj && this.customerObj.customerPackBarcodeList && this.customerObj.customerPackBarcodeList.length > 0) {
      this.addedItemsList = this.customerObj.customerPackBarcodeList;
      this.copyOfAddedItemsList = cloneDeep(this.customerObj.customerPackBarcodeList);
    }
    // Accounts => add new empty account
    if (
      !this.ForceCustomerOrganizationSelection &&
      (!this.customerAccountsList || this.customerAccountsList.length === 0)
    ) {
      this.addNewEmptyCustomerAccount();
    }
    this.fillPayerAccountList();
  }
  prepareNavigation() {
    this.navLinks = [
      {
        label: "Desc_Main_Customer_Data",
        index: this.shownData.MainData,
        isActive: false,
      }
    ];


  }

  fillPayerList() {
    this.outletDataSource = {
      totalItems: this.outletPayerList.length,
      data: this.outletPayerList,
    };
  }

  populateCustomerStatus() {
    this.customerStatusList = [];
    this.customerService.getCustomerStatus().subscribe(result => {
      this.customerStatusList = result.data ? result.data : [];
    });
  }
  onRowClicked(event: any) {
    event.object.hasPrivilegeOnPaymentTermDivision = this.hasPrivilegeOnPaymentTermDivision;
    event.object.hasPrivilegeOnOnHoldDivision = this.hasPrivilegeOnOnHoldDivision;

    switch (event.operation) {
      case RowOperation.delete:
        if (
          this.coreSession.checkActivitiesAvailability(
            ConstantURLs.customersURL,
            MenuActions.Delete
          )
        ) {
          this.coreSession.ModalDialog.ShowMessage(
            this.translateService.instant(
              ConstantMessages.MsgDeleteConfirmation
            ),
            DialogMode.YesNo,
            this.translateService.instant(ConstantMessages.WarningCaption)
          ).then((result: DialogResult) => {
            if (result === DialogResult.Yes) {
              if (event.object.dataAction == DataActions.Add) {
                var newOutletIndex = this.customerObj.outlets.findIndex(x => x.outletId === event.object.outletId);
                if (newOutletIndex >= 0) {
                  this.customerObj.outlets.splice(newOutletIndex, 1);
                }
                // this.customerObj.outlets.splice(event.index, 1);
                this.dataSource = {
                  totalItems: this.customerObj.outlets.filter(
                    (outlet) => outlet.dataAction != DataActions.Delete && outlet.dataAction != DataActions.inActive
                  ).length,
                  data: this.customerObj.outlets.filter(
                    (outlet) => outlet.dataAction != DataActions.Delete && outlet.dataAction != DataActions.inActive
                  ),
                };

                if (this.dataSource.data.length <= 1) {
                  this.isDefault.enable();
                  this.isDefault.updateValueAndValidity();
                  this.tabelProperties.showNewBtn = true;
                }
                if (this.newOutletCodeSequence != "")
                  this.sortingCustomerCode()

              } else {
                     event.object.dataAction = DataActions.Delete;
                        this.dataSource = {
                          totalItems: this.customerObj.outlets.filter(
                            (outlet) => outlet.dataAction != DataActions.Delete && outlet.dataAction != DataActions.inActive
                          ).length,
                          data: this.customerObj.outlets.filter(
                            (outlet) => outlet.dataAction != DataActions.Delete && outlet.dataAction != DataActions.inActive
                          ),
                        };
                        if (this.dataSource.data.length <= 1) {
                          this.isDefault.enable();
                          this.isDefault.updateValueAndValidity();
                        }

                //this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgDesc_Delete_New_Outlet));
              }
              this.setOutletAccounts();
              if (!this.editOutlet) {
                // this.dataSource.data.splice(event.index, 1);
                this.outletPayerList = this.outletPayerList.filter(x => x.outletId != event.object.outletId);

                // let index = -1;
                // if (this.ControlTransactionDivisionLevel) {
                //   this.divisionsList.forEach(x => {
                //     index = this.outletPayerList.findIndex(a => a.outletId == event.object.outletId && a.divisionId == x.divisionId)
                //     if (index > -1) {
                //       this.outletPayerList.splice(index, 1);
                //     }
                //   })
                // } else {
                //   index = this.outletPayerList.findIndex(a => a.outletId == event.object.outletId)
                //   if (index > -1) {
                //     this.outletPayerList.splice(index, 1);
                //   }
                // }
                this.fillPayerList();
              }
            }
          });
        }
        break;
      case RowOperation.approve:
        break;
      case RowOperation.edit:
        this.selectedIndex = event.index;
        this.selectedOutletId = event.object.outletId;
        if (event.object.dataAction == DataActions.NoChange || event.object.dataAction == DataActions.EditFromParent) {
          this.getOutletDataFromDB(event.object);
        } else {
          this.outletObj = cloneDeep(event.object);
          this.outletObj.accountsList = cloneDeep(event.object.accountsList);
          if (this.ForceCustomerOrganizationSelection) {
            const custAccount = this.customerAccountsList.filter(acc => acc.dataAction !== DataActions.Delete.valueOf());
            const allOrganizationIds = custAccount.map(account => account.organizationId.toString()).join(',')
            if (allOrganizationIds.trim() !== '' && this.customerStatusList && this.customerStatusList.length > 0) {
              var customerStatus = this.customerStatusList.filter(status => status.customerStatusId === this.outletObj.customerStatusId);

              if (customerStatus.every(status => !status.organizationId.toString().split(',').some(id => allOrganizationIds.includes(id)))) {
                this.outletObj.customerStatusId = -1;
              }
            }
          }
          this.editOutlet = true;
          this.coreSession.hideCustomerEntrySliderFooter = true;
          this.showModal = true;
          this.openDivisionEntryDialog()

        }

        // this.editOutletEntry(event.object.customerIdSignature,event.object.outletIdSignature);
        break;
      case RowOperation.Select:
        if (
          this.customerObj.outlets.find(
            (outlet) => outlet.outletId == event.object.outletId
          ).isMain == true
        ) {
          this.customerObj.outlets.find(
            (outlet) => outlet.outletId == event.object.outletId
          ).isMain = false;
        } else {
          let index = this.customerObj.outlets.findIndex(
            (o) => o.isMain == true
          );
          if (index > -1) {
            this.customerObj.outlets[index].isMain = false;
            if (
              this.customerObj.outlets[index].dataAction == DataActions.NoChange
            ) {
              // this.customerObj.outlets[index].dataAction = DataActions.Edit;
            }
          }
          this.customerObj.outlets.find(
            (outlet) => outlet.outletId == event.object.outletId
          ).isMain = true;
        }
        if (
          this.customerObj.outlets.find(
            (outlet) => outlet.outletId == event.object.outletId
          ).dataAction == DataActions.NoChange
        ) {
          // this.customerObj.outlets.find(
          //   (outlet) => outlet.outletId == event.object.outletId
          // ).dataAction = DataActions.Edit;
        }
        break;
      case RowOperation.Deactivate:
          this.coreSession.ModalDialog.ShowMessage(
            this.translateService.instant(
              ConstantMessages.MsgDeactivateConfirmation
            ),
            DialogMode.YesNo,
            this.translateService.instant(ConstantMessages.WarningCaption)
          ).then((result: DialogResult) => {
            if (result === DialogResult.Yes) {
              event.object.dataAction = DataActions.inActive;
              event.object.inactive = true;
              this.dataSource = {
                totalItems: this.customerObj.outlets.filter(
                  (outlet) => outlet.dataAction != DataActions.Delete && outlet.dataAction != DataActions.inActive
                ).length,
                data: this.customerObj.outlets.filter(
                  (outlet) => outlet.dataAction != DataActions.Delete && outlet.dataAction != DataActions.inActive
                ),
              };
            }
          })

       // this.updateCustomerOutletActiveStatus(event.object, false);
        break;
        case RowOperation.Activate:
          if (event.object.dataAction == DataActions.Add) {
            event.object.inactive = false;
          return;
          }
          this.coreSession.ModalDialog.ShowMessage(
            this.translateService.instant(
              ConstantMessages.MsgReactivateConfirmation
            ),
            DialogMode.YesNo,
            this.translateService.instant(ConstantMessages.WarningCaption)
          ).then((result: DialogResult) => {
            if (result === DialogResult.Yes) {
              event.object.inactive = false;
              event.object.dataAction = DataActions.Edit;

            }

          // this.dataSource = {
          //   totalItems: this.customerObj.outlets.filter(
          //     (outlet) => outlet.dataAction != DataActions.inActive
          //   ).length,
          //   data: this.customerObj.outlets.filter(
          //     (outlet) => outlet.dataAction != DataActions.inActive
          //   ),
          // }
          })

          break;

      }
  }
  updateCustomerOutletActiveStatus(outlet: any, isActive) {
    var msg = '';
    if (isActive) {
      msg = ConstantMessages.MsgReactivateConfirmation;
    } else {
      msg = ConstantMessages.MsgDeactivateConfirmation;
    }
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(msg), DialogMode.YesNo).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          this.coreSession.ModalLoading.Show();
          let filter: GeneralFilter = {
            outletId: outlet.outletId,
            includeInactive: isActive,
          }
          this.customerService.updateOutletActiveStatus(filter).subscribe(response => {
            this.coreSession.ModalLoading.Hide();
            if (response.status != null && response.status >= 0) {
              this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly));
              //this.populateDiscounts();
            } else {
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
            }
          },
            (error: HttpErrorResponse) => {
              this.coreSession.ModalLoading.Hide();
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
            });
        }
      });
  }
  ChangeDataView(index: number) {
    // Block switching to account tab if header data tab is not filled correctly
    if (
      (index === this.shownData.AccountData || index === this.shownData.PackBarcode || (this.UsePayerAccount && index === this.shownData.AccountPayerData)) &&
      this.customerForm.get("headerData").invalid
    ) {
      if (this.customerForm.get("headerData").get("email").invalid) {
        this.customerForm.get("headerData").get("email").markAsTouched();
        this.coreSession.showWarrning(
          this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant(ConstantMessages.MsgEmailSyntax)
        );
        return;
      } else {
        this.markFormGroupTouched();
        this.coreSession.showWarrning(
          this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant(ConstantMessages.MsgFillMandatory)
        );
        return;
      }
    }

    this.navLinks.forEach((a) => (a.isActive = false));
    this.navBarselectedIndex = index;
    this.navLinks[index].isActive = true;
  }

  addNewOutlet() {
    if (this.customerForm.invalid) {
      if (this.customerForm.get("headerData").invalid) {
        if (this.customerForm.get("headerData").get("email").invalid) {
          this.customerForm.get("headerData").get("email").markAsTouched();
          this.coreSession.showWarrning(
            this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.MsgEmailSyntax)
          );
          return;
        } else {
          this.markFormGroupTouched();
          this.coreSession.showWarrning(
            this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.MsgFillMandatory)
          );
          return;
        }
      }
    }

    this.showSharedTable = false
    this.editOutlet = false;
    this.selectedIndex = -1;
    this.selectedOutletId = this.dynamicOutletId;
    this.outletObj = undefined;
    this.FillCustomerObjData();
    this.coreSession.hideCustomerEntrySliderFooter = true;
    this.showModal = true;
    this.openDivisionEntryDialog()

  }
  showSharedTable = false
  close() {
    if (this.customerObj && this.customerObj.outlets) {
      this.dataSource = {
        totalItems: this.customerObj.outlets.filter(
          (outlet) => outlet.dataAction != DataActions.Delete
        ).length,
        data: this.customerObj.outlets.filter(
          (outlet) => outlet.dataAction != DataActions.Delete
        ),
      };
    }
    this.coreSession.hideCustomerEntrySliderFooter = false;
    this.showModal = false;
    this.DivisionEntryDialog.Close()


    if (this.dataSource.data.length > 1) {
      this.isDefault.setValue(false);
      this.isDefault.disable();
      this.isDefault.updateValueAndValidity();
    } else if (this.isDefault.value && this.dataSource.data.length == 1) {
      this.tabelProperties.showNewBtn = false;
    }
    this.showSharedTable = true
  }
  FillCustomerObjData() {
    if (!this.customerObj) {
      this.customerObj = new CustomerModel();
    }
    let descriptions = [];

    if (
      this.customerForm.get("headerData").get("descriptionLanguages").value !=
      null
    ) {
      descriptions = this.customerForm
        .get("headerData")
        .get("descriptionLanguages").value;
      let index = descriptions.findIndex(
        (x) => x.languageId === this.coreSession.selectedLanguageId
      );
      if (index == -1) {
        descriptions.push({
          languageId: this.coreSession.selectedLanguageId,
          description: this.customerForm.get("headerData").get("customerName")
            .value,
        });
      } else {
        descriptions[index].description = this.customerForm
          .get("headerData")
          .get("customerName").value;
      }
    }
    descriptions;
    this.customerObj.customerName = this.customerForm.value.headerData.customerName;
    this.customerObj.customerCode = this.customerForm.get('headerData').get('customerCode').value;
    this.customerObj.phone = this.customerForm.value.headerData.customerPhone;
    this.customerObj.email = this.customerForm.value.headerData.email;
    this.customerObj.fax = this.customerForm.value.headerData.customerFax;
    if (this.CheckPaymentTermOnCustomerLevel) {
      this.customerObj.paymentTermId = this.customerForm.value.headerData.paymentTermId;
    } else {
      this.customerObj.paymentTermId = -1;
    }
    // this.customerObj.streetId=this.customerForm.value.headerData.street;
    // this.customerObj.streetNumber=this.customerForm.value.headerData.streetNumber;
    this.customerObj.contractNumber = this.customerForm.value.headerData.contractNumber;
    this.customerObj.currencyId = -1
    this.customerObj.descriptionLanguages = descriptions;
    //  Fill Account Data
    this.customerObj.accountsList = this.customerAccountsList;
    this.customerObj.isDefault = this.customerForm
      .get("headerData")
      .get("isDefault").value;
    this.customerObj.allowPayAllOutlets = this.customerForm
      .get("headerData")
      .get("allowPayAllOutlets").value;
    this.customerObj.exportCustomer = this.customerForm
      .get("headerData")
      .get("exportCustomer").value;


    this.customerObj.employeeId =
      this.employeeId.value != null ? this.employeeId.value : -1;

    this.customerObj.hasPrivilegeOnPaymentTermDivision = this.hasPrivilegeOnPaymentTermDivision;
    this.customerObj.hasPrivilegeOnOnHoldDivision = this.hasPrivilegeOnOnHoldDivision;

    // this.customerObj.customerIdSignature = '';
    // this.customerObj.isDirectSales = false;
    // this.customerObj.fax = '';
    // this.customerObj.isNewCustomer = false;
    // this.customerObj.contractNumber = '';
    // this.customerObj.collectord =-1;
    // this.customerObj.currencyId =-1;
    // this.customerObj.isDirectSales = false;
    // this.customerObj.currencyDescription   = '';
    // this.customerObj.outlets  = [];
    if (this.ForceCustomerOrganizationSelection) {
      const custAccount = this.customerAccountsList.filter(acc => acc.dataAction !== DataActions.Delete.valueOf());
      const allOrganizationIds = custAccount.map(account => account.organizationId.toString()).join(',');
      if (this.customerStatusList && this.customerStatusList.length > 0) {
        if (this.customerObj.outlets != null && this.customerObj.outlets.length > 0) {
          this.customerObj.outlets.forEach(outlet => {
            var customerStatus = this.customerStatusList.filter(status => status.customerStatusId === outlet.customerStatusId);
            if (customerStatus.every(status => !status.organizationId.toString().split(',').some(id => allOrganizationIds.includes(id)))) {
              outlet.customerStatusId = -1;
              // outlet.dataAction = DataActions.Add;
            }
          })
        }
      }
    }


    var addedPackBarcodeList = this.addedItemsList.filter(i => i.dataAction === DataActions.Edit);
    if (addedPackBarcodeList) {
      this.customerObj.customerPackBarcodeList = addedPackBarcodeList;
    }
    this.customerObj.outletPayersList = this.outletPayerList;
  }
  onCancel() {
    this.router.navigate([ConstantURLs.customersURL], {
      relativeTo: this.route.parent,
    });
  }
  SaveCustomerData() {
    if (this.customerForm.invalid) {
      if (this.customerForm.get("headerData").invalid) {
        if (this.customerForm.get("headerData").get("email").invalid) {
          this.customerForm.get("headerData").get("email").markAsTouched();
          this.coreSession.showWarrning(
            this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.MsgEmailSyntax)
          );
          return;
        } else {
          this.markFormGroupTouched();
          this.coreSession.showWarrning(
            this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.MsgFillMandatory)
          );
          return;
        }
      }
    }
    var descriptions = this.customerForm.get("headerData").get("descriptionLanguages").value;
    if (this.checkForLanguageDescription && descriptions.filter(x => x.languageId != this.coreSession.selectedLanguageId && x.description == '').length != 0) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddDescriptionForCustomer));
      return;
    }

    if (this.ForceCustomerOrganizationSelection && this.checkMandatoryFieldsOnCustomer && this.dataSource.data.length > 0 && this.dataSource.data.filter(x => x.routesList && x.routesList.length > 0) && this.dataSource.data.filter(x => x.routesList.length > 0).length == 0) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddAccountAndTerritoriesForCustomerOutlet) + ' => ' + this.dataSource.data.map(({ outletName }) => outletName).join(', '));
      return;
    }
    // Account Validations :
    // 1. if ForceCustomerOrganizationSelection is false then must define valid account for customer and
    //    if ForceCustomerOrganizationSelection is true then must fill account.
    if (
      this.coreSession.cachedGeneralData.webApplication === WebApplication.Sonic
    ) {

      // 2. Check credit limit : sum of child accounts credit must not exceed customer account credit
      for (var i = 0; i < this.customerAccountsList.length; i++) {
        if (this.customerAccountsList[i].dataAction != DataActions.Delete) {
          let sumOfChildsCreditLimit = this.getSumOfChildsAccountsCredit(
            this.customerAccountsList[i]
          );
          if (
            sumOfChildsCreditLimit > this.customerAccountsList[i].creditLimit
          ) {
            var msg = "";
            if (this.ForceCustomerOrganizationSelection) {
              msg =
                this.translateService.instant("Desc_Vendor") +
                " " +
                this.customerAccountsList[i].organizationCodeName +
                " : " +
                this.translateService.instant(
                  ConstantMessages.MsgExceedCustomerAccount
                );
            } else {
              msg = this.translateService.instant(
                ConstantMessages.MsgExceedCustomerAccount
              );
            }
            this.ChangeDataView(this.shownData.AccountData);
            this.coreSession.showWarrning(
              this.translateService.instant(ConstantMessages.WarningCaption),
              msg
            );
            return;
          }
        }
      }
      //3. if CheckMandatoryFieldsOnCustomer is true then must define valid account for each outlet
      if (this.checkMandatoryFieldsOnCustomer) {
        for (var i = 0; i < this.customerObj.outlets.length; i++) {
          if (this.customerObj.outlets[i].accountsList.length === 0) {
            msg = this.translateService.instant(
              ConstantMessages.MsgMustDefineOutletAccount
            );
            this.coreSession.showWarrning(
              this.translateService.instant(ConstantMessages.WarningCaption), msg
            );
            return;
          }
        }
      }
    }

    this.coreSession.ModalLoading.Show();
    this.FillCustomerObjData();
    let customerId = -1;

    if (this.customerObj.customerId) customerId = this.customerObj.customerId;
    if (!this.isEditMode) {
      if (this.NewCustomerCodeSequence != "") {
        this.customerObj.maxCustomerCode = this.coreSession.generateCustomerCode(this.maxCustomerCode);
      }
    } else {
      if (this.NewCustomerCodeSequence != "")
        this.customerObj.maxCustomerCode = this.maxCustomerCode;
    }
    let codeFilter = [
      {
        tableName: "Customer",
        columnName: "CustomerCode",
        insertedValue: this.customerObj.customerCode,
        excludedString: " And CustomerId != " + customerId,
        columnDescription: this.translateService.instant("Desc_Customer_Code"),
      },
    ];
    if (
      this.sessionData
        .getConfigurationValue(
          ConstantConfigurations.CheckCustomerUniquenessEntry
        )
        .toLowerCase() === "true"
    ) {
      if (this.customerObj.email && this.customerObj.email != "") {
        codeFilter.push({
          tableName: "Customer",
          columnName: "Email",
          insertedValue: this.customerObj.email,
          excludedString: " And CustomerId != " + customerId,
          columnDescription: this.translateService.instant("Desc_Email"),
        });
      }
      if (this.customerObj.phone && this.customerObj.phone != "") {
        codeFilter.push({
          tableName: "Customer",
          columnName: "Phone",
          insertedValue: this.customerObj.phone,
          excludedString: " And CustomerId != " + customerId,
          columnDescription: this.translateService.instant("Desc_Phone"),
        });
      }
    }

    var NumberOfOutlets = this.dataSource.data.filter(outlet => outlet.inactive !== true).length;
    if (NumberOfOutlets == 0) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(
          "Desc_Please_Definition_One_Outlet_At_Least"
        )
      );
      this.coreSession.ModalLoading.Hide();
      return;
    }
    if (
      (this.dataSource.data.length > 1 &&
        this.employeeId.value &&
        this.employeeId.value != -1) ||
      (this.dataSource.data.length == 0 &&
        this.employeeId.value &&
        this.employeeId.value != -1)
    ) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(
          "Desc_Please_Definition_One_Outlet_At_Most_To_Assign_Default_Employee"
        )
      );
      this.coreSession.ModalLoading.Hide();
      return;
    }
    if (
      this.employeeId.value != null &&
      this.employeeId.value != -1 &&
      this.customerAccountsList.length == 0
    ) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(
          "Desc_Please_Add_Account_To_Assign_Default_Employee"
        )
      );
      this.coreSession.ModalLoading.Hide();
      return;
    }
    this.masterDataService.checkIfUniqueValueOfListOfData(codeFilter).subscribe(
      (response) => {
        if (response.status != null && response.status >= 0) {
          if (!response.data) {
            this.coreSession.ModalLoading.Hide();
            this.coreSession.showWarrning(
              this.translateService.instant(ConstantMessages.WarningCaption),
              response.message
            );
          } else {
            this.continueSavingData();
          }
        } else {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(response.message)
          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }
  continueSavingData() {
    var observable = new Observable<ResponseModel>();
    this.customerObj.outletPayersList = this.customerObj.outletPayersList.filter(payer => payer.payerId !== null && payer.payerId !== -1);
    if (this.isFromNewCustomer)
      observable = this.newCustomerService.UpdateCustomer(this.customerObj);
    else if (this.isEditMode)
      observable = this.customerService.UpdateCustomer(this.customerObj);
    else observable = this.customerService.InsertNewCustomer(this.customerObj);
    observable.subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          //swal('Success!', response.message, 'success');
          this.onSaveCompleted.emit();
          this.coreSession.showSuccess(
            this.translateService.instant(ConstantMessages.SuccessCaption),
            response.message
          );
          //this.router.navigate([ConstantURLs.customersURL], { relativeTo: this.route.parent });
        } else {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            response.message
          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }
  onSaveClick() {
    this.saveSubject.next();
  }
  // customerForm --headerData
  get customerName() {
    return this.customerForm.get("headerData").get("customerName");
  }
  get employeeId() {
    return this.customerForm.get("headerData").get("employeeId");
  }
  get isDefault() {
    return this.customerForm.get("headerData").get("isDefault");
  }
  private markFormGroupTouched() {
    (<FormGroup>(
      this.customerForm.get("headerData")
    )).controls.customerName.markAsTouched();
    (<FormGroup>(
      this.customerForm.get("headerData")
    )).controls.customerCode.markAsTouched();
    (<FormGroup>(
      this.customerForm.get("headerData")
    )).controls.currencyId.markAsTouched();
    // (<FormGroup>(
    //   this.customerForm.get('headerData')
    // )).controls.email.markAsTouched();
  }

  fillDivisionsList() {
    this.isDivisionLoading = true;
    this.divisionsList = [];
    this.divisionService
      .getDivisionsUnderEmployeeAccess()
      .subscribe((result) => {
        this.divisionsList = result;
        this.isDivisionLoading = false;
      });
  }
  afterSavedOutlet() {
    // dynamic outlet id will decreased by 1 for every added outlet
    var addedOutletId = -1;
    if (!this.editOutlet) {
      addedOutletId = this.dynamicOutletId;
      this.dynamicOutletId = this.dynamicOutletId - 1;
    }
    this.close();
    this.setOutletAccounts();
    if (!this.editOutlet) {
      var newOutletIndex = this.customerObj.outlets.findIndex(x => x.dummyOutletID === addedOutletId);
      if (newOutletIndex >= 0) {
        let payerObject = new PayerAccountModel();
        payerObject.customerId = this.customerObj.customerId;
        payerObject.outletId = this.customerObj.outlets[newOutletIndex].outletId;
        payerObject.outletCodeName = this.customerObj.outlets[newOutletIndex].outletCodeName;

        if (this.ControlTransactionDivisionLevel) {
          this.divisionsList.forEach(div => {
            let divPayer = cloneDeep(payerObject);
            divPayer.divisionId = div.divisionId;
            divPayer.divisionCodeName = div.divisionCodeName;
            this.outletPayerList.push(divPayer);
          });
        } else {
          this.outletPayerList.push(payerObject);
        }
        this.fillPayerList();
      }
    }
    if (this.newOutletCodeSequence != "") {
      this.nextMaxOutletCode = this.customerObj.maxOutletCode;
    }
    this.showSharedTable = true
  }
  onOtherLanguagesTextSubmitted(event) {
    this.customerForm
      .get("headerData")
      .get("descriptionLanguages")
      .setValue(event);
  }
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.componentVisitService.markComponentVisited('customer-entry');
    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.saveEvent.subscribe(() => {
      this.SaveCustomerData();
    });
  }

  // subscribeSaveClick() {

  //     this.saveBtnSubscription = this.events.subscribe(() => {
  //     this.SaveCustomerData();

  //   });

  // }
  // ngOnDestroy() {
  //   this.saveBtnSubscription.unsubscribe();
  // }

  //#region [Account Entry]
  initCustomerAccountEntryForm() {
    this.customerAccountEntryForm = new FormGroup({
      organizationId: new FormControl(null, Validators.required),
      creditLimit: new FormControl(null, Validators.required),
      currencyId: new FormControl({ value: null, disabled: true },)
    });
  }
  onChangeOrganization(organization) {
    this.selectedOrganization = organization;
    // this.customerForm
    //   .get("headerData")
    //   .get("currencyId").reset();
  }
  clearAccountEntry() {
    this.customerAccountEntryForm.reset();
    this.selectedOrganization = null;
  }
  addCustomerAccount() {
    // this method will be used  when force organization selection true
    this.customerAccountEntryForm.markAllAsTouched();
    if (this.customerAccountEntryForm.invalid) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgFillMandatory)
      );
      return;
    }
    if (
      this.customerAccountsList.findIndex(
        (a) =>
          a.organizationId ===
          this.customerAccountEntryForm.get("organizationId").value &&
          a.dataAction != DataActions.Delete
      ) >= 0
    ) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgAccountExist)
      );
      return;
    }

    if (this.ForceCustomerOrganizationSelection && this.ApplyCurrencyPerOrganization ) {
      //selected org has no base currency .
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgNoBaseCurrencyForSelectedOrg)
      );
      return;
    }
    let account = {
      isCollapsed: false,
      dummyCreditLimit: null,
      dummyOutletId: null,
      dummyDivisionId: null,
      accountId: -1,
      organizationId: this.customerAccountEntryForm.get("organizationId").value,
      currencyId:-1,
      creditLimit: +this.customerAccountEntryForm.get("creditLimit").value,
      balance: 0,
      accountTypeId: AccountTypes.ClientAccount.valueOf(),
      gl: false,
      commitmentLimit: 0,
      parentAccountId: -1,
      divisionId: -1,
      currencyName: "",
      organizationCodeName: this.selectedOrganization.organizationCodeName,
      currencyCodeName: this.selectedCurrency != null ? this.selectedCurrency.currencyCodeName : null,
      divisionCodeName: "",
      accountLevel: CustomerAccountLevel.CustomerAccount,
      dataAction: DataActions.Add,
    };
    this.customerAccountsList.push(account);
    this.clearAccountEntry();
  }
  getNonDeletedCustomerAccounts() {
    return this.customerAccountsList.filter(
      (a) => a.dataAction != DataActions.Delete
    );
  }
  addOutletAccountt(customerAccount) {
    if (
      !customerAccount.dummyOutletId ||
      customerAccount.dummyCreditLimit === undefined ||
      customerAccount.dummyCreditLimit == null ||
      (this.ControlTransactionOnDivisionLevel &&
        !customerAccount.dummyDivisionId)
    ) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgFillMandatory)
      );
      return;
    }

    var currencyId = -1;
    var outletId = customerAccount.dummyOutletId;
    var organizationId = customerAccount.organizationId;
    var insertedCreditLimit = +customerAccount.dummyCreditLimit;
    var divisionId = -1;
    var divisionCodeName = "";
    var sumOfChildsCreditLimit = 0;

    if (this.ControlTransactionOnDivisionLevel) {
      divisionId = customerAccount.dummyDivisionId;
      let divIndex = this.divisionsList.findIndex(
        (division) => division.divisionId === divisionId
      );
      if (divIndex >= 0) {
        divisionCodeName = this.divisionsList[divIndex].divisionCodeName;
      }
    }

    // 1. Check if account is exist before then block adding
    let outletIndex = this.dataSource.data.findIndex(
      (outlet) => outlet.outletId === outletId
    );
    if (outletIndex >= 0) {
      if (
        this.dataSource.data[outletIndex].accountsList != null &&
        this.dataSource.data[outletIndex].accountsList.length > 0
      ) {
        if (this.ControlTransactionOnDivisionLevel) {
          if (
            this.dataSource.data[outletIndex].accountsList.findIndex(
              (a) =>
                a.organizationId === organizationId &&
                a.divisionId === divisionId &&
                a.dataAction != DataActions.Delete
            ) >= 0
          ) {
            this.coreSession.showWarrning(
              this.translateService.instant(ConstantMessages.WarningCaption),
              this.translateService.instant(ConstantMessages.MsgAccountExist)
            );
            return;
          }
        } else {
          if (
            this.dataSource.data[outletIndex].accountsList.findIndex(
              (a) =>
                a.organizationId === organizationId &&
                a.dataAction != DataActions.Delete
            ) >= 0
          ) {
            this.coreSession.showWarrning(
              this.translateService.instant(ConstantMessages.WarningCaption),
              this.translateService.instant(ConstantMessages.MsgAccountExist)
            );
            return;
          }
        }
      } else {
        this.dataSource.data[outletIndex].accountsList = [];
      }
    } else {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.ErrorCaption),
        this.translateService.instant(ConstantMessages.ErrorHappened)
      );
      return;
    }

    sumOfChildsCreditLimit = this.getSumOfChildsAccountsCredit(customerAccount);
    sumOfChildsCreditLimit += insertedCreditLimit;
    if (sumOfChildsCreditLimit > customerAccount.creditLimit) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgExceedCustomerAccount)
      );
      return;
    }

    // Adding outlet account
    let newAccount = {
      accountId: -1,
      organizationId: organizationId,
      currencyId: -1,
      creditLimit: insertedCreditLimit,
      balance: 0,

      accountTypeId: AccountTypes.ClientAccount.valueOf(),
      gl: false,
      commitmentLimit: 0,
      parentAccountId: -1,
      divisionId: divisionId,

      currencyName: "",
      organizationCodeName: "",
      divisionCodeName: divisionCodeName,
      dataAction: DataActions.Add,
      accountLevel: this.ControlTransactionOnDivisionLevel
        ? CustomerAccountLevel.DivisionAccount
        : CustomerAccountLevel.OutletAccount,
    };

    if (outletIndex >= 0) {
      this.dataSource.data[outletIndex].accountsList.push(newAccount);
    }
    this.clearOutletAccountEntry(customerAccount);
  }
  getSumOfChildsAccountsCredit(customerAccount) {
    var sumOfChildsCreditLimit = 0;
    for (var i = 0; i < this.dataSource.data.length; i++) {
      for (var j = 0; j < this.dataSource.data[i].accountsList.length; j++) {
        var account = this.dataSource.data[i].accountsList[j];
        if (
          account.organizationId === customerAccount.organizationId &&
          account.dataAction != DataActions.Delete
        ) {
          sumOfChildsCreditLimit += account.creditLimit;
        }
      }
    }
    return sumOfChildsCreditLimit;
  }
  deleteCustomerAccount(account) {
    var deleteMessage = "";
    if (this.ForceCustomerOrganizationSelection) {
      deleteMessage = ConstantMessages.MsgConfirmDeleteAccountWithTerritories;
    } else {
      deleteMessage = ConstantMessages.MsgDeleteConfirmation;
    }

    this.coreSession.ModalDialog.ShowMessage(
      this.translateService.instant(deleteMessage),
      DialogMode.YesNo,
      this.translateService.instant(ConstantMessages.WarningCaption)
    ).then((res: DialogResult) => {
      if (res === DialogResult.Yes) {
        this.onDeleteCustomerAccount(account);
      }
    });
  }

  onDeleteCustomerAccount(account) {
    // check balance
    if (account.balance != 0) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(
          ConstantMessages.MsgDeleteAccountHavingBalance
        )
      );
      return;
    }

    // check childs for customer account
    if (this.isCustomerAccountHasChilds(account.organizationId)) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(
          ConstantMessages.MsgDeleteAccountHavingChilds
        )
      );
      return;
    }

    var accountIndex = this.customerAccountsList.findIndex(
      (a) =>
        a.organizationId === account.organizationId &&
        a.dataAction != DataActions.Delete
    );
    if (accountIndex >= 0) {
      // If account is added recently then remove it from the list
      if (account.dataAction == DataActions.Add) {
        this.customerAccountsList.splice(accountIndex, 1);
        if (this.ForceCustomerOrganizationSelection) {
          this.deleteAccountOrgRelatedData(account);
        }
      } else {
        // If account is saved before then check if it used in DB
        this.isValidToDeleteAccountFromDB(account);
      }
    }
  }

  deleteAccountOrgRelatedData(account) {
    if (!this.customerObj.outlets) return;
    this.customerObj.outlets.forEach((outlet) => {
      if (outlet.territories && outlet.territories.length > 0) {
        var territories = outlet.territories.filter(territory => territory.organizationId !== account.organizationId);
        outlet.territories = territories;
      }
      if (this.customerStatusList && this.customerStatusList.length > 0) {
        var customerStatus = this.customerStatusList.filter(status => status.customerStatusId === outlet.customerStatusId);
        if (customerStatus.some(status => status.organizationId.toString().split(',').includes(account.organizationId.toString())))
          outlet.customerStatusId = -1
      }

      if (outlet.routesList && outlet.routesList.length > 0) {
        // Route - Territory data ->
        var result = outlet.routesList.filter(
          (route) => route.organizationId !== account.organizationId
        );
        outlet.routesList = result; // return routes with organizationId !== Account's organizationId

      }
      if (outlet.groups && outlet.groups.length > 0 && this.forceOrganizationFilterForCustomerGroups) {
        // Customer Group data ->
        var groups = outlet.groups.filter(group => group.organizationId !== account.organizationId);
        outlet.groups = groups;
      }

      if (this.enableSalesDistributionChannel && outlet.salesDistributionChannels && outlet.salesDistributionChannels.length > 0) {
        let allOutletAccOrgsList = outlet.accountsList.filter(acc => acc.dataAction != DataActions.Delete).map(acc => acc.organizationId);
        var sdcs = outlet.salesDistributionChannels.filter(sdc =>
          sdc.organizationIds.split(',').some(sdcOrg => allOutletAccOrgsList.includes(parseInt(sdcOrg)))
        );
        outlet.salesDistributionChannels = sdcs;
      }
      if (this.allowSelectAlternativeWarehouseInFO && outlet.warehouseId && outlet.warehouseId > 0) {
        let allOutletAccOrgsList = outlet.accountsList.filter(acc => acc.dataAction != DataActions.Delete).map(acc => acc.organizationId);
        if (!allOutletAccOrgsList.includes(outlet.warehouseOrganizationId)) {
          outlet.warehouseId = -1;
          outlet.warehouseOrganizationId = -1;
        }
      }
      outlet.dataAction = outlet.dataAction === DataActions.NoChange ? DataActions.EditFromParent : outlet.dataAction;
    });
  }

  deleteOutletAccountOrgRelatedData(account, outletCode: string = null) {
    // get customer outlet object of the account to be deleted.
    // the obj might have more than one acc on different organizations
    if (!this.ControlTransactionOnDivisionLevel) {
      // If ControlTransactionOnDivisionLevel is FALSE, delete all customer outlet territory data on deleted account's organization
      if (account.accountId === -1) { // new account
        var outlet = this.accountOutletsList.find(o => o.outletCode === outletCode);
        if (outlet != null) {
          var deleteOrgRelatedData = outlet.accountsList.filter(acc => acc.organizationId === account.organizationId).length === 0;
          if (deleteOrgRelatedData) {
            // routes
            var result = outlet.routesList.filter((route) => route.organizationId !== account.organizationId);
            outlet.routesList = result;
            // territories
            var territories = outlet.territories.filter(territory => territory.organizationId !== account.organizationId);
            outlet.territories = territories;
            // customerStatus
            if (this.ForceCustomerOrganizationSelection) {
              if (this.customerStatusList && this.customerStatusList.length > 0) {
                var customerStatus = this.customerStatusList.filter(status => status.customerStatusId === outlet.customerStatusId);
                if (customerStatus.some(status => status.organizationId.toString().split(',').includes(account.organizationId.toString())))
                  outlet.customerStatusId = -1
              }
            }
            // groups
            if (this.forceOrganizationFilterForCustomerGroups && outlet.groups && outlet.groups.length > 0) {
              var groups = outlet.groups.filter(group => group.organizationId != account.organizationId);
              outlet.groups = groups;
            }
            // sdc
            if (this.enableSalesDistributionChannel && outlet.salesDistributionChannels && outlet.salesDistributionChannels.length > 0) {
              let allOutletAccOrgsList = outlet.accountsList.filter(acc => acc.dataAction != DataActions.Delete).map(acc => acc.organizationId);
              var sdcs = outlet.salesDistributionChannels.filter(sdc =>
                sdc.organizationIds.split(',').some(sdcOrg => allOutletAccOrgsList.includes(parseInt(sdcOrg)))
              );
              outlet.salesDistributionChannels = sdcs;
            }
            // alternative warehouses
            if (this.allowSelectAlternativeWarehouseInFO && outlet.warehouseId && outlet.warehouseId > 0) {
              let allOutletAccOrgsList = outlet.accountsList.filter(acc => acc.dataAction != DataActions.Delete).map(acc => acc.organizationId);
              if (!allOutletAccOrgsList.includes(outlet.warehouseOrganizationId)) {
                outlet.warehouseId = -1;
                outlet.warehouseOrganizationId = -1;
              }
            }
            outlet.dataAction = outlet.dataAction === DataActions.NoChange ? DataActions.EditFromParent : outlet.dataAction;
          }
        }
      } else {  // existing account (in DB)
        var acctoBeDeletedObj;
        this.accountOutletsList.forEach(accountOutletObj => {
          acctoBeDeletedObj = accountOutletObj.accountsList.filter(
            (acc) =>
              acc.accountId === account.accountId); //Unique Acc.
          if (acctoBeDeletedObj && acctoBeDeletedObj.length > 0) {
            var result = accountOutletObj.routesList.filter(
              (route) => route.organizationId !== account.organizationId);
            accountOutletObj.routesList = result;

            var territories = accountOutletObj.territories.filter(territory => territory.organizationId !== account.organizationId);
            accountOutletObj.territories = territories;
            if (this.ForceCustomerOrganizationSelection) {
              if (this.customerStatusList && this.customerStatusList.length > 0) {
                var customerStatus = this.customerStatusList.filter(status => status.customerStatusId === accountOutletObj.customerStatusId);
                if (customerStatus.some(status => status.organizationId.toString().split(',').includes(account.organizationId.toString())))
                  accountOutletObj.customerStatusId = -1
              }
            }

            if (this.forceOrganizationFilterForCustomerGroups && accountOutletObj.groups && accountOutletObj.groups.length > 0) {
              var groups = accountOutletObj.groups.filter(group => group.organizationId != account.organizationId);
              accountOutletObj.groups = groups;
            }

            if (this.enableSalesDistributionChannel && accountOutletObj.salesDistributionChannels && accountOutletObj.salesDistributionChannels.length > 0) {
              let allOutletAccOrgsList = accountOutletObj.accountsList.filter(acc => acc.dataAction != DataActions.Delete).map(acc => acc.organizationId);
              var sdcs = accountOutletObj.salesDistributionChannels.filter(sdc =>
                sdc.organizationIds.split(',').some(sdcOrg => allOutletAccOrgsList.includes(parseInt(sdcOrg)))
              );
              accountOutletObj.salesDistributionChannels = sdcs;
            }
            if (this.allowSelectAlternativeWarehouseInFO && accountOutletObj.warehouseId && accountOutletObj.warehouseId > 0) {
              let allOutletAccOrgsList = accountOutletObj.accountsList.filter(acc => acc.dataAction != DataActions.Delete).map(acc => acc.organizationId);
              if (!allOutletAccOrgsList.includes(accountOutletObj.warehouseOrganizationId)) {
                accountOutletObj.warehouseId = -1;
                accountOutletObj.warehouseOrganizationId = -1;
              }
            }
            accountOutletObj.dataAction = accountOutletObj.dataAction === DataActions.NoChange ? DataActions.EditFromParent : accountOutletObj.dataAction;
          }
        });
      }
    }
  }

  deleteDivisionAccountOrgRelatedData(account) {
    if (this.ControlTransactionOnDivisionLevel) {

      var acctoBeDeletedObj;
      var accCustOutObj;

      if (account.accountId === -1) {
        //Find other accounts on the organization of the account to be deleted.
        //if accounts > 2 => do not delete territory data, else, delete territory data
        var currentOutletOrgAccounts = this.currentOutletAccounts.filter(acc => acc.organizationId === account.organizationId && acc.dataAction !== 4);
        if (currentOutletOrgAccounts.length - 1 === 0) {
          this.accountOutletsList.forEach(accOutObj => {
            if (accOutObj.outletId === this.currentOutlet.outletId) {
              var result = accOutObj.routesList.filter(
                (route) => route.organizationId !== account.organizationId);
              accOutObj.routesList = result;

              var territories = accOutObj.territories.filter(territory => territory.organizationId !== account.organizationId);
              accOutObj.territories = territories;
              if (this.ForceCustomerOrganizationSelection) {
                if (this.customerStatusList && this.customerStatusList.length > 0) {
                  var customerStatus = this.customerStatusList.filter(status => status.customerStatusId === accOutObj.customerStatusId);
                  if (customerStatus.some(status => status.organizationId.toString().split(',').includes(account.organizationId.toString())))
                    accOutObj.customerStatusId = -1
                }
              }

              if (this.forceOrganizationFilterForCustomerGroups && accOutObj.groups && accOutObj.groups.length > 0) {
                var groups = accOutObj.groups.filter(group => group.organizationId !== account.organizationId);
                accOutObj.groups = groups;
              }
              if (this.enableSalesDistributionChannel && accOutObj.salesDistributionChannels && accOutObj.salesDistributionChannels.length > 0) {
                let allOutletAccOrgsList = accOutObj.accountsList.filter(acc => acc.dataAction != DataActions.Delete).map(acc => acc.organizationId);
                var sdcs = accOutObj.salesDistributionChannels.filter(sdc =>
                  sdc.organizationIds.split(',').some(sdcOrg => allOutletAccOrgsList.includes(parseInt(sdcOrg)))
                );
                accOutObj.salesDistributionChannels = sdcs;
              }
              if (this.allowSelectAlternativeWarehouseInFO && accOutObj.warehouseId && accOutObj.warehouseId > 0) {
                let allOutletAccOrgsList = accOutObj.accountsList.filter(acc => acc.dataAction != DataActions.Delete).map(acc => acc.organizationId);
                if (!allOutletAccOrgsList.includes(accOutObj.warehouseOrganizationId)) {
                  accOutObj.warehouseId = -1;
                  accOutObj.warehouseOrganizationId = -1;
                }
              }
              accOutObj.dataAction = accOutObj.dataAction === DataActions.NoChange ? DataActions.EditFromParent : accOutObj.dataAction;
            }
          });

        }
      } else {
        this.accountOutletsList.forEach((accOutObj) => {
          acctoBeDeletedObj = accOutObj.accountsList.filter((acc) => acc.accountId === account.accountId);
          if (acctoBeDeletedObj && acctoBeDeletedObj.length > 0) { //found the account in the list...
            accCustOutObj = accOutObj;
            var outletAccsOnCurrentOrg = accCustOutObj.accountsList.filter(acc => acc.organizationId === account.organizationId && acc.dataAction !== 4);
            if (outletAccsOnCurrentOrg && outletAccsOnCurrentOrg.length === 0) {
              // No more accs defined on this org for this outlet, delete territory data for outlet
              var result = accOutObj.routesList.filter(
                (route) => route.organizationId !== account.organizationId);
              accOutObj.routesList = result;

              var territories = accOutObj.territories.filter(territory => territory.organizationId !== account.organizationId);
              accOutObj.territories = territories;

              // customerStatus
              if (this.ForceCustomerOrganizationSelection) {
                if (this.customerStatusList && this.customerStatusList.length > 0) {
                  var customerStatus = this.customerStatusList.filter(status => status.customerStatusId === accOutObj.customerStatusId);
                  if (customerStatus.some(status => status.organizationId.toString().split(',').includes(account.organizationId.toString())))
                    accOutObj.customerStatusId = -1
                }
              }

              if (this.forceOrganizationFilterForCustomerGroups && accOutObj.groups && accOutObj.groups.length > 0) {
                var groups = accOutObj.groups.filter(group => group.organizationId !== account.organizationId);
                accOutObj.groups = groups;
              }
              if (this.enableSalesDistributionChannel && accOutObj.salesDistributionChannels && accOutObj.salesDistributionChannels.length > 0) {
                let allOutletAccOrgsList = accOutObj.accountsList.filter(acc => acc.dataAction != DataActions.Delete).map(acc => acc.organizationId);
                var sdcs = accOutObj.salesDistributionChannels.filter(sdc =>
                  sdc.organizationIds.split(',').some(sdcOrg => allOutletAccOrgsList.includes(parseInt(sdcOrg)))
                );
                accOutObj.salesDistributionChannels = sdcs;
              }
              if (this.allowSelectAlternativeWarehouseInFO && accOutObj.warehouseId && accOutObj.warehouseId > 0) {
                let allOutletAccOrgsList = accOutObj.accountsList.filter(acc => acc.dataAction != DataActions.Delete).map(acc => acc.organizationId);
                if (!allOutletAccOrgsList.includes(accOutObj.warehouseOrganizationId)) {
                  accOutObj.warehouseId = -1;
                  accOutObj.warehouseOrganizationId = -1;
                }
              }
              accOutObj.dataAction = accOutObj.dataAction === DataActions.NoChange ? DataActions.EditFromParent : accOutObj.dataAction;
            }
          }
        });
      }
    }
  }
  deleteOutletAccount(outlet, account) {
    this.coreSession.ModalDialog.ShowMessage(
      this.translateService.instant(ConstantMessages.MsgDeleteConfirmation),
      DialogMode.YesNo,
      this.translateService.instant(ConstantMessages.WarningCaption)
    ).then((res: DialogResult) => {
      if (res === DialogResult.Yes) {
        // Check balance
        if (account.balance != 0) {
          this.coreSession.showWarrning(
            this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(
              ConstantMessages.MsgDeleteAccountHavingBalance
            )
          );
          return;
        }

        var accountIndex = outlet.accountsList.findIndex(
          (a) =>
            a.organizationId === account.organizationId &&
            a.dataAction != DataActions.Delete &&
            ((this.ControlTransactionDivisionLevel && a.divisionId === account.divisionId) || (!this.ControlTransactionDivisionLevel))
        );
        if (accountIndex >= 0) {
          // If account is added recently then remove it from the list
          if (account.dataAction == DataActions.Add) {
            this.currentOutlet = cloneDeep(outlet);
            this.currentOutletAccounts = cloneDeep(outlet.accountsList);
            outlet.accountsList.splice(accountIndex, 1);
            // Account level is 2. [Account is on outlet level]
            if (account.accountLevel === 2) {
              this.deleteOutletAccountOrgRelatedData(account, outlet.outletCode);
            } else if (account.accountLevel === 3 && this.ControlTransactionOnDivisionLevel) {
              // Account level is 3. [Account is on outlet - division level]
              this.deleteDivisionAccountOrgRelatedData(account);
            }
          } else {
            // If account is saved before then check if it used in DB
            this.isValidToDeleteAccountFromDB(account);
          }
        }
      }
    });
  }
  isValidToDeleteAccountFromDB(account) {
    this.coreSession.ModalLoading.Show();
    this.customerService.isValidToDeleteAccount(account.accountId).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (response.data) {
            account.dataAction = DataActions.Delete;
            if (this.ForceCustomerOrganizationSelection) {
              if (account.accountLevel === 1) {
                // Account is on organization level (accountLevel = 1) => delete all territories for this org.
                this.deleteAccountOrgRelatedData(account);
              } else if (account.accountLevel === 2) {
                // Account is on customerOutlet level (accountLevel = 2)
                this.deleteOutletAccountOrgRelatedData(account);
              } else if (account.accountLevel === 3) {
                // Account is on customerOutlet - division level (accountLevel = 3)
                this.deleteDivisionAccountOrgRelatedData(account);
              }
            }

            this.coreSession.showSuccess(
              this.translateService.instant(ConstantMessages.SuccessCaption),
              this.translateService.instant(
                ConstantMessages.MsgDeletedSuccessfully
              )
            );
          } else {
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              response.message
            );
          }
        } else {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            response.message
          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }
  clearOutletAccountEntry(customerAccount) {
    customerAccount.dummyOutletId = null;
    customerAccount.dummyDivisionId = null;
    customerAccount.dummyCreditLimit = null;
  }
  isAnyNonHiddenOutletAccountDefined(organizationId) {
    let isExist = false;
    for (var i = 0; i < this.dataSource.data.length; i++) {
      if (
        this.dataSource.data[i].accountsList.findIndex(
          (a) =>
            a.organizationId === organizationId &&
            a.dataAction != DataActions.Delete &&
            !a.isHidden
        ) >= 0
      ) {
        isExist = true;
        return isExist;
      }
    }
    return isExist;
  }
  isCustomerAccountHasChilds(organizationId) {
    let isExist = false;
    for (var i = 0; i < this.dataSource.data.length; i++) {
      if (
        this.dataSource.data[i].accountsList.findIndex(
          (a) =>
            a.organizationId === organizationId &&
            a.dataAction != DataActions.Delete
        ) >= 0
      ) {
        isExist = true;
        return isExist;
      }
    }
    return isExist;
  }
  getOutletNonHiddenAccounts(outlet, organizationId) {
    return outlet.accountsList.filter(
      (a) =>
        a.organizationId === organizationId &&
        a.dataAction != DataActions.Delete &&
        !a.isHidden
    );
  }
  validateEditAccountLimit(customerAccount) {
    let sumOfChildsCreditLimit = this.getSumOfChildsAccountsCredit(
      customerAccount
    );
    if (sumOfChildsCreditLimit > customerAccount.creditLimit) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgExceedCustomerAccount)
      );
      return;
    }
  }
  addNewEmptyCustomerAccount() {
    let account = {
      isCollapsed: false,
      dummyCreditLimit: null,
      dummyOutletId: null,
      dummyDivisionId: null,
      accountId: -1,
      organizationId: this.coreSession.CurrentOperator.organizationId,
      currencyId: -1,
      creditLimit: 0,
      balance: 0,
      accountTypeId: AccountTypes.ClientAccount.valueOf(),
      gl: false,
      commitmentLimit: 0,
      parentAccountId: -1,
      divisionId: -1,
      organizationCodeName: "",
      currencyCodeName: "",
      divisionCodeName: "",
      accountLevel: CustomerAccountLevel.CustomerAccount,
      dataAction: DataActions.Add,
    };
    this.customerAccountsList.push(account);
  }
  setOutletAccounts() {
    if (
      !this.searchOutletPattern ||
      this.searchOutletPattern.trim().length === 0 ||
      this.searchOutletPattern.trim() === "" ||
      this.searchOutletPattern.trim().length === null
    ) {
      this.accountOutletsList = this.dataSource.data;
    } else {
      this.accountOutletsList = this.dataSource.data.filter(
        (x) =>
          x.outletCode
            .toLowerCase()
            .includes(this.searchOutletPattern.toLowerCase().trim()) ||
          x.outletName
            .toLowerCase()
            .includes(this.searchOutletPattern.toLowerCase().trim()) ||
          x.outletCodeName
            .toLowerCase()
            .includes(this.searchOutletPattern.toLowerCase().trim())
      );
    }
  }

  onChangeIsDefault(event: any) {
    if (!event.currentTarget.checked) {
      this.employeeId.setValue(null);
      this.employeeId.disable();
      this.tabelProperties.showNewBtn = true;
      this.showPayAllOutlet = true;
    } else {
      this.employeeId.enable();
      this.showPayAllOutlet = false;
      if (this.dataSource.data.length == 1) {
        this.tabelProperties.showNewBtn = false;
      }
      /* if (this.employeeId.value == null)
        this.employeeId.setValue(this.coreSession.CurrentOperator.employeeId); */
    }
    this.employeeId.updateValueAndValidity();
  }
  onSelectedCurrency(currency: any) {
    this.customerObj.currencyId = this.customerForm
      .get("headerData")
      .get("currencyId").value;
    this.selectedCurrency = currency;
    this.fillPayerAccountList();
  }

  populateItems(fillUIData?: boolean) {
    this.itemFilter.itemCategoryId = this.filterForm.get('itemCategoryId').value ? this.filterForm.get('itemCategoryId').value : -1;
    this.itemFilter.divisionId = this.filterForm.get('divisionId').value ? this.filterForm.get('divisionId').value : -1;

    this.itemService.getAllItemsLazyLoading(this.itemFilter).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        this.itemsDataSource = {
          totalItems: response.data.totalItems,
          data: response.data.data
        }
        if (fillUIData) {
          this.reflectAddedItemsOnUI(this.itemsDataSource)
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    });
  }
  populateCustomerPayerOutlets() {
    this.outletsFilter.customerId = this.customerId;
    this.customerService.getCustomersPayerOutlets(this.outletsFilter).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        response.data.forEach(element => {
          element.payerId == -1 ? element.payerId = null : element.payerId;
        });
        this.outletPayerList = response.data;
        this.fillPayerList();
      }
    });
  }
  onValueChanges(event: any) {
    if (event) {
      let changedValue = event.object;
      let payerId = event.object.payerId;
      let index = -1;
      if (this.ControlTransactionDivisionLevel) {
        index = this.outletPayerList.findIndex(a => a.payerId === changedValue.payerId && a.outletId == changedValue.outletId && a.divisionId == changedValue.divisionId);
      } else {
        index = this.outletPayerList.findIndex(a => a.payerId === changedValue.payerId && a.outletId == changedValue.outletId);
      }

      let index1 = this.payerList.findIndex(a => a.payerId === changedValue.payerId);
      if (index > -1 && index1 > -1) {
        this.outletPayerList[index].creditLimit = this.payerList[index1].creditLimit;
        this.outletPayerList[index].balance = this.payerList[index1].balance;
      } else {
        this.outletPayerList[index].creditLimit = 0;
        this.outletPayerList[index].balance = 0;
      }
    }
  }
  reflectAddedItemsOnUI(UIdataSource) {
    if (this.itemsDataSource) {
      this.itemsDataSource.data.map(item => {
        var idx = this.addedItemsList.findIndex(addeditem => addeditem.itemId === item.itemId &&
          addeditem.packId === item.packId);
        if (idx > -1) {
          item.customerPackBarcode = this.addedItemsList[idx].customerPackBarcode;
        }
      });
    }
    // this.copyOfItemsDataSource = {
    //   data: cloneDeep(this.itemsDataSource.data),
    //   totalItems: this.itemsDataSource.data.length
    // }
  }

  onDivisionSelected(division) {
  }

  onCategorySelected(category) {
  }

  onFindItems(value) {
    this.populateItems(true);
  }

  onResetItems() {
    this.filterForm.reset();
    this.itemFilter.divisionId = -1;
    this.itemFilter.itemCategoryId = -1;

  }

  onTableFilterChanged(query: any) {
    this.itemFilter.customListFilter = query;
    this.populateItems(true);
  }

  onEditItemBarcode(value) {
    if (value && value !== undefined) {
      value.object.dataAction = DataActions.Edit;
      var idx = this.addedItemsList.findIndex(addedItem => addedItem.itemId === value.object.itemId &&
        addedItem.packId === value.object.packId);
      if (idx > -1) {
        this.addedItemsList[idx].customerPackBarcode = value.object.customerPackBarcode;
        this.addedItemsList[idx].dataAction = DataActions.Edit;
      } else {
        this.addedItemsList.push(value.object);
      }

      this.copyOfAddedItemsList = cloneDeep(this.addedItemsList);
      // this.reflectAddedItemsOnUI(null);
    }
  }
  fillnewOutletCodeSequence() {
    this.maxOutletCode = "";
    this.customerService.getMaxNewOutletCodeSequence().subscribe(result => {
      this.maxOutletCode = result.data;
      this.nextMaxOutletCode = result.data;
    });
  }
  sortingCustomerCode() {
    var newCustomerCode = this.maxOutletCode;
    for (let i = 0; i < this.customerObj.outlets.length; i++) {
      if (this.customerObj.outlets[i].dataAction == DataActions.Add.valueOf()) {
        this.customerObj.outlets[i].outletCode = newCustomerCode;
        newCustomerCode = this.coreSession.generateCustomerCode(newCustomerCode);
      }
    }
    this.nextMaxOutletCode = newCustomerCode
  }
  //#endregion
}
