import {
  Component,
  OnInit,
  ViewChild,
  Output,
  EventEmitter,
} from "@angular/core";
import { CustomerModel } from "../../../../shared/models/customer/customer.model";
import { ITableProperties } from "../../../../shared/models/shared-table/table-properties.interface";
import {
  RowOperation,
  MultiSelectionOperation,
} from "../../../../shared/models/enums/shared-table-operation.enum";
import { SharedTableResult } from "../../../../shared/models/shared-table/shared-table-result.interface";
import {
  CustomListFilter,
  OrderListFilter,
} from "../../../../shared/models/shared-table/custom-list.interface";
import { MainFilterComponent } from "../../../../shared/components/filters/main-filter/main-filter.component";
import { CustomerService } from "../../../../shared/services/data-definition/customer/customers.service";
import { CoreSession } from "../../../../core/core.session";
import { ActivatedRoute, Router } from "@angular/router";
import { ResponseModel } from "../../../../shared/models/api-models/api-models";
import { DialogMode } from "../../../../shared/models/enums/dialog-mode.enum";
import { HttpErrorResponse } from "@angular/common/http";
import { ConstantMessages } from "../../../../shared/models/constants/constant-message";
import { ConstantURLs } from "../../../../shared/models/constants/constant-URL";
import { SessionDataProvider } from "../../../../core/session-data-provider.service";
import { TranslateService } from "@ngx-translate/core";
import { DialogResult } from "../../../../shared/models/enums/dialog-result.enum";
import { MenuActions } from "../../../../shared/models/enums/menu-actions-enum";
import { Subject } from "rxjs";
import { ImportDataTypes } from "../../../../shared/models/import/ImportDataTypes";
import { ConstantConfigurations } from "../../../../shared/models/constants/constant-configuration";
import { SelectInvoicesComponent } from "../../../../shared/components/invoices/select-invoices/select-invoices.component";
import { NavBarService } from "../../../../core/sidebar/sidebar.service";

@Component({
  selector: "app-customers-list",
  templateUrl: "./customers-list.component.html",
  styleUrls: ["./customers-list.component.css"],
})
export class CustomersListComponent implements OnInit {
  @ViewChild("selectInvoiceDialog", { static: true }) selectInvoiceDialog: SelectInvoicesComponent;
  @Output() rowOperation = new EventEmitter();
  customerObj: CustomerModel;
  selectedCustomerId = -1;
  // customerIdSignature='';
  isEditMode = false;
  showEntrySlider = false;
  showTransactionSlider = false;
  showSelectInvoiceDialog: boolean = false;
  saveSubject: Subject<void> = new Subject<void>();
  dataType: ImportDataTypes = ImportDataTypes.Customers;
  customerCodeName: string;
  //#region [DECLARATIONS]
  tableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: true,
    showSearchBtn: true,
    isMultiSelection: true,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      {
        title: "Desc_Customer_Code",
        key: "customerCode",
        isSortable: true,
      },
      {
        title: "Desc_Customer_Name",
        key: "customerName",
        isSortable: true,
      },
      {
        title: "Desc_Customer_Phone",
        key: "phone",
        isSortable: false,
      },
      {
        title: "Desc_Vendor",
        key: "organizationCodeName",
        isSortable: true,
      },
    ],
  };
  modalReference: any;
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: [],
  };

  query: OrderListFilter = {
    customListFilter: {
      searchFilter: "",
      page: 0,
      pageSize: this.coreSession.pageSize,
    },

    customerId: -1,
    territoryId: -1,
    routeId: -1,
    customerStatusId: -1,
    outletId: -1,
    organizationId: -1,
    isVendingMachine: false
  };

  ForceCustomerOrganizationSelection: boolean = false;
  maxCustomerCode: string = '';
  nextMaxCustomerCode: string = '';
  newCustomerCodeSequence: string;
  //#endregion

  //#region [VIEW CHILD]
  @ViewChild("mainFilter") mainFilter: MainFilterComponent;

  //#endregion

  //#region [Life Cycle Hooks]
  constructor(
    private customerService: CustomerService,
    public coreSession: CoreSession,
    private route: ActivatedRoute,
    private router: Router,
    private sessionDataProvider: SessionDataProvider,
    private translateService: TranslateService,
    private sessionData: SessionDataProvider,
    private navService: NavBarService

  ) { }

  showSharedTable: boolean = true;

  ngOnInit() {

    this.navService.endtour.subscribe(() => {
      // Call the onTourEnd() function or perform any action
      this.navService.tourStatus = true;
    });

    this.newCustomerCodeSequence = this.sessionData.getConfigurationValue(ConstantConfigurations.NewCustomerCodeSequence);
    this.populateCustomersList();
    this.coreSession.SetTitle("Customers List");
    this.ForceCustomerOrganizationSelection =
      this.sessionData
        .getConfigurationValue(
          ConstantConfigurations.ForceCustomerOrganizationSelection
        )
        .toLowerCase() === "true";

    this.addDeleteAction();
    this.addEditAction();
    // this.addStockAction();
    this.tableData.showNewBtn = this.coreSession.checkActivitiesAvailability(
      ConstantURLs.customersURL,
      MenuActions.Add
    );
    this.tableData.showImport = this.tableData.showNewBtn;
  }
  fillnewCustomerCodeSequence() {
    this.maxCustomerCode = "";
    this.customerService.getMaxNewCustomerCodeSequence().subscribe(result => {
      this.maxCustomerCode = result.data;
      this.nextMaxCustomerCode = result.data;
      this.customerObj = null;
      this.selectedCustomerId = -1;
      this.isEditMode = false;
      this.showEntrySlider = true;
    });
  }
  addDeleteAction() {
    if (
      this.coreSession.checkActivitiesAvailability(
        ConstantURLs.customersURL,
        MenuActions.Delete
      )
    ) {
      this.tableData.rowOperations.push({
        operation: RowOperation.delete,
        title: "Desc_Delete",
        icon: "fa-solid fa-trash",
        color: "#f1685e",
      });

      // this.tableData.multiSelectionOperations.push(
      //   {
      //     operation: MultiSelectionOperation.generate,
      //     title: "Desc_Calculate",
      //     icon: "fa fa-calculator"
      //   }
      // );
    }
  }
  addEditAction() {
    if (
      this.coreSession.checkActivitiesAvailability(
        ConstantURLs.customersURL,
        MenuActions.Edit
      )
    ) {
      this.tableData.rowOperations.push({
        operation: RowOperation.edit,
        title: "Desc_Edit",
        icon: "fa-regular fa-pen-to-square",
        color: "#12344d",
      });
    }
  }
  addStockAction() {
    this.tableData.rowOperations.push({
      operation: RowOperation.Stock,
      title: 'Desc_Stock',
      icon: 'fa fa-cubes',
      color: '#0f0f0f',
      showWhenKeyValueTrue: true,
      showHideOptionPerLine: true,
      controlKeyName: "showStockBtn"
    });
  }
  //#endregion

  //#region [GET CUSTOMERS]

  populateCustomersList() {
    this.coreSession.ModalLoading.Show();
    this.customerService.getCustomers(this.query).subscribe(
      (response: ResponseModel) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.dataSource = response.data;
        } else {
          this.dataSource = {
            totalItems: 0,
            data: [],
          };
          // this.coreSession.ModalDialog.ShowMessage(response.message, DialogMode.None);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }
  //#endregion

  //#region [SHARED TABLE EVENTS]
  onRowClicked(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        if (
          this.coreSession.checkActivitiesAvailability(
            ConstantURLs.customersURL,
            MenuActions.Delete
          )
        ) {
          this.coreSession.ModalDialog.ShowMessage(
            this.translateService.instant(
              ConstantMessages.MsgDeleteConfirmation
            ),
            DialogMode.YesNo,
            this.translateService.instant(ConstantMessages.WarningCaption)
          ).then((result: DialogResult) => {
            if (result === DialogResult.Yes) {
              this.customerService
                .isValidToDeleteCustomer(event.object.customerId)
                .subscribe(
                  (response: ResponseModel) => {
                    this.coreSession.ModalLoading.Hide();
                    if (response.status != null && response.status >= 0) {
                      this.deleteCustomer(event.object.customerId);
                    } else {
                      this.coreSession.showError(
                        this.translateService.instant(
                          ConstantMessages.ErrorCaption
                        ),
                        response.message
                      );
                    }
                  },
                  (error: HttpErrorResponse) => {
                    this.coreSession.ModalLoading.Hide();
                    this.coreSession.showError(
                      this.translateService.instant(
                        ConstantMessages.ErrorCaption
                      ),
                      this.translateService.instant(
                        ConstantMessages.ErrorHappened
                      )
                    );
                  }
                );
            }
          });
        }
        break;
      case RowOperation.approve:
        break;
      case RowOperation.edit:
        if (
          this.coreSession.checkActivitiesAvailability(
            ConstantURLs.customersURL,
            MenuActions.Edit
          )
        ) {
          this.selectedCustomerId = event.object.customerId;
          this.isEditMode = true;
          this.showEntrySlider = true;
          this.showSharedTable = false
        }
        break;
      case RowOperation.Stock:
        this.selectedCustomerId = event.object.customerId;
        this.customerCodeName = event.object.customerCodeName;
        this.showTransactionSlider = true;
        this.selectInvoiceDialog.showDialog(this.selectedCustomerId).then(
          (result) => {
          });
        break;
    }
  }
  deleteCustomer(customerId: number) {
    this.customerService.deleteCustomer(customerId).subscribe(
      (response: ResponseModel) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(
            this.translateService.instant(ConstantMessages.SuccessCaption),
            response.message
          );
          this.populateCustomersList();
        } else {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            response.message
          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }
  onMultiSelectionOperation(event: any) {
    switch (event.operation) {
      case MultiSelectionOperation.approve:
        break;
      case MultiSelectionOperation.delete:
        break;
      case MultiSelectionOperation.generate:
        this.onCalculateClick(event.object);
        break;
    }
  }
  openFilter() {
    this.mainFilter.Show().then((result) => { });
  }

  onTableFilterChanged(query: any) {
    this.query.customListFilter = query;
    this.populateCustomersList();
  }

  //#endregion
  onFindButtonClicked(result) {
    this.query.customListFilter.page = 0;
    // this.query.customerId = result.customerId;
    this.query.routeId = result.routeId,
      this.query.customerStatusId = result.customerStatusId,
      this.query.territoryId = result.territoryId,
      this.query.organizationId = result.organizationId,
      this.query.isVendingMachine = result.isVendingMachine,
      this.populateCustomersList();
  }
  onNewBtnClicked() {
    if (this.newCustomerCodeSequence != "")
      this.fillnewCustomerCodeSequence();
    else {
      this.customerObj = null;
      this.selectedCustomerId = -1;
      this.isEditMode = false;
      // this.showEntrySlider = true;
    }
    this.showSharedTable = false
    //   this.router.navigate([ConstantURLs.customerAddURL] , {relativeTo: this.route.parent} );
  }
  onCalculateClick(selectedCustomers: any[]) {
    this.coreSession.ModalLoading.Show();
    this.customerService.callCustOutLocationProcedure(selectedCustomers).subscribe((response) => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), response.message);
      } else {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), response.message
        );
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide(); this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  afterImportCustomer() {
    this.populateCustomersList();
  }
  closeCustomerEntrySlider() {
    this.customerObj = null;
    this.selectedCustomerId = -1;
    this.isEditMode = false;
    this.showEntrySlider = false;
    this.coreSession.SetTitle("Customers");
    this.showSharedTable = true

  }
  onSaveCustomerClick() {
    this.saveSubject.next();
  }
  afterSaveCustomer() {
    this.closeCustomerEntrySlider();
    this.populateCustomersList();
    this.showSharedTable = true
  }
  //#region [METHODS]
  find() {
    this.modalReference.close();
  }
  Reset() { }
  //#endregion
}
