import { Component, OnDestroy, OnInit } from '@angular/core';
import { Subject, Subscription } from 'rxjs';
import { ActivatedRoute, Router, NavigationEnd } from '@angular/router';
import { CustomerModel } from '../../../../shared/models/customer/customer.model';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { FormProcessMode } from '../../../../shared/models/enums/form-process-mode.enum';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { NavigationData } from '../../../../shared/models/navigation-data/navigation-data.model';
import { NavBarService } from '../../../../core/sidebar/sidebar.service';
import { ShepherdService } from 'angular-shepherd';
import { TourService } from '../../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../../shared/shepherd-config/trackTour.service';

@Component({
  selector: 'app-customers-main',
  templateUrl: './customers-main.component.html',
  styleUrls: ['./customers-main.component.css']
})
export class CustomersMainComponent implements OnInit, OnDestroy {
  // hideNewButton = false ;
  navLinks: any[];
  hideTabs: boolean = false;
  moduleId: number;
  customerObj: CustomerModel;
  saveSubject: Subject<void> = new Subject<void>();
  indexCounter: number = -1;

  constructor(private route: ActivatedRoute,
    private router: Router,
    private sessionDataProvider: SessionDataProvider,
    private navService: NavBarService,
    private shepherdService: ShepherdService,
    private tourService: TourService,
    private componentVisitService: ComponentVisitService) {
    router.events.subscribe(val => {
      if (val instanceof NavigationEnd) {
        if (val.url.includes(ConstantURLs.customerAddURL)
          || val.url.includes(ConstantURLs.customerEditURL)) {
          this.hideTabs = true;
        } else {
          this.hideTabs = false;
        }
      }
    });
  }
  private tourStartTimeout: any;
  private endTour = false

  startTour(forceTour?: boolean) {
    this.tourStartTimeout = setTimeout((() => {
      if (!this.tourService.isFirstTour()) {
        this.endTour = true;
        this.navService.endtour.next();
      }
      else {
        if (this.tourService.isTourCompletedForComponent('customer-main')) {
          this.endTour = true;

          this.navService.endtour.next();
          return;
        }
        const elementSelectors = this.navLinks.map((_, i) => `#column-${i}`);
        const title = ['Desc_Customer'];
        const text = ['Desc_content_Customers'];

        // Target each column by its unique ID
        const steps = this.tourService.generateSteps(elementSelectors, title, text);
        this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
        this.shepherdService.modal = true;
        this.shepherdService.addSteps(steps);
        this.shepherdService.start();
        this.shepherdService.tourObject.on('complete', () => {
          this.endTour = true;
          this.navService.endtour.next();
        });

        this.shepherdService.tourObject.on('cancel', () => {
          this.endTour = true;
          this.navService.endtour.next();
        });
      }

    }), 1000)
  }
  ngAfterViewInit() {
    this.startTour()
  }

  ngOnInit() {
    this.tourSubscription = this.tourService.startTourMain$.subscribe(() => {
      this.startTour(true)
    });
    this.prepareNavigation();
    var index = this.navLinks.findIndex(x => x.link == this.navService.searchMenuURL);
    if (index == -1) index = 0;
    this.navLinks[index].isActive = true;
    this.setNavigation(this.navLinks[index]);
  }
  prepareNavigation() {
    this.navLinks = [];
    for (let menu of this.sessionDataProvider.allMenusAvailable) {
      if (menu.menuId.includes('100-003-')) {
        this.indexCounter = this.indexCounter + 1
        let newName = {
          label: menu.menuName,
          link: menu.url,
          isActive: false,
          index: this.indexCounter
        };
        this.navLinks.push(newName);
      }
    }
  }

  onSaveCustomer() {
    this.saveSubject.next();

  }
  private tourSubscription: Subscription;

  ngOnDestroy() {

    this.navService.setNavigation([]);

    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.navService.tourStatus = false;
    this.componentVisitService.markComponentVisited('customer-main');
    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }


  }
  onChangeSeletedTab(tab) {
    this.setNavigation(tab);
  }
  setNavigation(tab) {
    if (this.endTour)
      this.navService.endtour.next(true);

    let navigationList: NavigationData[] = [];
    navigationList.push(
      {
        Name: 'Desc_Data_Definition',
        URL: ConstantURLs.dataDefinitionURL
      },
      {
        Name: 'Desc_Customers_Tab_Caption',
        URL: undefined
      },
      {
        Name: tab.label,
        URL: undefined
      }
    );
    this.navService.setNavigation(navigationList);
  }


}
