import { Injectable, Inject } from "@angular/core";
import "rxjs/add/operator/map";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { CoreSession } from "../../../core/core.session";
import { ResponseModel } from "../../../shared/models/api-models/api-models";
import { CustomListFilter } from "../../../shared/models/shared-table/custom-list.interface";
import { MachineListFilter } from "../../../shared/models/customer/machine.filter";

@Injectable({
  providedIn: "root"
})
export class MachineCustomerService {
  private url = "";
  httpOptions;

  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "MachineCustomer";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
        Authorization: "my-auth-token"
      })
    };
  }
  getMachineTypes() {
    const urlValue: string = this.url + "/GetMachineTypes";
    return this.http.get<ResponseModel>(urlValue).map(response => {
      return response.data;
    });
  }
  getMachineBoxTypes() {
    const urlValue: string = this.url + "/GetMachineBoxTypes";
    return this.http.get<ResponseModel>(urlValue).map(response => {
      return response.data;
    });
  }
  saveMachineTemplate(template: any) {
    const urlValue: string = this.url + "/SaveMachineTemplate";
    (urlValue);
    return this.http
      .post(urlValue, JSON.stringify(template), this.httpOptions)
      .map(response => {
        const result = new ResponseModel();
        result.data = response["data"];
        result.message = response["message"];
        result.status = response["status"];
        return result;
      });
  }
  getMachineTemplateList() {
    const urlValue: string = this.url + "/GetMachineTemplateList";
    return this.http.get<ResponseModel>(urlValue + "?").map(response => {
      return response.data;
    });
  }
  deleteVendingMachineTemplate(templateId: number) {
    const urlValue: string = this.url + '/DeleteVendingMachineTemplate';
    return this.http.post(urlValue, templateId, this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  saveMachineBox(box: any) {
    const urlValue: string = this.url + '/SaveMachineBox';
    (urlValue);
    return this.http.post(urlValue, JSON.stringify(box), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  getMachineBoxesList(boxFilterFilter: any) {
    const urlValue: string = this.url + '/GetMachineBoxesList';
    (urlValue);
    return this.http.post(urlValue, JSON.stringify(boxFilterFilter), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  deleteMachineBox(boxId: number) {
    const urlValue: string = this.url + '/DeleteMachineBox';
    return this.http.post(urlValue, boxId, this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  getMachineBoxData(boxId) {
    const urlValue = this.url + '/GetMachineBoxData';
    return this.http
      .get<ResponseModel>(urlValue + '?' + this.coreSession.toQueryString(boxId))
      .map(response => {
        return response;
      });
  }
  getMachineTemplateData(filter) {
    const urlValue = this.url + '/GetMachineTemplateData';
    let template = filter;
    return this.http
      .post<ResponseModel>(urlValue, template)
      .map(response => {
        return response;
      });
  }
  getAllMachineBoxes(machineTypeId: number) {
    const urlValue: string = this.url + "/GetAllMachineBoxes";
    return this.http
      .post<ResponseModel>(urlValue, machineTypeId)
      .map(response => {
        return response.data;
      });
  }

  getAvailableMachineBoxes(filter: CustomListFilter) {
    const urlValue: string = this.url + "/GetAvailableMachineBoxes";
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response;
    });
  }

  getVehicleBoxes(vehicleId: number) {
    const urlValue: string = this.url + "/GetVehicleBoxes";
    return this.http.post<ResponseModel>(urlValue, vehicleId).map(response => {
      return response;
    });
  }

  changeBoxesStatus(object: any) {
    const urlValue: string = this.url + "/ChangeBoxesStatus";
    return this.http.post<ResponseModel>(urlValue, object).map(response => {
      return response;
    });
  }

  getServedMachines(filter: MachineListFilter) {
    const urlValue: string = this.url + "/GetServedMachines";
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response;
    });
  }

  //#region [Coffee capacity template]
  getRawMaterialItems(templateId: number) {
    const urlValue: string = this.url + "/GetRawMaterialItems";
    return this.http
      .post<ResponseModel>(urlValue, templateId)
      .map(response => {
        return response;
      });
  }
  saveCoffeeCapacityTemplate(template: any) {
    const urlValue: string = this.url + '/SaveCoffeeCapacityTemplate';
    (urlValue);
    return this.http.post(urlValue, JSON.stringify(template), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  getCoffeeCapacityTemplateData(templateId: number) {
    const urlValue = this.url + '/GetCoffeeCapacityTemplateData';
    return this.http
      .post<ResponseModel>(urlValue, templateId)
      .map(response => {
        return response;
      });
  }
  deleteCoffeeCapacityTemplate(templateId: number) {
    const urlValue: string = this.url + '/deleteCoffeeCapacityTemplate';
    return this.http.post(urlValue, templateId, this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  getCoffeeCapacityTemplateList() {
    const urlValue: string = this.url + "/GetCoffeeCapacityTemplateList";
    return this.http.get<ResponseModel>(urlValue + "?").map(response => {
      return response.data;
    });
  }
  //#endregio

}
