import { HereMapComponent } from './../../../employee-operation/maps/here-map/here-map.component';
import { OperatorModel } from './../../../../shared/models/operator/operator.model';
import { Component, OnInit, Input, ViewChild, Injectable, Output, EventEmitter, DebugElement, ElementRef, Renderer2, AfterViewInit } from '@angular/core';
import { FormControl, Validators, FormGroup, FormArray } from '@angular/forms';
import { map } from 'rxjs/operators';
import { Observable, Subject, Subscription } from 'rxjs';
import { CustomerTypes } from '../../../../shared/models/enums/customer-types.enum';
import { CustomerModel } from '../../../../shared/models/customer/customer.model';
import { CustomerGroupModel } from '../../../../shared/models/customer/customer.group.model';
import { CustomerOutletModel, CustomerOutletContactModel, CustomerStatusModel } from '../../../../shared/models/customer/outlet.model';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { RowOperation, MultiSelectionOperation } from '../../../../shared/models/enums/shared-table-operation.enum';
import { NgbModal, NgbModalConfig, NgbModalRef } from '@ng-bootstrap/ng-bootstrap';
import { CoreSession } from '../../../../core/core.session';
import { CustomerService } from '../../../../shared/services/data-definition/customer/customers.service';
import { TranslateService } from '@ngx-translate/core';
import { DataActions } from '../../../../shared/models/enums/data-actions.enum';
import { ResponseModel } from '../../../../shared/models/api-models/api-models';
import { DialogMode } from '../../../../shared/models/enums/dialog-mode.enum';
import { HttpErrorResponse, HttpClient } from '@angular/common/http';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { MachineTypes } from '../../../../shared/models/enums/machine-types-enum';
import { DialogResult } from '../../../../shared/models/enums/dialog-result.enum';
import { AccountTypes } from '../../../../shared/models/enums/account-types-enum';
import { ITextInput } from '../../../../shared/models/shared-table/custom-list.interface';
import { TextLanguage } from '../../../../shared/models/general/textLanguage.model';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../../shared/models/constants/constant-configuration';
import { WebApplication } from '../../../../shared/models/enums/web-application.enum';
import { EmailFileModel } from '../../../../shared/models/email/email.model';
import { saveAs } from "file-saver";
import { ImageFileModel } from '../../../../shared/models/image/image-file.model';
import { stringCompare } from 'igniteui-angular-core';
import { SharedDialogComponent } from '../../../../shared/components/shared-dialog/shared-dialog.component';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { SelectTerritoriesComponent } from '../../../../shared/components/select-territories/select-territories.component';
import * as cloneDeep from 'lodash/cloneDeep';
import { RouteModel } from '../../../../shared/models/route/route.model';
import { MenuActions } from '../../../../shared/models/enums/menu-actions-enum';
import { ItemService } from '../../../../shared/services/data-definition/product/item.service';
import { DivisionService } from '../../../../shared/services/data-definition/product/division.service';
import { HereMapService } from '../../../employee-operation/maps/here-maps.service';
import { CustomerTrackingModel } from '../../../../shared/models/tracking/customerTracking.model';
import { OutletMapComponent } from '../outlet-map/outlet-map.component';
import { NewCustomerService } from '../../../customer-operation/new-customer/new-customer.service';
import { IDateTimePickerProperties } from '../../../../shared/models/dateTimeModel/date-time-properties.interface';
import { DateTimeModel } from '../../../../shared/models/dateTimeModel/date-time.model';
import { Router } from "@angular/router";
import { ShepherdService } from 'angular-shepherd';
import { TourService } from '../../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../../shared/shepherd-config/trackTour.service';
import { GoogleMapService } from '../outlet-map/google-map-service/google-map-service';
@Component({
  selector: 'app-outlet-entry',
  templateUrl: './outlet-entry.component.html',
  styleUrls: ['./outlet-entry.component.css']
})
@Injectable()
export class OutletEntryComponent implements OnInit {
  @ViewChild('templateEntry', { static: true }) templateEntry: SharedDialogComponent;
  @ViewChild('mapEntry', { static: true }) mapEntry: SharedDialogComponent;
  @ViewChild("groupAchievmentPromotions", { static: true }) groupAchievmentPromotionsModal: NgbModal;
  imageupload = this.coreSession.baseURL + "assets/img/upload-icon.png";
  @Input()
  public appId: any;

  @Input()
  public appCode: any;

  @Input()
  public lat: any;

  @Input()
  public lng: any;

  @Input()
  public width: any;

  @Input()
  public height: any;

  @Input() isFromNewCustomer: boolean = false;
  @Input() maxOutletCode: string;
  outletForm: FormGroup;
  isViewMode: boolean = false;
  @Input() isEditMode: boolean = false;
  @Input() events: Observable<void>;
  @Output() onSaveCompleted: EventEmitter<void> = new EventEmitter();
  @Input() outletId: number = -1;
  refreshPaymentTermSubject: Subject<void> = new Subject<void>();
  modal: any;
  showTerritoryEntryDialog = false;
  attachedFiles: EmailFileModel[] = [];
  outletNameInput: ITextInput = {
    formControlName: 'outletName',
    placeHolder: 'Desc_Outlet_Name',
    label: 'Desc_Outlet_Name',
    isRequierd: true
  };
  contactNameInput: ITextInput = {
    formControlName: 'contactName',
    placeHolder: 'Desc_Contact_Name',
    label: 'Desc_Contact_Name',
    isRequierd: false
  };
  contactAddressInput: ITextInput = {
    formControlName: 'address',
    placeHolder: 'Desc_Address',
    label: 'Desc_Address',
    isRequierd: false
  };
  selectedStreet = "";
  selectedArea = "";
  selectedCity = "";
  selectedCountry = "";
  selectedState ="";
  oldDescription: any[] = [];
  contactNameOldDescription: any[] = [];
  contactAddressOldDescription: any[] = [];
  contactDescription: any[] = [];
  saveSubject: Subject<void> = new Subject<void>();
  selectedCustomerType: CustomerTypes = CustomerTypes.CashCustomer;
  saveBtnSubscription: any;
  navBarselectedIndex: number = 0;
  @Input() customerObj: CustomerModel = new CustomerModel();
  disablePaymentTerm = true;
  disableBillToBill = true;
  isCashCustomer: boolean = false;
  allGroupsList: CustomerGroupModel[] = [];
  machineTypesList: any[] = [];
  isMachineTypesLoading = false;
  oldMachineTypeId = null;
  customerOutletContactModel: CustomerOutletContactModel;
  contactsDataSourceArray: CustomerOutletContactModel[] = [];
  contactId: number = -1;
  selectedContactIndex: number = -1;
  contactAddBtnDesc: string = '';
  groups: CustomerGroupModel[] = [];
  operatorsList: OperatorModel[] = [];
  customerStatusList: CustomerStatusModel[] = [];
  isOperatorLoading: boolean = false;
  isClassLoading: boolean = false;
  imagesNames: any[] = [];
  imagesPaths: any[] = [];
  //#region [Contract Images and Attachments]
  maxIndex: number = 0;
  formData: FormData = new FormData();
  //#endregion
  dropdownSettings = {
    singleSelection: false,
    idField: 'groupId',
    textField: 'groupCodeName',
    selectAllText: '',
    unSelectAllText: '',
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: '',
    itemsShowLimit: 2
  };

  navLinks: any[];
  shownData: any = {
    MainData: 0,
    Machine: 1,
    PaymentTerms: 2,
    Location: 3,
    OperatorData: 4,
    Attachments: 5,
    ContactData: 6,
    Images: 7
  }
  @Input() outletObj: CustomerOutletModel = new CustomerOutletModel();
  @Input() currentIndexId: number = -1;
  @ViewChild("selectTerritoriesDialog", { static: true }) selectTerritoriesDialog: SelectTerritoriesComponent;
  group_dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  route_dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  territory_dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  contacts_dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  routeTabelProperties: ITableProperties = {
    pageSize: 100,
    showPaginator: true,
    showSearch: true,
    isOnline: true,
    isMultiSelection: true,
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e'
      }
    ],
    multiSelectionOperations: [
      {
        operation: MultiSelectionOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash'
      }
    ],
    columns: [
      {
        title: 'Desc_Route_Code',
        key: 'routeCode',
        isSortable: true,
        width: '40%'
      },
      {
        title: 'Desc_Route_Name',
        key: 'routeName',
        isSortable: true,
        width: '60%'
      }
    ]
  };
  territoryTabelProperties: ITableProperties = {
    pageSize: 100,
    showPaginator: true,
    showSearch: true,
    isOnline: true,
    isMultiSelection: true,
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e'
      }
    ],
    multiSelectionOperations: [
      {
        operation: MultiSelectionOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash'
      }
    ],
    columns: [
      {
        title: 'Desc_Territory_Code',
        key: 'territoryCode',
        isSortable: true,
        width: '40%'
      },
      {
        title: 'Desc_Territory_Name',
        key: 'territoryName',
        isSortable: true,
        width: '60%'
      }
    ]
  };

  territoryTableProperties: ITableProperties = {
    pageSize: 100,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    isMultiSelection: false,
    showNewBtn: true,
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e'
      }
    ],
    multiSelectionOperations: [
      // {
      //   operation: MultiSelectionOperation.delete,
      //   title: 'Desc_Delete',
      //   icon: 'fa-solid fa-trash'
      // }
    ],
    columns: [
      {
        title: 'Desc_Territory',
        key: 'territoryCodeName',
        isSortable: true,
        width: '40%'
      },
      {
        title: 'Desc_Route',
        key: 'routeCodeName',
        isSortable: true,
        width: '60%'
      }
    ]
  };


  contactsTableProperties: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    isMultiSelection: false,
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e'
      }, {
        operation: RowOperation.edit,
        title: "Desc_Edit",
        icon: "fa-regular fa-pen-to-square",
        color: "#12344d"
      }
    ],
    multiSelectionOperations: [],
    columns: [
      {
        title: 'Desc_Contact_Name',
        key: 'contactName',
        isSortable: true,

      },
      // {
      //   title: 'Desc_Address',
      //   key: 'address',
      //   isSortable: true,
      //   width: '14%'
      // },
      // {
      //   title: 'Desc_Mobile',
      //   key: 'mobile',
      //   isSortable: true,
      //   width: '14%'
      // },
      {
        title: 'Desc_Phone',
        key: 'phone',
        isSortable: true,

      },
      // {
      //   title: 'Desc_Fax',
      //   key: 'fax',
      //   isSortable: true,
      //   width: '14%'
      // },
      {
        title: 'Desc_Email',
        key: 'email',
        isSortable: true,

      }
      // ,
      // {
      //   title: 'Desc_Street',
      //   key: 'streetName',
      //   isSortable: true,
      //   width: '10%'
      // }
    ]
  };
  groupAchievementsTableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: false,
    isOnline: false,
    showSearch: true,
    isMultiSelection: true,
    showEditButton: false,
    rowOperations: [],
    multiSelectionOperations: [],
    specificActionWhenCheckAll: true,
    specificActionWhenCheckRow: true,
    columns: [
      { title: 'Desc_Promotion', key: 'promotionName', isSortable: false, width: '100%' },
    ]
  };
  isUsedMachine: boolean = false;
  hasICashBalance: boolean = false;
  ControlTransactionDivisionLevel = false;
  ApplyMachineTypesFlow = false;
  ForceCustomerBarcodeChecking: boolean = false;
  divisionsPaymentTermList: any[] = [];
  selectedPaymentTerm: any;
  selectedDivision: any;
  divisionsPaymentTermForm: FormGroup;
  divisionsPaymentSharedTabelData: ITableProperties = {
    pageSize: 15,
    showPaginator: false,
    showSearch: false,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: false,
    showNewBtn: false,
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e'
      }
    ],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Division', key: 'divisionCodeName', isSortable: true, width: '50%' },
      { title: 'Desc_Payment_Term', key: 'paymentTermDescription', isSortable: false, width: '50%' },
    ]
  };
  divisionsPaymentDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  territoriesDataSourceShared: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  otherAddressLanguages: any[] = [];
  otherAddress2Languages: any[] = [];
  addressInput: ITextInput = {
    formControlName: 'address',
    placeHolder: 'Desc_Address',
    label: 'Desc_Address',
  };
  address2Input: ITextInput = {
    formControlName: 'address2',
    placeHolder: 'Desc_Address2',
    label: 'Desc_Address2',
  };
  showBarcodeTemplateData: boolean = false;

  type1: string = 'password';
  type2: string = 'password';
  eyeIcon: string = 'fa-regular fa-eye eye-icon';
  slashIcon: string = 'fa-regular fa-eye-slash eye-icon';
  AllowCustomerAppLogin = false;
  allowSameOperatorForMultiCustomer = false;
  direction: any;
  addedTerritoriesList: any[] = [];
  copyOfAddedTerr: any[] = [];
  copyOfCustomerAccounts: any[] = [];
  routesList: RouteModel[] = [];
  territoryEntryHidden: boolean = false;
  ForceCustomerOrganizationSelection: boolean = false;
  hasPrivilegeOnOnHoldDivision: boolean = false;
  hasPrivilegeOnPaymentTermDivision: boolean = false;
  CheckPaymentTermOnCustomerLevel: boolean = false;
  allDivisionsList: any[] = [];
  allSalesDistributionChannelsList: any[] = [];
  divisionsDropdownSettings = {
    singleSelection: false,
    idField: "divisionId",
    textField: "divisionCodeName",
    selectAllText: "",
    unSelectAllText: "",
    searchPlaceholderText: "",
    allowSearchFilter: true,
    itemsShowLimit: 2,
  };
  sdcDropdownSettings = { // sales distribution channels
    singleSelection: false,
    idField: "sdcId",
    textField: "sdcCodeName",
    selectAllText: "",
    unSelectAllText: "",
    searchPlaceholderText: "",
    allowSearchFilter: true,
    itemsShowLimit: 2,
  };
  addedGroups: any[] = [];
  deletedGroups: any[] = [];
  originalGroups: any[] = [];
  isThereAnyAchievementPromotions: boolean = false;
  groupsAchievementPromotions: any[] = [];
  achievementPromotionsDS: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  includedGroupAchievementPromotions: any[] = [];
  excludedGroupAchievementPromotions: any[] = [];
  modalRef: NgbModalRef;
  showAddNew = false;
  showAddNewGroup = false;
  checkMandatoryFieldsOnCustomer: boolean = false;
  checkForLanguageDescription: boolean = false;
  selectedCustomerPromortion: boolean = false;
  enableSalesDistributionChannel: boolean = false;
  organizationIds: string = "";
  allowSelectAlternativeWarehouseInFO: boolean = false;
  operatorOrgAccess: string = "";
  usePayerAccount: boolean = false;
  allTerritoriesList: any[] = [];
  NewOutletCodeSequence: string;
  territoriesDropdownSettings = {
    singleSelection: false,
    idField: "territoryId",
    textField: "territoryCodeName",
    selectAllText: "",
    unSelectAllText: "",
    searchPlaceholderText: "",
    allowSearchFilter: true,
    itemsShowLimit: 1,
  };
  tradeLicenceExpiryDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Trade_Licence_Expiry_Date',
    formControlName: 'tradeLicenceExpiryDate',
    isCalendarOnly: true,
    labelHidden: false
  };
  tradeExpiryDate: DateTimeModel = new DateTimeModel();
  constructor(private modalService: NgbModal,
    public coreSession: CoreSession,
    private customerService: CustomerService,
    private translateService: TranslateService,
    private sessionData: SessionDataProvider,
    private http: HttpClient,
    private itemService: ItemService,
    private divisionService: DivisionService,
    private config: NgbModalConfig,
    private newCustomerService: NewCustomerService,
    private router : Router,
    private shepherdService : ShepherdService,
    private tourService: TourService,
     private componentVisitService: ComponentVisitService,
     private googleMapService : GoogleMapService

  ) {
    config.backdrop = true;
  }
  showTableContect = false
  ngAfterViewInit() {
    this.ChangeDataView(0)
    }
    private tourStartTimeout: any;

    startTour(elementSelectors,type,forceTour?:boolean){
      this.tourStartTimeout=  setTimeout((data=>{
          if(!this.tourService.isFirstTour()){
                if(type=='Contact'){
                  this.showTableContect = true
                }
          }
            if(!forceTour)
            if (this.tourService.isTourCompletedForComponent('outlet-entry')) {
              if(type=='Contact'){
                this.showTableContect = true
              }
              return;
            }
            if(this.tourService.isFirstTour()||forceTour){

              const titles = [];
              const texts = [];
              for (let index = 0; index < elementSelectors.length; index++) {
              const { title, text } = this.getTitleAndText(index,type);
              titles.push(title);
              texts.push(text);
            }
            const steps = this.tourService.generateSteps(elementSelectors,titles,texts);
            this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
            this.shepherdService.modal = true;
            this.shepherdService.addSteps(steps);
            this.shepherdService.start();
            this.shepherdService.tourObject.on('complete', () => {
              if(type=='Contact'){
                this.showTableContect = true
              }
          });
          this.shepherdService.tourObject.on('cancel', () => {
            if(type=='Contact'){
              this.showTableContect = true
            }
        });


      }

      }),500)


    }
    getTitleAndText(index: number,type): { title: string, text: string } {
      let title = '';
      let text = '';

      if (type == 'MainData') {
      switch (index) {
    case 0:
        title = "Desc_Outlet";
        text = "Desc_Outlet_Def";
        break;
    case 1:
        title = "Desc_Outlet_Name";
        text = "Desc_Outlet_Name";
        break;
    case 2:
        title = "Desc_Outlet_Code";
        text = "Desc_Outlet_Code";
        break;
    case 3:
        title = "Desc_Customer_Type";
        text = "Desc_Content_Customer_Type";
        break;
    case 4:
        title = "Desc_Customer_Sub_Type";
        text = "Desc_content_Customer_Sub_Type";
        break;
    case 5:
        title = "Desc_Commissioner_Of_Receipt";
        text = "Desc_content_Commissioner";
        break;
    case 6:
        title = "Desc_Tax_Number";
        text = "Desc_content_Tax_Number";
        break;
    case 7:
        title = "Desc_Trade_Licence_No";
        text = "Desc_Trade_Licence_Number";
        break;
    case 8:
        title = "Desc_Trade_Licence_Expiry_Date";
        text = "Desc_content_Trade_Licence_Expire";
        break;
    case 9:
        title = "Desc_Note";
        text = "Desc_content_Note";
        break;
    case 10:
        title = "Desc_Attachments";
        text = "Desc_content_Attach";
        break;
    case 11:
        title = "Desc_Inactive";
        text = "Desc_content_Inactive_Toggle";
        break;
    default:
        title = `Step ${index + 1}`;
        text = `Content in default at bottom.`;
}
return { title, text };

      } else if (type === 'Location') {
        switch (index) {
          case 0:
              title = "Desc_Location";
              text = "Desc_Location_Def";
              break;
          case 1:
              title = "Desc_Map";
              text = "Desc_Content_Map";
              break;
          default:
              title = `Step ${index + 1}`;
              text = `Content in default at bottom.`;
      }
      }
      else if (type == 'OperationData') {
        switch (index) {
          case 0:
              title = "Desc_content_Operation_Data";
              text = "Desc_content_Operation_Data";
              break;
          case 1:
              title = "Desc_Inactive";
              text = "Desc_User_Inactive_Lock_Account";
              break;
          default:
              title = `Step ${index + 1}`;
              text = `Content in default at bottom.`;
      }
      }else if (type === 'Attachment') {
        switch (index) {
          case 0:
            title = "Desc_Attachments";
            text = "Desc_content_Attach";
            break;
          default:
            title = `Step ${index + 1}`;
            text = `Content in defult at bottom.`;
        }
      }else if (type === 'Contact') {
        switch (index) {
          case 0:
            title = "Desc_Contacts";
            text = 'Desc_content_Contact';
            break;
          case 1:
            title = "Desc_Clear";
            text = "Desc_Clear_Button";
            break;
          case 2:
            title = "Desc_Add";
            text = "Desc_Add_Button";
            break;
          default:
            title = `Step ${index + 1}`;
            text = `Content in defult at bottom.`;
        }
      }

      return { title, text };
    }

    private tourSubscription: Subscription;

  ngOnInit() {
    this.tourSubscription = this.tourService.startTourEntryModel$.subscribe(() => {
   var elementSelectors

      var index = this.navLinks.findIndex(a => a.isActive ==true);
      switch(index){
        case 0 :
         elementSelectors = ['#outlet-main','#customer-name',
          '#customer-code','#customer-type','#customer-sub-type',
        '#Commissioner', '#Tax-Number','#Trade-Licence-Number',
        '#Trade-Licence-Expire','#Note','#attach' ,'#Inactive'
        ] // Target each column by its unique ID
        this.startTour(elementSelectors,'MainData',true)
        break
        case 3 :
          elementSelectors = ['#Location-def','#map'] // Target each column by its unique ID
          this.startTour(elementSelectors,'Location',true)
          break
  case 4 :
    elementSelectors = ['#Operation-data','#Inactive-operation'] // Target each column by its unique ID
    this.startTour(elementSelectors,'OperationData',true)
    break
  case 5 :
    elementSelectors = ['#attach-data'] // Target each column by its unique ID
    this.startTour(elementSelectors,'Attachment',true)
    break
  case 6:
    elementSelectors = ['#Contact-def','#clear','#add-contact'] // Target each column by its unique ID
    this.startTour(elementSelectors,'Contact',true)
    break
      }

    });
    this.operatorOrgAccess = this.coreSession.CurrentOperator.organizationAccess && this.coreSession.CurrentOperator.organizationAccess.trim() !== ""
      ? this.coreSession.CurrentOperator.organizationAccess : "-1";
    this.fillCustomerOrganizationIds();

    this.showAddNew = this.coreSession.checkActivitiesAvailability(ConstantURLs.customersURL, MenuActions.Add);
    this.showAddNewGroup = this.coreSession.checkActivitiesAvailability(ConstantURLs.customersHierarchyURL, MenuActions.Add);

    this.ApplyMachineTypesFlow = this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyMachineTypesFlow).toLowerCase() === "true";
    this.ControlTransactionDivisionLevel = this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true"
    this.CheckPaymentTermOnCustomerLevel = this.sessionData.getConfigurationValue(ConstantConfigurations.CheckPaymentTermOnCustomerLevel).toLowerCase() === "true"
    this.ForceCustomerBarcodeChecking = this.sessionData.getConfigurationValue(ConstantConfigurations.forceCustomerBarcodeChecking).toLowerCase() === "true";

    this.checkMandatoryFieldsOnCustomer = this.sessionData.getConfigurationValue(ConstantConfigurations.CheckMandatoryFieldsOnCustomer).toLowerCase() === 'true';

    this.checkForLanguageDescription = this.sessionData.getConfigurationValue(ConstantConfigurations.CheckForLanguageDescription).toLowerCase() === 'true';
    this.NewOutletCodeSequence = this.sessionData.getConfigurationValue(ConstantConfigurations.NewOutletCodeSequence);
    if (this.ControlTransactionDivisionLevel && this.coreSession.checkActivitiesAvailability(ConstantURLs.customersURL, MenuActions.DivisionsPaymentTerm)) {
      this.hasPrivilegeOnPaymentTermDivision = true;
    }
    if (this.ControlTransactionDivisionLevel && this.coreSession.checkActivitiesAvailability(ConstantURLs.customersURL, MenuActions.DivisionsOnHoldStatus)) {
      this.hasPrivilegeOnOnHoldDivision = true;
    }
    this.divisionsDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.divisionsDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.divisionsDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
    this.sdcDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.sdcDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.sdcDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
    this.territoriesDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.territoriesDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.territoriesDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
    this.ForceCustomerOrganizationSelection = this.sessionData.getConfigurationValue(ConstantConfigurations.ForceCustomerOrganizationSelection).toLowerCase() === "true";
    if (this.ForceCustomerOrganizationSelection) {
      var activeAccountsList = this.customerObj.accountsList.filter(acc => acc.dataAction != 4)
      if (activeAccountsList.length <= 0) {
        // Territory-select is Hidden
        this.territoryEntryHidden = true;
      } else {
        //Territory-select is not Hidden
        this.territoryEntryHidden = false;
      }
    }
    else {
      // Territory-select is not Hidden
      this.territoryEntryHidden = false;
    }

    this.contactAddBtnDesc = 'Desc_Add';
    this.AllowCustomerAppLogin = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowCustomerAppLogin).toLowerCase() === "true"
    this.allowSameOperatorForMultiCustomer = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowSameOperatorForMultiCustomer).toLowerCase() === "true"
    this.prepareNavigation();
    this.subscribeSaveClick();
    this.showBarcodeTemplateData = (this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyGS1TrackAndTraceTemplate).toLowerCase() === "true");
    this.enableSalesDistributionChannel = this.sessionData.getConfigurationValue(ConstantConfigurations.EnableSalesDistributionChannel).toLowerCase() === "true";
    this.allowSelectAlternativeWarehouseInFO = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowSelectAlternativeWarehouseInFO).toLowerCase() === "true";
    this.usePayerAccount = this.sessionData.getConfigurationValue(ConstantConfigurations.UsePayerAccount).toLowerCase() === "true";
    this.navLinks[0].isActive = true;
    this.fillMachineTypesList();
    this.fillDivisionsList();
    this.populateGroupsList();
    this.populateSalesDistributionChannels();
    this.populateTerritoriesList();
    this.populateCustomerStatusList();
    this.InitOutletForm();
    if (this.NewOutletCodeSequence != "" && !this.isEditMode) {
      this.outletForm.get('headerData').get('outletCode').setValue(this.maxOutletCode);
    }
    if (this.allowSameOperatorForMultiCustomer) {
      this.fillCustomerOperatorsList();
    }
    this.initDivisionPayTermForm();

    if (this.outletObj) {
      if (this.isEditMode) {
        if (this.outletObj.outletAttachments && this.outletObj.outletAttachments.length > 0) {
          this.attachedFiles = [];
          for (let outletFile of this.outletObj.outletAttachments) {
            var currentPath = document.getElementsByTagName("base")[0].href + this.customerObj.customerAttachmentsBasePath + "/" + this.outletId + "/" + outletFile;
            let file = new EmailFileModel();
            let name = currentPath.substr(currentPath.lastIndexOf('/') + 1);
            file.name = name;
            let dotes = name && (name.length > 20) ? '..' : '';
            file.shortName = name.substring(0, 20) + dotes;
            let imgExtensions = ['png', 'jpg', 'jpeg', 'gif']
            file.isImage = imgExtensions.includes(name.split('.').pop()) ? true : false;
            file.path = file.isImage ? currentPath : this.coreSession.getDefaultPathAttachments();
            file.pathFile = file.name;
            this.getFile(currentPath).subscribe(response => {
              file.file = response
              this.attachedFiles.push(file);
            });
          }
        }

        if (this.outletObj.routesList && this.outletObj.routesList.length > 0) {
          var outletObjRoutesList = cloneDeep(this.outletObj.routesList);
          this.territoriesDataSourceShared = {
            totalItems: outletObjRoutesList.length,
            data: outletObjRoutesList
          };
        }
      }


      if (this.hasPrivilegeOnPaymentTermDivision) {
        this.divisionsPaymentTermList = this.outletObj.outletDivisionPaymentTermList;
        this.fillDivisionsPaymentTermList();
      }
      this.oldMachineTypeId = this.outletObj.machineTypeId === -1 ? null : this.outletObj.machineTypeId;
      if (this.outletObj.customerTypeId == CustomerTypes.CreditCustomer.valueOf()) {
        this.disablePaymentTerm = false;
        this.isCashCustomer = false;
        this.enableDisablePaymentTermsTab();
      }
      if (this.outletObj.customerTypeId == CustomerTypes.BillToBillCustomer.valueOf()) {
        this.disableBillToBill = false;
        this.disablePaymentTerm = false;
        this.isCashCustomer = false;
        this.enableDisablePaymentTermsTab();
      }
      if (this.outletObj.customerTypeId == CustomerTypes.CashCustomer.valueOf()) {
        this.isCashCustomer = true;
      }
      // this code is delete after merge attachment task
      // if (this.outletObj.attachedFiles && this.outletObj.attachedFiles.length >0)
      //   this.attachedFiles = this.outletObj.attachedFiles ;

      this.FillUIFromOutletObj();
      this.oldDescription = this.outletObj.descriptionLanguages;
      if (this.outletObj && this.outletObj.customerOutletContacts && this.outletObj.customerOutletContacts.length > 0) {
        this.contacts_dataSource = {
          data: this.outletObj.customerOutletContacts,
          totalItems: this.outletObj.customerOutletContacts.length
        }
      }
    }
    else {

      this.outletObj = new CustomerOutletModel();
      this.outletObj.dataAction = DataActions.Add;
      this.outletObj.isValidDelete = true
      this.outletObj.customerIdSignature = this.customerObj.customerIdSignature;
      this.outletObj.customerId = this.customerObj.customerId;
      this.oldDescription = null;
      this.tradeLicenceExpiryDateProperties.min = new Date();
    }
    this.dropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.dropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    if (this.isEditMode) {
      this.getOuletImages()
      this.modal = document.getElementById("myModal");
    }
    this.direction = this.coreSession.isRTL;
  }

  fillCustomerOrganizationIds() {
    let organizationIdsList = [...new Set(this.customerObj.accountsList.filter(acc => acc.dataAction !== DataActions.Delete.valueOf()).map(acc => acc.organizationId))];
    this.organizationIds = organizationIdsList ? organizationIdsList.join(',') : "";
  }

  fillDivisionsList() {
    this.allDivisionsList = [];
    this.divisionService.getAllDivisions(-1).subscribe(result => {
      this.allDivisionsList = result.data;
    });
  }
  fillMachineTypesList() {
    this.machineTypesList = [];
    this.isMachineTypesLoading = true;

  }
  InitOutletForm() {
    this.outletForm = new FormGroup({
      'headerData': new FormGroup({
        customerName: new FormControl({ value: this.customerObj.customerName, disabled: true }, Validators.required),
        customerCode: new FormControl({ value: this.customerObj.customerCode, disabled: true }, Validators.required),
        outletName: new FormControl({ value: '', disabled: this.isViewMode }, Validators.required),
        outletCode: new FormControl({ value: '', disabled: this.isViewMode || (this.NewOutletCodeSequence != "") }, Validators.required),
        barcode: new FormControl({ value: '', disabled: this.isViewMode },),
        customerPhone: new FormControl({ value: '', disabled: this.isViewMode }),
        customerFax: new FormControl({ value: '', disabled: this.isViewMode }),
        email: new FormControl({ value: '', disabled: this.isViewMode }, [Validators.email, Validators.pattern('^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$')]),
        customerTypeId: new FormControl({ value: null, disabled: this.isViewMode },),
        customerStatusId: new FormControl({ value: null, disabled: this.isViewMode }),
        paymentTermId: new FormControl({ value: null, disabled: this.isViewMode || this.disablePaymentTerm }, (this.disablePaymentTerm || this.CheckPaymentTermOnCustomerLevel ? Validators.nullValidator : Validators.required)),
        billsNumber: new FormControl({ value: '', disabled: this.isViewMode || this.disableBillToBill }, (this.disableBillToBill ? Validators.nullValidator : Validators.required)),
        customerClassId: new FormControl({ value: null, disabled: this.isViewMode },Validators.required), customerSubClassId: new FormControl({ value: null, disabled: this.isViewMode }),
        taxNumber: new FormControl({ value: '', disabled: this.isViewMode }),
        vendorNumber: new FormControl({ value: '', disabled: this.isViewMode }),
        commissionerOfReceipt: new FormControl({ value: '', disabled: this.isViewMode }),
        notes: new FormControl({ value: '', disabled: this.isViewMode }),
        nonTaxable: new FormControl({ value: '', disabled: this.isViewMode }),
        onHold: new FormControl({ value: '', disabled: this.isViewMode }),
        inactive: new FormControl({ value: '', disabled: this.isViewMode }),
        VIP: new FormControl({ value: '', disabled: this.isViewMode }),
        isBusinessCustomer: new FormControl({ value: '', disabled: this.isViewMode }),
        isVendingMachine: new FormControl({ value: '', disabled: this.isViewMode }),
        gln: new FormControl({ value: '', disabled: this.isViewMode }),
        tradeLicenceName: new FormControl({ value: '', disabled: this.isViewMode }),
        tradeLicenceNumber: new FormControl({ value: '', disabled: this.isViewMode }),
        tradeLicenceExpiryDate: new FormControl({ value: '', disabled: this.isViewMode }),
        groupsControl: new FormControl([]),
        machineTypeId: new FormControl(null),
        iCashBalance: new FormControl({ value: '', disabled: true }),
        descriptionLanguages: new FormControl([]),
        customerOutletContacts: new FormControl([]),
        onHoldDivisionsList: new FormControl([]),
        salesDistributionChannelList: new FormControl([]),
        buildingNumber: new FormControl({ value: null, disabled: this.isViewMode }),
        warehouseId: new FormControl({ value: null, disabled: this.isViewMode }),
        territoriesControl: new FormControl([]),
        companyPrefix: new FormControl(),
      }),
      // machineDetailsForm: new FormGroup({
      //   machineId: new FormControl(-1, Validators.required),
      //   customerId: new FormControl(-1, Validators.required),
      //   outletId: new FormControl(-1, Validators.required),
      //   machineTypeId: new FormControl('', Validators.required),
      //   serialNumber: new FormControl('', Validators.required),
      //   tokenNumber: new FormControl('', Validators.required),
      //   imei: new FormControl('', Validators.required),
      //   model: new FormControl(''),
      //   machineTemplateId: new FormControl(''),
      //   capacityTemplateId: new FormControl(''),
      //   machineBoxes: new FormControl([]),
      // }),
      locationData: new FormGroup({
        zipCode: new FormControl({ value: '', disabled: this.isViewMode }),
        address: new FormControl({ value: '', disabled: this.isViewMode }),
        address2: new FormControl({ value: '', disabled: this.isViewMode }),
        gpsLatitude: new FormControl({ value: '', disabled: this.isViewMode }),
        gpsLongitude: new FormControl({ value: '', disabled: this.isViewMode }),
        country: new FormControl({ value: '', disabled: this.isViewMode }),
        state: new FormControl({ value: '', disabled: this.isViewMode }),
        city: new FormControl({ value: '', disabled: this.isViewMode }),
        area: new FormControl({ value: '', disabled: this.isViewMode }),
        street: new FormControl({ value: '', disabled: this.isViewMode }),
        landmark: new FormControl({ value: '', disabled: this.isViewMode })
      }),
      operatorData: new FormGroup({
        operatorName: new FormControl(null),
        operatorPassword: new FormControl(null),
        confirmPassword: new FormControl(null),
        isLockedOperator: new FormControl(false),
        operatorId: new FormControl(null),
        tempOperatorId: new FormControl(-1),
        predefinedOperator: new FormControl(false)
      }),
      contactData: new FormGroup({
        contactId: new FormControl(null),
        contactName: new FormControl(''),
        mobile: new FormControl(null),
        phone: new FormControl(null),
        fax: new FormControl(null),
        street: new FormControl(null),
        streetName: new FormControl(null),
        address: new FormControl(null),
        address2: new FormControl(null),
        email: new FormControl('', [Validators.email, Validators.pattern('^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$')]),
        contactDescriptionLanguages: new FormControl([]),
        addressDescriptionLanguages: new FormControl([]),
        address2DescriptionLanguages: new FormControl([]),
        languageId: new FormControl(null)
      }),
    });
  }
  FillUIFromOutletObj() {
    // this.isUsedMachine = this.outletObj.machineData.isUsedMachine;
    this.hasICashBalance = this.outletObj.hasICashBalance;
    this.otherAddressLanguages = this.outletObj.addressLanguages;
    this.otherAddress2Languages = this.outletObj.address2Languages;
    this.tradeExpiryDate = this.outletObj.tradeLicenceExpiryDate;
    this.outletForm = new FormGroup({
      headerData: new FormGroup({
        customerName: new FormControl({ value: this.customerObj.customerName, disabled: true }, Validators.required),
        customerCode: new FormControl({ value: this.customerObj.customerCode, disabled: true }, Validators.required),
        outletName: new FormControl({ value: this.outletObj.outletName, disabled: this.isViewMode }, Validators.required),
        outletCode: new FormControl({ value: this.outletObj.outletCode, disabled: this.isViewMode || (this.NewOutletCodeSequence != "") }, Validators.required),
        barcode: new FormControl({ value: this.outletObj.barcode, disabled: this.isViewMode }),
        customerPhone: new FormControl({ value: this.outletObj.phone, disabled: this.isViewMode }),
        customerFax: new FormControl({ value: this.outletObj.fax, disabled: this.isViewMode }),
        email: new FormControl({ value: this.outletObj.email, disabled: this.isViewMode }, [Validators.email, Validators.pattern('^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$')]),
        customerTypeId: new FormControl({ value: this.outletObj.customerTypeId, disabled: this.isViewMode }, Validators.required),
        customerStatusId: new FormControl({ value: (this.outletObj.customerStatusId > 0 ? this.outletObj.customerStatusId : null), disabled: this.isViewMode }),
        paymentTermId: new FormControl({ value: this.outletObj.paymentTermId > 0 ? this.outletObj.paymentTermId : null, disabled: this.isViewMode || this.disablePaymentTerm }, (this.disablePaymentTerm || this.CheckPaymentTermOnCustomerLevel ? Validators.nullValidator : Validators.required)),
        billsNumber: new FormControl({ value: (this.outletObj.billsNumber > 0 ? this.outletObj.billsNumber : null), disabled: this.isViewMode || this.disableBillToBill }, (this.disableBillToBill ? Validators.nullValidator : Validators.required)),
        customerClassId: new FormControl({ value: (this.outletObj.customerClassId > 0 ? this.outletObj.customerClassId : null), disabled: this.isViewMode }),
        customerSubClassId: new FormControl({ value: (this.outletObj.customerSubClassId > 0 ? this.outletObj.customerSubClassId : null), disabled: this.isViewMode }),
        taxNumber: new FormControl({ value: this.outletObj.taxNumber || this.outletObj.taxNumber == '' ? this.outletObj.taxNumber : null, disabled: this.isViewMode }),
        vendorNumber: new FormControl({ value: this.outletObj.vendorNumber || this.outletObj.vendorNumber == '' ? this.outletObj.vendorNumber : null, disabled: this.isViewMode }),
        commissionerOfReceipt: new FormControl({ value: this.outletObj.commissionerOfReceipt, disabled: this.isViewMode }),
        notes: new FormControl({ value: this.outletObj.notes, disabled: this.isViewMode }),
        nonTaxable: new FormControl({ value: !this.outletObj.taxable, disabled: this.isViewMode }),
        onHold: new FormControl({ value: this.outletObj.onHold, disabled: this.isViewMode }),
        inactive: new FormControl({ value: this.outletObj.inactive, disabled: this.isViewMode }),
        VIP: new FormControl({ value: this.outletObj.isHighlighted, disabled: this.isViewMode }),
        isBusinessCustomer: new FormControl({ value: this.outletObj.isBusinessCustomer, disabled: this.isViewMode }),
        isVendingMachine: new FormControl({ value: this.outletObj.isVendingMachine, disabled: this.isViewMode }),
        gln: new FormControl({ value: this.outletObj.gln, disabled: this.isViewMode }),
        tradeLicenceName: new FormControl({ value: this.outletObj.tradeLicenceName ? this.outletObj.tradeLicenceName : null, disabled: this.isViewMode }),
        tradeLicenceNumber: new FormControl({ value: this.outletObj.tradeLicenceNumber ? this.outletObj.tradeLicenceNumber : null, disabled: this.isViewMode }),
        tradeLicenceExpiryDate: new FormControl({ value: this.tradeExpiryDate ? this.tradeExpiryDate : null, disabled: this.isViewMode }),
        groupsControl: new FormControl({ value: this.outletObj.groups == null ? [] : this.outletObj.groups, disabled: this.isViewMode }),
        machineTypeId: new FormControl({ value: (this.outletObj.machineTypeId === -1 ? null : this.outletObj.machineTypeId), disabled: this.isUsedMachine }),
        iCashBalance: new FormControl({ value: this.outletObj.iCashBalance, disabled: true }),
        descriptionLanguages: new FormControl(this.outletObj.descriptionLanguages),
        customerOutletContact: new FormControl(this.outletObj.customerOutletContacts),
        onHoldDivisionsList: new FormControl(this.outletObj.onHoldDivisionsList),
        salesDistributionChannelList: new FormControl(this.outletObj.salesDistributionChannels ? this.outletObj.salesDistributionChannels : []),
        buildingNumber: new FormControl({ value: this.outletObj.buildingNumber ? this.outletObj.buildingNumber : null, disabled: this.isViewMode }),
        warehouseId: new FormControl({ value: this.outletObj.warehouseId && this.outletObj.warehouseId > 0 ? this.outletObj.warehouseId : null, disabled: this.isViewMode }),
        territoriesControl: new FormControl({ value: this.outletObj.territories == null ? [] : this.outletObj.territories, disabled: this.isViewMode }),
        companyPrefix: new FormControl({ value: this.outletObj.companyPrefix >= 0 ? this.outletObj.companyPrefix : null, disabled: this.isViewMode })
      }),

      locationData: new FormGroup({
        zipCode: new FormControl(
           this.outletObj.zipCode
        ),
        address: new FormControl(
       this.outletObj.address
        ),
        address2: new FormControl(
          this.outletObj.address2
        ),
        gpsLatitude: new FormControl(
          this.outletObj.gpsLatitude
        ),
        gpsLongitude: new FormControl(
          this.outletObj.gpsLongitude
        ),
        country: new FormControl(
         this.outletObj.countryId === "" ? null : this.outletObj.countryId,
        ),
        state: new FormControl(
       this.outletObj.stateId === "" ? null : this.outletObj.stateId
        ),
        city: new FormControl(
       this.outletObj.cityId === "" ? null : this.outletObj.cityId
        ),
        area: new FormControl(
          this.outletObj.areaId === "" ? null : this.outletObj.areaId
        ),
        street: new FormControl(
         this.outletObj.streetId === "" ? null : this.outletObj.streetId
        ),
        landmark: new FormControl(
        this.outletObj.landmark
        ),
      }),
      operatorData: new FormGroup({
        operatorName: new FormControl(this.outletObj.operatorName == '' ? null : this.outletObj.operatorName),
        operatorPassword: new FormControl(this.outletObj.operatorPassword == '' ? null : this.outletObj.operatorPassword),
        confirmPassword: new FormControl(this.outletObj.operatorPassword == '' ? null : this.outletObj.operatorPassword),
        isLockedOperator: new FormControl(this.outletObj.isLockedOperator),
        operatorId: new FormControl(this.outletObj.operatorId == -1 ? -1 : this.outletObj.operatorId),
        tempOperatorId: new FormControl(this.outletObj.tempOperatorId == -1 ? -1 : this.outletObj.tempOperatorId),
        predefinedOperator: new FormControl(this.outletObj.matchWithExistsOperator)
      }),

      contactData: new FormGroup({
        contactId: new FormControl({ value: '', disabled: this.isViewMode }),
        contactName: new FormControl({ value: '', disabled: this.isViewMode }),
        mobile: new FormControl({ value: '', disabled: this.isViewMode }),
        phone: new FormControl({ value: '', disabled: this.isViewMode }),
        fax: new FormControl({ value: '', disabled: this.isViewMode }),
        street: new FormControl({ value: '', disabled: this.isViewMode }),
        streetName: new FormControl({ value: '', disabled: this.isViewMode }),
        address: new FormControl({ value: '', disabled: this.isViewMode }),
        address2: new FormControl({ value: '', disabled: this.isViewMode }),
        email: new FormControl({ value: '', disabled: this.isViewMode }, [Validators.email, Validators.pattern('^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$')]),
        contactDescriptionLanguages: new FormControl({ value: [], disabled: this.isViewMode }),
        addressDescriptionLanguages: new FormControl({ value: [], disabled: this.isViewMode }),
        address2DescriptionLanguages: new FormControl({ value: [], disabled: this.isViewMode }),
        languageId: new FormControl({ value: '', disabled: this.isViewMode })
      }),
    });
      this.selectedArea = this.outletObj.areaId;
     this.selectedCity = this.outletObj.cityId;
     this.selectedState = this.outletObj.stateId ;
     this.selectedCountry = this.outletObj.countryId ;
     this.selectedStreet= this.outletObj.streetId;



    this.outletObj.customerOutletContacts= this.outletObj.customerOutletContacts.length> 0? this.outletObj.customerOutletContacts:  this.contactsDataSourceArray ;

    if (this.outletObj.routesList) {
      var outletObjRoutesList = cloneDeep(this.outletObj.routesList);
      this.territoriesDataSourceShared = {
        totalItems: outletObjRoutesList.length,
        data: outletObjRoutesList
      };
    }
    if (this.CheckPaymentTermOnCustomerLevel)
      this.outletObj.paymentTermId = -1

    this.addedTerritoriesList = this.territoriesDataSourceShared.data;
    this.originalGroups = cloneDeep(this.outletObj.groups);
    this.updateNavigation();

  }
  ChangeDataView(index: number) {
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.showTableContect = false

    this.navLinks.forEach(a => a.isActive = false);
    this.navBarselectedIndex = index;
    this.navLinks[index].isActive = true;
    var elementSelectors

    switch(index){
      case 0 :
 elementSelectors = ['#outlet-main','#customer-name',
        '#customer-code','#customer-type','#customer-sub-type',
      '#Commissioner', '#Tax-Number','#Trade-Licence-Number',
      '#Trade-Licence-Expire','#Note','#attach' ,'#Inactive'
      ] // Target each column by its unique ID
        this.startTour(elementSelectors,'MainData')
      break
      case 3 :
        elementSelectors = ['#Location-def','#map'] // Target each column by its unique ID
     this.startTour(elementSelectors,'Location')
break
case 4 :
  elementSelectors = ['#Operation-data','#Inactive-operation'] // Target each column by its unique ID
  this.startTour(elementSelectors,'OperationData')
break
case 5 :
  elementSelectors = ['#attach-data'] // Target each column by its unique ID
  this.startTour(elementSelectors,'Attachment')
break
case 6:
  elementSelectors = ['#Contact-def','#clear','#add-contact'] // Target each column by its unique ID
  this.startTour(elementSelectors,'Contact')

break
    }
  }

  getOuletImages() {

    let customerOutletId = this.customerObj.customerId + '_' + this.outletObj.outletId;
    this.customerService.GetOutletImages(customerOutletId).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.imagesNames = response.data;
          this.imagesPaths = Array.from(this.imagesNames)
          if (this.imagesPaths && this.imagesPaths.length > 0) {
            this.imagesPaths.forEach((path, index) => {
              var currentPath = document.getElementsByTagName("base")[0].href + path;
              this.imagesPaths[index] = currentPath;
            });
          }
          this.addImagesTab();
        }
      });

  }


  addImagesTab() {
    if (this.isEditMode) {
      this.navLinks.push({
        label: 'Desc_Images',
        index: this.shownData.Images,
        isActive: false,
        hidden: false,
        disable: false
      });
    }

  }


  onOtherAddressLanguagesTextSubmitted(event) {
    this.otherAddressLanguages = event;
  }
  onOtherAddress2LanguagesTextSubmitted(event) {
    this.otherAddress2Languages = event;
  }
  FillOutletObjData() {
    this.outletObj.territoryRouteList = this.territoriesDataSourceShared.data;

    this.routesList = [];
    this.routesList = this.territoriesDataSourceShared.data;

    if (!this.outletObj) this.outletObj = new CustomerOutletModel();
    let descriptions = [];

    if (this.outletForm.get('headerData').get('descriptionLanguages').value != null) {
      descriptions = this.outletForm.get('headerData').get('descriptionLanguages').value;
      let index = descriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId)
      if (index == -1) {
        descriptions.push({
          languageId: this.coreSession.selectedLanguageId,
          description: this.outletForm.get('headerData').get('outletName').value
        });
      } else {
        descriptions[index].description = this.outletForm.get('headerData').get('outletName').value;
      }
    }

    let addressDescriptions = [];
    if (this.otherAddressLanguages) {
      addressDescriptions = this.otherAddressLanguages;
    }
    let addressIndex = addressDescriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId)
    if (addressIndex === -1) {
      addressDescriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.outletForm.get('locationData').get('address').value
      });
    } else {
      addressDescriptions[addressIndex].description = this.outletForm.get('locationData').get('address').value;
    }

    let address2Descriptions = [];
    if (this.otherAddress2Languages) {
      address2Descriptions = this.otherAddress2Languages;
    }
    let address2Index = address2Descriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId)
    if (address2Index === -1) {
      address2Descriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.outletForm.get('locationData').get('address2').value
      });
    } else {
      address2Descriptions[address2Index].description = this.outletForm.get('locationData').get('address2').value;
    }
    this.outletObj.outletName = this.outletForm.value.headerData.outletName.trim();
    this.outletObj.outletCode = this.outletForm.get('headerData').get('outletCode').value;
    this.outletObj.outletCodeName = this.outletObj.outletCode + ' ' + '--' + ' ' + this.outletObj.outletName;
    this.outletObj.phone = this.outletForm.value.headerData.customerPhone;
    this.outletObj.email = this.outletForm.value.headerData.email;
    this.outletObj.streetId = this.outletForm.value.locationData.street;
    if (!this.outletObj.streetId) this.outletObj.streetId = "";
    this.outletObj.gln = this.outletForm.value.headerData.gln;
    this.outletObj.address = this.outletForm.value.locationData.address;
    this.outletObj.address2 = this.outletForm.value.locationData.address2;
    this.outletObj.zipCode = this.outletForm.value.locationData.zipCode;
    this.outletObj.landmark = this.outletForm.value.locationData.landmark;
    this.outletObj.currencyId = this.customerObj.currencyId;
    this.outletObj.fax = this.outletForm.value.headerData.customerFax;
    this.outletObj.descriptionLanguages = descriptions;
    this.outletObj.addressLanguages = addressDescriptions;
    this.outletObj.address2Languages = address2Descriptions;
    this.outletObj.areaId = this.selectedArea;
    this.outletObj.cityId = this.selectedCity;
    this.outletObj.stateId = this.selectedState;
    this.outletObj.countryId = this.selectedCountry;
    this.outletObj.streetId = this.selectedStreet;
    this.outletObj.gpsLatitude = this.outletForm.value.locationData.gpsLatitude ? this.outletForm.value.locationData.gpsLatitude : 0;
    this.outletObj.gpsLongitude = this.outletForm.value.locationData.gpsLongitude ? this.outletForm.value.locationData.gpsLongitude : 0;
    if (this.contactsDataSourceArray && this.contactsDataSourceArray.length > 0) {
      this.outletObj.customerOutletContacts = this.contactsDataSourceArray;
    }
    if (this.outletForm.value.headerData.inactive == '') this.outletObj.inactive = false;
    else
      this.outletObj.inactive = this.outletForm.value.headerData.inactive;

    if (this.outletForm.value.headerData.onHold == '') this.outletObj.onHold = false;
    else
      this.outletObj.onHold = this.outletForm.value.headerData.onHold;

    if (this.outletForm.value.headerData.nonTaxable == '') this.outletObj.taxable = true;
    else
      this.outletObj.taxable = !this.outletForm.value.headerData.nonTaxable;

    if (this.outletForm.value.headerData.VIP == '') this.outletObj.isHighlighted = false;
    else
      this.outletObj.isHighlighted = this.outletForm.value.headerData.VIP;
    if (this.outletForm.value.headerData.isBusinessCustomer == '') this.outletObj.isBusinessCustomer = false;
    else
      this.outletObj.isBusinessCustomer = this.outletForm.value.headerData.isBusinessCustomer;
    if (this.outletForm.value.headerData.isVendingMachine == '') this.outletObj.isVendingMachine = false;
    else
      this.outletObj.isVendingMachine = this.outletForm.value.headerData.isVendingMachine;
    this.outletObj.taxNumber = this.outletForm.value.headerData.taxNumber;
    this.outletObj.tradeLicenceNumber = this.outletForm.value.headerData.tradeLicenceNumber;
    this.outletObj.tradeLicenceName = this.outletForm.value.headerData.tradeLicenceName;
    if (this.outletForm.value.headerData.tradeLicenceExpiryDate) {
      this.outletObj.tradeLicenceExpiryDateModel = this.coreSession.getDateTimeModel(
        new Date(this.outletForm.value.headerData.tradeLicenceExpiryDate)
      );
      this.outletObj.tradeLicenceExpiryDate = this.outletForm.value.headerData.tradeLicenceExpiryDate;
    }
    this.outletObj.vendorNumber = this.outletForm.value.headerData.vendorNumber;
    this.outletObj.barcode = (this.outletForm.value.headerData.barcode && this.outletForm.value.headerData.barcode !== '') ? this.outletForm.value.headerData.barcode.trim() : this.outletForm.value.headerData.barcode;
    this.outletObj.customerTypeId = this.outletForm.value.headerData.customerTypeId;
    if (!this.outletObj.customerTypeId) this.outletObj.customerTypeId = 1;
    this.outletObj.customerStatusId = this.outletForm.value.headerData.customerStatusId;
    if (!this.outletObj.customerStatusId) this.outletObj.customerStatusId = -1;
    if (!this.CheckPaymentTermOnCustomerLevel) {
      this.outletObj.paymentTermId = this.outletForm.value.headerData.paymentTermId;
    } else {
      this.outletObj.paymentTermId = -1
    }
    if (!this.outletObj.paymentTermId) this.outletObj.paymentTermId = -1;
    this.outletObj.billsNumber = this.outletForm.value.headerData.billsNumber;
    if (!this.outletObj.billsNumber) this.outletObj.billsNumber = 0;
    this.outletObj.customerClassId = this.outletForm.value.headerData.customerClassId;
    if (!this.outletObj.customerClassId) this.outletObj.customerClassId = -1;
    this.outletObj.customerSubClassId = this.outletForm.value.headerData.customerSubClassId;
    if (!this.outletObj.customerSubClassId) this.outletObj.customerSubClassId = -1;
    this.outletObj.commissionerOfReceipt = this.outletForm.value.headerData.commissionerOfReceipt;
    this.outletObj.notes = this.outletForm.value.headerData.notes;
    // this.outletObj.groups = this.outletForm.value.headerData.groupsControl;
    let selectedGroupIds = this.outletForm.value.headerData.groupsControl.map(g => g.groupId);
    this.outletObj.groups = this.allGroupsList.filter(grp => selectedGroupIds.includes(grp.groupId));

    this.outletObj.outletDivisionPaymentTermList = this.divisionsPaymentTermList;
    this.outletObj.onHoldDivisionsList = this.outletForm.get("headerData").get("onHoldDivisionsList").value ? this.outletForm.get("headerData").get("onHoldDivisionsList").value : [];
    this.outletObj.buildingNumber = this.outletForm.value.headerData.buildingNumber && this.outletForm.value.headerData.buildingNumber.trim() != "" ? this.outletForm.value.headerData.buildingNumber : "";
    this.outletObj.warehouseId = this.outletForm.value.headerData.warehouseId ? this.outletForm.value.headerData.warehouseId : -1;
    // Operator Data
    this.outletObj.operatorName = this.outletForm.get('operatorData').get('operatorName').value ? this.outletForm.get('operatorData').get('operatorName').value.trim() : '';
    this.outletObj.operatorPassword = this.outletForm.get('operatorData').get('operatorPassword').value ? this.outletForm.get('operatorData').get('operatorPassword').value.trim() : '';
    this.outletObj.isLockedOperator = this.outletForm.get('operatorData').get('isLockedOperator').value;
    this.outletObj.operatorId = this.outletForm.get('operatorData').get('operatorId').value ? this.outletForm.get('operatorData').get('operatorId').value : -1
    this.outletObj.tempOperatorId = this.outletForm.get('operatorData').get('tempOperatorId').value ? this.outletForm.get('operatorData').get('tempOperatorId').value : -1

    //Route Data
    this.outletObj.routesList = this.routesList;

    if (this.enableSalesDistributionChannel) {
      var selectedSDCIds = this.outletForm.value.headerData.salesDistributionChannelList ? this.outletForm.value.headerData.salesDistributionChannelList.map(sdc => sdc.sdcId) : [];
      this.outletObj.salesDistributionChannels = this.allSalesDistributionChannelsList.filter(sdc => selectedSDCIds.includes(sdc.sdcId));
      // this.outletObj.salesDistributionChannels = this.outletForm.value.headerData.salesDistributionChannelList ? this.outletForm.value.headerData.salesDistributionChannelList : [];
    }
    else
      this.outletObj.salesDistributionChannels = [];

    let selectedTerritoryIds = this.outletForm.get("headerData").get("territoriesControl").value ? this.outletForm.get("headerData").get("territoriesControl").value.map(t => t.territoryId) : [];
    this.outletObj.territories = this.allTerritoriesList.filter(territory => selectedTerritoryIds.includes(territory.territoryId));
    // #region[Machine Customer]

    // if is not used machine then get final insertion, else no changes over machine data

    // #endregion
  }
  checkIfNeedToSaveOperator(): boolean {
    if (this.outletObj.operatorId === -1) {
      if (this.outletObj.operatorName != null && this.outletObj.operatorName != '' && this.outletObj.operatorPassword != null && this.outletObj.operatorPassword != '') {
        return true;
      }
    } else {
      if (this.outletObj.orginalOperatorName != this.outletObj.operatorName ||
        this.outletObj.orginalOperatorPassword != this.outletObj.operatorPassword ||
        this.outletObj.orginalIsLockedOperator != this.outletObj.isLockedOperator) {
        return true;
      }
    }
    return false;
  }

  onCustomerTypeChanged(event: number) {
    this.selectedCustomerType = event;
    this.divisionsPaymentTermList = [];
    this.outletForm.get('headerData').get('paymentTermId').reset(null);
    this.outletForm.get('headerData').get('billsNumber').reset(null);

    this.outletForm.get('headerData').get('paymentTermId').disable({ onlySelf: true, emitEvent: false });
    this.outletForm.get('headerData').get('billsNumber').disable({ onlySelf: true, emitEvent: false });
    this.outletForm.get('headerData').get('billsNumber').setValidators([Validators.nullValidator]);
    this.outletForm.get('headerData').get('paymentTermId').setValidators([Validators.nullValidator]);
    this.outletForm.get('headerData').get('billsNumber').markAsUntouched();
    this.outletForm.get('headerData').get('paymentTermId').markAsUntouched();

    this.disablePaymentTerm = true;
    this.enableDisablePaymentTermsTab();
    this.disableBillToBill = true;
    switch (this.selectedCustomerType) {
      case CustomerTypes.CashCustomer.valueOf():
        this.disablePaymentTerm = true;
        this.enableDisablePaymentTermsTab();
        this.disableBillToBill = true;
        this.isCashCustomer = true;
        break;
      case CustomerTypes.CreditCustomer.valueOf():
        this.disablePaymentTerm = false;
        this.isCashCustomer = false;
        this.enableDisablePaymentTermsTab();
        this.outletForm.get('headerData').get('paymentTermId').enable({ onlySelf: true, emitEvent: false });
        if (!this.CheckPaymentTermOnCustomerLevel) {
          this.outletForm.get('headerData').get('paymentTermId').setValidators([Validators.required]);
        } else {
          this.outletForm.get('headerData').get('paymentTermId').setValidators([Validators.nullValidator]);
        }
        break;
      case CustomerTypes.BillToBillCustomer.valueOf():
        this.disableBillToBill = false;
        this.disablePaymentTerm = false;
        this.isCashCustomer = false;
        this.enableDisablePaymentTermsTab();
        this.outletForm.get('headerData').get('paymentTermId').enable({ onlySelf: true, emitEvent: false });
        if (!this.CheckPaymentTermOnCustomerLevel) {
          this.outletForm.get('headerData').get('paymentTermId').setValidators([Validators.required]);
        } else {
          this.outletForm.get('headerData').get('paymentTermId').setValidators([Validators.nullValidator]);
        }
        this.outletForm.get('headerData').get('billsNumber').enable({ onlySelf: true, emitEvent: false });
        this.outletForm.get('headerData').get('billsNumber').setValidators([Validators.required]);

        break;
    }
    this.outletForm.get('headerData').get('paymentTermId').updateValueAndValidity();
    this.outletForm.get('headerData').get('billsNumber').updateValueAndValidity();
  }
  saveOutletClicked() {
    // Prepare data
    this.outletForm.get('contactData').get('contactName').clearValidators();
    this.outletForm.get('contactData').get('contactName').updateValueAndValidity();
    if (!this.customerObj) this.customerObj = new CustomerModel();
    if (!this.customerObj.outlets) this.customerObj.outlets = [];
    this.FillOutletObjData();

    this.fillAddedGroupsList(this.outletObj.groups);
    this.fillDeletedGroupsList(this.outletObj.groups);
    if ((this.addedGroups && this.addedGroups.length > 0 && !this.selectedCustomerPromortion) || (this.deletedGroups && this.deletedGroups.length > 0 && !this.selectedCustomerPromortion)) {
      this.checkCustomerGroupAchievementPromotions(this.addedGroups, this.deletedGroups);
    } else {
      // Validation => if valid then save
      this.isValidOutlet();
    }
  }
  saveOutlet() {
    this.outletObj.isNeedToSaveOperator = this.checkIfNeedToSaveOperator();
    if (!this.isEditMode) {
      this.outletObj.dataAction = DataActions.Add;
      this.outletObj.outletId = this.outletId;
      this.outletObj.dummyOutletID = this.outletId;

      this.outletObj.accountsList = [];
      this.customerObj.outlets.push(this.outletObj);
      if (this.NewOutletCodeSequence != "") {
        this.customerObj.maxOutletCode = this.coreSession.generateCustomerCode(this.maxOutletCode);
      }
    } else {
      var index = this.coreSession.GetIndexForList(this.customerObj.outlets, 'outletId', this.outletObj.outletId);
      if (index >= 0) {
        this.customerObj.outlets[index] = this.outletObj;
        if (this.customerObj.outlets[index].dataAction != DataActions.Add) {
          this.customerObj.outlets[index].dataAction = DataActions.Edit;
        }
      } else {
        // error
        this.outletObj.dataAction = DataActions.Add;
        this.customerObj.outlets.push(this.outletObj);
      }
      if (this.NewOutletCodeSequence != "")
        this.customerObj.maxOutletCode = this.maxOutletCode;
    }
    this.onSaveCompleted.emit();
  }

  isValidOutlet() {
    // validate machine data :
    if (this.outletObj.machineTypeId == MachineTypes.VendingMachine.valueOf() || this.outletObj.machineTypeId == MachineTypes.CoffeeMachine.valueOf()) {

      // 1. validate machine mandatory fields
      if (this.outletForm.get('machineDetailsForm').invalid) {
        this.coreSession.markFormGroupTouched(this.outletForm.get('machineDetailsForm') as FormGroup);
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMachineData));
        this.ChangeDataView(this.shownData.Machine);
        return;
      }
      // 2. validate unique serial number with current customer outlets
      if (this.customerObj.outlets.filter(outlet => outlet.machineData.serialNumber === this.outletObj.machineData.serialNumber && outlet.outletId != this.outletId).length > 0) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueMachineSerialNumber));
        this.ChangeDataView(this.shownData.Machine);
        return;
      }
      // 3. validate unique IMEI with current customer outlets
      if (this.customerObj.outlets.filter(outlet => outlet.machineData.imei === this.outletObj.machineData.imei && outlet.outletId != this.outletId).length > 0) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueMachineIMEINumber));
        this.ChangeDataView(this.shownData.Machine);
        return;
      }
    }

    // Valid Outlet Description When CheckForLanguageDescription
    var descriptions = this.outletForm.get("headerData").get("descriptionLanguages").value;
    if (this.checkForLanguageDescription && descriptions.filter(x => x.languageId != this.coreSession.selectedLanguageId && x.description == '').length != 0) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddDescriptionForCustomerOutlet));
      return;
    }

    // Valid Outlet Description When CheckMandatoryFieldsOnCustomer
    if (this.checkMandatoryFieldsOnCustomer) {
      if (this.outletObj.groups && this.outletObj.groups.length == 0) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddCustomerGroupsForCustomerOutlet));
        return;
      }

      // if (this.outletObj.customerOutletContacts && this.outletObj.customerOutletContacts.length == 0) {
      //   this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddContactsForCustomerOutlet));
      //   return;
      // }

      if (this.outletObj.routesList && !this.territoryEntryHidden && this.outletObj.routesList.length == 0) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddTerritoriesForCustomerOutlet));
        return;
      }
    }

    // validate outlet mandatory fields
    if (this.outletForm.invalid) {
      this.coreSession.markFormGroupTouched(this.outletForm);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      if (this.outletForm.get('headerData').get('outletName').valid && this.outletForm.get('headerData').get('outletCode').valid && this.outletForm.get('headerData').get('barcode').valid) {
        if (this.outletForm.get('headerData').get('paymentTermId').invalid && this.hasPrivilegeOnPaymentTermDivision) {
          this.ChangeDataView(this.shownData.PaymentTerms);
        }
      }
      return;
    }
    // validate unique outlet code with current customer outlets codes
    if (this.customerObj.outlets.filter(outlet => outlet.outletCode === this.outletObj.outletCode && outlet.outletId != this.outletId).length > 0) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueCode));
      return;
    }
    // validate unique outlet barcode with current customer outlets barcodes
    // if (this.outletObj.barcode != null || this.outletObj.barcode != '') {
    //   if (this.customerObj.outlets.filter(outlet => outlet.barcode === this.outletObj.barcode && outlet.outletId != this.outletId).length > 0) {
    //     this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueBarcode));
    //     return;
    //   }
    // }
    //#region [Operator validations]
    if (this.AllowCustomerAppLogin) {
      var countOfFilledData = 0;
      let confirmPassword = this.outletForm.get('operatorData').get('confirmPassword').value;
      if (this.outletObj.operatorName && this.outletObj.operatorName != '') {
        countOfFilledData += 1;
      }
      if (this.outletObj.operatorPassword && this.outletObj.operatorPassword != '') {
        countOfFilledData += 1;
      }
      if (confirmPassword && confirmPassword != '') {
        countOfFilledData += 1;
      }
      if (countOfFilledData > 0 && countOfFilledData < 3) {
        this.ChangeDataView(this.shownData.OperatorData);
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillOperatorDataCorrectly));
        return;
      }
      if (this.outletObj.operatorPassword != null && this.outletObj.operatorPassword != '') {
        if (this.outletObj.operatorPassword != confirmPassword) {
          this.ChangeDataView(this.shownData.OperatorData);
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgPasswordsNotMatches));
          return;
        }
      }
      this.outletObj.matchWithExistsOperator = this.allowSameOperatorForMultiCustomer && this.outletObj.operatorId != -1;
      // validate unique operator name with current customer outlets operators excluding current outlet
      if (this.outletObj.operatorName && this.outletObj.operatorName != '' && !this.outletObj.matchWithExistsOperator) {
        if (this.customerObj.outlets.findIndex(outlet => outlet.operatorName === this.outletObj.operatorName && outlet.outletId != this.outletId) >= 0) {
          this.ChangeDataView(this.shownData.OperatorData);
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueUserName));
          return;
        }
      }
    }
    //#endregion
    if (this.sessionData.getConfigurationValue(ConstantConfigurations.CheckCustomerUniquenessEntry).toLowerCase() === "true") {

      // validate unique outlet Phone with current customer outlets phones
      if (this.outletObj.phone && this.outletObj.phone != '') {
        if (this.customerObj.outlets.filter(outlet => outlet.phone === this.outletObj.phone && outlet.outletId != this.outletId).length > 0) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant('Desc_Phone') + ' ' + this.translateService.instant(ConstantMessages.MsgMustBeUnique));
          return;
        }
      }
      // validate unique outlet Email with current customer outlets Emails
      if (this.outletObj.email && this.outletObj.email != '') {
        if (this.customerObj.outlets.filter(outlet => outlet.email === this.outletObj.email && outlet.outletId != this.outletId).length > 0) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant('Desc_Email') + ' ' + this.translateService.instant(ConstantMessages.MsgMustBeUnique));
          return;
        }
      }
    }
    // validate outlet data with saved values in DB
    if (!this.outletForm.invalid) {
      this.customerService.validateOutletToSave(this.outletObj).subscribe(response => {
        if (response.status != null && response.status >= 0) {
          if (!response.data.isValid) {
            if (!response.data.uniqueCode) {
              this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueCode));
            }  else if (!response.data.uniquePhone) {
              this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant('Desc_Phone') + ' ' + this.translateService.instant(ConstantMessages.MsgMustBeUnique));
            } else if (!response.data.uniqueEmail) {
              this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant('Desc_Email') + ' ' + this.translateService.instant(ConstantMessages.MsgMustBeUnique));
            }
            else if (!response.data.uniqueMachineSerialNumber) {
              this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueMachineSerialNumber));
            }
            else if (!response.data.uniqueMachineIMEINumber) {
              this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueMachineIMEINumber));
            }
            if (!response.data.uniqueOperatorName && this.AllowCustomerAppLogin) {
              this.ChangeDataView(this.shownData.OperatorData);
              this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueUserName));
            }
          }
          else {
            if (this.attachedFiles && this.attachedFiles.length >= 0) {
              this.outletObj.outletAttachments = [];
              for (let file of this.attachedFiles) {
                this.outletObj.outletAttachments.push(file.name);
                if (file.file)
                  this.formData.append("attachedFiles", file.file, file.name);
              }
              this.formData.set("customerID", (!this.customerObj.customerId || this.customerObj.customerId === null) ? '-1' : this.customerObj.customerId.toString());
              if (!this.isEditMode) {
                this.formData.set("outletID", (this.outletId).toString());
              } else {
                this.formData.set("outletID", (this.outletObj.outletId).toString());
              }
              this.sendAttachmentsToDB(this.formData);
            }
            else {
              this.saveOutlet();

            }
          }
        }
        else {

          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
    }

  }

  prepareNavigation() {

    this.navLinks = [

      {
        label: 'Desc_Outlet_Definition',
        index: this.shownData.MainData,
        isActive: false,
        hidden: false,
        disable: false

      },
      {
        label: 'Desc_Machine_Definition',
        index: this.shownData.Machine,
        isActive: false,
        hidden: true,
        disable: false
      },
      {
        label: 'Desc_Payment_Term',
        index: this.shownData.PaymentTerms,
        isActive: false,
        hidden: !this.hasPrivilegeOnPaymentTermDivision,
        disable: true
      },
      {
        label: 'Desc_Location',
        index: this.shownData.Location,
        isActive: false,
        hidden: false,
        disable: false
      },
      {
        label: 'Desc_Operator_Data',
        index: this.shownData.OperatorData,
        isActive: false,
        hidden: !this.AllowCustomerAppLogin,
        disable: false
      },
      {
        label: 'Desc_Attachments',
        index: this.shownData.Attachments,
        isActive: false,
        hidden: false,
        disable: false

      }
    ];
    if (this.coreSession.cachedGeneralData.webApplication === WebApplication.Sonic) {
      this.navLinks.push({
        label: 'Desc_Contacts',
        index: this.shownData.ContactData,
        isActive: false,
        hidden: false,
        disable: false
      });
    }

  }
  enableDisablePaymentTermsTab() {
    if (this.hasPrivilegeOnPaymentTermDivision) {
      this.navLinks[this.shownData.PaymentTerms].disable = this.disablePaymentTerm;
    }
  }
  onChangePaymentTerm(term) {
    this.selectedPaymentTerm = term;
  }
  onChangeDivision(division) {
    this.selectedDivision = division;
  }
  initDivisionPayTermForm() {
    this.divisionsPaymentTermForm = new FormGroup({
      paymentTermId: new FormControl(null, Validators.required),
      divisionId: new FormControl(null, Validators.required),
    });
  }
  onRowOperationForDivPayTerm(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        this.deleteDivisionsPaymentTerm(event.object);
        break;
    }
  }
  addDivisionsPaymentTerm() {
    if (this.divisionsPaymentTermForm.invalid) {
      this.coreSession.markFormGroupTouched(this.divisionsPaymentTermForm);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory))
      return;
    }
    if (this.divisionsPaymentTermList.findIndex(x => x.divisionId === this.divisionsPaymentTermForm.value.divisionId) >= 0) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgExistPaymentTermOnDivision))
      return;
    }
    let divPayTermObject = {
      divisionId: this.divisionsPaymentTermForm.value.divisionId,
      paymentTermId: this.divisionsPaymentTermForm.value.paymentTermId,
      divisionCodeName: this.selectedDivision.divisionCodeName,
      paymentTermDescription: this.selectedPaymentTerm.paymentTermDescription
    };
    this.divisionsPaymentTermList.push(divPayTermObject);
    this.fillDivisionsPaymentTermList();
    this.divisionsPaymentTermForm.reset();
  }
  deleteDivisionsPaymentTerm(selectedPayTerm) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          let index = -1;
          index = this.divisionsPaymentTermList.findIndex(x => x.divisionId === selectedPayTerm.divisionId)
          if (index != -1) {
            this.divisionsPaymentTermList.splice(index, 1);
            this.fillDivisionsPaymentTermList();
          }
        }
      });
  }
  fillDivisionsPaymentTermList() {
    this.divisionsPaymentDataSource = {
      data: this.divisionsPaymentTermList,
      totalItems: this.divisionsPaymentTermList.length
    }
  }
  populateGroupsList() {

    let organizationIdsString = null;
    if (this.customerObj.accountsList && this.customerObj.accountsList.length > 0) {
      let organizationIdsList = [...new Set(this.customerObj.accountsList.filter(acc => acc.dataAction !== DataActions.Delete.valueOf()).map(acc => acc.organizationId))];
      organizationIdsString = organizationIdsList && organizationIdsList.length > 0 ?
        organizationIdsList.join(',') : null;
    }

    this.customerService.getAllCustomerGroups(organizationIdsString).subscribe(result => {
      this.allGroupsList = result.data;
      if (this.outletObj && this.outletObj.groups != null) {
        this.groups = this.outletObj.groups;
      } else
        this.groups = [];
      // (this.outletForm.get('headerData').get('groupsControl').value);
      (this.groups);
      //  this.outletForm.get('headerData').get('groupsControl').setValue(this.groups);
    });
  }

  populateSalesDistributionChannels() {
    let organizationIdsString = null;
    if (this.customerObj.accountsList && this.customerObj.accountsList.length > 0) {
      let organizationIdsList = [...new Set(this.customerObj.accountsList.filter(acc => acc.dataAction !== DataActions.Delete.valueOf()).map(acc => acc.organizationId))];
      organizationIdsString = organizationIdsList && organizationIdsList.length > 0 ?
        organizationIdsList.join(',') : null;
    }
    var filter = {
      organizationIds: organizationIdsString
    }
    this.customerService.getAllSalesDistributionChannels(filter).subscribe(result => {
      this.allSalesDistributionChannelsList = result.data;
    });
  }

  onMachineTypeChanged() {
    // 1 if it was no machine data then user add machine then proceed normally
    // 2. if there exist machine type and any of machine details filled then ask user to confirm or not on cleare filled data
    // 3. if there exist machine type but data not filled then update normally
    if (!this.isUsedMachine) {
      // 1 :
      if (this.oldMachineTypeId === null || this.oldMachineTypeId === -1) {
        this.changeMachineTypeProcess();
      } else {
        // 2  :
        if (
          (this.outletForm.get('machineDetailsForm').get('serialNumber').value != null && this.outletForm.get('machineDetailsForm').get('serialNumber').value != '')
          || (this.outletForm.get('machineDetailsForm').get('tokenNumber').value != null && this.outletForm.get('machineDetailsForm').get('tokenNumber').value != '')
          || (this.outletForm.get('machineDetailsForm').get('imei').value != null && this.outletForm.get('machineDetailsForm').get('imei').value != '')
          || (this.outletForm.get('machineDetailsForm').get('model').value != null && this.outletForm.get('machineDetailsForm').get('model').value != '')
          || (this.outletForm.get('machineDetailsForm').get('machineTemplateId').value != null && this.outletForm.get('machineDetailsForm').get('machineTemplateId').value != '')
          || (this.outletForm.get('machineDetailsForm').get('capacityTemplateId').value != null && this.outletForm.get('machineDetailsForm').get('capacityTemplateId').value != '')
          || (this.outletForm.get('machineDetailsForm').get('machineBoxes').value != null && this.outletForm.get('machineDetailsForm').get('machineBoxes').value != '')
        ) {
          this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearMachineDataConfirmation), DialogMode.YesNo).then(
            (res: DialogResult) => {
              if (res === DialogResult.Yes) {
                this.changeMachineTypeProcess();
              } else {
                this.outletForm.get('headerData').get('machineTypeId').setValue(this.oldMachineTypeId);
                this.updateNavigation();
              }
            });
        } else {
          // 3:
          this.changeMachineTypeProcess();
        }
      }
    }
  }

  populateTerritoriesList() {
    let organizationIdsString = null;
    if (this.customerObj.accountsList && this.customerObj.accountsList.length > 0) {
      let organizationIdsList = [...new Set(this.customerObj.accountsList.filter(acc => acc.dataAction !== DataActions.Delete.valueOf()).map(acc => acc.organizationId))];
      organizationIdsString = organizationIdsList && organizationIdsList.length > 0 ?
        organizationIdsList.join(',') : null;
    }
    var filter = {
      hideInactiveTerritories: false,
      organizationIds: organizationIdsString
    };
;

  }

  get machineTemplateIdInput() {
    return this.outletForm.get('machineDetailsForm').get('machineTemplateId');
  }
  get capacityTemplateIdInput() {
    return this.outletForm.get('machineDetailsForm').get('capacityTemplateId');
  }
  get machineBoxesInput() {
    return this.outletForm.get('machineDetailsForm').get('machineBoxes');
  }
  changeMachineTypeProcess() {
    this.resetMachineData();
    if (this.outletForm.get('headerData').get('machineTypeId').value == MachineTypes.VendingMachine.valueOf() || this.outletForm.get('headerData').get('machineTypeId').value == MachineTypes.CoffeeMachine.valueOf()) {
      (<any>Object).values((<FormGroup>this.outletForm.get('machineDetailsForm')).controls).forEach(control => {
        control.setValidators(Validators.required);
        control.updateValueAndValidity();
      });
      if (this.outletForm.get('headerData').get('machineTypeId').value == MachineTypes.CoffeeMachine.valueOf()) {
        this.machineTemplateIdInput.setValidators(Validators.nullValidator);
        this.machineTemplateIdInput.updateValueAndValidity();
      } else if (this.outletForm.get('headerData').get('machineTypeId').value == MachineTypes.VendingMachine.valueOf()) {
        this.machineBoxesInput.setValidators(Validators.nullValidator);
        this.machineBoxesInput.updateValueAndValidity();
        this.capacityTemplateIdInput.setValidators(Validators.nullValidator);
        this.capacityTemplateIdInput.updateValueAndValidity();
      }
    }
    this.oldMachineTypeId = this.outletForm.get('headerData').get('machineTypeId').value;
    this.outletForm.get('machineDetailsForm').get('machineTypeId').setValue(this.oldMachineTypeId);
    this.updateNavigation();
  }
  resetMachineData() {
    this.outletForm.get('machineDetailsForm').get('machineTypeId').reset();
    this.outletForm.get('machineDetailsForm').get('serialNumber').reset();
    this.outletForm.get('machineDetailsForm').get('tokenNumber').reset();
    this.outletForm.get('machineDetailsForm').get('imei').reset();
    this.outletForm.get('machineDetailsForm').get('model').reset();
    this.outletForm.get('machineDetailsForm').get('machineTemplateId').reset();
    this.outletForm.get('machineDetailsForm').get('capacityTemplateId').reset();
    this.outletForm.get('machineDetailsForm').get('machineBoxes').setValue([]);
  }
  updateNavigation() {

    if (this.outletForm.get('headerData').get('machineTypeId').value === '' || this.outletForm.get('headerData').get('machineTypeId').value === null || this.outletForm.get('headerData').get('machineTypeId').value === -1) {
      this.navLinks[this.shownData.Machine].hidden = true;
    } else {
      this.navLinks[this.shownData.Machine].hidden = true;
    }
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.saveOutletClicked();
    });
  }
  onOtherLanguagesTextSubmitted(event) {
    this.outletForm.get('headerData').get('descriptionLanguages').setValue(event);
  }
  onOtherContactNameLanguagesTextSubmitted(event) {
    this.outletForm.get('contactData').get('contactDescriptionLanguages').setValue(event);
  }
  onOtherContactAddressLanguagesTextSubmitted(event) {
    this.outletForm.get('contactData').get('addressDescriptionLanguages').setValue(event);
  }
  onAddingNewCustomerGroup(newGroup: CustomerGroupModel) {
    this.populateGroupsList();
    let selectedGroups = this.outletForm.value.headerData.groupsControl;
    if (!selectedGroups) selectedGroups = [];
    selectedGroups.push(newGroup);
    (newGroup);
    this.outletForm.get('headerData').get('groupsControl').setValue(selectedGroups);
    //this.outletForm.value.headerData.groupsControl=selectedGroups;
    this.onCloseGroupClicked();
  }
  onSaveGroupClicked() {
    this.saveSubject.next();
  }
  onCloseGroupClicked() {
    this.templateEntry.Close();
  }

  showGroupModal() {
    this.templateEntry.Show(true).then(
      (res) => {
      }
    );
  }
  onDialogResult(event) {
    if (event && event.saveCLicked) {
      this.onSaveGroupClicked();
    }
  }
  onAddingLocation(newLoaction: CustomerOutletModel) {
    this.outletForm.get('locationData').get('gpsLatitude').setValue(newLoaction.gpsLatitude);
    this.outletForm.get('locationData').get('gpsLongitude').setValue(newLoaction.gpsLongitude);
    this.outletObj.gpsLatitude = newLoaction.gpsLatitude;
    this.outletObj.gpsLongitude = newLoaction.gpsLongitude;

    this.getGeocoding(this.outletObj.gpsLatitude, this.outletObj.gpsLongitude);
    this.mapEntry.Close();
  }

  getGeocoding(latitude: string, longitude: string) {
    this.googleMapService.getReverseGeocoding(latitude, longitude).subscribe(
      (location) => {
        console.log(location);
        this.addressComponents = location.results[0].components;
        this.outletForm.get('locationData').get('country').setValue(this.addressComponents.country);
        this.outletForm.get('locationData').get('city').setValue(this.addressComponents.state);
        this.outletForm.get('locationData').get('zipCode').setValue(this.addressComponents.postcode?this.addressComponents.postcode:" ");
        this.outletForm.get('locationData').get('state').setValue(this.addressComponents.state);
        this.outletForm.get('locationData').get('street').setValue(this.addressComponents.road?this.addressComponents.road:" ");
        this.outletForm.get('locationData').get('address').setValue(location.results[0].formatted);
        this.outletForm.get('locationData').get('address2').setValue(location.results[0].formatted);
        this.outletForm.get('locationData').get('area').setValue(this.addressComponents.county);
        this.outletForm.get('locationData').get('landmark').setValue(this.addressComponents._normalized_city);
        this.selectedArea = this.addressComponents.county;
        this.selectedCity = this.addressComponents.state;
        this.selectedState = this.addressComponents.state;
        this.selectedCountry = this.addressComponents.country;
        this.selectedStreet = this.addressComponents.road;
      },
      (error) => {
        console.error('Error fetching geocoding data:', error);
      }
    );
  }
  extractAddressComponents(components: any) {
    components.forEach((component: any) => {
      const types = component.types;
      if (types.indexOf('country') > -1) {
        this.addressComponents.country = component.long_name;
      }
      if (types.indexOf('point_of_interest') > -1 || types.indexOf('establishment') > -1) {
        this.addressComponents.landmark = component.long_name;
      }
      if (types.indexOf('postal_code') > -1) {
        this.addressComponents.postal_code = component.long_name;
      }
      if (types.indexOf('route') > -1) {
        this.addressComponents.street = component.long_name;
      }
      if (types.indexOf('sublocality_level_1') > -1 || types.indexOf('locality') > -1) {
        this.addressComponents.area = component.long_name;
      }
      if (types.indexOf('administrative_area_level_1') > -1) {
        this.addressComponents.state = component.long_name;
      }
      if (types.indexOf('administrative_area_level_2') > -1) {
        this.addressComponents.city = component.long_name;
      }
    });

    this.addressComponents.address = `${this.addressComponents.street}, ${this.addressComponents.area}, ${this.addressComponents.city}, ${this.addressComponents.state}, ${this.addressComponents.country}`;
  }
  addressComponents: any = {
    country: '',
    landmark: '',
    postal_code: '',
    address: '',
    street: '',
    area: '',
    city: '',
    state: ''
  };


  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.componentVisitService.markComponentVisited('outlet-entry');
    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }
  }
  onRowClicked_groups(event: any) {

  }
  onRowClicked_routes(event: any) {

  }
  onRowClicked_territories(event: any) {

  }
  onRowClicked_contacts(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        this.deleteSelectContact(event.object);
        break;
      case RowOperation.edit:
        this.editSelectedContact(event.object);
        break;
    }
  }
  getGeoLocation(data: any) {
    this.selectedArea = data.areaID;
    this.selectedCity = data.cityID;
    this.selectedState = data.stateID;
    this.selectedCountry = data.countryID;
    this.selectedStreet = data.streetID;
  }
  onTogglePass(type: any) {
    switch (type) {
      case 1:
        if (this.type1 == 'password')
          this.type1 = 'text';
        else
          this.type1 = 'password';
        break;
      case 2:
        if (this.type2 == 'password')
          this.type2 = 'text';
        else
          this.type2 = 'password';
        break;
    }
  }

  fillContactsObject() {
    this.customerOutletContactModel = new CustomerOutletContactModel();
    if (this.selectedContactIndex < 0) {
      this.contactId = +this.contactId + 1;
    } else {
      this.contactId = this.contactsDataSourceArray[this.selectedContactIndex].contactId;
    }
    this.outletForm.get('contactData').get('contactId').setValue(this.contactId);
    this.customerOutletContactModel.contactId = this.outletForm.get('contactData').get('contactId').value;
    this.customerOutletContactModel.contactName = this.outletForm.get('contactData').get('contactName').value;
    this.customerOutletContactModel.address = this.outletForm.get('contactData').get('address').value === '' || this.outletForm.get('contactData').get('address').value == null ? '' : this.outletForm.get('contactData').get('address').value;
    this.customerOutletContactModel.email = this.outletForm.get('contactData').get('email').value;
    this.customerOutletContactModel.fax = (this.outletForm.get('contactData').get('fax').value === '' || this.outletForm.get('contactData').get('fax').value == null ? 0 : this.outletForm.get('contactData').get('fax').value);
    this.customerOutletContactModel.mobile = (this.outletForm.get('contactData').get('mobile').value === '' || this.outletForm.get('contactData').get('mobile').value == null ? 0 : this.outletForm.get('contactData').get('mobile').value);
    this.customerOutletContactModel.phone = (this.outletForm.get('contactData').get('phone').value === '' || this.outletForm.get('contactData').get('phone').value == null ? 0 : this.outletForm.get('contactData').get('phone').value);
    this.customerOutletContactModel.street = this.outletForm.get('contactData').get('street').value === '' || this.outletForm.get('contactData').get('street').value == null ? 0 : this.outletForm.get('contactData').get('street').value;
    this.customerOutletContactModel.addressDescriptionsLanguages = this.outletForm.get('contactData').get('addressDescriptionLanguages').value;
    this.customerOutletContactModel.contactDescriptionsLanguages = this.outletForm.get('contactData').get('contactDescriptionLanguages').value;

    let contactDescriptions = [];
    if (this.customerOutletContactModel.contactDescriptionsLanguages != null) {
      contactDescriptions = this.customerOutletContactModel.contactDescriptionsLanguages;
      let index = contactDescriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId)
      if (index == -1) {
        contactDescriptions.push({
          languageId: this.coreSession.selectedLanguageId,
          description: this.customerOutletContactModel.contactName
        });
        if (contactDescriptions.length === 1) {
          if (this.coreSession.selectedLanguageId === 1) {
            contactDescriptions.push({
              languageId: 2,
              description: ''
            });
          } else {
            contactDescriptions.push({
              languageId: 1,
              description: ''
            });
          }
        }

      } else {
        contactDescriptions[index].description = this.customerOutletContactModel.contactName;
      }
    }

    let addressDescriptions = [];
    if (this.customerOutletContactModel.addressDescriptionsLanguages != null) {
      addressDescriptions = this.customerOutletContactModel.addressDescriptionsLanguages;
      let index = addressDescriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId)
      if (index == -1) {
        addressDescriptions.push({
          languageId: this.coreSession.selectedLanguageId,
          description: (!this.customerOutletContactModel.address ? '' : this.customerOutletContactModel.address)
        });
        if (addressDescriptions.length === 1) {
          if (this.coreSession.selectedLanguageId === 1) {
            addressDescriptions.push({
              languageId: 2,
              description: ''
            });
          } else {
            addressDescriptions.push({
              languageId: 1,
              description: ''
            });
          }
        }
      } else {
        addressDescriptions[index].description = this.customerOutletContactModel.address;
      }
    }
  }

  resetContactFields() {
    this.outletForm.get('contactData').get('contactId').reset('');
    this.outletForm.get('contactData').get('contactName').reset('');
    this.outletForm.get('contactData').get('address').reset();
    this.outletForm.get('contactData').get('email').reset('');
    this.outletForm.get('contactData').get('fax').reset('');
    this.outletForm.get('contactData').get('mobile').reset('');
    this.outletForm.get('contactData').get('phone').reset('');
    this.outletForm.get('contactData').get('street').reset('');
    this.outletForm.get('contactData').get('streetName').reset('');
    this.outletForm.get('contactData').get('addressDescriptionLanguages').reset([]);
    this.outletForm.get('contactData').get('contactDescriptionLanguages').reset([]);

    this.contactAddBtnDesc = 'Desc_Add';
  }

  addContactData() {
    this.outletForm.get('contactData').get('contactName').setValidators([Validators.required]);
    this.outletForm.get('contactData').get('contactName').updateValueAndValidity();
    this.fillContactsObject();
    if (this.isCustomerUniqueEntry() && (this.customerOutletContactModel.email !== ''
      || this.customerOutletContactModel.mobile !== 0
      || this.customerOutletContactModel.phone !== 0
      || this.customerOutletContactModel.fax !== 0)) {
      this.checkCustomerDataOnline(this.customerOutletContactModel);
    } else {
      this.checkIsContactValid(this.customerOutletContactModel);
    }
  }

  clearContactData() {
    this.resetContactFields();

    this.selectedContactIndex = -1;
  }

  setContactDataMarkedAsTouched() {
    this.outletForm.get('contactData').get('email').markAsTouched();
    this.outletForm.get('contactData').get('contactName').markAsTouched();
  }

  checkIsContactValid(addedContact: CustomerOutletContactModel) {
    let mobileIndex = this.contactsDataSourceArray.findIndex(x => x.mobile !== 0 && x.mobile === addedContact.mobile);
    let faxIndex = this.contactsDataSourceArray.findIndex(x => x.fax !== 0 && x.fax === addedContact.fax);
    let phoneIndex = this.contactsDataSourceArray.findIndex(x => x.phone !== 0 && x.phone === addedContact.phone);
    let emailIndex = this.contactsDataSourceArray.findIndex(x => x.email != '' && x.email === addedContact.email);
    if (addedContact.mobile === 0 && addedContact.fax === 0 && addedContact.phone === 0 && addedContact.email === '') {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillAtLeastOneOfContactFields));
      return false;
    } else if (mobileIndex != -1 && mobileIndex !== this.selectedContactIndex) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddedMobileNumberAlreadyExists));
      return false;
    } else if (faxIndex != -1 && faxIndex !== this.selectedContactIndex) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddedFaxNumberAlreadyExists));
      return false;
    } else if (phoneIndex != -1 && phoneIndex !== this.selectedContactIndex) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddedPhoneNumberAlreadyExists));
      return false;
    } else if (emailIndex != -1 && emailIndex !== this.selectedContactIndex) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAddedEmailAlreadyExists));
      return false;
    } else if (this.outletForm.get('contactData').invalid) {
      this.setContactDataMarkedAsTouched();
      if (!this.outletForm.get('contactData').get('contactName') || this.outletForm.get('contactData').get('contactName').value === '') {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
        return false;
      } else {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgInsertValidEmail));
        return false;
      }
    } else {
      this.customerOutletContactModel.streetName = this.outletForm.get('contactData').get('streetName').value != null ? this.outletForm.get('contactData').get('streetName').value : '';
      if (this.selectedContactIndex >= 0) {
        this.contactsDataSourceArray[this.selectedContactIndex] = addedContact;
        this.selectedContactIndex = -1;
      } else {
        this.contactsDataSourceArray.push(addedContact);
      }
      this.contacts_dataSource = {
        data: this.contactsDataSourceArray,
        totalItems: this.contactsDataSourceArray.length
      }
      this.resetContactFields();
      return true;
    }
  }

  isCustomerUniqueEntry() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.CheckCustomerUniquenessEntry).toLowerCase() === "true"
  }

  checkCustomerDataOnline(selectedContact: CustomerOutletContactModel) {

    this.customerService.checkIfContactDataExists(selectedContact).subscribe(response => {

      if (response.message && response.message !== '' && response.status == -1) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), response.message);
      } else {
        this.checkIsContactValid(selectedContact);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });
  }

  deleteSelectContact(selectedContact: CustomerOutletContactModel) {

    let index = -1;
    index = this.contactsDataSourceArray.findIndex(x => x.contactId === selectedContact.contactId);

    if (index != -1) {
      this.contactsDataSourceArray.splice(index, 1);
      this.contacts_dataSource = {
        data: this.contactsDataSourceArray,
        totalItems: this.contactsDataSourceArray.length
      }
    }
  }

  editSelectedContact(selectedContact: CustomerOutletContactModel) {
    this.selectedContactIndex = this.contactsDataSourceArray.indexOf(selectedContact);
    this.outletForm.get('contactData').get('contactId').setValue(selectedContact.contactId);
    this.outletForm.get('contactData').get('contactName').setValue(selectedContact.contactName);
    this.outletForm.get('contactData').get('address').setValue(selectedContact.address);
    this.outletForm.get('contactData').get('email').setValue(selectedContact.email);
    this.outletForm.get('contactData').get('fax').setValue((selectedContact.fax === 0) ? '' : selectedContact.fax);
    this.outletForm.get('contactData').get('mobile').setValue((selectedContact.mobile === 0) ? '' : selectedContact.mobile);
    this.outletForm.get('contactData').get('phone').setValue((selectedContact.phone === 0) ? '' : selectedContact.phone);
    this.outletForm.get('contactData').get('street').setValue(selectedContact.street);
    this.outletForm.get('contactData').get('streetName').setValue(selectedContact.streetName);
    this.outletForm.get('contactData').get('addressDescriptionLanguages').setValue(selectedContact.addressDescriptionsLanguages);
    this.outletForm.get('contactData').get('contactDescriptionLanguages').setValue(selectedContact.contactDescriptionsLanguages);

    this.contactNameOldDescription = selectedContact.contactDescriptionsLanguages;
    this.contactAddressOldDescription = selectedContact.addressDescriptionsLanguages;
    this.contactAddBtnDesc = 'Desc_Edit';
  }
  onOperatorOptionChange() {

    this.outletObj.matchWithExistsOperator = !this.outletObj.matchWithExistsOperator;
    this.outletObj.operatorId = -1;
    this.outletForm.get('operatorData').get('tempOperatorId').setValue(this.outletForm.get('operatorData').get('operatorId').value);
    this.outletForm.get('operatorData').get('operatorId').setValue('');
    this.outletForm.get('operatorData').get('operatorName').setValue('');
    this.outletForm.get('operatorData').get('operatorPassword').setValue('');
    this.outletForm.get('operatorData').get('confirmPassword').setValue('');
  }
  fillCustomerOperatorsList() {
    this.operatorsList = [];
    this.isOperatorLoading = true;
    let outletCode = '';
    if (this.isEditMode) {
      outletCode = this.outletObj.outletCode;
    }
    this.customerService.getCustomerOperatorsList(outletCode).subscribe(result => {
      this.operatorsList = result;
      this.isOperatorLoading = false;
    });
  }
  populateCustomerStatusList() {
    let organizationIdsString = null;
    if (this.customerObj.accountsList && this.customerObj.accountsList.length > 0) {
      let organizationIdsList = [...new Set(this.customerObj.accountsList.filter(acc => acc.dataAction !== DataActions.Delete.valueOf()).map(acc => acc.organizationId))];
      organizationIdsString = organizationIdsList && organizationIdsList.length > 0 ?
        organizationIdsList.join(',') : null;
    }
    var filter = {
      organizationIds: organizationIdsString
    };
    this.customerStatusList = [];
    this.isClassLoading = true;
    this.customerService.getCustomerStatus().subscribe(result => {
      this.customerStatusList = result.data ? result.data : [];
      if (filter.organizationIds != null && filter.organizationIds.trim() !== '') {
        this.customerStatusList = this.customerStatusList.filter(status => {
          const statusOrgIds = status.organizationId.toString().split(',');
          const filterOrgIds = filter.organizationIds.split(',');
          return statusOrgIds.some(id => filterOrgIds.includes(id));
        });
      }
      this.isClassLoading = false;
    });
  }
  onCustomerOperatorChanged(operator: any) {
    if (operator) {
      this.outletForm.get('operatorData').get('operatorName').setValue(operator.operatorName);
      this.outletForm.get('operatorData').get('operatorPassword').setValue(operator.operatorPassword);
      this.outletForm.get('operatorData').get('confirmPassword').setValue(operator.operatorPassword);
    }
  }

  closeImage() {
    // When the user click (x), close the modal
    if (this.modal == undefined) {
      this.modal = document.getElementById("myModal");
    }
    this.modal.style.display = "none";
  }

  openImage(event: any) {

    if (event != null) {
      let target = event.target || event.srcElement || event.currentTarget;
      let modal = document.getElementById("myModal");
      let img = document.getElementById(target.attributes.id.nodeValue).getAttribute('src');
      let modalImg = document.getElementById("img01");
      modal.style.display = "block";
      modalImg.setAttribute('src', img);
      document.getElementById("footer-container").style.zIndex = '-1';
    }
  }

  //#region [Attachments]

  onUploadFiles(file) {
    if (file) {
      let files = file.srcElement.files;
      if (files.length > 0) {
        for (let index = 0; index < files.length; index++) {
          if (files[index].size > 10000000) //10 MB
          {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorLargeSize));
          }
          else {
            let fileObject = new EmailFileModel();
            let reader = new FileReader();
            fileObject.file = files[index];
            fileObject.name = files[index].name;
            let dotes = files[index].name && (files[index].name.length > 20) ? '..' : '';
            fileObject.shortName = files[index].name.substring(0, 20) + dotes;
            fileObject.index = this.maxIndex;
            fileObject.isImage = files[index].type.includes('image') ? true : false;
            reader.onload = (event: ProgressEvent) => {
              if (fileObject.isImage) {
                fileObject.path = (<FileReader>event.target).result;
              } else {
                fileObject.path = this.coreSession.getDefaultPathAttachments();
              }
              fileObject.pathFile = fileObject.name;
            };
            reader.readAsDataURL(file.target.files[index]);
            this.maxIndex++;
            this.attachedFiles.push(fileObject);
          }
        }
      }
    }
  }


  downloadFile(fileName, isEditMode: boolean) {
    //file type extension
    if (isEditMode) {
      let checkFileType = fileName.split('.').pop();
      var fileType;
      if (checkFileType == "txt") {
        fileType = "text/plain";
      }
      if (checkFileType == "pdf") {
        fileType = "application/pdf";
      }
      if (checkFileType == "doc") {
        fileType = "application/vnd.ms-word";
      }
      if (checkFileType == "docx") {
        fileType = "application/vnd.ms-word";
      }
      if (checkFileType == "xls") {
        fileType = "application/vnd.ms-excel";
      }
      if (checkFileType == "png") {
        fileType = "image/png";
      }
      if (checkFileType == "jpg") {
        fileType = "image/jpeg";
      }
      if (checkFileType == "jpeg") {
        fileType = "image/jpeg";
      }
      if (checkFileType == "gif") {
        fileType = "image/gif";
      }
      if (checkFileType == "csv") {
        fileType = "text/csv";
      }

      this.customerService.downloadOutletAttachments(this.outletObj.customerId + '\\' + this.outletObj.outletId, fileName, fileType).subscribe(
        success => {
          saveAs(success, fileName);
        },
        (error: HttpErrorResponse) => {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );
    }

  }
  onDeleteFile(file) {
    this.attachedFiles.splice(this.attachedFiles.indexOf(file), 1);
  }
  sendAttachmentsToDB(formData: FormData) {
    var observable = new Observable<ResponseModel>();
    if (this.isFromNewCustomer) {
      observable = this.newCustomerService.saveOutletAttachments(formData);
    } else {
      observable = this.customerService.saveOutletAttachments(formData)
    }
    observable.subscribe((respone: ResponseModel) => {
      if (respone.status === 0) {
        this.customerObj.customerAttachmentsBasePath = respone.data;
        this.saveOutlet();
      }
      else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.Desc_Check_Customer_Attachment_Path));
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  getFile(url) {
    return this.http
      .get(url, {
        responseType: "blob"
      })
      .pipe(
        map(response => {
          return new Blob([response], {
            type: "application/*"
          });
        })
      );
  }

  onRowOperationForTerritories(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        this.onDeleteAppliedItems(event.object);
        break;
    }
  }

  onDeleteAppliedItems(deletedItem: any) {
    var index = this.addedTerritoriesList.findIndex(x => x.routeId === deletedItem.routeId);
    if (index >= 0) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.addedTerritoriesList.splice(index, 1);
            this.fillTerritoryDateSource(this.addedTerritoriesList);
          }
        });
    }
  }

  openSelectTerritoriesDialog() {
    if (!this.outletForm.get('headerData').get('territoriesControl').value || this.outletForm.get('headerData').get('territoriesControl').value.length === 0) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgAddTerritoriesBeforeAddingRoutes));
      return;
    }
    var selectedTerritoryIds = this.outletForm.get('headerData').get('territoriesControl').value.map(t => t.territoryId).join(',');
    // Check for customer accounts before opening add territories dialog if ForceCustomerOrganizationSelection.
    if (this.ForceCustomerOrganizationSelection &&
      (!this.customerObj.accountsList || this.customerObj.accountsList.length <= 0)) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgDefineOneCustomerAccountAtleast));
      // return;
      this.closeSelectTerritoriesDialog();
    }

    this.copyOfAddedTerr = null;
    this.copyOfAddedTerr = cloneDeep(this.addedTerritoriesList);
    this.copyOfCustomerAccounts = null;
    this.copyOfCustomerAccounts = cloneDeep(this.customerObj.accountsList);
    // this.showTerritoryEntryDialog = true;
    this.selectTerritoriesDialog.setAccountsData(this.copyOfCustomerAccounts);
    this.selectTerritoriesDialog.showDialog(selectedTerritoryIds).then(
      (result) => {
        if (result != -1) {
          this.afterAddingSelectedRoutes(result);
        } else {
          this.closeSelectTerritoriesDialog();
        }
      });
  }

  afterAddingSelectedRoutes(selectedItems) {
    this.addedTerritoriesList = selectedItems;
    this.fillTerritoryDateSource(selectedItems);
    this.closeSelectTerritoriesDialog();

  }

  fillTerritoryDateSource(selectedItems) {
    this.territoriesDataSourceShared = {
      totalItems: selectedItems.length,
      data: selectedItems
    }

  }

  closeSelectTerritoriesDialog() {
    // this.showTerritoryEntryDialog = false;
    if (this.isEditMode) {
      this.coreSession.SetTitle(' ');
    } else {
      this.coreSession.SetTitle(' ');
    }
  }

  getRouteCustomerData() {
    return this.customerObj.outlets;
  }

  afterAddingNewPaymentTerm() {
    this.refreshPaymentTermSubject.next();
  }
  //#endregion


  //#region [Group Achievement Promotions]
  fillAddedGroupsList(newGroupsList: any[]) {
    this.addedGroups = [];
    if (this.originalGroups && this.originalGroups.length > 0) {
      newGroupsList.forEach(newGroup => {
        var idx = this.originalGroups.findIndex(oldGroup => oldGroup.groupId === newGroup.groupId);
        if (idx === -1) {
          this.addedGroups.push(newGroup.groupId);
        }
      });
    } else {
      this.addedGroups = newGroupsList.map(g => g.groupId);
    }
  }

  fillDeletedGroupsList(newGroupsList: any[]) {
    this.deletedGroups = [];
    if (this.originalGroups && this.originalGroups.length > 0) {
      this.originalGroups.forEach(oldGroup => {
        var idx = newGroupsList.findIndex(newGroup => newGroup.groupId === oldGroup.groupId);
        if (idx === -1) {
          this.deletedGroups.push(oldGroup.groupId);
        }
      });
    }
  }

  checkCustomerGroupAchievementPromotions(addedGroupIds, deletedGroupIds) {
    var allGroupsIds = addedGroupIds.concat(deletedGroupIds);
    this.customerService.checkCustomerGroupAchievementPromotions(allGroupsIds).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        if (response.data && response.data.length > 0) {
          this.isThereAnyAchievementPromotions = true;
          this.outletObj.isThereAnyGroupAchievementPromotions = true;
          this.groupsAchievementPromotions = response.data;
          this.achievementPromotionsDS = {
            data: response.data,
            totalItems: response.data.length
          };
          this.openAchievementPromotionsModal();
        } else {
          // No achievement promotions defined for selected groups.
          this.isThereAnyAchievementPromotions = false;
          this.outletObj.isThereAnyGroupAchievementPromotions = false;
          this.isValidOutlet();
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), ConstantMessages.ErrorHappened);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });
  }

  openAchievementPromotionsModal() {
    this.config.backdrop = "static";
    this.modalRef = this.modalService.open(this.groupAchievmentPromotionsModal, {
      centered: true,
    });
    this.config.backdrop = true;
  }

  closeAchievementPromotionsModal() {
    this.modalRef.dismiss();
    this.achievementPromotionsDS = {
      data: [],
      totalItems: 0
    };
  }

  onGroupAchievementPromotionsResult() {
    if (this.achievementPromotionsDS.data && this.achievementPromotionsDS.data.length > 0) {
      this.includedGroupAchievementPromotions = this.achievementPromotionsDS.data.filter(x => x.isChecked);
      this.excludedGroupAchievementPromotions = this.achievementPromotionsDS.data.filter(x => !x.isChecked);
      this.outletObj.includedGroupAchievementPromotions = this.includedGroupAchievementPromotions;
      this.outletObj.excludedGroupAchievementPromotions = this.excludedGroupAchievementPromotions;

    }
    this.selectedCustomerPromortion = true;
    this.closeAchievementPromotionsModal();
    this.isValidOutlet();
  }

  onGroupAchievementPromotionsCancel() {
    this.closeAchievementPromotionsModal();
  }
  openMap() {
    this.mapEntry.Show(true).then(
      (res) => {
      }
    );
  }

  onWarehouseSelected(warehouse: any) {
    if (this.outletObj) {
      this.outletObj.warehouseId = -1;
      this.outletObj.warehouseOrganizationId = -1;
    }
    if (warehouse && warehouse != undefined) {
      this.outletObj.warehouseId = warehouse.warehouseId;
      this.outletObj.warehouseOrganizationId = warehouse.organizationId;
    }
  }

  onDeSelectTerritory() {
    this.affectRoutesAfterChangeTerritories(false);
  }

  onDeselectAllTerritories() {
    this.affectRoutesAfterChangeTerritories(true);
  }

  affectRoutesAfterChangeTerritories(isDeSelectAll: boolean) {
    var selectedTerritoryIds = this.outletForm.get('headerData').get('territoriesControl').value && !isDeSelectAll ? this.outletForm.get('headerData').get('territoriesControl').value.map(t => t.territoryId) : [];
    var addedRoutes = this.territoriesDataSourceShared && this.territoriesDataSourceShared.data ? this.territoriesDataSourceShared.data : [];
    if (addedRoutes && addedRoutes.length > 0) {
      addedRoutes = addedRoutes.filter(r => selectedTerritoryIds.includes(r.territoryId));
    }
    this.territoriesDataSourceShared = {
      data: addedRoutes ? addedRoutes : [],
      totalItems: addedRoutes ? addedRoutes.length : 0
    };

    this.addedTerritoriesList = this.addedTerritoriesList.filter(t => selectedTerritoryIds.includes(t.territoryId));
  }
  onTradeExpiryDateSelected(date) {
    if (date)
      this.tradeExpiryDate = date;
  }
}

