import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';
import { environment } from './google-map-enviroment';

@Injectable({
  providedIn: 'root'
})
export class GoogleMapService {
  private apiKey = environment.googleMapsApiKey
  private apiKeyOpenCage = environment.openCageApiKey

  private apiUrl = 'https://maps.googleapis.com/maps/api';
  constructor(private http: HttpClient) { }

  getReverseGeocoding(latitude: string, longitude: string): Observable<any> {
    const url =`https://api.opencagedata.com/geocode/v1/json?q=${latitude}%2C${longitude}&key=${this.apiKeyOpenCage}`// `${this.apiUrl}&latlng=${latitude},${longitude}`;
    return this.http.get(url);
  }


  getGeocodePaid(address: string) {
    const url = `${this.apiUrl}/geocode/json?address=${encodeURIComponent(address)}&key=${this.apiKey}`;
    return this.http.get(url);
  }

  getReverseGeocodePaid(lat: number, lng: number) {
    const url = `${this.apiUrl}/geocode/json?latlng=${lat},${lng}&key=${this.apiKey}`;
    return this.http.get(url);
  }

  getPlaceDetailsPaid(placeId: string) {
    const url = `${this.apiUrl}/place/details/json?placeid=${placeId}&key=${this.apiKey}`;
    return this.http.get(url);
  }
}
