import { Component, OnInit, Input, ViewChild, ElementRef, Renderer2, Output, EventEmitter, OnDestroy } from '@angular/core';
import { NgbModal, NgbModalConfig } from '@ng-bootstrap/ng-bootstrap';
import { Observable } from 'rxjs';
import { FormGroup, FormControl } from '@angular/forms';
import { CustomerOutletModel } from '../../../../shared/models/customer/outlet.model';
import { ConnectionService } from 'ng-connection-service';
import { HttpErrorResponse } from '@angular/common/http';
import { TranslateService } from '@ngx-translate/core';
import { CoreSession } from '../../../../core/core.session';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { CustomerService } from '../../../../shared/services/data-definition/customer/customers.service';
import * as L from 'leaflet';
import { latLng } from 'leaflet';
import * as leaflet from 'leaflet';

declare var H: any;
var map;
@Component({
  selector: 'app-outlet-map',
  templateUrl: './outlet-map.component.html',
  styleUrls: ['./outlet-map.component.css']
})
export class OutletMapComponent implements OnInit, OnDestroy {

  latitudeAddress : number = 31.7397
  longitudeAddress:number= 35.4252
  locationChoosen = false
  private map;
  outletLocationForm: FormGroup;
  customerDescription: string;
  isCustomerOnHover: boolean = false;
  private ui: any;
  private platform: any;
  //private map: any;
  icon: any;
  sequenceIcon: any;
  marker: any;
  sequenceMarker: any;
  markersGroup: any;
  isMapVisible: boolean = false;
  closeResult: string;
  @Output() onAddingLocation = new EventEmitter();
  @Input() latitudeInEditMode: any = "0";
  @Input() longitudeInEditMode: any = "0";;
  locationObject: CustomerOutletModel

  @ViewChild("map", { static: true })
  public mapElement: ElementRef;

  @ViewChild("customerName", { static: true }) customerNameElement: ElementRef;
  @Input() saveEvent: Observable<void>;
  saveBtnSubscription: any;
  @Input()
  public appId: any;

  @Input()
  public appCode: any;

  @Input()
  public lat: any;

  @Input()
  public lng: any;

  @Input()
  public width: any;

  @Input()
  public height: any;

  @Input()
  public empDescription: any;

  vanDescription: any;
  latitude: string | any;
  longitude: string | any;
  options: any;


  @Input()
  public empId: any;
  gpsLatitude: number = 0;
  gpsLongitude: number = 0;

  // The scripts below are dynamically added to HTML body to configure Here Maps Services.
  scripts = [
    { 'src': 'https://js.api.here.com/v3/3.0/mapsjs-core.js', 'type': 'text/javascript', 'charset': 'utf-8' },
    { 'src': 'https://js.api.here.com/v3/3.0/mapsjs-service.js', 'type': 'text/javascript', 'charset': 'utf-8' },
    { 'src': 'https://js.api.here.com/v3/3.0/mapsjs-places.js', 'type': 'text/javascript', 'charset': 'utf-8' },
    { 'src': 'https://js.api.here.com/v3/3.0/mapsjs-mapevents.js', 'type': 'text/javascript', 'charset': 'utf-8' },
    { 'src': 'https://js.api.here.com/v3/3.0/mapsjs-ui.js', 'type': 'text/javascript', 'charset': 'utf-8' },
  ];
  mapServiceUnavailable: boolean = false;
  numberOfLoaded: number = 0;
  networkConnectionStateSubscription;
  resourcesLoaded: boolean = false;
  ngOnInit() {
    this.subscribeSaveClick();

    this.initForm();
    // this.platform = new H.service.Platform({
    //   "app_id": "SXw9u0a2JdpTuPzuWYss",
    //   "app_code": "Yp92GERdCKl1PHmcUnBHjw"
    // });
    this.subscribeToConnectionState();
  }

  subscribeToConnectionState() {
    this.networkConnectionStateSubscription =
      this.connectionService.monitor().subscribe((isConnected) => {
        if (isConnected) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgConnectionRestoredRefresh));
          this.enableScreen();
        }
        else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgMapsNetworkError));
          this.disableScreen();
        }
      });
  }
  enableScreen() {
    this.mapServiceUnavailable = false;
  }

  disableScreen() {
    this.mapServiceUnavailable = true;
    this.resourcesLoaded = false;
  }

  initForm() {
    this.outletLocationForm = new FormGroup({
      // # START OF SELECTION
      gpsLatitude: new FormControl({ value: this.latitudeInEditMode, disabled: true }),
      gpsLongitude: new FormControl({ value: this.longitudeInEditMode, disabled: true }),
    });
    if(this.latitudeInEditMode)
      this.locationChoosen = true

  }
  onMapClick(event){
    this.longitudeInEditMode = event.coords.lng
    this.latitudeInEditMode = event.coords.lat
    this.outletLocationForm.get('gpsLongitude').setValue(event.coords.lng);
      this.outletLocationForm.get('gpsLatitude').setValue(event.coords.lat);
    this.locationChoosen = true

  }
  public afterViewInit() {

    var thisComponent = this;

    // function onEachFeature() {
    //   map.on('click', function (e) {
    //     if (marker) {
    //       map.removeLayer(marker);
    //     }
    //     debugger;
    //     this.latitude = e.latlng.lat;
    //     this.longitude = e.latlng.lng;

    //     marker = new L.marker([this.latitude, this.longitude], markerOptions).addTo(map);
    //     thisComponent.outletLocationForm.get('gpsLongitude').setValue(this.longitude);
    //     thisComponent.outletLocationForm.get('gpsLatitude').setValue(this.latitude);
    //     this.gpsLongitude = this.longitude
    //     this.gpsLatitude = this.latitude;
    //   });
    // }
    if (!this.latitude || !this.longitude) {
      this.latitude = '31.959025';
      this.longitude = '35.905618';
    }

    if (map != undefined) map.remove();
    this.options = {
      center: latLng(this.latitude, this.longitude),
      zoom: 19,
      minZoom: 15,
      maxZoom: 21,
      zoomControl: true,
    };

    var iconOptions = {
      iconUrl: '../assets/img/store.png',
      iconSize: [50, 50]
    }
    // Creating a custom icon
    // var customIcon = L.icon(iconOptions);
    // var markerOptions = {
    //   title: "Customer Location",
    //   clickable: true,
    //   draggable: true,
    //   icon: customIcon
    // }
    // map = new leaflet.map('mapId', this.options);
    // if (this.latitudeInEditMode != undefined && this.longitudeInEditMode != undefined) {
    //   var marker = L.marker([this.latitudeInEditMode, this.longitudeInEditMode], markerOptions).addTo(map);
    //   map.setView([this.latitudeInEditMode, this.longitudeInEditMode], 12); // Set map center and zoom level
    //   this.outletLocationForm.get('gpsLongitude').setValue(this.longitudeInEditMode);
    //   this.outletLocationForm.get('gpsLatitude').setValue(this.latitudeInEditMode);
    // }
    // const searchControl = GeoSearchControl({
    //   provider: new OpenStreetMapProvider(),
    //   marker: markerOptions
    // });

    //map.addControl(searchControl);
    // var layer = new L.TileLayer('http://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', { maxZoom: 21 }, { attribution: "Map data ..." });
    // map.addLayer(layer);
    // var marker = L.marker([this.latitude, this.longitude], markerOptions);
    // marker.addTo(map);
    // onEachFeature();

    //this.initMap();
    // let defaultLayers = this.platform.createDefaultLayers();
    // defaultLayers.normal.map.setMin(2);

    // this.map = new H.Map(
    //   document.getElementById("mapId"),
    //   defaultLayers.normal.map,
    //   {
    //     zoom: 2,
    //     center: { lat: "0", lng: "0" }
    //   }
    // );
    // if (this.latitudeInEditMode != undefined && this.longitudeInEditMode != undefined) {
    //   const marker = new H.map.Marker({ lat: this.latitudeInEditMode, lng: this.longitudeInEditMode });
    //   this.map.addObject(marker);
    //   this.map.setCenter({ lat: this.latitudeInEditMode, lng: this.longitudeInEditMode });
    //   this.map.setZoom(12)
    // }
    // let behavior = new H.mapevents.Behavior(new H.mapevents.MapEvents(this.map));

    // this.ui = H.ui.UI.createDefault(this.map, defaultLayers);
    // ("Control = ");
    // (this.ui);
    // //.......
    // window.addEventListener('resize',
    //   () => this.map.getViewPort().resize());
    // //.......
    // this.ui.getControl('mapsettings').setVisibility(false);
    // this.ui.getControl('zoom').setVisibility(false);
    // this.ui.getControl('scalebar').setVisibility(false);
    this.clickMap()
  }

  // public ngAfterViewInit() {
  //   let defaultLayers = this.platform.createDefaultLayers();
  //   defaultLayers.normal.map.setMin(2);

  //   this.map = new H.Map(
  //     document.getElementById("mapId"),
  //     defaultLayers.normal.map,
  //     {
  //       zoom: 2,
  //       center: { lat: "0", lng: "0" }
  //     }
  //   );

  //   let behavior = new H.mapevents.Behavior(new H.mapevents.MapEvents(this.map));

  //   this.ui = H.ui.UI.createDefault(this.map, defaultLayers);
  //   ("Control = ");
  //   (this.ui);
  //   //.......
  //   window.addEventListener('resize',
  //     () => this.map.getViewPort().resize());
  //   //.......
  //   this.ui.getControl('mapsettings').setVisibility(false);
  //   this.ui.getControl('zoom').setVisibility(false);
  //   this.ui.getControl('scalebar').setVisibility(false);
  //   this.clickMap()
  // }

  constructor(private modalService: NgbModal,
    private connectionService: ConnectionService,
    private translateService: TranslateService,
    private coreSession: CoreSession,
    private customerService: CustomerService,
  ) {
    // if (navigator.onLine) { // if internet is connected
    //   // var i = 0;
    //   // this.prepareMapServices(i);
    //   this.checkHereServiceAvailability();
    // } else { // if no internet connection, do not load map, display network error message.

    //   this.mapServiceUnavailable = true;
    // }
  }

  // ChangeLatLng(e: any) {
  // 	this.currentLatLng.emit(e.latlng);
  // }

  checkHereServiceAvailability() {

    this.customerService.checkIfHereMapIsAvailable().subscribe(response => {

      if (response && response.status >= 0 && response.data) {
        var i = 0;
        this.prepareMapServices(i);
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant('Error occured at "js.api.here.com"'));
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant('Error occured at "js.api.here.com"'));
    });
  }

  prepareMapServices(startIdx: number) {

    var loadNextSource = true;
    this.loadScript(this.scripts[startIdx]['src'], this.scripts[startIdx]['type'], this.scripts[startIdx]['charset'], 'src' + (startIdx + 1).toString()
    ).then(() => { // loaded successfully

      // console.log( this.scripts[startIdx]['src'], ' Loaded, H: ', H);
      if (loadNextSource) {
        if ((startIdx + 1) < this.scripts.length) {
          startIdx++;
          this.prepareMapServices(startIdx);
        } else {
          this.afterResourcesLoad();
        }
      }
    }, () => { // not loaded

      loadNextSource = false;
      this.mapServiceUnavailable = true;
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgMapsNetworkError));
    });
  }

  loadScript(src: string, type: string, charset: string, id: string) {

    return new Promise((resolve, reject) => {

      if (!document.getElementById(id)) {
        const script = document.createElement('script')
        script.type = type;
        script.charset = charset;
        script.id = id;
        script.onload = resolve;
        script.onerror = reject;
        script.src = src;
        document.getElementsByTagName('body')[0].appendChild(script);
      } else {
        resolve(null); //sd,gfsd,gfsdk.f
      }
    })
  }

  afterResourcesLoad() {
    this.resourcesLoaded = true;

    this.checkMapResources().then(() => { // map source exists
      // console.log('RESOLVED');

      // setTimeout(() => {

      if (!this.mapServiceUnavailable
        && H && H != undefined && H.service && H.service != undefined
      ) {
        this.platform = new H.service.Platform({
          "app_id": "SXw9u0a2JdpTuPzuWYss",
          "app_code": "Yp92GERdCKl1PHmcUnBHjw"
        });
      } else {  // map source does not exist

        this.mapServiceUnavailable = true;
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgMapsNetworkError));
      }
      this.afterViewInit();
      // }, 1);
    }).catch((err) => {/*console.log('catch',err)*/; this.mapServiceUnavailable = true;
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgMapsNetworkError));
    });
  }

  checkMapResources() {
    var promise = new Promise<void>((resolve, reject) => {
      // setTimeout(() => {
      if (this.checkLoadedScripts()) {

        resolve();
      } else {

        reject();
      }
      // }, 1);
    });
    return promise;
  }


  public checkLoadedScripts(): boolean {
    var result = true;
    var i = 0;
    this.scripts.forEach(s => {
      if (document.getElementById('src' + (i + 1).toString())) {
        // console.log('element Exists ', document.getElementById('src'+(i + 1).toString()))
      } else {
        result = false;
      }
      i++;
    });
    return result;
  }

  private clickMap() {
    map.on('click', (e) => {
      // Remove existing marker
      map.eachLayer((layer) => {
        if (layer instanceof L.Marker) {
          map.removeLayer(layer);
        }
      });
      var iconOptions = {
        iconUrl: '../assets/img/store.png',
        iconSize: [50, 50]
      }
      // Creating a custom icon
      var markerOptions = {
        title: "Customer Location",
        clickable: true,
        draggable: true,
      }
      // Add new marker at clicked position
      var marker = L.marker(e.latlng, markerOptions).addTo(map);
      this.gpsLongitude = e.latlng.lng;
      this.gpsLatitude = e.latlng.lat;
      // Update form values with clicked coordinates
      this.outletLocationForm.get('gpsLongitude').setValue(e.latlng.lng);
      this.outletLocationForm.get('gpsLatitude').setValue(e.latlng.lat);
      // window.addEventListener('click', (e) => {
      //   this.setUpClickListener(this.map);
      //   this.outletLocationForm.get('gpsLongitude').setValue(this.map.gpsLongitude);
      //   this.outletLocationForm.get('gpsLatitude').setValue(this.map.gpsLatitude);
      //   // this.map.setCenter({ lat: this.map.gpsLatitude, lng: this.map.gpsLatitude });
      //   // this.map.setZoom(4)
      // });
    });
  }
  setUpClickListener(map) {
    // Attach an event listener to map display
    // obtain the coordinates
    map.addEventListener('tap', function (evt) {
      var coord = map.screenToGeo(evt.currentPointer.viewportX,
        evt.currentPointer.viewportY);
      const marker = new H.map.Marker({ lat: coord.lat, lng: coord.lng });
      if (map.getObjects().length > 0)
        map.removeObjects(map.getObjects())
      map.addObject(marker);
      this.gpsLongitude = coord.lng;
      this.gpsLatitude = coord.lat;
    }
    );

  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.saveEvent.subscribe(() => {
      this.onSaveClicked();
    });
  }
  onSaveClicked() {
    this.locationObject = new CustomerOutletModel();
    this.locationObject.gpsLatitude = this.latitudeInput.value != null ? this.latitudeInput.value : 0;
    this.locationObject.gpsLongitude = this.longitudeInput.value != null ? this.longitudeInput.value : 0;
    if (Number(this.locationObject.gpsLatitude) == 0 && Number(this.locationObject.gpsLongitude) == 0) {
      return;
    } else {
      this.onAddingLocation.emit(this.locationObject);
    }
  }
  get latitudeInput() {
    return this.outletLocationForm.get('gpsLatitude');
  }
  get longitudeInput() {
    return this.outletLocationForm.get('gpsLongitude');
  }

  ngOnDestroy(): void {
    if (this.networkConnectionStateSubscription) this.networkConnectionStateSubscription.unsubscribe();
  }
}

