import { EventEmitter, Inject, Injectable } from "@angular/core";
import { HubConnection, HubConnectionBuilder } from "@aspnet/signalr";
import {
  HttpClient,
  HttpErrorResponse,
  HttpHeaders,
} from "@angular/common/http";
import { CoreSession } from "../../../../core/core.session";
import { ResponseModel } from "../../../../shared/models/api-models/api-models";

@Injectable({
  providedIn: "root",
})

export class ChattingAssignmentService {
    url = "";
    httpOptions;

    constructor(
        private http: HttpClient,
        @Inject("BASE_URL") baseUrl: string,
        public coreSession: CoreSession
      ) {
        this.url = baseUrl + "ChattingAssignment";
        this.httpOptions = {
          headers: new HttpHeaders({
            "Content-Type": "application/json",
            Authorization: "my-auth-token",
          }),
        };
      }


      updateChattingUsers(user, languageId: number) {
        const urlValue: string = this.url + "/InformChattingUsers";
        return this.http
          .post<ResponseModel>(urlValue + "?languageId=" + languageId, user)
          .map((response) => {
            return response;
          });
      }

      saveAddedEmployeesToChattingList(
        assignmentList,
        employeeId: number,
        languageId: number
      ) {
        const urlValue: string = this.url + "/InsertAddedEmployeesToChattingList";
        return this.http
          .post<ResponseModel>(
            urlValue + "?employeeId=" + employeeId + "&languageId=" + languageId,
            assignmentList
          )
          .map((response) => {
            return response;
          });
      }


      saveAddedSecurityGroupsToChattingList(
        assignmentList,
        employeeId: number,
        languageId: number
      ) {
        const urlValue: string =
          this.url + "/InsertAddedSecurityGroupsToChattingList";
        return this.http
          .post<ResponseModel>(
            urlValue + "?employeeId=" + employeeId + "&languageId=" + languageId,
            assignmentList
          )
          .map((response) => {
            return response;
          });
      }


      deleteEmployeesFromChattingList(
        assignmentList,
        employeeId: number,
        languageId: number
      ) {
        const urlValue: string = this.url + "/DeleteEmployeesFromChattingList";
        return this.http
          .post<ResponseModel>(
            urlValue + "?employeeId=" + employeeId + "&languageId=" + languageId,
            assignmentList
          )
          .map((response) => {
            return response;
          });
      }

      deleteSecurityGroupsFromChattingList(
        assignmentList,
        employeeId: number,
        languageId: number
      ) {
        const urlValue: string = this.url + "/DeleteSecurityGroupsFromChattingList";
        return this.http
          .post<ResponseModel>(
            urlValue + "?employeeId=" + employeeId + "&languageId=" + languageId,
            assignmentList
          )
          .map((response) => {
            return response;
          });
      }


      getChattingListForAvailableUsersToAdd(filter) {
        const urlValue: string = this.url + '/GetChattingListForAvailableUsersToAdd';
        return this.http.post<ResponseModel>(urlValue, filter).map(response => {
          return response;
        });
      }
    
      getChattingListForAvailableSecurityGroupsToAdd(filter) {
        const urlValue: string = this.url + '/GetChattingListForAvailableSecurityGroupsToAdd';
        return this.http.post<ResponseModel>(urlValue, filter).map(response => {
          return response;
        });
      }
    
      getChattingListForAddedBeforeUsers(filter) {
        const urlValue: string = this.url + '/GetChattingListForAddedBeforeUsers';
        return this.http.post<ResponseModel>(urlValue, filter).map(response => {
          return response;
        });
      }
    
      getChattingListForAddedBeforeSecurityGroups(filter) {
        const urlValue: string = this.url + '/GetChattingListForAddedBeforeSecurityGroups';
        return this.http.post<ResponseModel>(urlValue, filter).map(response => {
          return response;
        });
      }
}
