import { HttpErrorResponse } from '@angular/common/http';
import { Component, OnInit } from '@angular/core';
import { FormControl, FormGroup } from '@angular/forms';
import { TranslateService } from '@ngx-translate/core';
import { CoreSession } from '../../../../../core/core.session';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { SharedTableResult } from '../../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../../shared/models/shared-table/table-properties.interface';
import { EmployeeService } from '../../../../employee/employee.service';
import * as cloneDeep from 'lodash/cloneDeep';
import { MultiSelectionOperation, RowOperation } from '../../../../../shared/models/enums/shared-table-operation.enum';
import { ChattingAssignmentModel } from '../../../../../shared/models/chatting/chatting-assignment.model';
import { CommonButtonStyles } from '../../../../../shared/models/enums/common-button-styles.enum';
import { ChattingUser } from '../../../../../shared/models/chatting/chatting-user.model';
import { ChattingAssignmentStatus } from '../../../../../shared/models/enums/chatting/chatting-assignment-status.enum';
import { ConstantURLs } from '../../../../../shared/models/constants/constant-URL';
import { MenuActions } from '../../../../../shared/models/enums/menu-actions-enum';
import { ChattingAssignmentService } from '../chatting-assignment.service';

@Component({
  selector: 'app-chatting-list-assignment',
  templateUrl: './chatting-list-assignment.component.html',
  styleUrls: ['./chatting-list-assignment.component.css']
})
export class ChattingListAssignmentComponent implements OnInit {

  employeeForm: FormGroup;
  filterForm: FormGroup;
  selectedEmployeeId: number = -1;
  selectedEmployeeCodeName: string;
  selectedEmployee;
  selectedSecurityGroup = {
    id: -1,
    caption: ''
  };

  showAddedEmployees: boolean = true;
  showAddedSG: boolean = false;
  showAvailableEmployees: boolean = true;
  showAvailableSG: boolean = false;

  addedEmployeesTableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: false,
    isMultiSelection: true,
    rowOperations: [

    ],
    multiSelectionOperations: [

    ],
    columns: [
      {
        title: "Desc_Employee",
        key: "employeeCodeName",
        isSortable: true,
        width: "50%"
      },
      {
        title: "Desc_Employee_Type",
        key: "employeeTypeName",
        isSortable: true,
        width: "50%"
      }
    ]
  };

  addedSecurityGroupsTableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: false,
    isMultiSelection: true,
    rowOperations: [

    ],
    multiSelectionOperations: [

    ],
    columns: [
      {
        title: "Desc_Security_Group",
        key: 'securityGroupIdName',
        isSortable: false,
        width: '100%',
      },
    ]
  };

  availableEmployeesTableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: false,
    isMultiSelection: true,
    newBtnCaption: 'Desc_Add',
    rowOperations: [

    ],
    multiSelectionOperations: [

    ],
    columns: [
      {
        title: "Desc_Employee",
        key: "employeeCodeName",
        isSortable: true,
        width: "50%"
      },
      {
        title: "Desc_Employee_Type",
        key: "employeeTypeName",
        isSortable: true,
        width: "50%"
      }
    ]
  };

  availableSecurityGroupsTableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: false,
    isMultiSelection: true,
    newBtnCaption: 'Desc_Add',
    rowOperations: [

    ],
    multiSelectionOperations: [

    ],
    columns: [
      {
        title: "Desc_Security_Group",
        key: 'securityGroupIdName',
        isSortable: false,
        width: '100%',
      },
    ]
  };



  employeeFilter = {
    employeeTypes: [],
    hasTerritories: false,
    hasVehicles: false,
    routeId: -1,
    regionId: -1,
    channelId: -1,
    filterOnRoute: false,
    isAllEmployeesFieldAvailable: false,
    customerId: -1,
    outletId: -1,
    organizationId: -1,
    multiOrganizationId: '',
    isExceptSelectedEmployees: false,
    salesManagerId: -1,
    supervisorId: -1
  };

  addedEmployeesDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  addedSGDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  availableEmployeesDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  availableSGDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  constructor(private coreSession: CoreSession,
    private translateService: TranslateService,
    private chattingAssignmentService: ChattingAssignmentService,
    ) { }

  ngOnInit(): void {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.chattingListAssignmentURL, MenuActions.Add)) {
      this.availableSecurityGroupsTableData.rowOperations.push({
        operation: RowOperation.add,
        title: "Desc_Add_Field",
        icon: "fa fa-plus",
        color: "#66bb6d",
      });

      this.availableSecurityGroupsTableData.multiSelectionOperations.push({
        operation: MultiSelectionOperation.add,
        title: "Desc_Add",
        icon: "fa-solid fa-plus",
        color: "#66bb6d",
      });

      this.availableEmployeesTableData.rowOperations.push({
        operation: RowOperation.add,
        title: "Desc_Add",
        icon: "fa fa-plus",
        color: "#66bb6d",
      });

      this.availableEmployeesTableData.multiSelectionOperations.push({
        operation: MultiSelectionOperation.add,
        title: "Desc_Add",
        icon: "fa-solid fa-plus",
        color: "#66bb6d",
      });
    }

    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.chattingListAssignmentURL, MenuActions.Delete)) {
      this.addedSecurityGroupsTableData.rowOperations.push({
        operation: RowOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e'
      });

      this.addedSecurityGroupsTableData.multiSelectionOperations.push({
        operation: MultiSelectionOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e',
        style: CommonButtonStyles.Negative.valueOf()
      });

      this.addedEmployeesTableData.rowOperations.push({
        operation: RowOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e'
      });

      this.addedEmployeesTableData.multiSelectionOperations.push({
        operation: MultiSelectionOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e',
        style: CommonButtonStyles.Negative.valueOf()
      });
    }
    this.initForm();
    this.initFilterForm();
  }

  initForm() {
    this.employeeForm = new FormGroup({
      employeeId: new FormControl(),
      securityGroupId: new FormControl(),
    });
  }

  initFilterForm() {
    this.filterForm = new FormGroup({
      showAddedSecurityGroups: new FormControl(false),
      showAvailableSecurityGroups: new FormControl(false),
      showAddedEmployees: new FormControl(true),
      showAvailableEmployees: new FormControl(true),
    });
  }

  onShowAddedEmployeesChange() {
    this.resetAddedTablesDS();
    if (this.showAddedEmployeesInput.value) {
      this.showAddedSecurityGroupsInput.setValue(false);
      this.showAddedEmployees = true;
      this.showAddedSG = false;
      if (this.selectedEmployeeId > -1 && this.selectedSecurityGroup.id === -1) {
        let filter = {
          employeeId: this.selectedEmployeeId,
          securityGroupId: -1
        }
        this.populateAddedBeforeEmployees(filter);
      } else if (this.selectedEmployeeId === -1 && this.selectedSecurityGroup.id > -1) {
        let filter = {
          employeeId: -1,
          securityGroupId: this.selectedSecurityGroup.id
        }
        this.populateAddedBeforeEmployees(filter);
      }
    } else {
      this.showAddedSecurityGroupsInput.setValue(true);
      this.showAddedEmployees = false;
      this.showAddedSG = true;
      if (this.selectedEmployeeId > -1 && this.selectedSecurityGroup.id === -1) {
        let filter = {
          employeeId: this.selectedEmployeeId,
          securityGroupId: -1
        }
        this.populateAddedBeforeSecurityGroups(filter);
      } else if (this.selectedEmployeeId === -1 && this.selectedSecurityGroup.id > -1) {
        let filter = {
          employeeId: -1,
          securityGroupId: this.selectedSecurityGroup.id
        }
        this.populateAddedBeforeSecurityGroups(filter);
      }
    }
  }

  onShowAddedSecurityGroupsChange() {
    this.resetAddedTablesDS();
    if (this.showAddedSecurityGroupsInput.value) {
      this.showAddedEmployeesInput.setValue(false);
      this.showAddedEmployees = false;
      this.showAddedSG = true;
      if (this.selectedEmployeeId > -1 && this.selectedSecurityGroup.id === -1) {
        let filter = {
          employeeId: this.selectedEmployeeId,
          securityGroupId: -1
        }
        this.populateAddedBeforeSecurityGroups(filter);
      } else if (this.selectedEmployeeId === -1 && this.selectedSecurityGroup.id > -1) {
        let filter = {
          employeeId: -1,
          securityGroupId: this.selectedSecurityGroup.id
        }
        this.populateAddedBeforeSecurityGroups(filter);
      }
    } else {
      this.showAddedEmployeesInput.setValue(true);
      this.showAddedEmployees = true;
      this.showAddedSG = false;
      if (this.selectedEmployeeId > -1 && this.selectedSecurityGroup.id === -1) {
        let filter = {
          employeeId: this.selectedEmployeeId,
          securityGroupId: -1
        }
        this.populateAddedBeforeEmployees(filter);
      } else if (this.selectedEmployeeId === -1 && this.selectedSecurityGroup.id > -1) {
        let filter = {
          employeeId: -1,
          securityGroupId: this.selectedSecurityGroup.id
        }
        this.populateAddedBeforeEmployees(filter);
      }
    }
  }

  onshowAvailableEmployeesChange() {
    this.resetAvailableTablesDS();
    if (this.showAvailableEmployeesInput.value) {
      this.showAvailableSecurityGroupsInput.setValue(false);
      this.showAvailableSG = false;
      this.showAvailableEmployees = true;
      if (this.selectedEmployeeId > -1 && this.selectedSecurityGroup && this.selectedSecurityGroup.id === -1) {
        let filter = {
          employeeId: this.selectedEmployeeId,
          securityGroupId: -1
        }
        this.populateAvailableEmployees(filter);
      } else if (this.selectedEmployeeId === -1 && this.selectedSecurityGroup && this.selectedSecurityGroup.id > -1) {
        let filter = {
          employeeId: -1,
          securityGroupId: this.selectedSecurityGroup.id
        }
        this.populateAvailableEmployees(filter);
      }
    } else {
      this.showAvailableSecurityGroupsInput.setValue(true);
      this.showAvailableSG = true;
      this.showAvailableEmployees = false;
      if (this.selectedEmployeeId > -1 && this.selectedSecurityGroup.id === -1) {
        let filter = {
          employeeId: this.selectedEmployeeId,
          securityGroupId: -1
        }
        this.populateAvailableSecurityGroups(filter);
      } else if (this.selectedEmployeeId === -1 && this.selectedSecurityGroup.id > -1) {
        let filter = {
          employeeId: -1,
          securityGroupId: this.selectedSecurityGroup.id
        }
        this.populateAvailableSecurityGroups(filter);
      }
    }
  }

  onshowAvailableSecurityGroupsChange() {
    this.resetAvailableTablesDS();
    if (this.showAvailableSecurityGroupsInput.value) {
      this.showAvailableEmployeesInput.setValue(false);
      this.showAvailableEmployees = false;
      this.showAvailableSG = true;
      if (this.selectedEmployeeId > -1 && this.selectedSecurityGroup.id === -1) {
        let filter = {
          employeeId: this.selectedEmployeeId,
          securityGroupId: -1
        }
        this.populateAvailableSecurityGroups(filter);
      } else if (this.selectedEmployeeId === -1 && this.selectedSecurityGroup.id > -1) {
        let filter = {
          employeeId: -1,
          securityGroupId: this.selectedSecurityGroup.id
        }
        this.populateAvailableSecurityGroups(filter);
      }
    } else {
      this.showAvailableEmployeesInput.setValue(true);
      this.showAvailableEmployees = true;
      this.showAvailableSG = false;
      if (this.selectedEmployeeId > -1 && this.selectedSecurityGroup.id === -1) {
        let filter = {
          employeeId: this.selectedEmployeeId,
          securityGroupId: -1
        }
        this.populateAvailableEmployees(filter);
      } else if (this.selectedEmployeeId === -1 && this.selectedSecurityGroup.id > -1) {
        let filter = {
          employeeId: -1,
          securityGroupId: this.selectedSecurityGroup.id
        }
        this.populateAvailableEmployees(filter);
      }
    }
  }

  // table row operations

  onAddedEmpRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        if (event.object && event.object != null) {
          var assignment = new ChattingAssignmentModel();
          assignment.selectedUserId = this.selectedEmployeeId;
          assignment.selectedSecurityGroupId = this.selectedSecurityGroup ? this.selectedSecurityGroup.id : -1;
          assignment.addedUserId = event.object.employeeId;
          assignment.addedSecurityGroupId = -1;
          var deletedEmpList = [];
          deletedEmpList.push(assignment);

          // Infrom chatting users of assignment change, then delete them.
          var user: ChattingUser = new ChattingUser();
          user.userId = this.coreSession.CurrentOperator.employeeId;
          user.userName = this.coreSession.CurrentOperator.employeeName;
          user.addRemoveAssignment = true;
          user.isBOUser = true;
          user.assignmentStatus = ChattingAssignmentStatus.Remove;
          user.chattingAssignmentStatusValue = ChattingAssignmentStatus.Remove.valueOf();

          this.deleteEmployees(deletedEmpList);

        }
        break;
    }
  }
  onAddedSGRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        if (event.object && event.object != null) {
          var assignment = new ChattingAssignmentModel();
          assignment.selectedUserId = this.selectedEmployeeId;
          assignment.selectedSecurityGroupId = this.selectedSecurityGroup ? this.selectedSecurityGroup.id : -1;
          assignment.addedUserId = -1;
          assignment.addedSecurityGroupId = event.object.securityGroupId;
          var deletedSGList = [];
          deletedSGList.push(assignment);
          // Infrom chatting users of assignment change, then delete them.
          var user: ChattingUser = new ChattingUser();
          user.userId = this.coreSession.CurrentOperator.employeeId;
          user.userName = this.coreSession.CurrentOperator.employeeName;
          user.addRemoveAssignment = true;
          user.isBOUser = true;
          user.assignmentStatus = ChattingAssignmentStatus.Remove;
          user.chattingAssignmentStatusValue = ChattingAssignmentStatus.Remove.valueOf();

          this.deleteSecurityGroups(deletedSGList);
        }
        break;
    }
  }
  onAvailableEmpRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.add:
        if (event.object && event.object != null) {
          var assignment = new ChattingAssignmentModel();
          assignment.selectedUserId = this.selectedEmployeeId;
          assignment.selectedSecurityGroupId = this.selectedSecurityGroup ? this.selectedSecurityGroup.id : -1;
          assignment.addedUserId = event.object.employeeId;
          assignment.addedSecurityGroupId = -1;
          var addedEmpList = [];
          addedEmpList.push(assignment);
          this.saveAddedEmployees(addedEmpList);
        }
        break;
    }
  }
  onAvailableSGRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.add:
        if (event.object && event.object != null) {
          var assignment = new ChattingAssignmentModel();
          assignment.selectedUserId = this.selectedEmployeeId;
          assignment.selectedSecurityGroupId = this.selectedSecurityGroup ? this.selectedSecurityGroup.id : -1;
          assignment.addedUserId = -1;
          assignment.addedSecurityGroupId = event.object.securityGroupId;
          var addedSGList = [];
          addedSGList.push(assignment);
          this.saveAddedSecurityGroups(addedSGList);
        }
    }
  }

  onMultiSelectionOperationForAddedEmp(event: any) {
    switch (event.operation) {
      case MultiSelectionOperation.delete: {
        var deletedEmployeesList = [];
        event.object.forEach(emp => {
          var assignment = new ChattingAssignmentModel();
          assignment.selectedUserId = this.selectedEmployeeId;
          assignment.selectedSecurityGroupId = this.selectedSecurityGroup ? this.selectedSecurityGroup.id : -1;
          assignment.addedUserId = emp.employeeId;
          assignment.addedSecurityGroupId = -1;
          deletedEmployeesList.push(assignment);
        });
        // Infrom chatting users of assignment change, then delete them.
        var user: ChattingUser = new ChattingUser();
        user.userId = this.coreSession.CurrentOperator.employeeId;
        user.userName = this.coreSession.CurrentOperator.employeeName;
        user.addRemoveAssignment = true;
        user.isBOUser = true;
        user.assignmentStatus = ChattingAssignmentStatus.Remove;
        user.chattingAssignmentStatusValue = ChattingAssignmentStatus.Remove.valueOf();

        this.deleteEmployees(deletedEmployeesList);

        break;
      }
    }
  }
  onMultiSelectionOperationForAddedSG(event: any) {
    switch (event.operation) {
      case MultiSelectionOperation.delete: {
        var deletedSecurityGroupsList = [];
        event.object.forEach(SG => {
          var assignment = new ChattingAssignmentModel();
          assignment.selectedUserId = this.selectedEmployeeId;
          assignment.selectedSecurityGroupId = this.selectedSecurityGroup ? this.selectedSecurityGroup.id : -1;
          assignment.addedUserId = -1;
          assignment.addedSecurityGroupId = SG.securityGroupId;
          deletedSecurityGroupsList.push(assignment);
        });
        // Infrom chatting users of assignment change, then delete them.
        var user: ChattingUser = new ChattingUser();
        user.userId = this.coreSession.CurrentOperator.employeeId;
        user.userName = this.coreSession.CurrentOperator.employeeName;
        user.addRemoveAssignment = true;
        user.isBOUser = true;
        user.assignmentStatus = ChattingAssignmentStatus.Remove;
        user.chattingAssignmentStatusValue = ChattingAssignmentStatus.Remove.valueOf();

        this.deleteSecurityGroups(deletedSecurityGroupsList);

        break;
      }
    }
  }
  onMultiSelectionOperationForAvailableEmp(event: any) {
    switch (event.operation) {
      case MultiSelectionOperation.add: {
        var addedEmployeesList = []
        event.object.forEach(emp => {
          var assignment = new ChattingAssignmentModel();
          assignment.selectedUserId = this.selectedEmployeeId;
          assignment.selectedSecurityGroupId = this.selectedSecurityGroup ? this.selectedSecurityGroup.id : -1;
          assignment.addedUserId = emp.employeeId;
          assignment.addedSecurityGroupId = -1;
          addedEmployeesList.push(assignment);
        });
        this.saveAddedEmployees(addedEmployeesList);
        break;
      }
    }
  }
  onMultiSelectionOperationForAvailableSG(event: any) {
    switch (event.operation) {
      case MultiSelectionOperation.add: {
        var addedSecurityGroupsList = [];
        event.object.forEach(SG => {
          var assignment = new ChattingAssignmentModel();
          assignment.selectedUserId = this.selectedEmployeeId;
          assignment.selectedSecurityGroupId = this.selectedSecurityGroup ? this.selectedSecurityGroup.id : -1;
          assignment.addedUserId = -1;
          assignment.addedSecurityGroupId = SG.securityGroupId;
          addedSecurityGroupsList.push(assignment);
        });
        this.saveAddedSecurityGroups(addedSecurityGroupsList);
        break;
      }
    }
  }
  // table row operations

  updateChattingUsersOnAssigmentChange(status: ChattingAssignmentStatus) {
    var user: ChattingUser = new ChattingUser();
    user.userId = this.coreSession.CurrentOperator.employeeId;
    user.userName = this.coreSession.CurrentOperator.employeeName;
    user.addRemoveAssignment = true;
    user.isBOUser = true;
    user.assignmentStatus = status;
    user.chattingAssignmentStatusValue = status.valueOf();

    this.chattingAssignmentService.updateChattingUsers(user, this.coreSession.selectedLanguageId).subscribe(response => {
      if (response && response.status != null && response.status >= 0) {

      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(response.message));
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });
  }

  saveAddedEmployees(addedEmployeesList) {
    this.coreSession.ModalLoading.Show();
    this.chattingAssignmentService.saveAddedEmployeesToChattingList(addedEmployeesList
      , this.coreSession.CurrentOperator.employeeId
      , this.coreSession.selectedLanguageId).subscribe(response => {
        this.coreSession.ModalLoading.Hide();
        if (response && response.status != null && response.status >= 0) {
          // this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(response.message));
          if (response.data && response.data.length > 0 && response.data[0].selectedUserId > -1) {
            // added user is [Employee], re-populate added/available employees list for selected employee.
            let filter = {
              employeeId: response.data[0].selectedUserId,
              securityGroupId: -1
            }
            this.populateAddedBeforeEmployees(filter, true);
            this.populateAvailableEmployees(filter, true);
          } else if (response.data && response.data.length > 0 && response.data[0].selectedSecurityGroupId > -1) {
            // added user is [Employee], re-populate added/available employees list for selected Security Group.
            let filter = {
              employeeId: -1,
              securityGroupId: response.data[0].selectedSecurityGroupId
            }
            this.populateAddedBeforeEmployees(filter, true);
            this.populateAvailableEmployees(filter, true);
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(response.message));
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

  saveAddedSecurityGroups(addedSecurityGroupsList) {
    this.coreSession.ModalLoading.Show();
    this.chattingAssignmentService.saveAddedSecurityGroupsToChattingList(addedSecurityGroupsList
      , this.coreSession.CurrentOperator.employeeId
      , this.coreSession.selectedLanguageId).subscribe(response => {
        this.coreSession.ModalLoading.Hide();
        if (response && response.status != null && response.status >= 0) {
          // this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(response.message));
          if (response.data && response.data.length > 0 && response.data[0].selectedUserId > -1) {
            // Added user is [SG], re-populate added/available SG list for selected employee.
            let filter = {
              employeeId: response.data[0].selectedUserId,
              securityGroupId: -1
            }
            this.populateAddedBeforeSecurityGroups(filter, true);
            this.populateAvailableSecurityGroups(filter, true);
          } else if (response.data && response.data.length > 0 && response.data[0].selectedSecurityGroupId > -1) {
            // Added user is [SG], re-populate added/available SG list for selected Security Group.
            let filter = {
              employeeId: -1,
              securityGroupId: response.data[0].selectedSecurityGroupId
            }
            this.populateAddedBeforeSecurityGroups(filter, true);
            this.populateAvailableSecurityGroups(filter, true);
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(response.message));
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

  deleteEmployees(deletedEmployeesList) {
    this.coreSession.ModalLoading.Show();
    this.chattingAssignmentService.deleteEmployeesFromChattingList(deletedEmployeesList
      , this.coreSession.CurrentOperator.employeeId
      , this.coreSession.selectedLanguageId).subscribe(response => {
        this.coreSession.ModalLoading.Hide();
        if (response && response.status != null && response.status >= 0) {

          if (response.data && response.data.length > 0 && response.data[0].selectedUserId > -1) {
            // Deleted user is [Employee] re-populate employee added/available for selected employee datasources and display them.
            let filter = {
              employeeId: response.data[0].selectedUserId,
              securityGroupId: -1
            }
            this.populateAddedBeforeEmployees(filter, true);
            this.populateAvailableEmployees(filter, true);
          }
          else if (response.data && response.data.length > 0 && response.data[0].selectedSecurityGroupId > -1) {
            // Deleted user is [Employee] re-populate employee added/available for selected SG datasources and display them.
            let filter = {
              employeeId: -1,
              securityGroupId: response.data[0].selectedSecurityGroupId
            }
            this.populateAddedBeforeEmployees(filter, true);
            this.populateAvailableEmployees(filter, true);
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(response.message));
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

  deleteSecurityGroups(deletedSecurityGroupList) {
    this.coreSession.ModalLoading.Show();
    this.chattingAssignmentService.deleteSecurityGroupsFromChattingList(deletedSecurityGroupList
      , this.coreSession.CurrentOperator.employeeId
      , this.coreSession.selectedLanguageId).subscribe(response => {
        this.coreSession.ModalLoading.Hide();
        if (response && response.status != null && response.status >= 0) {
          if (response.data && response.data.length > 0 && response.data[0].selectedUserId > -1) {
            // Deleted user is [Security Group] re-populate Security Group added/available for selected employee datasources and display them.
            let filter = {
              employeeId: response.data[0].selectedUserId,
              securityGroupId: -1
            }
            this.populateAddedBeforeSecurityGroups(filter, true);
            this.populateAvailableSecurityGroups(filter, true);
          } else if (response.data && response.data.length > 0 && response.data[0].selectedSecurityGroupId > -1) {
            // Deleted user is [Security Group] re-populate Security Group added/available for selected SG datasources and display them.
            let filter = {
              employeeId: -1,
              securityGroupId: response.data[0].selectedSecurityGroupId
            }
            this.populateAddedBeforeSecurityGroups(filter, true);
            this.populateAvailableSecurityGroups(filter, true);
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(response.message));
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  onEmployeeSelected(employee) {
    this.securityGroupIdInput.reset();
    this.selectedEmployeeId = -1;
    this.selectedEmployee = null;
    // this.selectedSecurityGroup = null;
    this.selectedSecurityGroup = {
      id: -1,
      caption: ''
    };
    this.resetTablesDS();
    if (employee && employee != undefined) {
      this.selectedEmployeeId = employee.employeeId;
      this.selectedEmployee = employee;
      let filter = {
        employeeId: this.selectedEmployeeId,
        securityGroupId: -1
      }
      if (this.showAddedEmployeesInput.value) {
        this.populateAddedBeforeEmployees(filter);
      } else if (this.showAddedSecurityGroupsInput.value) {
        this.populateAddedBeforeSecurityGroups(filter);
      }
      if (this.showAvailableEmployeesInput.value) {
        this.populateAvailableEmployees(filter);
      } else if (this.showAvailableSecurityGroupsInput.value) {
        this.populateAvailableSecurityGroups(filter);
      }
    }
  }

  onSecurityGroupSelected(securityGroup) {
    this.employeeIdInput.reset();
    this.selectedEmployeeId = -1;
    this.selectedEmployee = null;
    // this.selectedSecurityGroup = null;
    this.selectedSecurityGroup = {
      id: -1,
      caption: ''
    };
    this.resetTablesDS();
    if (securityGroup && securityGroup !== undefined) {
      this.selectedSecurityGroup = securityGroup; //id / caption
      let filter = {
        employeeId: -1,
        securityGroupId: this.selectedSecurityGroup.id
      }
      if (this.showAddedEmployeesInput.value) {
        this.populateAddedBeforeEmployees(filter);
      } else if (this.showAddedSecurityGroupsInput.value) {
        this.populateAddedBeforeSecurityGroups(filter);
      }
      if (this.showAvailableEmployeesInput.value) {
        this.populateAvailableEmployees(filter);
      } else if (this.showAvailableSecurityGroupsInput.value) {
        this.populateAvailableSecurityGroups(filter);
      }
    }
  }

  resetTablesDS() {
    this.addedEmployeesDataSource = {
      totalItems: 0,
      data: []
    };
    this.addedSGDataSource = {
      totalItems: 0,
      data: []
    };
    this.availableEmployeesDataSource = {
      totalItems: 0,
      data: []
    };
    this.availableSGDataSource = {
      totalItems: 0,
      data: []
    };
  }

  resetAddedTablesDS() {
    this.addedEmployeesDataSource = {
      totalItems: 0,
      data: []
    };
    this.addedSGDataSource = {
      totalItems: 0,
      data: []
    };
  }

  resetAvailableTablesDS() {
    this.availableEmployeesDataSource = {
      totalItems: 0,
      data: []
    };
    this.availableSGDataSource = {
      totalItems: 0,
      data: []
    };
  }

  populateAvailableEmployees(filter, resetView?: boolean) {
    this.coreSession.ModalLoading.Show();
    this.chattingAssignmentService.getChattingListForAvailableUsersToAdd(filter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {

        this.availableEmployeesDataSource = {
          data: response.data,
          totalItems: response.data.length
        }
        if (resetView) {
          this.showAvailableEmployeesInput.setValue(true);
          this.showAvailableSecurityGroupsInput.setValue(false);
          this.showAvailableEmployees = true;
          this.showAvailableSG = false;
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });
  }

  populateAvailableSecurityGroups(filter, resetView?: boolean) {
    this.coreSession.ModalLoading.Show();
    this.chattingAssignmentService.getChattingListForAvailableSecurityGroupsToAdd(filter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {

        this.availableSGDataSource = {
          data: response.data,
          totalItems: response.data.length
        }
        if (resetView) {
          this.showAvailableEmployeesInput.setValue(false);
          this.showAvailableSecurityGroupsInput.setValue(true);
          this.showAvailableEmployees = false;
          this.showAvailableSG = true;
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });

  }

  populateAddedBeforeEmployees(filter, resetView?: boolean) {
    this.coreSession.ModalLoading.Show();
    this.chattingAssignmentService.getChattingListForAddedBeforeUsers(filter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.addedEmployeesDataSource = {
          data: response.data,
          totalItems: response.data.length
        }
        if (resetView) {
          this.showAddedEmployeesInput.setValue(true);
          this.showAddedSecurityGroupsInput.setValue(false);
          this.showAddedEmployees = true;
          this.showAddedSG = false;
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });
  }

  populateAddedBeforeSecurityGroups(filter, resetView?: boolean) {
    this.coreSession.ModalLoading.Show();
    this.chattingAssignmentService.getChattingListForAddedBeforeSecurityGroups(filter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {

        this.addedSGDataSource = {
          data: response.data,
          totalItems: response.data.length
        }
        if (resetView) {
          this.showAddedEmployeesInput.setValue(false);
          this.showAddedSecurityGroupsInput.setValue(true);
          this.showAddedEmployees = false;
          this.showAddedSG = true;
        }

      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });
  }

  get employeeIdInput() {
    return this.employeeForm.get('employeeId');
  }
  get securityGroupIdInput() {
    return this.employeeForm.get('securityGroupId');
  }

  get showAddedEmployeesInput() {
    return this.filterForm.get('showAddedEmployees');
  }
  get showAddedSecurityGroupsInput() {
    return this.filterForm.get('showAddedSecurityGroups');
  }
  get showAvailableEmployeesInput() {
    return this.filterForm.get('showAvailableEmployees');
  }
  get showAvailableSecurityGroupsInput() {
    return this.filterForm.get('showAvailableSecurityGroups');
  }
}
