import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { AuthGuard } from '../../../core/auth/auth.gurad';
import { ConstantURLs } from '../../../shared/models/constants/constant-URL';
import { ItemsListsListComponent } from '../items-lists-definition/items-lists-list/items-lists-list.component';
import { EmployeeManagmentMainComponent } from './employee-managment-main/employee-managment-main.component';
import { EmployeeListComponent } from './employee/employee-list/employee-list.component';


const employeeRouting: Routes = [
  {
    path: "",
    canActivate: [AuthGuard],
    component: EmployeeManagmentMainComponent,
    children: [
      {
        path: ConstantURLs.employeeURL,
        canActivate: [AuthGuard],
        component: EmployeeListComponent
      },

      {
        path: ConstantURLs.employeeItemsListURL,
        canActivate: [AuthGuard],
        component: ItemsListsListComponent,
      },
      {
        path: "",
        canActivate: [AuthGuard],
        redirectTo: "/" + ConstantURLs.dataDefinitionURL + "/" + ConstantURLs.staffURL + "/" + ConstantURLs.employeeURL, pathMatch: "full"
      }
    ]
  }
];
@NgModule({
  imports: [RouterModule.forChild(employeeRouting)],
  exports: [RouterModule]
})
export class EmployeeRoutingModule { }
