import { NgModule } from "@angular/core";
import { CommonModule } from "@angular/common";
import { TranslateModule } from "@ngx-translate/core";
import { NgbTooltipModule, NgbModule } from "@ng-bootstrap/ng-bootstrap";
import { ReactiveFormsModule, FormsModule } from "@angular/forms";
import { NgSelectModule } from "@ng-select/ng-select";
import { SharedModule } from "../../../shared/shared.module";
import { EmployeeRoutingModule } from "./employee-routing.module";
import { NgMultiSelectDropDownModule } from "ng-multiselect-dropdown";
import { EmployeeEntryComponent } from "./employee/employee-entry/employee-entry.component";
import { EmployeeBasicDataComponent } from "./employee/employee-basic-data/employee-basic-data.component";
import { EmployeeSecurityDataComponent } from "./employee/employee-security-data/employee-security-data.component";
import { EmployeeDocumentSequenceDataComponent } from "./employee/employee-document-sequence-data/employee-document-sequence-data.component";
import { EmployeeAccountDataComponent } from "./employee/employee-account-data/employee-account-data.component";
import { EmployeeListComponent } from "./employee/employee-list/employee-list.component";
import { EmployeeRelatedDataComponent } from "./employee/employee-related-data/employee-related-data.component";
import { NgOptionHighlightModule } from "@ng-select/ng-option-highlight";
import { MatListModule } from '@angular/material/list';
import { MatIconModule } from "@angular/material/icon";
import { AvatarModule } from "ngx-avatar";
import { FlatpickrModule } from 'angularx-flatpickr';
import { CalendarModule, DateAdapter } from 'angular-calendar';
import { adapterFactory } from 'angular-calendar/date-adapters/date-fns';
import { EmployeeManagmentMainComponent } from "./employee-managment-main/employee-managment-main.component";


@NgModule({
  declarations: [
    EmployeeManagmentMainComponent,
    EmployeeBasicDataComponent,
    EmployeeRelatedDataComponent,
    EmployeeSecurityDataComponent,
    EmployeeDocumentSequenceDataComponent,
    EmployeeAccountDataComponent,
    EmployeeListComponent,
    EmployeeEntryComponent,
  ],
  imports: [
    CommonModule,
    ReactiveFormsModule,
    FormsModule,
    NgbTooltipModule,
    SharedModule,
    NgbModule,
    NgSelectModule,
    EmployeeRoutingModule,
    NgMultiSelectDropDownModule,
    TranslateModule.forChild(),
    NgOptionHighlightModule,
    MatListModule,
    MatIconModule,
    AvatarModule,
    FlatpickrModule.forRoot(),
    CalendarModule.forRoot({
      provide: DateAdapter,
      useFactory: adapterFactory,
    }),
  ],
})
export class EmployeeModule { }
