import { DataActions } from './../../../../../shared/models/enums/data-actions.enum';
import { CoreSession } from './../../../../../core/core.session';
import { SessionDataProvider } from './../../../../../core/session-data-provider.service';
import { Component, OnInit, Input, Output, OnChanges, SimpleChanges, OnDestroy } from '@angular/core';
import { FormGroup, FormControl, Validators, FormArray } from '@angular/forms';
import { ConstantConfigurations } from '../../../../../shared/models/constants/constant-configuration';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { SharedTableResult } from '../../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../../shared/models/shared-table/table-properties.interface';
import { RowOperation } from '../../../../../shared/models/enums/shared-table-operation.enum';
import { AccountTypes } from '../../../../../shared/models/enums/account-types-enum';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import * as cloneDeep from 'lodash/cloneDeep';
import { ShepherdService } from 'angular-shepherd';
import { Router } from '@angular/router';
import { TourService } from '../../../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../../../shared/shepherd-config/trackTour.service';
import { Subscription } from 'rxjs';
@Component({
  selector: 'app-employee-account-data',
  templateUrl: './employee-account-data.component.html',
  styleUrls: ['./employee-account-data.component.css']
})
export class EmployeeAccountDataComponent implements OnInit, OnChanges, OnDestroy {
  @Input() triggerToStartTour: boolean = false;

  @Input() accountData: FormGroup;
  @Input() disableCurrency = false;
  @Input() divisionAccountsList: any[] = [];
  @Input() isNewEmployee: boolean = false;
  @Input() divisions: any[] = [];
  @Input() organizationId: number = -1;
  @Input() isEditMode = false;
  @Input() originalOrg = -1;
  accountDivisionData: FormGroup;
  isDivisionLoading: boolean = false;
  controlTransactionOnDivisionLevel: boolean = false;
  checkCreditLimitOnEmployeeDivisionAccount: boolean = false;
  dataSource: SharedTableResult = { totalItems: 0, data: [] };
  ApplyCurrencyPerOrg = null;
  tableData: ITableProperties = {
    pageSize: 50,
    showPaginator: false,
    isOnline: false,
    showSearch: true,
    showSearchBtn: false,
    showNewBtn: false,
    isMultiSelection: false,
    openFilterDirectly: false,
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e'
      }
    ],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Division', key: 'divisionCodeName', isSortable: false, width: '25%' },
      { title: 'Desc_Balance', key: 'balance', isSortable: false, width: '25%', numberOfDigits: true },
      { title: 'Desc_Credit_Limit', key: 'creditLimit', numberOfDigits: true, isEditable: true, isSortable: true, width: '25%' }
    ]
  };
  numberOfDigits: number = 0;
  constructor(
    private sessionData: SessionDataProvider,
    private translateService: TranslateService,
    private coreSession: CoreSession,
    private router: Router,
    private shepherdService: ShepherdService,
    private tourService: TourService,
    private componentVisitService: ComponentVisitService
  ) {
  }

  ngOnDestroy(): void {
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.componentVisitService.markComponentVisited('employee-account-data-entry');

    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }
    this.triggerToStartTour = false


  }

  getElementSelector(): string[] {
    var elementSelectors = ['#currency-def', '#Balance-def', '#Credit-Limit-def'];
    return elementSelectors
  }
  private tourSubscription: Subscription;

  ngOnInit() {
    this.tourSubscription = this.tourService.startTourEntry$.subscribe(() => {
      if (this.triggerToStartTour == true) {
        var elementSelectors = this.getElementSelector()
        this.startTour(elementSelectors, true)
      }
    })
    if (this.isDivisionLevel()) {
      this.initializeDivisionsDataForm();

      //Fill Data In Edit Mode
      if (this.divisionAccountsList && this.divisionAccountsList.length > 0 && !this.isNewEmployee) {
        this.fillDataSource();
      }
    }
    this.ApplyCurrencyPerOrg = this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyCurrencyPerOrganization).toLowerCase() === "true";
    this.numberOfDigits = + this.sessionData.getConfigurationValue(ConstantConfigurations.NumberOfDigits);
  }

  ngOnChanges(changes: SimpleChanges) {
    if (this.triggerToStartTour) {
      // If triggerToStartTour has changed and it's not the first change
      var elementSelectors = this.getElementSelector() // Target each column by its unique ID
      this.startTour(elementSelectors);
    }
  }
  private tourStartTimeout: any;

  startTour(elementSelectors, forceTour?: boolean) {
    this.tourStartTimeout = setTimeout((data => {

      if (!forceTour)
        if (this.tourService.isTourCompletedForComponent('employee-account-data-entry')) {

          return;
        }
      const titles = [];
      const texts = [];
      for (let index = 0; index < elementSelectors.length; index++) {
        const { title, text } = this.getTitleAndText(index);
        titles.push(title);
        texts.push(text);
      }
      const steps = this.tourService.generateSteps(elementSelectors, titles, texts);
      this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
      this.shepherdService.modal = true;
      this.shepherdService.addSteps(steps);
      this.shepherdService.start();
    }), 500)
  }
  getTitleAndText(index: number): { title: string, text: string } {
    let title = '';
    let text = '';

    switch (index) {
      case 0:
        title = "Let's go to define your item";
        text = 'Here you can define your items.';
        break;
      case 1:
        title = "Let's go to define your customer";
        text = "Here you can define your customer";
        break;
      case 2:
      case 3:
      case 4:
      case 5:
        title = `Step ${index + 1} Title`;
        text = `Step ${index + 1} Content`;
        break;
      default:
        title = `Step ${index + 1}`;
        text = `Content in defult at bottom.`;
    }

    return { title, text };
  }

  initializeDivisionsDataForm() {
    this.accountDivisionData = new FormGroup({
      divisionId: new FormControl(null, Validators.required),
      creditLimitDivision: new FormControl(null, Validators.required),
      balance: new FormControl({ value: 0, disabled: true }, Validators.required),
    })
  }
  fillDataSource() {
    if (!this.isNewEmployee) {
      this.dataSource = {
        data: this.divisionAccountsList.filter(x => x.dataAction != DataActions.Delete && x.accountId != -1),
        totalItems: this.divisionAccountsList.filter(x => x.dataAction != DataActions.Delete && x.accountId != -1).length
      }
    } else {
      this.dataSource = {
        data: this.divisionAccountsList.filter(x => x.dataAction != DataActions.Delete),
        totalItems: this.divisionAccountsList.filter(x => x.dataAction != DataActions.Delete).length
      }
    }

  }
  addEmployeeAccount() {
    if (this.checkValuesAndRequiredData()) {

      let checkDivisionExist = false;
      let divisionId = this.accountDivisionData.get('divisionId').value;
      let indexDivision = this.divisions.findIndex(x => x.divisionId == divisionId);

      if (this.dataSource && this.dataSource.data.length > 0) {
        if (this.dataSource.data.findIndex(result => result.divisionId == divisionId) >= 0) {
          checkDivisionExist = true;
        }
      }
      if (!checkDivisionExist && divisionId) {
        this.divisionAccountsList.push(
          {
            'currencyId': this.accountData.get('currencyId').value,
            'creditLimit': this.accountDivisionData.get('creditLimitDivision').value,
            'divisionId': this.accountDivisionData.get('divisionId').value,
            'divisionCodeName': this.divisions[indexDivision].divisionCodeName,
            'organizationId': this.organizationId,
            'balance': 0,
            'accountTypeId': AccountTypes.EmployeeAccount,
            'dataAction': DataActions.Add
          });
        this.accountDivisionData.reset();
        this.fillDataSource();
      } else {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption)
          , this.translateService.instant(ConstantMessages.MsgAccountExist));
      }
    }
  }


  checkValuesAndRequiredData() {
    let result = false;
    let creditLimitDivision = +this.accountDivisionData.get('creditLimitDivision').value;

    if (this.organizationId <= 0 || (this.divisions && this.divisions.length <= 0)) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption)
        , this.translateService.instant(ConstantMessages.MsgYouhavetofillorganizationanddivisions));
    } else {
      result = true;
    }

    if (this.accountDivisionData.valid && result) {
      let totalCreditLimit = 0;
      let totalCreditLimitNoAccessDivision = 0

      if (this.dataSource.data && this.dataSource.data.length > 0) {
        this.dataSource.data.forEach(x => {
          totalCreditLimit += x.creditLimit;
          if (x.accountId == -1)
            totalCreditLimitNoAccessDivision = x.totalCreditLimit != undefined ? x.totalCreditLimit : 0;

        });
      }

      if ((creditLimitDivision + totalCreditLimit + totalCreditLimitNoAccessDivision) > +this.accountData.get('creditLimit').value) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant(ConstantMessages.MsgAccountcreditexceedetheparentcreditlimit));
        result = false;
      } else {
        result = true;
      }
    } else {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgFillMandatory));
      result = false;
    }

    return result;
  }

  checkValueByRow() {

    let creditLimit = +this.accountData.get('creditLimit').value;
    let totalCreditlimit = 0;
    let totalCreditLimitNoAccessDivision = 0;

    if (this.dataSource && this.dataSource.data.length > 0) {
      this.dataSource.data.forEach(result => {
        result.creditLimit = Number(result.creditLimit);
        totalCreditlimit += Number(result.creditLimit);
        if (result.accountId == -1)
          totalCreditLimitNoAccessDivision = result.totalCreditLimit != undefined ? result.totalCreditLimit : 0;
      })
    }
    if ((totalCreditlimit + totalCreditLimitNoAccessDivision) > creditLimit) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgAccountcreditexceedetheparentcreditlimit));
    }
    this.fillDataSource();

  }

  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation)
          , DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
            (result: DialogResult) => {
              if (result === DialogResult.Yes) {
                this.onDeleteClicked(event);
              }
            });
        break;
    }
  }

  onDeleteClicked(object: any) {

    let index = this.dataSource.data.findIndex(x => x.divisionId == object.object.divisionId);
    //|| object.object.dataAction != DataActions.Add
    if (object.object.balance != 0) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.MsgCantDeleteAcountNoneZeroBalance));
    } else {
      var divisionIndex = this.divisionAccountsList.findIndex(x => x.divisionId === this.dataSource.data[index].divisionId);
      if (divisionIndex >= 0) {
        if (this.dataSource.data[index].dataAction == DataActions.Add) {
          this.divisionAccountsList.splice(divisionIndex, 1);
        } else {
          this.divisionAccountsList[divisionIndex].dataAction = DataActions.Delete;
          this.dataSource.data.splice(index, 1);
        }
      }
      this.fillDataSource();
    }
  }


  isDivisionLevel() {
    let result = false;
    this.controlTransactionOnDivisionLevel = this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true";
    this.checkCreditLimitOnEmployeeDivisionAccount = this.sessionData.getConfigurationValue(ConstantConfigurations.CheckCreditLimitOnEmployeeDivisionAccount).toLowerCase() === "true";
    if (this.controlTransactionOnDivisionLevel && this.checkCreditLimitOnEmployeeDivisionAccount) {
      result = true;
    }
    return result;
  }
  onSelectedCurrency(currency: any) {
  }

}
