import { Component, OnInit, Input, OnChanges, SimpleChanges, OnDestroy } from '@angular/core';
import { FormGroup, Validators } from '@angular/forms';
import { MasterDataService } from '../../../master-data.service';
import { EmployeeService } from '../../../../employee/employee.service';
import { CoreSession } from '../../../../../core/core.session';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { ITextInput } from '../../../../../shared/models/shared-table/custom-list.interface';
import { MasterDataScreens, MasterDataStatus } from '../../../../../shared/models/enums/master-data-screens';
import { HttpErrorResponse } from '@angular/common/http';
import { ReasonModel } from '../../../../../shared/models/reason-model/reason-model';
import { Router } from '@angular/router';
import { ShepherdService } from 'angular-shepherd';
import { TourService } from '../../../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../../../shared/shepherd-config/trackTour.service';
import { Subscription } from 'rxjs';
@Component({
  selector: 'app-employee-basic-data',
  templateUrl: './employee-basic-data.component.html',
  styleUrls: ['./employee-basic-data.component.css']
})
export class EmployeeBasicDataComponent implements OnInit, OnChanges, OnDestroy {

  @Input() employeeBasicData: FormGroup;
  @Input() employeeId: number;
  @Input() isNewEmployee: boolean;
  operatorid:number
  employeeName: string;
  employeeCode: string;
  employeePhone: string;
  employeeMobile: string;
  employeeEmail: string;
  employeeNationalId: string;
  employeeOrganizationId: number = null;
  employeeTypeId: number;

  isTypesLoading: boolean = false;
  employeeTypesList: any[] = [];

  isOrganizationLoading: boolean = false;
  organizationsList: any[] = [];
  reasonsList: [];
  titleReason: string = '';
  oldInactiveVale: false;
  reasonId: number;
  showReasonCombo: boolean = false;
  employeeNameInput: ITextInput = {
    formControlName: 'employeeName',
    placeHolder: 'Desc_Name',
    label: 'Desc_Name',
    isRequierd: true
  };
  oldDescription: any[] = [];
  reasonObject: ReasonModel = null;
  @Input() triggerToStartTour: boolean = false;

  constructor(
    private masterDataService: MasterDataService,
    private employeeService: EmployeeService,
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private router: Router,
    private shepherdService: ShepherdService,
    private tourService: TourService,
    private componentVisitService: ComponentVisitService
  ) {

  }
  ngOnDestroy(): void {
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.componentVisitService.markComponentVisited('employee-basic-data-entry');
    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }
    this.triggerToStartTour = false

  }

  getTitleAndText(index: number): { title: string, text: string } {
    let title = '';
    let text = '';

    switch (index) {
      case 0:
        title = "Desc_User";
        text = 'Desc_Enter_Name_of_User';
        break;
      case 1:
        title = "Desc_Phone";
        text = "Desc_Enter_Phone_of_User";
        break;
      case 2:
        title = `Desc_Email`;
        text = `Desc_Enter_Email_of_User`;
        break;
      case 3:
        title = `Desc_National_ID`;
        text = `Desc_Enter_National_ID`;
        break;
      case 4:
        title = `Desc_Inactive_Toggle`;
        text = `Desc_content_Inactive_Toggle`;
        break;
      case 5:

      default:
        title = `Step ${index + 1}`;
        text = `Content in defult at bottom.`;
    }

    return { title, text };
  }
  ngAfterViewInit() {
    var elementSelectors = this.getElementSelector()// Target each column by its unique ID
    this.startTour(elementSelectors)
  }
  ngOnChanges(changes: SimpleChanges) {

    if (this.triggerToStartTour) {
      var elementSelectors = this.getElementSelector()
      // Target each column by its unique ID
      this.startTour(elementSelectors)
    }



  }
  getElementSelector(): string[] {
    var elementSelectors = ['#user-def',
       '#contact-1', '#contact-2', '#National', '#Inactive',
    ]
    return elementSelectors
  }

  private tourStartTimeout: any;

  startTour(elementSelectors, forceTour?: boolean) {
    {
      this.tourStartTimeout = setTimeout((data => {

        if (!forceTour)
          if (this.tourService.isTourCompletedForComponent('employee-basic-data-entry')) {

            return;
          }

          if(this.tourService.isFirstTour()||forceTour){
            const titles = [];
            const texts = [];
            for (let index = 0; index < elementSelectors.length; index++) {
              const { title, text } = this.getTitleAndText(index);
              titles.push(title);
              texts.push(text);
            }
            const steps = this.tourService.generateSteps(elementSelectors, titles, texts);
            this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
            this.shepherdService.modal = true;
            this.shepherdService.addSteps(steps);
            this.shepherdService.start();

            if (this.triggerToStartTour == false)
              if (this.tourStartTimeout) {
                clearTimeout(this.tourStartTimeout);
              }
          }
          }), 500)

        }
      }
      private tourSubscription: Subscription;

  ngOnInit() {
    this.operatorid = this.coreSession.CurrentOperator.operatorId;
    this.tourSubscription = this.tourService.startTourEntry$.subscribe(() => {
      var elementSelectors = this.getElementSelector()
      this.startTour(elementSelectors, true)
      if (this.triggerToStartTour == true) {

      }
    });
    this.fillEmployeeTypesList();
    this.fillOrganizationList();
    if (!this.isNewEmployee) {
      this.oldDescription = this.employeeBasicData.get('descriptionLanguages').value;
      (this.oldDescription);
    } else {
      this.oldDescription = null;
    }

    this.oldInactiveVale = this.employeeBasicData.get('isInactive').value;
  }
  fillEmployeeTypesList() {
    this.employeeTypesList = [];
    this.isTypesLoading = true;
    this.employeeService.getEmployeeTypes().subscribe(result => {
      this.employeeTypesList = result;
      // if add mode select first elemnt else select saved org id
      if (this.employeeTypesList != null && this.employeeTypesList.length > 0) {
        (this.employeeBasicData.get('employeeTypeId').value);
        if (this.isNewEmployee || this.employeeBasicData.get('employeeTypeId').value == null) {
          this.employeeTypeId = 1;
          this.employeeBasicData.get('employeeTypeId').setValue(this.employeeTypeId);
        } else {
          this.employeeTypeId = this.employeeBasicData.get('employeeTypeId').value;
        }
      }
      this.isTypesLoading = false;
    });
  }

  fillOrganizationList() {
    this.organizationsList = [];
    this.isOrganizationLoading = true;
    this.masterDataService.getOrganizationList().subscribe(result => {
      this.organizationsList = result;
      // if add mode select first elemnt else select saved org id
      if (this.organizationsList != null && this.organizationsList.length > 0) {
        if (this.isNewEmployee || this.employeeBasicData.get('organizationId').value == null) {
          this.employeeOrganizationId = this.organizationsList[0].organizationId;
          this.employeeBasicData.get('organizationId').setValue(this.employeeOrganizationId);
        } else {
          this.employeeOrganizationId = this.employeeBasicData.get('organizationId').value;
        }
      }
      this.isOrganizationLoading = false;
    });
  }

  //#region [Events]
  onChangeEmployeeType() {
    this.employeeTypeId = 1//this.employeeBasicData.get('employeeTypeId').value;
  }
  onChangeOrganization() {
    this.employeeOrganizationId = this.employeeBasicData.get('organizationId').value;
    this.coreSession.showError(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgChangeOrganization));
  }
  onChangeOnHoldStatus() {
    this.employeeBasicData.get('isOnHold').setValue(!this.employeeBasicData.get('isOnHold').value);
  }
  onChangeInActiveStatus(event: any) {
    this.reasonObject = new ReasonModel();
    this.reasonObject.referenceId = this.employeeId;
    this.reasonObject.status = event.target.checked ? MasterDataStatus.Deactivate : MasterDataStatus.Activate;
    this.reasonObject.screenId = MasterDataScreens.Employees;
  }

  onChangeOutSourceStatus() {
    this.employeeBasicData.get('isOutSource').setValue(!this.employeeBasicData.get('isOutSource').value);
  }
  onOtherLanguagesTextSubmitted(event) {
    this.employeeBasicData.get('descriptionLanguages').setValue(event);
    (this.employeeBasicData.get('descriptionLanguages').value);
    // this.oldDescription = event;
  }

  onReasonSelected(event: any) {
    if (event != undefined) {
      this.employeeBasicData.controls.reasonId.setValue(event.ReasonId);
    } else {
      this.employeeBasicData.controls.reasonId.setValue(null);
    }
  }
  //#endregion

}
