import { SalesDistributionChannelService } from './../../../customer-managment/sales-distribution-channel/sales-distribution-channel.service';
import { Component, OnInit, Input, OnChanges, SimpleChanges, OnDestroy } from '@angular/core';
import { FormControl, FormGroup } from '@angular/forms';
import { EmployeeDocumentSequence } from '../../../../../shared/models/documentSequence/employee-document-sequence.model';
import { DocumentSequencePrefixes } from '../../../../../shared/models/documentSequence/document-sequence-prefix.model';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import { MasterDataService } from '../../../master-data.service';
import { CoreSession } from '../../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantConfigurations } from '../../../../../shared/models/constants/constant-configuration';
import { SessionDataProvider } from '../../../../../core/session-data-provider.service';
import * as cloneDeep from 'lodash/cloneDeep';
import { DocumentSequence } from '../../../../../shared/models/documentSequence/document-sequence.model';
import { DocumentTypes } from '../../../../../shared/models/enums/document-types.enum';
import { ITableProperties } from '../../../../../shared/models/shared-table/table-properties.interface';
import { RowOperation } from '../../../../../shared/models/enums/shared-table-operation.enum';
import { SharedTableResult } from '../../../../../shared/models/shared-table/shared-table-result.interface';
import { ShepherdService } from 'angular-shepherd';
import { Router } from '@angular/router';
import { TourService } from '../../../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../../../shared/shepherd-config/trackTour.service';
import { Subscription } from 'rxjs';
@Component({
  selector: 'app-employee-document-sequence-data',
  templateUrl: './employee-document-sequence-data.component.html',
  styleUrls: ['./employee-document-sequence-data.component.css']
})
export class EmployeeDocumentSequenceDataComponent implements OnInit, OnChanges, OnDestroy {
  @Input() triggerToStartTour: boolean = false;
  @Input() employeeDocumentSequenceData: FormGroup;
  @Input() organizationId: number;
  @Input() employeeId: number = -1;
  @Input() isNewEmployee: boolean;
  @Input() employeeCode: string;
  @Input() employeeDocumentSequenceList: EmployeeDocumentSequence[] = [];
  @Input() divisions: any[] = [];
  isDivisionLoading: boolean = false;
  isSalesChannelLoading: boolean = false;
  direction: any;
  isCollapsed = false;
  documentSequenceByDivision: any[] = [];
  selectedDivision = null;
  isCollapsedCustomerCode = true;
  isCollapsedSalesChannel = true;
  customerCodeForm: FormGroup;
  salesChannelForm: FormGroup;
  salesChannels: any[] = [];
  selectedSalesChannel = null;
  salesChannelsTable: ITableProperties = {
    pageSize: 50,
    showPaginator: false,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    newBtnCaption: 'Desc_Add',
    rowOperations: [{
      operation: RowOperation.delete,
      title: 'Desc_Delete',
      icon: 'fa-solid fa-trash',
      color: '#f1685e'
    }
    ],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Sales_Distribution_Channel', key: 'sdcDescription', isSortable: true, width: '50%' },
      { title: 'Desc_Max_Invoice_ID', key: 'maxInvoiceId', isSortable: true, width: '50%' }
    ]
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  documentSequenceBySalesChannel: any[] = [];
  employeeAlldocumentSequenceData: any[] = [];
  constructor(private masterDataService: MasterDataService,
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private sessionData: SessionDataProvider,
    private channelService: SalesDistributionChannelService,
    private router: Router,
    private shepherdService: ShepherdService,
    private tourService: TourService,
    private componentVisitService: ComponentVisitService
  ) { }
  ngOnDestroy(): void {
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.componentVisitService.markComponentVisited('employee-document-sequence-entry');
    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }
    this.triggerToStartTour = false


  }

  getElementSelector(): string[] {
    var elementSelectors = ['#document-sequance-def', '#clear-button-def', '#suggest-button-def']
    return elementSelectors
  }
  private tourSubscription: Subscription;

  ngOnInit() {
    this.tourSubscription = this.tourService.startTourEntry$.subscribe(() => {

      if (this.triggerToStartTour == true) {
        var elementSelectors = this.getElementSelector()
        this.startTour(elementSelectors, true)
      }
    })
    this.direction = this.coreSession.isRTL;

    if (this.applyDivisionsOnDocumentSequence())
      this.initializeForm();

    if (this.applyDivisionsOnDocumentSequence() && !this.isNewEmployee) {

      if (this.employeeDocumentSequenceData.get('employeeDocumentSequenceList').value
        && this.employeeDocumentSequenceData.get('employeeDocumentSequenceList').value.length > 0) {
        this.employeeDocumentSequenceData.get('employeeDocumentSequenceList').value.forEach(element => {
          this.documentSequenceByDivision.push({
            'divisionId': element.divisionId, 'isCollapsed': true,
            'employeeId': element.employeeId, 'divisionName': element.divisionName,
            'documentSequenceList': element.documentSequenceList.filter(x => (x.key !== DocumentTypes.CustomerCode && x.key !== DocumentTypes.NewCustomerCode))
          })

        });
      }
      this.newCustomerCodeControl.setValue(this.employeeDocumentSequenceData.get('newCustomerCode').value);
      this.maxCustomerCodeControl.setValue(this.employeeDocumentSequenceData.get('maxCustomerCode').value);
    }
    if (this.applySalesChannelsOnDocumentSequence()) {
      // let tempDocumentSequence = this.employeeDocumentSequenceData.get('employeeDocumentSequenceList').value;
      // this.employeeAlldocumentSequenceData = cloneDeep(tempDocumentSequence);
      // this.employeeDocumentSequenceList[0].documentSequenceList = tempDocumentSequence[0].documentSequenceList.filter(x => x.key != DocumentTypes.Invoice);
      this.fillSalesChannels();
      this.initializeForm();
      if (!this.isNewEmployee) {
        this.documentSequenceBySalesChannel = this.employeeDocumentSequenceData.get('salesChannelDocumentSequenceList').value;
        this.fillSalesChannelList();
      }
    }
  }

  initializeForm() {
    this.customerCodeForm = new FormGroup({
      newCustomerCode: new FormControl(""),
      maxCustomerCode: new FormControl(""),
    })
    this.salesChannelForm = new FormGroup({
      sdcId: new FormControl(null),
      maxInvoiceCode: new FormControl(null),
    })
  }


  ngOnChanges(changes: SimpleChanges) {
    if (this.triggerToStartTour) {
      // If triggerToStartTour has changed and it's not the first change
      var elementSelectors = this.getElementSelector() // Target each column by its unique ID
      this.startTour(elementSelectors);
    }

  }
  private tourStartTimeout: any;

  startTour(elementSelectors, forceTour?: boolean) {
    this.tourStartTimeout =
      setTimeout((data => {
        if (!forceTour)
          if (this.tourService.isTourCompletedForComponent('employee-document-sequence-entry')) {
            return;
          }

          if(this.tourService.isFirstTour() || forceTour){

            const titles = [];
            const texts = [];
            for (let index = 0; index < elementSelectors.length; index++) {
          const { title, text } = this.getTitleAndText(index);
          titles.push(title);
          texts.push(text);
        }
        const steps = this.tourService.generateSteps(elementSelectors, titles, texts);
        this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
        this.shepherdService.modal = true;
        this.shepherdService.addSteps(steps);
        this.shepherdService.start();
      }
      }), 500)
  }
  getTitleAndText(index: number): { title: string, text: string } {
    let title = '';
    let text = '';

    switch (index) {
      case 0:
        title = "Desc_Document_Sequence_Data";
        text = 'Desc_Define_Document_Sequence';
        break;
      case 1:
        title = "Desc_Clear_Button";
        text = "Desc_Clear_Button";
        break;
      case 2:
        case 1:
          title = "Desc_Suggest_Button";
          text = "Desc_Fill_All_Fields_With_Suggestion";
          break;
      case 3:
      case 4:
      case 5:
        title = `Step ${index + 1} Title`;
        text = `Step ${index + 1} Content`;
        break;
      default:
        title = `Step ${index + 1}`;
        text = `Content in defult at bottom.`;
    }

    return { title, text };
  }
  suggestDocumentSequence(indexRow: number) {
    let codeFilter = {
      tableName: 'Employee',
      columnName: 'EmployeeCode',
      insertedValue: this.employeeCode,
      excludedString: ' And EmployeeId != ' + this.employeeId,
    }
    if (this.applyDivisionsOnDocumentSequence()) {
      this.masterDataService.checkIfUniqueValue(codeFilter).subscribe(response => {
        if (response.status != null && response.status >= 0) {
          if (response.data) {
            let data = this.documentSequenceByDivision[indexRow].documentSequenceList.find(x => x.value.trim() != '');
            if (data != null) {
              this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
                (res: DialogResult) => {
                  if (res == DialogResult.Yes) {
                    this.documentSequenceByDivision[indexRow].documentSequenceList.forEach(document => { document.suggestedValue = document.prefix + this.employeeCode + DocumentSequencePrefixes.Counter });
                    this.documentSequenceByDivision[indexRow].documentSequenceList.forEach(document => { document.value = document.suggestedValue });
                    this.employeeDocumentSequenceData.get('employeeDocumentSequenceList').setValue(this.documentSequenceByDivision);
                  }
                });
            } else {
              this.documentSequenceByDivision[indexRow].documentSequenceList.forEach(document => { document.suggestedValue = document.prefix + this.employeeCode + DocumentSequencePrefixes.Counter });
              this.documentSequenceByDivision[indexRow].documentSequenceList.forEach(document => {
                document.value = document.suggestedValue;
                this.employeeDocumentSequenceData.get('employeeDocumentSequenceList').setValue(this.documentSequenceByDivision);
              });
            }
          } else {
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueCode));
          }

        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.WarningCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
      );
    } else {
      this.masterDataService.checkIfUniqueValue(codeFilter).subscribe(response => {
        if (response.status != null && response.status >= 0) {
          if (response.data) {
            let data = this.employeeDocumentSequenceList[0].documentSequenceList.find(x => x.value.trim() != '');
            if (data != null) {
              this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
                (res: DialogResult) => {
                  if (res == DialogResult.Yes) {
                    this.employeeDocumentSequenceList[0].documentSequenceList.forEach(document => { document.suggestedValue = document.prefix + this.employeeCode + DocumentSequencePrefixes.Counter });
                    this.employeeDocumentSequenceList[0].documentSequenceList.forEach(document => { document.value = document.suggestedValue });
                  }
                });
            } else {
              this.employeeDocumentSequenceList[0].documentSequenceList.forEach(document => { document.suggestedValue = document.prefix + this.employeeCode + DocumentSequencePrefixes.Counter });
              this.employeeDocumentSequenceList[0].documentSequenceList.forEach(document => {
                document.value = document.suggestedValue;
              });
            }
          } else {
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueCode));
          }

        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.WarningCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
      );
    }
  }
  suggestMaxInvoiceSalesChannel() {

    let codeFilter = {
      tableName: 'Employee',
      columnName: 'EmployeeCode',
      insertedValue: this.employeeCode,
      excludedString: ' And EmployeeId != ' + this.employeeId,
    }
    this.masterDataService.checkIfUniqueValue(codeFilter).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        if (response.data) {
          this.maxInvoiceCodeControl.reset();
          this.fillFormDocSeqInvoice();
        } else {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueCode));
        }

      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.WarningCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
    );
  }
  clearDocumentSequence(indexRow: number) {

    if (this.applyDivisionsOnDocumentSequence()) {
      let data = this.documentSequenceByDivision[indexRow].documentSequenceList.find(x => x.value.trim() != '');
      if (data != null) {
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
          (res: DialogResult) => {
            if (res == DialogResult.Yes) {
              this.documentSequenceByDivision[indexRow].documentSequenceList.forEach(document => {
                document.value = '';
              });
            }
            this.employeeDocumentSequenceData.get('employeeDocumentSequenceList').setValue(this.documentSequenceByDivision);
          });
      } else {
        this.documentSequenceByDivision[indexRow].documentSequenceList.forEach(document => { document.value = ''; });
      }
    } else {
      let data = this.employeeDocumentSequenceList[0].documentSequenceList.find(x => x.value.trim() != '');
      if (data != null) {
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
          (res: DialogResult) => {
            if (res == DialogResult.Yes) {
              this.employeeDocumentSequenceList[0].documentSequenceList.forEach(document => {
                document.value = '';
              });
            }
          });
      } else {
        this.employeeDocumentSequenceList[0].documentSequenceList.forEach(document => { document.value = ''; });
      }
    }
  }

  isDivisionLevel() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true";
  }
  isSalesChannelLevel() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.EnableSalesDistributionChannel).toLowerCase() === "true";
  }
  applyDivisionsOnDocumentSequence() {
    return (this.isDivisionLevel() && this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyDivisionsOnDocumentSequence).toLowerCase() === "true")
  }
  applySalesChannelsOnDocumentSequence() {
    return (this.isSalesChannelLevel() && this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyDocumentSequencePerSalesChannel).toLowerCase() === "true")
  }
  onAddDocumentSeq() {
    this.unCollapseDocumentSequence(-1);
    if (this.selectedDivision) {
      let tempData = {
        divisionId: -1,
        isCollapsed: false,
        divisionName: '',
        employeeId: -1,
        documentSequenceList: []
      };

      tempData.documentSequenceList = cloneDeep(new EmployeeDocumentSequence(-1, -1).documentSequenceList.filter(x => (x.key != DocumentTypes.CustomerCode && x.key != DocumentTypes.NewCustomerCode)));
      tempData.divisionId = this.selectedDivision.divisionId;
      tempData.isCollapsed = false;
      tempData.divisionName = this.selectedDivision.divisionCodeName;
      let indexRow = this.documentSequenceByDivision.findIndex(x => x.divisionId === this.selectedDivision.divisionId);
      if (indexRow >= 0) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant('Desc_Division_Already_Exists'));
      } else {
        this.documentSequenceByDivision.push(tempData);
        this.employeeDocumentSequenceData.get('employeeDocumentSequenceList').setValue(this.documentSequenceByDivision)
        return;
      }
    } else {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant('Desc_Please_Select_Division'));
      return
    }
  }
  onAddDocumentSeqSalesChannel() {
    if (this.salesChannelControl.value == null) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant('Desc_Please_Select_Sales_Channel'));
      return
    }
    if (this.maxInvoiceCodeControl.value == null) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant('Desc_Fill_Max_Invoice_ID'));
      return
    }
    if (this.selectedSalesChannel) {
      let salesChnDocObject = {
        sdcId: this.selectedSalesChannel.sdcId,
        divisionId: -1,
        isCollapsed: false,
        sdcDescription: this.selectedSalesChannel.sdcDescription,
        employeeId: this.employeeId,
        maxInvoiceId: this.maxInvoiceCodeControl.value
      };

      let indexRow = this.documentSequenceBySalesChannel.findIndex(x => x.sdcId === this.selectedSalesChannel.sdcId);
      if (indexRow >= 0) {
        this.maxInvoiceCodeControl.reset();
        this.salesChannelControl.reset();
        this.selectedSalesChannel = [];
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant('Desc_Sales_Channel_Already_Exists'));
      } else {
        this.documentSequenceBySalesChannel.push(salesChnDocObject);
        this.employeeDocumentSequenceData.get('salesChannelDocumentSequenceList').setValue(this.documentSequenceBySalesChannel)
        this.fillSalesChannelList();
        this.maxInvoiceCodeControl.reset();
        this.salesChannelControl.reset();
        this.selectedSalesChannel = [];
        return;
      }
    }
    else {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant('Desc_Please_Select_Sales_Channel'));
      return
    }
  }
  onSelectDivivsion(divisionObj: any) {
    if (divisionObj != undefined) {
      this.selectedDivision = divisionObj;
    } else {
      this.selectedDivision = null;
    }
  }
  onSelectSalesChannel(salesChannelObj: any) {
    if (salesChannelObj != undefined) {
      this.selectedSalesChannel = salesChannelObj;
    } else {
      this.selectedSalesChannel = null;
    }
  }
  unCollapseDocumentSequence(indexRow: number) {
    if (indexRow >= 0) {
      this.documentSequenceByDivision[indexRow].isCollapsed = !this.documentSequenceByDivision[indexRow].isCollapsed;
    }
    if (this.documentSequenceByDivision && this.documentSequenceByDivision.length > 0) {
      this.documentSequenceByDivision.forEach((res, index) => {
        if (index != indexRow)
          res.isCollapsed = true;
      })
    }
  }

  clearDocumentSequenceCustomerCode() {


    if (this.newCustomerCodeControl.value != '' || this.maxCustomerCodeControl.value != '') {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (res: DialogResult) => {
          if (res == DialogResult.Yes) {
            this.newCustomerCodeControl.setValue("")
            this.maxCustomerCodeControl.setValue("")
          }
        });
    } else {
      this.newCustomerCodeControl.setValue("")
      this.maxCustomerCodeControl.setValue("")
    }

    this.employeeDocumentSequenceData.get('newCustomerCode').setValue("")
    this.employeeDocumentSequenceData.get('maxCustomerCode').setValue("")
  }


  unCollapseDocumentSequenceCustomerCode() {
    this.isCollapsedCustomerCode = this.isCollapsedCustomerCode ? false : true;
  }
  unCollapseDocumentSequenceSalesChannel() {
    this.isCollapsedSalesChannel = this.isCollapsedSalesChannel ? false : true;
  }
  suggestDocumentSequenceCustomerCode() {

    let codeFilter = {
      tableName: 'Employee',
      columnName: 'EmployeeCode',
      insertedValue: this.employeeCode,
      excludedString: ' And EmployeeId != ' + this.employeeId,
    }

    this.masterDataService.checkIfUniqueValue(codeFilter).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        if (response.data) {
          if (this.newCustomerCodeControl.value != '' || this.maxCustomerCodeControl.value != '') {
            this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgClearFilledDataConfirmation),
              DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
                (res: DialogResult) => {
                  if (res == DialogResult.Yes) {
                    this.fillCustomerData();
                  }
                });
          } else {
            this.fillCustomerData();
          }
        } else {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueCode));
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.WarningCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
    );

  }
  fillCustomerData() {

    let dataSeqNewCustomerCode = this.employeeDocumentSequenceList[0].documentSequenceList.find(x => x.key == DocumentTypes.NewCustomerCode);
    let dataSeqMaxCustomerCode = this.employeeDocumentSequenceList[0].documentSequenceList.find(x => x.key == DocumentTypes.CustomerCode);
    this.newCustomerCodeControl.setValue(dataSeqNewCustomerCode.suggestedValue = dataSeqNewCustomerCode.prefix + this.employeeCode + DocumentSequencePrefixes.Counter);
    this.maxCustomerCodeControl.setValue(dataSeqMaxCustomerCode.suggestedValue = dataSeqMaxCustomerCode.prefix + this.employeeCode + DocumentSequencePrefixes.Counter);
    this.fillFormDocSeqCustomer();
  }
  fillFormDocSeqCustomer() {
    this.employeeDocumentSequenceData.get('newCustomerCode').setValue(this.newCustomerCodeControl.value)
    this.employeeDocumentSequenceData.get('maxCustomerCode').setValue(this.maxCustomerCodeControl.value)
  }
  fillFormDocSeqInvoice() {
    let dataSeqMaxInvoiceCode = DocumentSequencePrefixes.InvoicePrefix;
    this.maxInvoiceCodeControl.setValue(dataSeqMaxInvoiceCode + this.selectedSalesChannel.sdcCode + '-' + this.employeeCode + DocumentSequencePrefixes.Counter);

  }
  fillSalesChannels() {
    this.channelService.getAllSalesDistributionChannel().subscribe(response => {
      if (response.status != null && response.status >= 0) {
        this.salesChannels = response.data;
      } else {
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(response.message)
        );
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });
  }
  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption))
          .then(
            (result: DialogResult) => {
              if (result === DialogResult.Yes) {
                this.onDeleteClicked(event);
              }
            }
          );
        break;
    }
  }
  fillSalesChannelList() {
    this.dataSource = {
      data: this.documentSequenceBySalesChannel,
      totalItems: this.documentSequenceBySalesChannel.length
    }
  }
  onDeleteClicked(event: any) {
    this.documentSequenceBySalesChannel.splice(this.documentSequenceBySalesChannel.indexOf(event.object), 1);
    this.fillSalesChannelList();
  }
  get newCustomerCodeControl() {
    return this.customerCodeForm.get('newCustomerCode')
  }
  get maxCustomerCodeControl() {
    return this.customerCodeForm.get('maxCustomerCode')
  }
  get salesChannelControl() {
    return this.salesChannelForm.get('sdcId')
  }
  get maxInvoiceCodeControl() {
    return this.salesChannelForm.get('maxInvoiceCode')
  }

}
