import { Component, OnInit, Input, Output, EventEmitter, OnDestroy } from '@angular/core';
import { CoreSession } from '../../../../../core/core.session';
import { FormGroup, FormControl, Validators, FormArray } from '@angular/forms';
import { EmployeeDocumentSequence } from '../../../../../shared/models/documentSequence/employee-document-sequence.model';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { HttpErrorResponse } from '@angular/common/http';
import { EmployeeService } from '../../../../employee/employee.service';
import { ActivatedRoute, Router, Params } from '@angular/router';
import { ConstantURLs } from '../../../../../shared/models/constants/constant-URL';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { TranslateService } from '@ngx-translate/core';
import { MasterDataService } from '../../../master-data.service';
import { AccountTypes } from '../../../../../shared/models/enums/account-types-enum';
import { EmployeeTypes } from '../../../../../shared/models/enums/employee-types.enum';
import { ResponseModel } from '../../../../../shared/models/api-models/api-models';
import { Observable } from 'rxjs';
import { WebApplication } from '../../../../../shared/models/enums/web-application.enum';
import { ConstantConfigurations } from '../../../../../shared/models/constants/constant-configuration';
import { SessionDataProvider } from '../../../../../core/session-data-provider.service';
import { AuthService } from '../../../../../core/auth/auth.service';
import { ConstantStorage } from '../../../../../shared/models/constants/constant-stroage';
import { AESEncryptionService } from '../../../../../shared/services/EncrDecrService.service';
import { MenuActions } from '../../../../../shared/models/enums/menu-actions-enum';
import { DocumentTypes } from '../../../../../shared/models/enums/document-types.enum';

@Component({
  selector: 'app-employee-entry',
  templateUrl: './employee-entry.component.html',
  styleUrls: ['./employee-entry.component.css']
})
export class EmployeeEntryComponent implements OnInit, OnDestroy {
  @Input() isNewEmployee: boolean = true;
  employeeId: number = -1;
  oldRelatedEmployeeId: number = -1;
  @Input() saveEvent: Observable<void>;
  @Output() onSavingEmployeeEvent = new EventEmitter();
  @Output() closeEmployeeEntrySlider = new EventEmitter();
  saveBtnSubscription: any;
  @Input() employeeIdSignature: string = '';
  isloading: boolean = false;
  currentEmployee: any = null;
  notAllowChangePasswordMsg: string = null;
  navLinks: any[];
  showBasicData: boolean = false;
  showRelatedData: boolean = false;
  showDocumentSequence: boolean = false;
  showSecurityData: boolean = false;
  showAccountData: boolean = false;
  isAllowToChangePassword = true;
  // accountsDivisionData: any;
  oldPassword: string;
  originalOrg = -1;
  public employeeDetailsForm: FormGroup;

  //#region  [Account Division Level]
  controlTransactionOnDivisionLevel: boolean = false;
  checkCreditLimitOnEmployeeDivisionAccount: boolean = false;
  divisionAccountsList: any[] = [];
  tempList: any[];
  //#endregion
  //#region [document sequence data]
  applyDocumentSequenceOnDivisionLevel: boolean = false;
  employeeDocumentSequenceList: EmployeeDocumentSequence[] = [];
  //#endregion

  disableCurrency: boolean = false;
  forceActiveDirectoryLogin: boolean = false;
  enableActiveDirectoryLogin: boolean = false;
  showOrginzationAcess: boolean = false;
  constructor(
    public coreSession: CoreSession,
    private employeeService: EmployeeService,
    private translateService: TranslateService,
    private masterDataService: MasterDataService,
    private sessionData: SessionDataProvider,
    private authService: AuthService,
    private secService: AESEncryptionService,

  ) {
  }


  ngOnInit() {

    this.coreSession.hideEmployeeEntrySliderFooter = false;
    this.enableActiveDirectoryLogin = this.sessionData.getConfigurationValue(ConstantConfigurations.EnableActiveDirectoryLogin).toLowerCase() === "true";
    this.forceActiveDirectoryLogin = this.enableActiveDirectoryLogin && this.sessionData.getConfigurationValue(ConstantConfigurations.ForceActiveDirectoryLogin).toLowerCase() === "true";
    this.subscribeSaveClick();
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.employeeURL, MenuActions.AccessSecurityData)) {
      this.showOrginzationAcess = true
    }
    if (!this.isNewEmployee && this.employeeIdSignature && this.employeeIdSignature != '') {
      this.coreSession.SetTitle('Edit Employee');
      this.fillEmployeeDataInEditMode();
    } else {
      this.employeeId = -1;
      this.employeeIdSignature = '';
      this.isNewEmployee = true;
      this.coreSession.SetTitle('Add Employee');
      this.prepareNavigation();
      if (!this.applyDocumentSequenceOnDivisionLevel) {
        this.employeeDocumentSequenceList = [];
        this.employeeDocumentSequenceList.push(new EmployeeDocumentSequence(this.employeeId, -1));
      }
      this.fillDefaultFormPropertiesInAddMode();
      this.initForm();
      this.navLinks[0].isActive = true;
      this.showBasicData = true;


    }

  }
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.saveEvent.subscribe(() => {
      this.onSaveButtonClick();
    });
  }
  AllowChangePassword() {
    this.employeeService.getAllowChangePassword(this.currentEmployee.operatorId).subscribe(
      (response: ResponseModel) => {
        if (response.status != null && response.status >= 0) {
          this.isAllowToChangePassword = response.data;
          if (this.isAllowToChangePassword) {
            this.employeeDetailsForm.get('securityData').get('operatorPassword').enable();
            this.employeeDetailsForm.get('securityData').get('confirmPassword').enable();
            this.employeeDetailsForm.get('securityData').get('operatorName').enable();
          }
          else {
            this.employeeDetailsForm.get('securityData').get('operatorPassword').disable();
            this.employeeDetailsForm.get('securityData').get('confirmPassword').disable();
            this.employeeDetailsForm.get('securityData').get('operatorName').disable();
          }
        } else {
          this.isAllowToChangePassword = false;
          this.employeeDetailsForm.get('securityData').get('operatorPassword').disable();
          this.employeeDetailsForm.get('securityData').get('confirmPassword').disable();
          this.employeeDetailsForm.get('securityData').get('operatorName').disable();
          //this.notAllowChangePasswordMsg = this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          this.notAllowChangePasswordMsg = response.message;

        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }
  fillEmployeeDataInEditMode() {
    this.isloading = true;
    this.employeeService.getEmployeeData(this.employeeIdSignature).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.currentEmployee = response.data;

          // decrypt data
          if (this.currentEmployee.operatorPassword && this.currentEmployee.operatorPassword != '') {
            var data = this.secService.decryptData(this.currentEmployee.operatorPassword, this.coreSession.CurrentOperator.employeeId);
            if (data) {
              this.currentEmployee.operatorPassword = JSON.parse(data);
            } else {
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
              this.closeEmployeeEntrySlider.emit();
            }
          } else {
            this.currentEmployee.operatorPassword = '';
          }
          if (this.currentEmployee.operatorName && this.currentEmployee.operatorName != '') {
            var data = this.secService.decryptData(this.currentEmployee.operatorName, this.coreSession.CurrentOperator.employeeId);
            if (data) {
              this.currentEmployee.operatorName = JSON.parse(data);
            } else {
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
              this.closeEmployeeEntrySlider.emit();
            }
          } else {
            this.currentEmployee.operatorName = '';
          }


          this.oldPassword = this.currentEmployee.operatorPassword;
          this.originalOrg = this.currentEmployee.organizationId;
          // set employee id not encrypted value

          this.employeeId = this.currentEmployee.employeeId;
          this.oldRelatedEmployeeId = this.currentEmployee.relatedEmployeeId;
          this.divisionAccountsList = response.data.accountsDivision;
          if (this.currentEmployee.accountId != -1 && this.currentEmployee.account.balance > 0) {
            this.disableCurrency = true;
          }
          if (this.currentEmployee.employeeDocumentSequenceList == null) {
            if (!this.applyDocumentSequenceOnDivisionLevel) {
              this.employeeDocumentSequenceList = [];
              this.employeeDocumentSequenceList.push(new EmployeeDocumentSequence(this.employeeId, -1));
            }
          } else {
            this.employeeDocumentSequenceList = this.currentEmployee.employeeDocumentSequenceList;
            this.employeeDocumentSequenceList[0].documentSequenceList = this.employeeDocumentSequenceList[0].documentSequenceList
            .filter((document) =>
                document.key === DocumentTypes.Invoice.valueOf() ||
                document.key === DocumentTypes.Order.valueOf() ||
                document.key === DocumentTypes.NewCustomerCode.valueOf() ||
                document.key === DocumentTypes.OrderInvoice.valueOf() ||
                document.key === DocumentTypes.DeliveryNote.valueOf() ||
                document.key === DocumentTypes.Promotion.valueOf() ||
                document.key === DocumentTypes.CustomerCode.valueOf()
            );


          }
          this.prepareNavigation();
          this.initForm();
          this.navLinks[0].isActive = true;
          this.showBasicData = true;
          this.isloading = false;
          if (this.currentEmployee.employeeId == this.coreSession.CurrentOperator.employeeId && !this.currentEmployee.isActiveDirectoryLogin) {
            this.AllowChangePassword();
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  fillDefaultFormPropertiesInAddMode() {
    this.currentEmployee = {
      employeeIdSignature: '',
      employeeId: -1,
      operatorId: -1,
      accountId: -1,
      isNewEmployee: true,
      employeeName: null,
      isOperatorLinkedWithOperatorPrivilege: false,
      descriptionLanguages: [],
      statusReasonId: -1,
      employeeCode: null,
      phone: null,
      mobile: null,
      email: null,
      nationalIDNumber: null,
      organizationId: null,
      employeeTypeId: null,
      onHold: false,
      inactive: false,
      outSource: false,
      status: '',
      organizationName: '',
      organizationCode: '',
      organizationCodeName: '',
      employeeTypeName: '',

      divisions: [],
      defaultDivisionId: null,
      deviceSerial: null,
      driverId: null,
      helperId: null,
      channelId: null,
      contactCountryId: null,
      employeeBranchId: null,
      regionId: null,
      vehicleId: null,
      truckId: null,
      relatedEmployeeTypeId: null,
      relatedEmployeeId: null,
      territoryId: null,
      warehouses: [],

      isFrontOfficUser: false,
      operatorName: '',
      operatorPassword: '',
      oldPassword: '',
      allowToChangePassword: null,
      confirmPassword: '',
      securityGroups: [],
      isActiveDirectoryLogin: this.forceActiveDirectoryLogin ? true : false,

      employeeDocumentSequenceList: this.employeeDocumentSequenceList,
      maxCustomerCode: null,
      newCustomerCode: null,
      account: {
        accountId: -1,
        organizationId: '',
        currencyId: '',
        creditLimit: '',
        balance: 0,

        accountTypeId: AccountTypes.EmployeeAccount.valueOf(),
        gl: false,
        commitmentLimit: 0,
        parentAccountId: -1,
        divisionId: -1,

        currencyName: '',
        organizationName: '',
        divisionCodeName: '',
        accountName: '',
        typeName: '',
      }
    }
  }
  initForm() {
    this.employeeDetailsForm = new FormGroup({

      'basicData': new FormGroup({
        employeeName: new FormControl(this.currentEmployee.employeeName, Validators.required),
        employeeCode: new FormControl(this.currentEmployee.employeeCode, Validators.required),
        employeePhone: new FormControl(this.currentEmployee.phone),
        employeeMobile: new FormControl(this.currentEmployee.mobile),
        employeeEmail: new FormControl(this.currentEmployee.email, [Validators.email, Validators.pattern('^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$')]),
        employeeNationalId: new FormControl(this.currentEmployee.nationalIDNumber),
        organizationId: new FormControl(this.currentEmployee.organizationId, Validators.required),
        employeeTypeId: new FormControl(this.currentEmployee.employeeTypeId, Validators.required),
        isOnHold: new FormControl(this.currentEmployee.onHold),
        isInactive: new FormControl(this.currentEmployee.inactive),
        isOutSource: new FormControl(this.currentEmployee.outSource),
        descriptionLanguages: new FormControl(this.currentEmployee.descriptionLanguages),
        reasonId: new FormControl(null)
      }),
      'relatedData': new FormGroup({
        divisions: new FormControl(this.currentEmployee.divisions),
        defaultDivisionId: new FormControl(this.currentEmployee.defaultDivisionId === -1 ? null : this.currentEmployee.defaultDivisionId),
        deviceSerial: new FormControl(this.currentEmployee.deviceSerial == '' ? null : this.currentEmployee.deviceSerial),
        vehicleId: new FormControl(this.currentEmployee.vehicleId === -1 ? null : this.currentEmployee.vehicleId),
        truckId: new FormControl(this.currentEmployee.truckId === -1 ? null : this.currentEmployee.truckId),
        territoryId: new FormControl(this.currentEmployee.territoryId === -1 ? null : this.currentEmployee.territoryId),
        helperId: new FormControl(this.currentEmployee.helperId === -1 ? null : this.currentEmployee.helperId),
        regionId: new FormControl(this.currentEmployee.regionId === -1 ? null : this.currentEmployee.regionId),
        channelId: new FormControl(this.currentEmployee.channelId === -1 ? null : this.currentEmployee.channelId),
        contactCountryId: new FormControl(this.currentEmployee.contactCountryId === -1 ? null : this.currentEmployee.contactCountryId),
        employeeBranchId: new FormControl(this.currentEmployee.employeeBranchId === -1 ? null : this.currentEmployee.employeeBranchId),
        driverId: new FormControl(this.currentEmployee.driverId === -1 ? null : this.currentEmployee.driverId),
        relatedEmployeeTypeId: new FormControl(this.currentEmployee.relatedEmployeeTypeId === -1 ? null : this.currentEmployee.relatedEmployeeTypeId),
        relatedEmployeeId: new FormControl(this.currentEmployee.relatedEmployeeId === -1 ? null : this.currentEmployee.relatedEmployeeId),
        warehouses: new FormControl(this.currentEmployee.warehouses),
        organizationsAccessList: new FormControl(this.currentEmployee.organizationsAccessList),
        customerId: new FormControl(this.currentEmployee.customerId === -1 ? null : this.currentEmployee.customerId),
        outletId: new FormControl(),
        customerID_outletID: new FormControl(this.currentEmployee.customerID_OutletID),
        itemsList: new FormControl(this.currentEmployee.itemsList),
      }),

      'securityData': new FormGroup({
        operatorName: new FormControl(this.currentEmployee.operatorName == '' ? null : this.currentEmployee.operatorName),
        // operatorPassword: new FormControl({ value: this.currentEmployee.operatorPassword == '' ? null : this.currentEmployee.operatorPassword, disabled: false }),
        // confirmPassword: new FormControl({ value: this.currentEmployee.operatorPassword == '' ? null : this.currentEmployee.operatorPassword, disabled: false }),
        operatorPassword: new FormControl({ value: null, disabled: !this.enableActiveDirectoryLogin ? false : this.currentEmployee.isActiveDirectoryLogin || this.forceActiveDirectoryLogin }),
        confirmPassword: new FormControl({ value: null, disabled: !this.enableActiveDirectoryLogin ? false : this.currentEmployee.isActiveDirectoryLogin || this.forceActiveDirectoryLogin }),
        securityGroups: new FormControl(this.currentEmployee.securityGroups),
        securityGroupsTemp: new FormControl(this.currentEmployee.securityGroups),
        forceLogout: new FormControl(false),
        isActiveDirectoryLogin: new FormControl({ value: this.forceActiveDirectoryLogin ? true : !this.enableActiveDirectoryLogin ? false : this.currentEmployee.isActiveDirectoryLogin, disabled: this.forceActiveDirectoryLogin }),
      }),
      'documentSequenceData': new FormGroup({
        employeeDocumentSequenceList: new FormControl(this.currentEmployee.employeeDocumentSequenceList),
        newCustomerCode: new FormControl(this.currentEmployee.newCustomerCode),
        maxCustomerCode: new FormControl(this.currentEmployee.maxCustomerCode),
        salesChannelDocumentSequenceList: new FormControl(this.currentEmployee.salesChannelDocumentSequenceList != null ? this.currentEmployee.salesChannelDocumentSequenceList : []),
      }),
      'accountData': new FormGroup({
        currencyId: new FormControl({
          value: this.currentEmployee.account.currencyId === -1 || this.currentEmployee.account.currencyId.toString().trim() === '' || this.currentEmployee.account.currencyId.toString().trim().length === 0
            ? null : this.currentEmployee.account.currencyId, disabled: this.disableCurrency
        }, Validators.required),
        balance: new FormControl({ value: this.currentEmployee.account.balance, disabled: true }),
        creditLimit: new FormControl(this.currentEmployee.account.creditLimit, Validators.required),
        currencyName: new FormControl(this.currentEmployee.account.currencyName)
      }),
      'accountsDivisionList': new FormGroup({
        accountsData: new FormControl(this.divisionAccountsList, this.isDivisionLevel ? Validators.required : null)
      })
    })
  }

  //#region [Methods]
  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_User_Definition',
        index: 0,
        isActive: false
      },
      {
        label: ConstantMessages.LblRelatedData,
        index: 1,
        isActive: false
      },
      {
        label: ConstantMessages.LblDocumentSequenceData,
        index: 2,
        isActive: false
      },
    ];
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.employeeURL, MenuActions.AccessSecurityData)) {
      this.navLinks.push({
        label: ConstantMessages.LblSecurityData,
        index: 3,
        isActive: false
      });
    }
    // if (this.coreSession.cachedGeneralData.webApplication === WebApplication.Sonic) {
    //   this.navLinks.push({
    //     label: ConstantMessages.LblAccountData,
    //     index: 4,
    //     isActive: false
    //   });
    // }
  }
  triggerToStartTourBasicData = false;
  triggerToStartTourRelatedData = false;
  triggerToStartTourDocemonetSecuanceData = false;
  triggerToStartTourSecuityData = false;
  triggerToStartTourAccountData = false


  showEntrySection(selectedIndex: number) {
    if (selectedIndex > 0) {
      if (this.employeeDetailsForm.get('basicData').invalid) {
        if (this.employeeDetailsForm.get('basicData').get('employeeEmail').invalid) {
          this.employeeDetailsForm.get('basicData').get('employeeEmail').markAsTouched();
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgEmailSyntax));
          return;
        }
        else {
          this.coreSession.markFormGroupTouched(this.employeeDetailsForm);
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
          return;
        }
      }
    }
    this.clearSelection();

    if (selectedIndex == 0) {
      this.showBasicData = true;
      this.triggerToStartTourBasicData = true;
    }
    else if (selectedIndex == 1) {
      this.showRelatedData = true;
      this.triggerToStartTourRelatedData = true;
    }
    else if (selectedIndex == 2) {
      this.showDocumentSequence = true;
      this.triggerToStartTourDocemonetSecuanceData = true
    }
    else if (selectedIndex == 3) {
      this.showSecurityData = true;
      this.triggerToStartTourSecuityData = true
    }
    else if (selectedIndex == 4) {
      this.showAccountData = true;
      this.triggerToStartTourAccountData = true
    }
    this.navLinks[selectedIndex].isActive = true;
  }
  clearSelection() {
    this.showBasicData = false;
    this.showRelatedData = false;
    this.showDocumentSequence = false;
    this.showSecurityData = false;
    this.showAccountData = false;
    this.triggerToStartTourAccountData = false
    // this.triggerToStartTourSecuityData = false
    this.triggerToStartTourDocemonetSecuanceData = false
    this.triggerToStartTourRelatedData = false;
    this.triggerToStartTourBasicData = false;


    this.navLinks.forEach(a => a.isActive = false);
  }
  //#endregion

  //#region [Getters]
  get employeeCodeInput() {
    return this.employeeDetailsForm.get('basicData').get('employeeCode');
  }
  get employeeOrganizationIdInput() {
    return this.employeeDetailsForm.get('basicData').get('organizationId');
  }
  get employeeTypeIdInput() {
    return this.employeeDetailsForm.get('basicData').get('employeeTypeId');
  }
  //#endregion

  prepareEmployeeObject() {
    let descriptions = [];
    let isAllDivisions = true;
    if (this.employeeDetailsForm.get('basicData').get('descriptionLanguages').value != null) {
      descriptions = this.employeeDetailsForm.get('basicData').get('descriptionLanguages').value;
      if (descriptions.find(x => x.languageId === this.coreSession.selectedLanguageId) == null) {
        descriptions.push({
          languageId: this.coreSession.selectedLanguageId,
          description: this.employeeDetailsForm.get('basicData').get('employeeName').value
        });
      }
    }
    if (!this.applyDivisionsOnDocumentSequence())
      this.employeeDetailsForm.get('documentSequenceData').get('employeeDocumentSequenceList').setValue(this.employeeDocumentSequenceList);
    let currencyId = -1;
    if (this.disableCurrency) {
      currencyId = this.currentEmployee.account.currencyId;
    } else if (this.employeeDetailsForm.value.accountData.currencyId != '' && this.employeeDetailsForm.value.accountData.currencyId != null) {
      currencyId = this.employeeDetailsForm.value.accountData.currencyId;
    }
    let creditLimit = 0;
    if (this.employeeDetailsForm.value.accountData.creditLimit != '' && this.employeeDetailsForm.value.accountData.creditLimit != null) {
      creditLimit = +this.employeeDetailsForm.value.accountData.creditLimit;
    }

    // Fill Account Data
    let accountObject = {
      accountId: this.currentEmployee.account.accountId,
      organizationId: this.employeeDetailsForm.value.basicData.organizationId,
      currencyId: currencyId,
      creditLimit: creditLimit,
      balance: this.currentEmployee.account.balance,

      accountTypeId: AccountTypes.EmployeeAccount.valueOf(),
      gl: this.currentEmployee.account.gl,
      commitmentLimit: this.currentEmployee.account.commitmentLimit,
      parentAccountId: -1,
      divisionId: -1,

      currencyName: '',
      organizationName: '',
      divisionCodeName: '',
      accountName: '',
      typeName: '',
    };

    if (
      this.coreSession.CurrentOperator.employeeId === this.employeeId &&
      !this.isNewEmployee
    ) {
      isAllDivisions = false;
    }

    let organizationId = this.employeeDetailsForm.get('basicData').get('organizationId').value;
    let organizationsAccessList = this.employeeDetailsForm.get('relatedData').get('organizationsAccessList').value ? this.employeeDetailsForm.get('relatedData').get('organizationsAccessList').value : [];
    // Adding selected organization to organizations access list
    if (organizationsAccessList.findIndex(o => o.organizationId === organizationId) < 0) {
      let org = {
        organizationId: organizationId,
        organizationCodeName: ''
      }
      organizationsAccessList.push(org);
    }
    let employee = {
      employeeIdSignature: this.employeeIdSignature,
      employeeId: this.employeeId,
      accountId: this.currentEmployee.account.accountId,
      operatorId: this.currentEmployee.operatorId,
      isNewEmployee: this.isNewEmployee,
      employeeName: this.employeeDetailsForm.get('basicData').get('employeeName').value == null ? '' : this.employeeDetailsForm.get('basicData').get('employeeName').value,
      employeeCode: this.employeeDetailsForm.get('basicData').get('employeeCode').value == null ? '' : this.employeeDetailsForm.get('basicData').get('employeeCode').value,
      phone: this.employeeDetailsForm.get('basicData').get('employeePhone').value == null ? '' : this.employeeDetailsForm.get('basicData').get('employeePhone').value,
      mobile: this.employeeDetailsForm.get('basicData').get('employeeMobile').value == null ? '' : this.employeeDetailsForm.get('basicData').get('employeeMobile').value,
      email: this.employeeDetailsForm.get('basicData').get('employeeEmail').value == null ? '' : this.employeeDetailsForm.get('basicData').get('employeeEmail').value,
      nationalIDNumber: this.employeeDetailsForm.get('basicData').get('employeeNationalId').value == null ? '' : this.employeeDetailsForm.get('basicData').get('employeeNationalId').value,
      organizationId: organizationId,
      employeeTypeId: this.employeeDetailsForm.get('basicData').get('employeeTypeId').value == null ? '' : this.employeeDetailsForm.get('basicData').get('employeeTypeId').value,
      onHold: this.employeeDetailsForm.get('basicData').get('isOnHold').value == null ? false : this.employeeDetailsForm.get('basicData').get('isOnHold').value,
      inactive: this.employeeDetailsForm.get('basicData').get('isInactive').value == null ? false : this.employeeDetailsForm.get('basicData').get('isInactive').value,
      outSource: this.employeeDetailsForm.get('basicData').get('isOutSource').value == null ? false : this.employeeDetailsForm.get('basicData').get('isOutSource').value,
      statusReasonId: this.employeeDetailsForm.get('basicData').get('reasonId').value == null ? -1 : this.employeeDetailsForm.get('basicData').get('reasonId').value,
      status: '',
      organizationName: '',
      organizationCode: '',
      organizationCodeName: '',
      employeeTypeName: '',
      descriptionLanguages: descriptions,

      divisions: this.employeeDetailsForm.get('relatedData').get('divisions').value == null ? [] : this.employeeDetailsForm.get('relatedData').get('divisions').value,
      defaultDivisionId: this.employeeDetailsForm.get('relatedData').get('defaultDivisionId').value == null ? -1 : this.employeeDetailsForm.get('relatedData').get('defaultDivisionId').value,
      deviceSerial: this.employeeDetailsForm.get('relatedData').get('deviceSerial').value == null ? '' : this.employeeDetailsForm.get('relatedData').get('deviceSerial').value,
      driverId: this.employeeDetailsForm.get('relatedData').get('driverId').value == null ? -1 : this.employeeDetailsForm.get('relatedData').get('driverId').value,
      helperId: this.employeeDetailsForm.get('relatedData').get('helperId').value == null ? -1 : this.employeeDetailsForm.get('relatedData').get('helperId').value,
      channelId: this.employeeDetailsForm.get('relatedData').get('channelId').value == null ? -1 : this.employeeDetailsForm.get('relatedData').get('channelId').value,
      contactCountryId: this.employeeDetailsForm.get('relatedData').get('contactCountryId').value == null ? -1 : this.employeeDetailsForm.get('relatedData').get('contactCountryId').value,
      employeeBranchId: this.employeeDetailsForm.get('relatedData').get('employeeBranchId').value == null ? -1 : this.employeeDetailsForm.get('relatedData').get('employeeBranchId').value,
      regionId: this.employeeDetailsForm.get('relatedData').get('regionId').value == null ? -1 : this.employeeDetailsForm.get('relatedData').get('regionId').value,
      vehicleId: this.employeeDetailsForm.get('relatedData').get('vehicleId').value == null ? -1 : this.employeeDetailsForm.get('relatedData').get('vehicleId').value,
      truckId: this.employeeDetailsForm.get('relatedData').get('truckId').value == null ? -1 : this.employeeDetailsForm.get('relatedData').get('truckId').value,
      relatedEmployeeTypeId: this.employeeDetailsForm.get('relatedData').get('relatedEmployeeTypeId').value == null ? -1 : this.employeeDetailsForm.get('relatedData').get('relatedEmployeeTypeId').value,
      relatedEmployeeId: this.employeeDetailsForm.get('relatedData').get('relatedEmployeeId').value == null ? -1 : this.employeeDetailsForm.get('relatedData').get('relatedEmployeeId').value,
      oldRelatedEmployeeId: this.oldRelatedEmployeeId,
      territoryId: this.employeeDetailsForm.get('relatedData').get('territoryId').value == null ? -1 : this.employeeDetailsForm.get('relatedData').get('territoryId').value,
      warehouses: this.employeeDetailsForm.get('relatedData').get('warehouses').value == null ? [] : this.employeeDetailsForm.get('relatedData').get('warehouses').value,
      customerId: this.employeeDetailsForm.get('relatedData').get('customerId').value == null ? -1 : this.employeeDetailsForm.get('relatedData').get('customerId').value,
      customerID_outletID: this.employeeDetailsForm.get('relatedData').get('customerID_outletID').value == null ? '' : this.employeeDetailsForm.get('relatedData').get('customerID_outletID').value,
      organizationsAccessList: organizationsAccessList,

      isFrontOfficUser: false,
      operatorName: this.employeeDetailsForm.get('securityData').get('operatorName').value == null ? '' : this.employeeDetailsForm.get('securityData').get('operatorName').value,
      // * if isActiveDirectoryLogin true that means we cash password null or empty and isActiveDirectoryLogin
      // is true only when the config enableActiveDirectory true *
      operatorPassword: this.employeeDetailsForm.get('securityData').get('isActiveDirectoryLogin').value == true && this.employeeDetailsForm.get('basicData').get('employeeTypeId').value != EmployeeTypes.Salesperson ? '' : this.employeeDetailsForm.get('securityData').get('operatorPassword').value == null || this.employeeDetailsForm.get('securityData').get('operatorPassword').value == '' ? this.currentEmployee.operatorPassword : this.employeeDetailsForm.get('securityData').get('operatorPassword').value,
      confirmPassword: this.employeeDetailsForm.get('securityData').get('isActiveDirectoryLogin').value == true && this.employeeDetailsForm.get('basicData').get('employeeTypeId').value != EmployeeTypes.Salesperson ? '' : this.employeeDetailsForm.get('securityData').get('confirmPassword').value == null || this.employeeDetailsForm.get('securityData').get('confirmPassword').value == '' ? this.currentEmployee.operatorPassword : this.employeeDetailsForm.get('securityData').get('confirmPassword').value,
      oldPassword: this.oldPassword,
      securityGroups: this.employeeDetailsForm.get('securityData').get('securityGroups').value == null ? [] : this.employeeDetailsForm.get('securityData').get('securityGroups').value,
      isActiveDirectoryLogin: this.employeeDetailsForm.get('securityData').get('isActiveDirectoryLogin').value == null ? false : this.employeeDetailsForm.get('securityData').get('isActiveDirectoryLogin').value,
      allowToChangePassword: this.isAllowToChangePassword,
      employeeDocumentSequenceList: this.employeeDetailsForm.get('documentSequenceData').get('employeeDocumentSequenceList').value == null ? [] : this.employeeDetailsForm.get('documentSequenceData').get('employeeDocumentSequenceList').value,
      newCustomerCode: this.employeeDetailsForm.get('documentSequenceData').get('newCustomerCode').value == null ? '' : this.employeeDetailsForm.get('documentSequenceData').get('newCustomerCode').value,
      maxCustomerCode: this.employeeDetailsForm.get('documentSequenceData').get('maxCustomerCode').value == null ? '' : this.employeeDetailsForm.get('documentSequenceData').get('maxCustomerCode').value,
      salesChannelDocumentSequenceList: this.employeeDetailsForm.get('documentSequenceData').get('salesChannelDocumentSequenceList').value == null ? [] : this.employeeDetailsForm.get('documentSequenceData').get('salesChannelDocumentSequenceList').value,
      account: accountObject,
      accountsDivision: this.divisionAccountsList,
      itemsList: this.employeeDetailsForm.get('relatedData').get('itemsList').value == null ? [] : this.employeeDetailsForm.get('relatedData').get('itemsList').value,
      EmployeeAccess: isAllDivisions,
    }
    return employee;
  }
  onCancelSaving() {
    // this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgCancelConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
    //   (res: DialogResult) => {
    //     if (res === DialogResult.Yes) {
    //       this.router.navigate([ConstantURLs.employeeURL], { relativeTo: this.route.parent });
    //     }
    //   });
  }
  onSaveButtonClick() {
    if (this.employeeDetailsForm.get('basicData').invalid) {
      if (this.employeeDetailsForm.get('basicData').get('employeeEmail').invalid) {
        this.employeeDetailsForm.get('basicData').get('employeeEmail').markAsTouched();
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgEmailSyntax));
        return;
      }
      else {
        this.coreSession.markFormGroupTouched(this.employeeDetailsForm);
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
        return;
      }
    }
    let userName = this.employeeDetailsForm.get('securityData').get('operatorName').value;
    let password = this.employeeDetailsForm.get('securityData').get('operatorPassword').value;
    let confirmPassword = this.employeeDetailsForm.get('securityData').get('confirmPassword').value;
    let isActiveDirectoryLogin = this.employeeDetailsForm.get('securityData').get('isActiveDirectoryLogin').value;

    var patt = /[^\u0000-\u007F ]+/;
    if (userName != null && userName != '' && userName.replace(patt, "") !== userName) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgEnglishUsername));
      return;
    }
    if (password != null && password != '' && password.replace(patt, "") !== password) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgEnglishPassword));
      return;
    }

    var countOfFilledData = 0;
    var isUserNameDefined = false;
    var isPasswordDefined = false;
    var isConfirmDefined = false;
    if (userName && userName != '') {
      isUserNameDefined = true;
      countOfFilledData += 1;
    }
    if (password && password != '') {
      isPasswordDefined = true;
      countOfFilledData += 1;
    }
    if (confirmPassword && confirmPassword != '') {
      isConfirmDefined = true;
      countOfFilledData += 1;
    }
    // if (!this.isNewEmployee && countOfFilledData == 0 && this.currentEmployee.operatorName && this.currentEmployee.operatorName != "") {
    //   this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MessageCannotDeleteOperator));
    //   return;
    // }
    if (!this.isNewEmployee && !isUserNameDefined && this.currentEmployee.operatorName && this.currentEmployee.operatorName != "") {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MessageCannotDeleteOperator));
      return;
    }
    // if (countOfFilledData > 0 && countOfFilledData < 3) {
    //   this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillOperatorDataCorrectly));
    //   return;
    // }
    if (!isActiveDirectoryLogin) {

      if (this.isNewEmployee && countOfFilledData > 0 && countOfFilledData < 3) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillOperatorDataCorrectly));
        return;
      }
      if ((isPasswordDefined && !isConfirmDefined) || (isConfirmDefined && !isPasswordDefined) || (!isUserNameDefined && isConfirmDefined && isPasswordDefined)) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillOperatorDataCorrectly));
        return;
      }
      if (password != null && password != '') {
        if (password != confirmPassword) {
          if (this.isNewEmployee || ((!this.isNewEmployee && this.isAllowToChangePassword && this.oldPassword != this.employeeDetailsForm.get('securityData').get('operatorPassword').value))) {
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgPasswordsNotMatches));
            return;
          }
        }
      }
      // if (countOfFilledData === 0 && this.employeeDetailsForm.get('securityData').get('securityGroups').value && this.employeeDetailsForm.get('securityData').get('securityGroups').value.length > 0) {
      //   this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgCantSaveSecurityGroupsWithoutOperator));
      //   return;
      // }

      if (this.isNewEmployee && countOfFilledData != 3 && this.employeeDetailsForm.get('securityData').get('securityGroups').value && this.employeeDetailsForm.get('securityData').get('securityGroups').value.length > 0) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgCantSaveSecurityGroupsWithoutOperator));
        return;
      }

      if (!this.isNewEmployee && (countOfFilledData != 3 && (!isUserNameDefined || this.currentEmployee.operatorPassword == '' || this.currentEmployee.operatorPassword == null))
        && this.employeeDetailsForm.get('securityData').get('securityGroups').value && this.employeeDetailsForm.get('securityData').get('securityGroups').value.length > 0) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgCantSaveSecurityGroupsWithoutOperator));
        return;
      }
    }
    // if (countOfFilledData === 0 && this.currentEmployee.isOperatorLinkedWithOperatorPrivilege) {
    //   this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MessageCannotDeleteOperatorPrivilege));
    //   return;
    // }

    if (!isUserNameDefined && this.currentEmployee.isOperatorLinkedWithOperatorPrivilege) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MessageCannotDeleteOperatorPrivilege));
      return;
    }

    // let salesPersonOrDelivery = this.employeeDetailsForm.value.basicData.employeeTypeId === EmployeeTypes.Salesperson.valueOf()
    //   || this.employeeDetailsForm.value.basicData.employeeTypeId === EmployeeTypes.Deliveryperson.valueOf();

    // if (this.employeeDetailsForm.get('accountData').invalid) {
    //   if (salesPersonOrDelivery || this.currentEmployee.account.accountId != -1) {
    //     // Block Saving if employee type is sales person or delivery or if account is previously defined for that employee
    //     this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillEmployeeAccount));
    //     return;
    //   }
    // }
    this.showConfirmationMsgAndSavdData();
  }
  showConfirmationMsgAndSavdData() {
    var confirmationMsg = [];
    let checkExceedLimitEmployee = this.isDivisionLevel() ? this.checkExceedLimitEmployee(this.prepareEmployeeObject()) : true;
    if (this.applyDivisionsOnDocumentSequence()) {
      let docuemtSeqDivisionsList = [];
      docuemtSeqDivisionsList = this.employeeDetailsForm.get('documentSequenceData').get('employeeDocumentSequenceList').value;
      if (docuemtSeqDivisionsList && docuemtSeqDivisionsList.length > 0) {
        for (let docIndex = 0; docIndex < docuemtSeqDivisionsList.length; docIndex++) {
          if (docuemtSeqDivisionsList[docIndex].documentSequenceList.findIndex(x => (x.value && x.value.length > 0)) === -1) {
            confirmationMsg.push(this.translateService.instant(ConstantMessages.MsgEmployeeNoDocSeqWarnings));
            break;
          }
        }
      }

    } else {
      for (let docIndex = 0; docIndex < this.employeeDocumentSequenceList.length; docIndex++) {
        if (this.employeeDocumentSequenceList[docIndex].documentSequenceList.findIndex(x => (x.value && x.value.length > 0)) === -1) {
          confirmationMsg.push(this.translateService.instant(ConstantMessages.MsgEmployeeNoDocSeqWarnings));
          break;
        }
      }
    }
    if (!this.employeeDetailsForm.get('securityData').get('operatorName').value) {
      confirmationMsg.push(this.translateService.instant(ConstantMessages.MsgEmployeeNoOperatorWarnings));
    }
    if (!this.employeeDetailsForm.get('securityData').get('securityGroups').value || this.employeeDetailsForm.get('securityData').get('securityGroups').value.length == 0) {
      confirmationMsg.push(this.translateService.instant(ConstantMessages.MsgEmployeeNoSecurityWarnings));
    }
    // if (this.employeeDetailsForm.get('accountData').invalid) {
    //   if (this.employeeDetailsForm.get('accountData').get('currencyId').invalid) {
    //     confirmationMsg.push(this.translateService.instant(ConstantMessages.MsgEmployeeNoAccountWarnings));
    //   }
    //   else if (this.employeeDetailsForm.get('accountData').get('creditLimit').invalid) {
    //     confirmationMsg.push(this.translateService.instant(ConstantMessages.MsgEmployeeNoCrediltLimitAccountWarnings));
    //   }
    // }
    // if (!this.employeeDetailsForm.get('relatedData').get('customerId').value &&
    //   (this.employeeDetailsForm.get('basicData').get('employeeTypeId').value == EmployeeTypes.Collector.valueOf() ||
    //     this.employeeDetailsForm.get('basicData').get('employeeTypeId').value == EmployeeTypes.Deliveryperson.valueOf() ||
    //     this.employeeDetailsForm.get('basicData').get('employeeTypeId').value == EmployeeTypes.Driver.valueOf() ||
    //     this.employeeDetailsForm.get('basicData').get('employeeTypeId').value == EmployeeTypes.Merchandiser.valueOf() ||
    //     this.employeeDetailsForm.get('basicData').get('employeeTypeId').value == EmployeeTypes.Presales.valueOf() ||
    //     this.employeeDetailsForm.get('basicData').get('employeeTypeId').value == EmployeeTypes.Salesperson.valueOf() ||
    //     this.employeeDetailsForm.get('basicData').get('employeeTypeId').value == EmployeeTypes.VanInCharge.valueOf())

    // ) {
    //   confirmationMsg.push(this.translateService.instant(ConstantMessages.MsgThereIsNoLinkedCustomerToEmployee));
    // }


    if (confirmationMsg.length > 0 && checkExceedLimitEmployee) {
      this.coreSession.ModalDialog.ShowMessageList(
        this.translateService.instant(ConstantMessages.MsgFillEmployeeDataConfirmation),
        confirmationMsg,
        DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
          (res: DialogResult) => {
            if (res === DialogResult.Yes) {
              this.saveEmployee();
            }
            else return;
          }
        );
    } else {
      if (checkExceedLimitEmployee)
        this.saveEmployee();
    }
  }
  saveEmployee() {
    // Prepare Employee Object
    let employee = this.prepareEmployeeObject();
    // Validate : unique code, unique user name, password length, strong password, used password
    if (employee != null) {
      // this.coreSession.ModalLoading.Show();
      // this.employeeService.validateEmployeeToSave(employee).subscribe(response => {
      //   this.coreSession.ModalLoading.Hide();
      //   if (response.status != null && response.status >= 0) {
      //     if (!response.data.isValid) {
      //       this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), response.data.errorMessage);
      //     }
      //     else {
      this.saveEmployeeToDB(employee);
      //     }
      //   }
      //   else {
      //     this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      //   }
      // }, (error: HttpErrorResponse) => {
      //   this.coreSession.ModalLoading.Hide();
      //   this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      // }
      // );
    }

  }
  saveEmployeeToDB(employee) {
    if (employee != null) {
      employee.expirationDate = this.authService.getTokenExpirationDate();
      this.employeeService.saveEmployee(employee, this.isNewEmployee).subscribe(response => {
        if (response.status != null && response.status >= 0) {
          if (!response.data.isValid) {
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), response.data.errorMessage);
          } else {
            var editLogggedInUser = false;
            var forceLogout = this.employeeDetailsForm.get('securityData').get('forceLogout').value;
            editLogggedInUser = !this.isNewEmployee && employee.employeeId == this.coreSession.CurrentOperator.employeeId;
            if (
              (this.coreSession.CurrentOperator.employeeTypeId == EmployeeTypes.Director.valueOf() || this.coreSession.CurrentOperator.employeeTypeId == EmployeeTypes.SalesManager.valueOf() || this.coreSession.CurrentOperator.employeeTypeId == EmployeeTypes.Supervisor.valueOf())
              ||
              editLogggedInUser) {
              localStorage.setItem(ConstantStorage.TokenName, response.data.tokenString);
              localStorage.setItem(ConstantStorage.CurrentOperator, JSON.stringify(response.data.currentOperator));
            }
            this.coreSession.showSuccessWithTimeOut(1000, this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
            if (editLogggedInUser && forceLogout) {
              this.coreSession.SetDelay(2000).then((a) => {
                this.authService.logout();
              });
            } else {
              this.onSavingEmployeeEvent.emit();
            }
          }

        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(response.message));
        }
      },
        (error: HttpErrorResponse) => {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );
    }
  }

  isDivisionLevel() {
    let result = false;
    this.controlTransactionOnDivisionLevel = this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true";
    this.checkCreditLimitOnEmployeeDivisionAccount = this.sessionData.getConfigurationValue(ConstantConfigurations.CheckCreditLimitOnEmployeeDivisionAccount).toLowerCase() === "true";
    if (this.controlTransactionOnDivisionLevel && this.checkCreditLimitOnEmployeeDivisionAccount) {
      result = true;
    }
    return result;
  }

  checkExceedLimitEmployee(object: any) {

    let result = true;
    let totalLimit = 0;
    let totalCreditLimitNoAccessDivision = 0;
    if (object && object.accountsDivision && object.accountsDivision.length > 0 && object.account) {
      object.accountsDivision.forEach(x => {
        totalLimit += x.creditLimit;
        if (x.accountId == -1)
          totalCreditLimitNoAccessDivision = x.totalCreditLimit != undefined ? x.totalCreditLimit : 0;
      })
      if ((totalLimit + totalCreditLimitNoAccessDivision) > object.account.creditLimit) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant(ConstantMessages.MsgAccountcreditexceedetheparentcreditlimit));
        result = false;
      }
    }
    return result;
  }

  applyDivisionsOnDocumentSequence() {
    return (this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true"
      && this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyDivisionsOnDocumentSequence).toLowerCase() === "true")
  }
}
