import { Component, OnInit, ViewChild } from '@angular/core';
import { ConstantURLs } from '../../../../../shared/models/constants/constant-URL';
import { SharedTableResult } from '../../../../../shared/models/shared-table/shared-table-result.interface';
import { MultiSelectionOperation, RowOperation } from '../../../../../shared/models/enums/shared-table-operation.enum';
import { ITableProperties } from '../../../../../shared/models/shared-table/table-properties.interface';
import { TranslateService } from '@ngx-translate/core';
import { CoreSession } from '../../../../../core/core.session';
import { EmployeeService } from '../../../../employee/employee.service';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { FormGroup, FormControl } from '@angular/forms';
import { MasterDataService } from '../../../master-data.service';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { SessionDataProvider } from '../../../../../core/session-data-provider.service';
import { WarehouseService } from '../../../../../shared/services/data-definition/warehouse-and-vehicle/warehouse.service';
import { MenuActions } from '../../../../../shared/models/enums/menu-actions-enum';
import { Subject } from 'rxjs';
import { ImportDataTypes } from '../../../../../shared/models/import/ImportDataTypes';
import { SharedDialogComponent } from '../../../../../shared/components/shared-dialog/shared-dialog.component';
import { MasterDataScreens, MasterDataStatus } from '../../../../../shared/models/enums/master-data-screens';
import { ReasonModel } from '../../../../../shared/models/reason-model/reason-model';
import { DivisionService } from '../../../../../shared/services/data-definition/product/division.service';
import { VehicleService } from '../../../../../shared/services/data-definition/warehouse-and-vehicle/vehicle.service';

@Component({
  selector: 'app-employee-list',
  templateUrl: './employee-list.component.html',
  styleUrls: ['./employee-list.component.css']
})
export class EmployeeListComponent implements OnInit {
  employeeFilterForm: FormGroup;
  isFilterOpend: boolean = false;
  @ViewChild('ItemEntryDialog', { static: true }) ItemEntryDialog: SharedDialogComponent;

  isTypesLoading: boolean = false;
  employeeTypesList: any[] = [];

  isVehicleLoading: boolean = false;
  vehicleList: any[] = [];

  isDivisionLoading: boolean = false;
  divisionsList: any[] = [];

  tableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    isOnline: true,
    showSearch: true,
    showSearchBtn: true,
    showNewBtn: false,
    isMultiSelection: false,

    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_UserName', key: 'employeeName', isSortable: true, width: '15%' },
      { title: 'Desc_User_Code', key: 'employeeCode', isSortable: true, width: '15%' },
      { title: 'Desc_User_Type', key: 'employeeTypeName', isSortable: false, width: '10%' },
      { title: 'Desc_Status', key: 'status', isSortable: false, width: '10%' },
      { title: 'Desc_Vendor_Code', key: 'organizationCode', isSortable: true, width: '15%' },
      { title: 'Desc_Vendor', key: 'organizationName', isSortable: true, width: '15%' },
    ]
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  employeeFilter = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: this.coreSession.pageSize
    },
    employeeCodeName: '',
    employeeTypeId: -1,
    organizationId: -1,
    vehicleId: -1,
    divisionId: -1,
    deviceSerial: '',
    securityGroupId: -1,
    territoryId: -1,
    includeInactive: false,
    employeeId: -1,
    employeeBranchId: -1,
  };

  isEditMode = false;
  employeeIdSignature = null;
  showEntrySlider = false;
  saveSubject: Subject<void> = new Subject<void>();
  dataType: ImportDataTypes = ImportDataTypes.Employees;
  entryReasonObject: ReasonModel = null;
  employeeId: -1;
  isActive: false;
  showSharedTable:boolean = true
  constructor(
    public coreSession: CoreSession,
    private employeeService: EmployeeService,
    private translateService: TranslateService,
    private warehouseService: WarehouseService,
    private divisionService: DivisionService,
    private masterDataService: MasterDataService,
    private vehicleService: VehicleService) {
  }

  ngOnInit() {
    this.coreSession.SetTitle('Employees List');
    this.tableData.showNewBtn = this.coreSession.checkActivitiesAvailability(ConstantURLs.employeeURL, MenuActions.Add);
    this.tableData.showImport = this.tableData.showNewBtn;
    this.initForm();
    this.addDeleteAction();
    this.populateEmployeeList();
    this.fillEmployeeTypesList();
    this.fillDivisionsList();
  }
  initForm() {
    this.employeeFilterForm = new FormGroup({
      employeeCodeName: new FormControl(),
      employeeTypeId: new FormControl(),
      organizationId: new FormControl(),
      vehicleId: new FormControl(),
      employeeBranchId: new FormControl(),
      divisionId: new FormControl(),
      deviceSerial: new FormControl(),
      securityGroupId: new FormControl(),
      territoryId: new FormControl(),
      includeInactive: new FormControl(false)
    });
  }

  openItemEntryDialog() {
    this.ItemEntryDialog.Show(true).then((res) => { });
  }
  addDeleteAction() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.employeeURL, MenuActions.Edit)) {

      // this.tableData.rowOperations.push({
      //   operation: RowOperation.Activate,
      //   title: "Desc_Reactivate",
      //   icon: "fa fa-toggle-on",
      //   color: '#02b875',
      //   showWhenKeyValueTrue: true,
      //   showHideOptionPerLine: true,
      //   controlKeyName: 'inactive'
      // });

      this.tableData.rowOperations.push(
        {
          operation: RowOperation.Deactivate,
          title: 'Desc_Deactivate',
          icon: 'fa-solid fa-ban',
          color: '#f1685e',
          showWhenKeyValueFalse: true,
          showHideOptionPerLine: true,
          controlKeyName: 'inactive'
        });

      this.tableData.rowOperations.push({
        operation: RowOperation.edit,
        title: "Desc_Edit",
        icon: "fa-regular fa-pen-to-square",
        color: "#12344d"
      });
    }
  }
  populateEmployeeList() {
    this.coreSession.ModalLoading.Show();
    this.employeeService.getEmployeesList(this.employeeFilter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        // if(response.data.totalItems <= 0){
        //   this.coreSession.ModalDialog.ShowMessage(response.message, DialogMode.Ok);
        // }
        this.dataSource = <SharedTableResult>response.data;
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
    );
  }
  fillEmployeeTypesList() {
    this.employeeTypesList = [];
    this.isTypesLoading = true;
    this.employeeService.getEmployeeTypes().subscribe(result => {
      this.employeeTypesList = result;
      this.isTypesLoading = false;
    });
  }
  fillDivisionsList() {
    this.isDivisionLoading = true;
    this.divisionsList = [];
    this.divisionService.getDivisionsUnderOrgAccess().subscribe(result => {
      this.divisionsList = result;
      this.isDivisionLoading = false;
    });
  }

  onChangeOrganization() {
    this.employeeFilterForm.get('vehicleId').setValue(null);
    this.employeeFilterForm.get('employeeBranchId').setValue(null);
    this.employeeFilterForm.get('deviceSerial').setValue(null);
  }

  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.Deactivate:
        if (event.object.inactive) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgEmployeeIsInactive));
          return;
        } else {
          this.updateEmployeeActiveStatus(event.object, false);
        }
        break;
      case RowOperation.Activate:
        this.updateEmployeeActiveStatus(event.object, true);
        break;
      case RowOperation.edit:
        if (this.coreSession.checkActivitiesAvailability(ConstantURLs.employeeURL, MenuActions.Edit)) {
          this.editEmployeeData(event.object);
        }
        break;
    }
  }

  editEmployeeData(employee: any) {
    this.employeeIdSignature = employee.employeeIdSignature;
    this.isEditMode = true;
    this.showEntrySlider = true;
    this.openItemEntryDialog()
    // this.router.navigate(['/' + ConstantURLs.dataDefinitionURL + '/' + ConstantURLs.staffURL + '/' + ConstantURLs.editEmployeeURL, employee.employeeIdSignature]);
  }
  updateEmployeeActiveStatus(employee: any, isActive) {
    var msg = '';
    if (isActive) {
      msg = ConstantMessages.MsgReactivateConfirmation;
    } else {
      msg = ConstantMessages.MsgDeactivateConfirmation;
    }
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(msg), DialogMode.YesNo).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          this.entryReasonObject = new ReasonModel();
          this.entryReasonObject.titleReason = isActive ? 'Desc_Activation_Reason' : 'Desc_Deactivation_Reason';
          this.entryReasonObject.referenceId = employee.employeeId;
          this.entryReasonObject.status = isActive ? MasterDataStatus.Activate : MasterDataStatus.Deactivate;
          this.entryReasonObject.screenId = MasterDataScreens.Employees;
          this.employeeId = employee.employeeId;
          this.isActive = isActive;
        }
      });
  }

  openFilter() {
    this.isFilterOpend = !this.isFilterOpend;
    this.onReset();
  }
  onTableFilterChanged(query: any) {
    this.employeeFilter.customListFilter = query;

    this.populateEmployeeList();
  }
  ApplySerachFilterOnFind() {
    this.employeeFilter.customListFilter.page = 0;
    this.employeeFilter.customListFilter.pageSize = this.tableData.pageSize;
    this.employeeFilter.employeeTypeId = this.employeeFilterForm.get('employeeTypeId').value == null ? -1 : this.employeeFilterForm.get('employeeTypeId').value;
    this.employeeFilter.organizationId = this.employeeFilterForm.get('organizationId').value == null ? -1 : this.employeeFilterForm.get('organizationId').value;
    this.employeeFilter.vehicleId = this.employeeFilterForm.get('vehicleId').value == null ? -1 : this.employeeFilterForm.get('vehicleId').value;
    this.employeeFilter.employeeBranchId = this.employeeFilterForm.get('employeeBranchId').value == null ? -1 : this.employeeFilterForm.get('employeeBranchId').value;
    this.employeeFilter.divisionId = this.employeeFilterForm.get('divisionId').value == null ? -1 : this.employeeFilterForm.get('divisionId').value;
    this.employeeFilter.deviceSerial = this.employeeFilterForm.get('deviceSerial').value;
    this.employeeFilter.securityGroupId = this.employeeFilterForm.get('securityGroupId').value == null ? -1 : this.employeeFilterForm.get('securityGroupId').value;
    this.employeeFilter.territoryId = this.employeeFilterForm.get('territoryId').value == null ? -1 : this.employeeFilterForm.get('territoryId').value;
    this.employeeFilter.includeInactive = this.employeeFilterForm.get('includeInactive').value == null ? false : this.employeeFilterForm.get('includeInactive').value;
    //this.employeeFilter.employeeId = this.coreSession.CurrentOperator.employeeId;
    this.populateEmployeeList();
  }
  onReset() {
    this.employeeFilterForm.reset();
    this.employeeFilterForm.get('includeInactive').setValue(false);
  }
  openEmployeeEntry() {
    this.employeeIdSignature = null;
    this.isEditMode = false;
    this.showEntrySlider = true;
    this.showSharedTable = false
    this.openItemEntryDialog()
    // this.router.navigateByUrl('/' + ConstantURLs.dataDefinitionURL + '/' + ConstantURLs.staffURL + '/' + ConstantURLs.newEmployeeURL);
  }
  closeEmployeeEntrySlider() {
    this.employeeIdSignature = null;
    this.showEntrySlider = false;
    this.isEditMode = false;
    this.coreSession.SetTitle('Employees');
    this.showSharedTable = true
    this.ItemEntryDialog.Close()
  }
  onSaveEmployeeClick() {
    this.saveSubject.next()
  }
  afterSaveEmployee() {
    this.closeEmployeeEntrySlider();
    this.populateEmployeeList();
    this.showSharedTable = true
  }
  afterImportEmployee() {
    this.populateEmployeeList();
  }

  onDialogReasonResult(isContainsData) {
    if (!isContainsData) {
      this.updatEmployeeActiveStatus();
    } else {
      this.populateEmployeeList();
    }
  }


  updatEmployeeActiveStatus() {
    this.coreSession.ModalLoading.Show();
    var filter = {
      employeeId: this.employeeId,
      isActive: this.isActive
    }
    this.employeeService.updaEmployeeActiveStatus(filter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly));
        this.populateEmployeeList();
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });

  }

}
