import { SessionDataProvider } from "./../../../../../core/session-data-provider.service";
import { Component, OnInit, Input, ViewChild, Output, OnChanges, SimpleChanges, OnDestroy } from "@angular/core";
import { FormGroup } from "@angular/forms";
import { EmployeeTypes } from "../../../../../shared/models/enums/employee-types.enum";
import { CoreSession } from "../../../../../core/core.session";
import { WarehouseService } from "../../../../../shared/services/data-definition/warehouse-and-vehicle/warehouse.service";
import { EmployeeService } from "../../../../employee/employee.service";
import { Subject, Subscription } from "rxjs";
import { ConstantMessages } from "../../../../../shared/models/constants/constant-message";
import { TranslateService } from "@ngx-translate/core";
import { MasterDataService } from "../../../master-data.service";
import { ConstantConfigurations } from "../../../../../shared/models/constants/constant-configuration";
import { MultiSelectComponent } from "ng-multiselect-dropdown";
import { DataActions } from "../../../../../shared/models/enums/data-actions.enum";
import { NgbModal } from "@ng-bootstrap/ng-bootstrap";
import { SharedDialogComponent } from "../../../../../shared/components/shared-dialog/shared-dialog.component";
import { ListItem } from "./item-list";
import * as cloneDeep from "lodash/cloneDeep";
import { DivisionService } from "../../../../../shared/services/data-definition/product/division.service";
import { VehicleService } from "../../../../../shared/services/data-definition/warehouse-and-vehicle/vehicle.service";
import { ConstantURLs } from "../../../../../shared/models/constants/constant-URL";
import { MenuActions } from "../../../../../shared/models/enums/menu-actions-enum";
import { HttpErrorResponse } from "@angular/common/http";
import { Router } from '@angular/router';
import { ShepherdService } from 'angular-shepherd';
import { TourService } from "../../../../../shared/shepherd-config/shepherd-config";
import { ComponentVisitService } from "../../../../../shared/shepherd-config/trackTour.service";
@Component({
  selector: "app-employee-related-data",
  templateUrl: "./employee-related-data.component.html",
  styleUrls: ["./employee-related-data.component.css"],
})
export class EmployeeRelatedDataComponent implements OnInit, OnChanges, OnDestroy {
  @ViewChild("templateEntry", { static: true })
  newDevice: SharedDialogComponent;
  lblNone: string;
  lblAdd: string;
  @ViewChild("divisions", { static: true }) divisionsElem: MultiSelectComponent;
  @Input() employeeData: FormGroup;
  @Input() showOrginzationAcess = false
  @Input() employeeId: number = -1;
  @Input() isNewEmployee: boolean;
  @Input() organizationId: number;
  @Input() employeeTypeId: number;
  resetValuesOnChangeInputs = false;
  operatorid:number
  oldOrganizationId = -1;
  oldEmployeeTypeId = -1;
  changeOrgInput = false;
  changeTypeInput = false;
  isUploadedRoute = false;
  isFromStaffEmployeeOrgAccess: boolean = true;

  public employeeTypes;

  deviceName: string;
  deviceSerial: string;
  vehicleId: number;
  truckId: number;
  helperId: number;
  regionId: number;
  channelId: number;
  contactCountryId: number;
  employeeBranchId: number;
  driverId: number;
  territoryId: number;

  vehicleFilter: any = {
    employeeId: -1,
    organizationId: -1,
    getFree: false,
  };
  truckFilter: any = {
    employeeId: -1,
    organizationId: -1,
    getFree: false,
  };

  relatedEmployeeTypeId: number;
  relatedEmployeeId: number;

  isHelperLoading: boolean = false;
  helpersList: any[] = [];

  isRegionLoading: boolean = false;
  regionsList: any[] = [];

  isChannelLoading: boolean = false;
  channelsList: any[] = [];


  iscontactCountryLoading: boolean = false;
  contactCountrysList: any[] = [];

  isDriverLoading: boolean = false;
  driversList: any[] = [];

  isDevicesLoading: boolean = false;
  devicesList: any[] = [];

  controlTransactionOnDivisionLevel: boolean = false;
  checkCreditLimitOnEmployeeDivisionAccount: boolean = false;

  isRelatedEmployeeLoading: boolean = false;
  relatedEmployeesList: any[] = [];

  isTerritoryLoading: boolean = false;
  territoryList: any[] = [];
  showTerritoryScreen: boolean = false;

  isWarehousesLoading: boolean = false;
  warehouseList: any[] = [];
  warehouseDropdownSettings = {
    singleSelection: false,
    idField: "warehouseId",
    textField: "warehouseNameCode",
    selectAllText: "",
    unSelectAllText: "",
    searchPlaceholderText: "",
    allowSearchFilter: true,
    itemsShowLimit: 3,
  };

  isManagersListLoading: boolean = false;
  managersList: any[] = [];

  isVehicleLoading: boolean = false;
  vehicleList: any[] = [];
  showVehicleScreen: boolean = false;

  isTrucksLoading: boolean = false;
  truckList: any[] = [];

  isDivisionLoading: boolean = false;
  allDivisionsList: any[] = [];
  divisionsList: any[] = [];
  itemsList: any[] = [];
  isItemsListLoading: boolean = false;
  defaultDivisionId: number;
  divisionsDropdownSettings = {
    singleSelection: false,
    idField: "divisionId",
    textField: "divisionCodeName",
    selectAllText: "",
    unSelectAllText: "",
    searchPlaceholderText: "",
    allowSearchFilter: true,
    itemsShowLimit: 1,
  };
  itemsListDropdownSettings = {
    singleSelection: false,
    idField: "itemListId",
    textField: "itemListCodeName",
    selectAllText: "",
    unSelectAllText: "",
    searchPlaceholderText: "",
    allowSearchFilter: true,
    itemsShowLimit: 1,
  };
  divisionId: number;
  selectedDivision: any;

  saveDeviceSubject: Subject<void> = new Subject<void>();
  saveTerritorySubject: Subject<void> = new Subject<void>();
  saveVehicleSubject: Subject<void> = new Subject<void>();
  hideDriver = false;
  hideHelper = false;
  hideSupervisor = false;
  hideSalesManager = true;
  hideDirector = true;
  showWarehouse = false;
  showDefaultCustomer = false;
  showAddNewDevice = false;
  showAddNewVehicle = false;
  showAddNewTerritory = false;
  addnewDevice = false;
  isChangeDevice = false;
  hideTerritory = false;

  organizationsList: any[] = [];
  organizationDropdownSettings = {
    singleSelection: false,
    idField: "organizationId",
    textField: "organizationCodeName",
    selectAllText: "",
    unSelectAllText: "",
    searchPlaceholderText: "",
    allowSearchFilter: true,
    itemsShowLimit: 3,
  };

  isEditModeForTerritory: boolean = false;
  territoryObject: any = null;

  isEditModeForVehicle: boolean = false;
  vehicleObject: any = null;
  @Input() triggerToStartTour: boolean = false;

  constructor(
    public coreSession: CoreSession,
    private warehouseService: WarehouseService,
    private divisionService: DivisionService,
    private employeeService: EmployeeService,
    private masterDataService: MasterDataService,
    private translateService: TranslateService,
    private sessionData: SessionDataProvider,
    private vehicleService: VehicleService,
    private router: Router,
    private shepherdService: ShepherdService,
    private tourService: TourService,
    private componentVisitService: ComponentVisitService
  ) {
    this.employeeTypes = EmployeeTypes;
    this.lblNone = this.translateService.instant(ConstantMessages.LblNone);
    this.lblAdd =
      this.translateService.instant(ConstantMessages.LblAdd) + " ..";
  }
  private tourSubscription: Subscription;
  ngOnDestroy(): void {
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.componentVisitService.markComponentVisited('employee-related-data-entry');
    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }
    this.triggerToStartTour = false

  }

  getElementSelector(): string[] {
    var elementSelectors = [ '#Divisions-data-def'];
    return elementSelectors
  }

  ngOnInit() {
    this.operatorid = this.coreSession.CurrentOperator.operatorId;
    this.tourSubscription = this.tourService.startTourEntry$.subscribe(() => {
      if (this.triggerToStartTour == true) {
        var elementSelectors = this.getElementSelector()
        this.startTour(elementSelectors, true)
      }
    })
    this.showAddNewDevice = this.coreSession.checkActivitiesAvailability(ConstantURLs.deviceListURL, MenuActions.Add);
    this.showAddNewVehicle = this.coreSession.checkActivitiesAvailability(ConstantURLs.vehiclesURL, MenuActions.Add);
    this.showAddNewTerritory = this.coreSession.checkActivitiesAvailability(ConstantURLs.territoryURL, MenuActions.Add);

    this.divisionsDropdownSettings.selectAllText = this.translateService.instant(
      ConstantMessages.SelectAllCaption
    );
    this.divisionsDropdownSettings.unSelectAllText = this.translateService.instant(
      ConstantMessages.UnSelectAllCaption
    );
    this.divisionsDropdownSettings.searchPlaceholderText = this.translateService.instant(
      ConstantMessages.SearchCaption
    );

    this.warehouseDropdownSettings.selectAllText = this.translateService.instant(
      ConstantMessages.SelectAllCaption
    );
    this.warehouseDropdownSettings.unSelectAllText = this.translateService.instant(
      ConstantMessages.UnSelectAllCaption
    );
    this.warehouseDropdownSettings.searchPlaceholderText = this.translateService.instant(
      ConstantMessages.SearchCaption
    );

    this.organizationDropdownSettings.selectAllText = this.translateService.instant(
      ConstantMessages.SelectAllCaption
    );
    this.organizationDropdownSettings.unSelectAllText = this.translateService.instant(
      ConstantMessages.UnSelectAllCaption
    );
    this.organizationDropdownSettings.searchPlaceholderText = this.translateService.instant(
      ConstantMessages.SearchCaption
    );

    this.itemsListDropdownSettings.selectAllText = this.translateService.instant(
      ConstantMessages.SelectAllCaption
    );
    this.itemsListDropdownSettings.unSelectAllText = this.translateService.instant(
      ConstantMessages.UnSelectAllCaption
    );
    this.itemsListDropdownSettings.searchPlaceholderText = this.translateService.instant(
      ConstantMessages.SearchCaption
    );

    if (!this.isNewEmployee) {
      this.employeeData.get("relatedData").get("customerID_outletID")
        .setValue(this.employeeData.get("relatedData").get("customerID_outletID").value);
    }
    this.resetValuesOnChangeInputs = true;
    this.oldOrganizationId = this.organizationId;
    this.oldEmployeeTypeId = this.employeeTypeId;
    if (
      this.employeeTypeId == EmployeeTypes.Collector.valueOf() ||
      this.employeeTypeId == EmployeeTypes.Deliveryperson.valueOf() ||
      this.employeeTypeId == EmployeeTypes.Driver.valueOf() ||
      this.employeeTypeId == EmployeeTypes.Merchandiser.valueOf() ||
      this.employeeTypeId == EmployeeTypes.Presales.valueOf() ||
      this.employeeTypeId == EmployeeTypes.Salesperson.valueOf() ||
      this.employeeTypeId == EmployeeTypes.VanInCharge.valueOf()
    ) {
      this.showDefaultCustomer = true;
    } else {
      this.employeeData.get("relatedData").get("customerID_outletID").reset();
      this.showDefaultCustomer = false;
    }
    if (this.employeeTypeId == EmployeeTypes.ParkingBoy.valueOf()) {
      this.hideTerritory = true;
    }
    if (this.employeeTypeId == EmployeeTypes.Helper.valueOf()) {
      // you can't linke a helper with helper employee !
      this.hideHelper = true;
    } else {
      this.fillHelpersList();
    }
    if (this.employeeTypeId == EmployeeTypes.Driver.valueOf() ||
      this.employeeTypeId == EmployeeTypes.ParkingBoy.valueOf()) {
      this.hideDriver = true;
    } else {
      // you can't linke a driver with driver employee !
    }
    if (
      this.employeeTypeId === EmployeeTypes.StoreKeeper.valueOf() ||
      this.employeeTypeId === EmployeeTypes.Helper.valueOf() ||
      this.employeeTypeId === EmployeeTypes.Picker.valueOf() ||
      this.employeeTypeId === EmployeeTypes.Foreman.valueOf()
    ) {
      this.showWarehouse = true;
    }
    this.fillOrganizations();
    this.fillDivisionsList();
    this.fillRegionsList();
    this.fillcontactCountrysList();
    this.fillItemsList();
    if (this.employeeTypeId == EmployeeTypes.SalesManager.valueOf() ||
      this.employeeTypeId == EmployeeTypes.Director.valueOf()) {
      this.hideSupervisor = true;
      this.hideDirector = false;
    }
    if (
      this.employeeTypeId == EmployeeTypes.Supervisor.valueOf()
    ) {
      this.hideSalesManager = false;
      this.hideSupervisor = true;
      this.hideDirector = false;
    }
    this.fillManagersList();
    if (
      this.employeeData.get("relatedData").get("relatedEmployeeTypeId").value !=
      -1 &&
      this.employeeData.get("relatedData").get("relatedEmployeeTypeId").value !=
      null
    ) {
      this.relatedEmployeeTypeId = this.employeeData
        .get("relatedData")
        .get("relatedEmployeeTypeId").value;
      this.fillRelatedEmployeesList();
    }
  }
  private tourStartTimeout: any;

  startTour(elementSelectors, forceTour?: boolean) {

    this.tourStartTimeout = setTimeout((data => {
      if (!forceTour)
        if (this.tourService.isTourCompletedForComponent('employee-related-data-entry')) {

          return;
        }

        if(this.tourService.isFirstTour() || forceTour){

          const titles = [];
          const texts = [];
      for (let index = 0; index < elementSelectors.length; index++) {
        const { title, text } = this.getTitleAndText(index);
        titles.push(title);
        texts.push(text);
      }
      const steps = this.tourService.generateSteps(elementSelectors, titles, texts);
      this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
      this.shepherdService.modal = true;
      this.shepherdService.addSteps(steps);
      this.shepherdService.start();
    }
    }), 500)
    if (this.triggerToStartTour == false)
      if (this.tourStartTimeout) {
        clearTimeout(this.tourStartTimeout);
      }
    }
  getTitleAndText(index: number): { title: string, text: string } {
    let title = '';
    let text = '';

    switch (index) {
      case 0:
        title = "Desc_Division";
        text = 'Desc_Select_The_Division';
        break;
        case 1:
          title = "Let's go to define your customer";
          text = "Here you can define your customer";
          break;

      default:
        title = `Step ${index + 1}`;
        text = `Content in defult at bottom.`;
    }

    return { title, text };
  }
  ngOnChanges(changes: SimpleChanges) {

    this.changeOrgInput = false;
    this.changeTypeInput = false;

    if (
      this.resetValuesOnChangeInputs &&
      this.organizationId != null &&
      this.employeeTypeId != null
    ) {
      if (this.oldOrganizationId != this.organizationId) {
        this.changeOrgInput = true;
        // reset all values except divisions & organizations access
        this.employeeData.get("relatedData").get("regionId").reset();
        this.employeeData.get("relatedData").get("channelId").reset();
        this.employeeData.get("relatedData").get("employeeBranchId").reset();
        this.employeeData.get("relatedData").get("helperId").reset();
        this.employeeData.get("relatedData").get("driverId").reset();
        this.employeeData.get("relatedData").get("relatedEmployeeId").reset();
        this.employeeData
          .get("relatedData")
          .get("relatedEmployeeTypeId")
          .reset();
        this.employeeData.get("relatedData").get("vehicleId").reset();
        this.employeeData.get("relatedData").get("truckId").reset();
        this.employeeData.get("relatedData").get("territoryId").reset();
        this.employeeData.get("relatedData").get("warehouses").reset();
        this.employeeData.get("relatedData").get("deviceSerial").reset();

        this.relatedEmployeesList = [];

        this.fillRegionsList();
        this.fillHelpersList();
        this.oldOrganizationId = this.organizationId;
      } else if (this.oldEmployeeTypeId != this.employeeTypeId) {
        this.changeTypeInput = true;
        this.hideDriver = false;
        this.hideHelper = false;
        this.hideSupervisor = false;
        this.hideSalesManager = true;
        this.hideDirector = true;
        this.showWarehouse = false;
        this.hideTerritory = false;
        if (
          this.employeeTypeId === EmployeeTypes.StoreKeeper.valueOf() ||
          this.employeeTypeId === EmployeeTypes.Helper.valueOf() ||
          this.employeeTypeId === EmployeeTypes.Picker.valueOf() ||
          this.employeeTypeId === EmployeeTypes.Foreman.valueOf()
        ) {
          this.showWarehouse = true;
        }
        if (this.employeeTypeId != EmployeeTypes.Driver.valueOf()) {
          this.employeeData.get("relatedData").get("truckId").reset();
        }
        if (this.employeeTypeId == EmployeeTypes.Helper.valueOf()) {
          this.helpersList = [];
          this.employeeData.get("relatedData").get("helperId").reset();
          this.hideHelper = true;
        } else if (this.employeeTypeId == EmployeeTypes.Driver.valueOf() || this.employeeTypeId == EmployeeTypes.ParkingBoy.valueOf()) {
          this.driversList = [];
          this.employeeData.get("relatedData").get("driverId").reset();
          this.employeeData.get("relatedData").get("vehicleId").reset();
          this.hideDriver = true;
        }
        if (this.employeeTypeId == EmployeeTypes.ParkingBoy.valueOf()) {
          this.hideTerritory = true;
        }
        if (this.employeeTypeId == EmployeeTypes.SalesManager.valueOf() ||
          this.employeeTypeId == EmployeeTypes.Director.valueOf()) {
          this.hideSupervisor = true;
          this.hideDirector = false;
        }
        if (
          this.employeeTypeId == EmployeeTypes.Supervisor.valueOf()
        ) {
          this.hideDirector = false;
          this.hideSalesManager = false;
          this.hideSupervisor = true;
          if (
            this.employeeData.get("relatedData").get("relatedEmployeeTypeId")
              .value == EmployeeTypes.Supervisor.valueOf()
          ) {
            this.employeeData.get("relatedData").get("relatedEmployeeId").reset();
            this.employeeData
              .get("relatedData")
              .get("relatedEmployeeTypeId")
              .reset();
            this.relatedEmployeesList = [];
          }
        }
        this.fillManagersList();
      }
      if (
        this.employeeTypeId == EmployeeTypes.Collector.valueOf() ||
        this.employeeTypeId == EmployeeTypes.Deliveryperson.valueOf() ||
        this.employeeTypeId == EmployeeTypes.Driver.valueOf() ||
        this.employeeTypeId == EmployeeTypes.Merchandiser.valueOf() ||
        this.employeeTypeId == EmployeeTypes.Presales.valueOf() ||
        this.employeeTypeId == EmployeeTypes.Salesperson.valueOf() ||
        this.employeeTypeId == EmployeeTypes.VanInCharge.valueOf()
      ) {
        this.showDefaultCustomer = true;
      } else {
        this.employeeData.get("relatedData").get("customerID_outletID").reset();
        this.showDefaultCustomer = false;
      }
      this.oldEmployeeTypeId = this.employeeTypeId;
    }
    if (this.triggerToStartTour) {
      // If triggerToStartTour has changed and it's not the first change
      var elementSelectors = this.getElementSelector()// Target each column by its unique ID
      this.startTour(elementSelectors);
    }
  }

  fillOrganizations() {
    this.masterDataService.getOrganizationList(this.isFromStaffEmployeeOrgAccess).subscribe((result) => {
      this.organizationsList = result;
    });
  }
  fillRegionsList() {
    this.isRegionLoading = true;
    this.regionsList = [];
    this.employeeService.getRegions().subscribe((result) => {
      this.regionsList = result;
      this.isRegionLoading = false;
    });
  }

  fillcontactCountrysList() {
    this.iscontactCountryLoading = true;
    this.contactCountrysList = [];
    this.employeeService.getContactCountrys().subscribe((result) => {
      this.contactCountrysList = result;
      this.iscontactCountryLoading = false;
    });
  }
  fillHelpersList() {
    this.isHelperLoading = true;
    this.helpersList = [];
    let helperFilter = {
      employeeId: this.employeeId,
      organizationId: this.organizationId,
      employeeType: EmployeeTypes.Helper,
    };
    this.employeeService
      .getNotConnectedHelpersOrDrivers(helperFilter)
      .subscribe((result) => {
        this.helpersList = result;
        this.isHelperLoading = false;
      });
  }



  onChangeRelatedEmployeeType() {
    this.relatedEmployeeId = null;
    this.employeeData
      .get("relatedData")
      .get("relatedEmployeeId")
      .setValue(this.relatedEmployeeId);
    this.relatedEmployeeTypeId = this.employeeData
      .get("relatedData")
      .get("relatedEmployeeTypeId").value;
    if (this.relatedEmployeeTypeId != null && this.relatedEmployeeTypeId > -1) {
      this.fillRelatedEmployeesList();
    } else {
      this.relatedEmployeesList = [];
    }
  }

  fillRelatedEmployeesList() {
    this.isRelatedEmployeeLoading = true;
    this.relatedEmployeesList = [];

    let relatedEmployeeFilter = {
      employeeId: this.employeeId,
      organizationId: this.organizationId,
      employeeTypeId: this.relatedEmployeeTypeId,
    };
    this.employeeService
      .getRelatedEmployees(relatedEmployeeFilter)
      .subscribe((result) => {
        this.relatedEmployeesList = result;
        this.isRelatedEmployeeLoading = false;
      });
  }
  fillDivisionsList() {

    this.employeeData.get("relatedData").get("divisions").value;
    this.isDivisionLoading = true;
    this.allDivisionsList = [];
    this.divisionsList = [];

    let isAllDivisions = true;
    if (
      this.coreSession.CurrentOperator.employeeId === this.employeeId &&
      !this.isNewEmployee
    ) {
      isAllDivisions = false;
    }

    this.divisionService
      .getEmployeeDivisions(isAllDivisions, this.isFromStaffEmployeeOrgAccess)
      .subscribe((result) => {
        this.allDivisionsList = result;
        this.isDivisionLoading = false;

        if (!this.isNewEmployee) {
          this.divisionsList = result;
          const organizationsAccessList = this.employeeData.get('relatedData').get('organizationsAccessList').value;
          this.divisionsList = this.divisionsList.filter((division) => {
            return organizationsAccessList.some((org) => org.organizationId === division.organizationId);
          });
        }
        else {
          this.divisionsList = this.allDivisionsList;
        }
      });
  }




  fillManagersList() {
    this.isManagersListLoading = true;
    this.managersList = [];
    if (!this.hideSupervisor) {
      this.managersList.push({
        relatedEmployeeTypeId: EmployeeTypes.Supervisor.valueOf(),
        relatedEmployeeTypeName: this.translateService.instant(
          ConstantMessages.SupervisorCaption
        ),
      });
    }
    if (!this.hideSalesManager) {
      this.managersList.push({
        relatedEmployeeTypeId: EmployeeTypes.SalesManager.valueOf(),
        relatedEmployeeTypeName: this.translateService.instant(
          ConstantMessages.SalesManagerCaption
        ),
      });
    }
    if (!this.hideDirector) {
      this.managersList.push({
        relatedEmployeeTypeId: EmployeeTypes.Director.valueOf(),
        relatedEmployeeTypeName: this.translateService.instant(
          ConstantMessages.DirectorCaption
        ),
      });
    }
    this.isManagersListLoading = false;
  }
  fillItemsList() {
    this.isItemsListLoading = true;
    this.itemsList = [];
    this.employeeService
      .getItemsList()
      .subscribe((result) => {
        this.itemsList = result;
        this.isItemsListLoading = false;
      });
  }
  //#region [Events]
  onChangeVehicle() {
    this.vehicleId = this.employeeData
      .get("relatedData")
      .get("vehicleId").value;
  }
  onChangeTruck() {
    this.truckId = this.employeeData.get("relatedData").get("truckId").value;
  }
  onChangeDevice() {
    this.isChangeDevice = true;
    this.checkIfDeviceLinkedToUploadedRoute(this.deviceSerial, this.employeeId)
  }
  checkIfDeviceLinkedToUploadedRoute(deviceSerial?, employeeId?) {
  }
  onChangeDriver() {
    this.driverId = this.employeeData.get("relatedData").get("driverId").value;
  }
  onChangeHelper() {
    this.helperId = this.employeeData.get("relatedData").get("helperId").value;
  }
  onChangeRegion() {
    this.regionId = this.employeeData.get("relatedData").get("regionId").value;
  }
  onChangeChannel() {
    this.channelId = this.employeeData
      .get("relatedData")
      .get("channelId").value;
  }
  onChangeContactCountry() {
    this.contactCountryId = this.employeeData
      .get("relatedData")
      .get("contactCountryId").value;
  }
  onChangeRelatedEmployeeSelection() {
    this.relatedEmployeeId = this.employeeData
      .get("relatedData")
      .get("relatedData").value;
  }

  onChangeTerritory() {
    this.territoryId = this.employeeData
      .get("relatedData")
      .get("territoryId").value;
    // if(this.territoryId == -1){
    //   this.showTerritoryScreen = true;
    // }
  }

  onChangeDivision(event, isCleareAll: boolean) {

    if (this.isDivisionLevel()) {
      let accountsData = this.employeeData.get("accountsDivisionList").get("accountsData").value;
      let documentSeqData = this.applyDivisionsOnDocumentSequence() ?
        this.employeeData.get("documentSequenceData").get("employeeDocumentSequenceList").value : [];

      if ((event != undefined && accountsData.length > 0) || (event != undefined && documentSeqData.length > 0)) {
        let indexDivisionByAccount = accountsData.findIndex((x) => x.divisionId === event.divisionId && x.dataAction != DataActions.Delete);
        let indexDivisionByDocSeq = documentSeqData.findIndex((x) => x.divisionId === event.divisionId);

        if (indexDivisionByAccount >= 0 || indexDivisionByDocSeq >= 0) {
          var itemSelected = new ListItem();
          itemSelected.id = event.divisionId;
          itemSelected.text = event.divisionCodeName;
          this.divisionsElem.selectedItems.push(itemSelected);
          let tempList = [];
          this.divisionsElem.selectedItems.forEach(result => {
            tempList.push({ divisionId: result.id, divisionCodeName: result.text });

          })
          this.employeeData.get('relatedData').get('divisions').setValue(tempList)
          this.coreSession.showWarrning(
            this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(
              ConstantMessages.MsgCannotDeleteThisDivisionBecauseItsLinkedToAccountsOrDocSeq
            )
          );
        }
        if (isCleareAll == true) {
          accountsData.forEach((x) => {
            this.divisionsElem.selectedItems.push({
              id: x.divisionId,
              text: x.divisionCodeName,
            });
          });
          this.coreSession.showWarrning(
            this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(
              ConstantMessages.MsgCannotDeleteThisDivisionBecauseItsLinkedToAccountsOrDocSeq
            )
          );
        }
      }
    } else {
      this.defaultDivisionId = null;
      this.employeeData
        .get("relatedData")
        .get("defaultDivisionId")
        .setValue(this.defaultDivisionId);
    }
  }


  onChangeOrgAccsess(event, add: boolean, all: boolean) {

    if (add) {
      if (all) {

        this.divisionsList = cloneDeep(this.allDivisionsList);

      } else {
        var list = cloneDeep(this.allDivisionsList);
        list = this.allDivisionsList.filter((f) => f.organizationId == event.organizationId);
        list.forEach(element => {
          this.divisionsList.push(element);
        });
      }
    } else {
      if (all) {
        this.divisionsList = [];
      } else {
        var list = this.divisionsList.filter((f) => f.organizationId == event.organizationId);
        list.forEach(element => {
          var index = this.divisionsList.findIndex(f => f.organizationId == element.organizationId)
          this.divisionsList.splice(index, 1);
        });

      }
    }
    this.employeeData.get("relatedData").get("divisions").setValue([]);
    var originalData = cloneDeep(this.divisionsList);
    this.divisionsList = [];
    this.divisionsList = originalData;
  }

  onChangeDefaultDivisionId() {
    this.defaultDivisionId = this.employeeData
      .get("relatedData")
      .get("defaultDivisionId").value;
  }
  setCoreSessionTittle() {
    this.coreSession.SetTitle(
      this.isNewEmployee ? "Add Employee" : "Edit Employee"
    );
  }
  //#region [Device]
  afterSaveDevice(deviceSerial) {
    this.addnewDevice = true;
    this.isChangeDevice = false;
    this.checkIfDeviceLinkedToUploadedRoute(deviceSerial, this.employeeId);
    this.onCloseDeviceClicked();
    this.setCoreSessionTittle();
  }
  onSaveDeviceClicked() {
    this.saveDeviceSubject.next();
  }
  onCloseDeviceClicked() {
    this.setCoreSessionTittle();
    this.newDevice.Close();
  }

  showDeviceModal() {
    this.newDevice.Show(true).then((res) => { });
  }
  onDialogResult(event) {
    if (event && event.saveCLicked) {
      this.onSaveDeviceClicked();
    }
  }
  //#endregion

  //#region [Territory]
  afterSaveTerritory(result) {
    territoryId;
    var territoryId = result.territoryId;
    var inactive = result.inactive;
    this.territoryId = null;
    this.employeeData.get("relatedData").get("territoryId").setValue(null);
    if (!inactive) {
      this.territoryId = territoryId;
      this.employeeData
        .get("relatedData")
        .get("territoryId")
        .setValue(territoryId);
    }
    this.onCloseTerritoryClicked();
  }
  showTerritoryScreenSlider() {
    this.isEditModeForTerritory = false;
    this.territoryObject = null;
    this.showTerritoryScreen = true;
    this.coreSession.hideEmployeeEntrySliderFooter = true;
  }


  showTerritoryEditScreenSlider(territoryId) {
  }

  onSaveTerritoryClicked() {
    this.saveTerritorySubject.next();
  }
  onCloseTerritoryClicked() {
    this.showTerritoryScreen = false;
    this.coreSession.hideEmployeeEntrySliderFooter = false;
    this.setCoreSessionTittle();
  }
  //#endregion

  //#region [Vehicle]
  showVehicleScreenSilder() {
    this.isEditModeForVehicle = false;
    this.showVehicleScreen = true;
    this.coreSession.hideEmployeeEntrySliderFooter = true;
  }

  showVehicleEditScreenSlider(vehicleId) {
    this.isEditModeForVehicle = true;
    // this.vehicleService.getVehicleData(vehicleId, true).subscribe(
    //   response => {

    //     this.coreSession.ModalLoading.Hide();
    //     if (response.status != null && response.status >= 0) {
    //       this.vehicleObject = response.data;
    //       this.vehicleObject.organizationId = this.organizationId;

    //       this.showVehicleScreen = true;
    //       this.coreSession.hideEmployeeEntrySliderFooter = true;
    //     } else {
    //       this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
    //     }
    //   },
    //   (error: HttpErrorResponse) => {
    //     this.coreSession.ModalLoading.Hide();
    //     this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    //   });
  }

  afterSaveVehicle(result) {
    this.vehicleId = null;
    this.employeeData.get("relatedData").get("vehicleId").setValue(null);
    if (!result.inactive) {
      this.vehicleId = result.vehicleId;
      this.employeeData.get("relatedData").get("vehicleId").setValue(result.vehicleId);
    }
    this.onCloseVehicleClicked();
  }
  onSaveVehicleClicked() {
    this.saveVehicleSubject.next();
  }
  onCloseVehicleClicked() {
    this.showVehicleScreen = false;
    this.coreSession.hideEmployeeEntrySliderFooter = false;
    this.setCoreSessionTittle();
  }
  getManagetLabelDescription() {
    let name = "Desc_Manager";
    if (
      this.employeeData.get("relatedData").get("relatedEmployeeTypeId").value ==
      EmployeeTypes.Supervisor.valueOf()
    ) {
      name = "Desc_Supervisor";
    } else if (
      this.employeeData.get("relatedData").get("relatedEmployeeTypeId").value ==
      EmployeeTypes.SalesManager.valueOf()
    ) {
      name = "Desc_Sales_Manager";
    } else if (
      this.employeeData.get("relatedData").get("relatedEmployeeTypeId").value ==
      EmployeeTypes.Director.valueOf()
    ) {
      name = "Desc_Director";
    }
    return name;
  }

  isDivisionLevel() {
    let result = false;
    this.controlTransactionOnDivisionLevel =
      this.sessionData
        .getConfigurationValue(
          ConstantConfigurations.ControlTransactionOnDivisionLevel
        )
        .toLowerCase() === "true";
    this.checkCreditLimitOnEmployeeDivisionAccount =
      this.sessionData
        .getConfigurationValue(
          ConstantConfigurations.CheckCreditLimitOnEmployeeDivisionAccount
        )
        .toLowerCase() === "true";

    if (
      this.controlTransactionOnDivisionLevel &&
      this.checkCreditLimitOnEmployeeDivisionAccount
    ) {
      result = true;
    }
    return result;
  }

  onChangeCustomerOutlet(event: any) {
    this.employeeData
      .get("relatedData")
      .get("customerID_outletID")
      .setValue(event != undefined ? event.customerID_OutletID : "");
  }

  applyDivisionsOnDocumentSequence() {
    return (this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true"
      && this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyDivisionsOnDocumentSequence).toLowerCase() === "true")
  }
  copySerial() {
    navigator.clipboard.writeText(this.deviceSerial);
  }
  //#endregion
}
