import { Component, OnInit, Input, OnChanges, SimpleChanges, OnDestroy } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { MasterDataService } from '../../../master-data.service';
import { TranslateService } from '@ngx-translate/core';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import { CoreSession } from '../../../../../core/core.session';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { ConstantConfigurations } from '../../../../../shared/models/constants/constant-configuration';
import { SessionDataProvider } from '../../../../../core/session-data-provider.service';
import { EmployeeTypes } from '../../../../../shared/models/enums/employee-types.enum';
import { ShepherdService } from 'angular-shepherd';
import { Router } from '@angular/router';
import { TourService } from '../../../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../../../shared/shepherd-config/trackTour.service';
import { Subscription } from 'rxjs';
@Component({
  selector: 'app-employee-security-data',
  templateUrl: './employee-security-data.component.html',
  styleUrls: ['./employee-security-data.component.css']
})
export class EmployeeSecurityDataComponent implements OnInit, OnChanges, OnDestroy {
  @Input() triggerToStartTour: boolean = false;
  @Input() employeeSecurityData: FormGroup;
  @Input() organizationId: number;
  @Input() employeeId: number;
  @Input() isNewEmployee: boolean;
  @Input() employeeTypeId: number;
  resetValues = false;

  isSecurityGroupLoading: boolean = false;
  enableActiveDirectoryLogin: boolean = false;
  allSecurityGroupsList: any[] = [];

  dropdownSettings = {
    singleSelection: false,
    idField: 'securityGroupId',
    textField: 'securityGroupIdName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 5,

  };

  operatorName: string;
  operatorPassword: string;
  confirmPassword: string;
  securityGroups: any[] = [];
  type1: string = 'password';
  type2: string = 'password';
  eyeIcon: string = 'fa-regular fa-eye eye-icon';
  slashIcon: string = 'fa-regular fa-eye-slash eye-icon';
  @Input() notAllowChangePasswordMsg: string = null;
  @Input() isAllowToChangePassword: boolean = false;
  constructor(private masterDataService: MasterDataService,
    private translateService: TranslateService,
    private coreSession: CoreSession,
    private sessionData: SessionDataProvider,
    private router: Router,
    private shepherdService: ShepherdService,
    private tourService: TourService,
    private componentVisitService: ComponentVisitService) {
  }
  ngOnDestroy(): void {

    this.componentVisitService.markComponentVisited('employee-security-data-entry');

    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.triggerToStartTour = false

  }

  private tourSubscription: Subscription;

  ngOnInit() {
    this.tourSubscription = this.tourService.startTourEntry$.subscribe(() => {
      if (this.triggerToStartTour == true) {
        var elementSelectors = this.getElementSelector()
        this.startTour(elementSelectors, true)
      }
      // Target each column by its unique ID
    })
    //this.resetValues = true;
    this.dropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.dropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.dropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
    if (!this.enableActiveDirectoryLogin) {
      this.employeeSecurityData.get('isActiveDirectoryLogin').setValue(false);
    }
  }

  ngOnChanges(changes: SimpleChanges) {
    if (this.organizationId != null) {

      if (this.resetValues) {
        this.employeeSecurityData.get('securityGroups').setValue([]);
      }
      this.fillSecurityGroupsList();
    }
    if (this.employeeTypeId == EmployeeTypes.Salesperson) {
      this.enableActiveDirectoryLogin = false;
      this.employeeSecurityData.get('isActiveDirectoryLogin').setValue(false);
      this.enablePasswordValues();
    } else {
      this.enableActiveDirectoryLogin = this.sessionData.
        getConfigurationValue(ConstantConfigurations.EnableActiveDirectoryLogin).toLowerCase() === "true";
      var ForceActiveDirectoryLogin = this.sessionData.
        getConfigurationValue(ConstantConfigurations.ForceActiveDirectoryLogin).toLowerCase() === "true";
      if (this.enableActiveDirectoryLogin && ForceActiveDirectoryLogin) {
        this.disablePasswordValues();
        this.resetPasswordValues();
        this.employeeSecurityData.get('isActiveDirectoryLogin').setValue(true);
      }
    }
    if (this.triggerToStartTour) {
      // If triggerToStartTour has changed and it's not the first change
      var elementSelectors = this.getElementSelector() // Target each column by its unique ID
      this.startTour(elementSelectors);
    }
  }
  private tourStartTimeout: any;

  getElementSelector(): string[] {
    var elementSelectors = ['#UserName-def', '#Password-def', '#Confirm-Password-def', '#Security-Groups-def'];
    return elementSelectors
  }
  startTour(elementSelectors, forceTour?: boolean) {
    this.tourStartTimeout= setTimeout((data => {

      if (!forceTour)
        if (this.tourService.isTourCompletedForComponent('employee-security-data-entry')) {

          return;
        }

        if(this.tourService.isFirstTour() || forceTour){

          const titles = [];
          const texts = [];
      for (let index = 0; index < elementSelectors.length; index++) {
        const { title, text } = this.getTitleAndText(index);
        titles.push(title);
        texts.push(text);
      }
      const steps = this.tourService.generateSteps(elementSelectors, titles, texts);
      this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
      this.shepherdService.modal = true;
      this.shepherdService.addSteps(steps);
      this.shepherdService.start();
    }
    }), 500)
    if (this.triggerToStartTour == false)
      if (this.tourStartTimeout) {
        clearTimeout(this.tourStartTimeout);
      }
  }
  getTitleAndText(index: number): { title: string, text: string } {
    let title = '';
    let text = '';

    switch (index) {
      case 0:
        title = "Desc_User";
        text = 'Desc_Enter_Name_of_User';
        break;
        case 1:
          title = "Desc_Password";
        text = "Desc_Enter_Password_for_User";
        break;
      case 2:
        title = "Desc_Password";
        text = "Desc_Confirm_Password_for_User";
        break;
      case 3:
        case 2:
          title = "Desc_Security_Group";
          text = "Desc_Select_Security_Group_for_User";
          break;
      case 4:
      case 5:
        title = `Step ${index + 1} Title`;
        text = `Step ${index + 1} Content`;
        break;
      default:
        title = `Step ${index + 1}`;
        text = `Content in defult at bottom.`;
    }

    return { title, text };
  }
  onTogglePass(type: any) {
    switch (type) {
      case 1:
        if (this.type1 == 'password')
          this.type1 = 'text';
        else
          this.type1 = 'password';
        break;
      case 2:
        if (this.type2 == 'password')
          this.type2 = 'text';
        else
          this.type2 = 'password';
        break;
    }
  }
  onCheckADLoginChange(event) {
    if (event.target.checked) {
      this.disablePasswordValues();
    } else {
      this.enablePasswordValues();
    }
    this.resetPasswordValues();
  }
  resetPasswordValues() {
    this.employeeSecurityData.get('confirmPassword').setValue(null);
    this.employeeSecurityData.get('operatorPassword').setValue(null);
  }
  disablePasswordValues() {
    this.employeeSecurityData.get('confirmPassword').disable();
    this.employeeSecurityData.get('operatorPassword').disable();
  }
  enablePasswordValues() {
    this.employeeSecurityData.get('confirmPassword').enable();
    this.employeeSecurityData.get('operatorPassword').enable();
  }
  fillSecurityGroupsList() {
    this.allSecurityGroupsList = [];
    this.isSecurityGroupLoading = true;
    let filter = {
      organizationId: this.organizationId,
      employeeId: -1
    }
    this.masterDataService.getSecurityGroupsList(filter).subscribe(result => {
      this.allSecurityGroupsList = result;
      this.isSecurityGroupLoading = false;
    });
  }
  changeSecurityGroup() {
    var editLogggedInUser = !this.isNewEmployee && this.employeeId == this.coreSession.CurrentOperator.employeeId;
    if (editLogggedInUser) {
      var groups = this.employeeSecurityData.get('securityGroups').value;
      var temp = this.employeeSecurityData.get('securityGroupsTemp').value;
      var isForcseLogout = this.employeeSecurityData.get('forceLogout').value;

      if (!isForcseLogout) {
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgChangeSecurityGroupConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
          (res: DialogResult) => {
            if (res === DialogResult.Yes) {
              this.employeeSecurityData.get('securityGroupsTemp').setValue(groups);
              this.employeeSecurityData.get('forceLogout').setValue(true);
            } else {
              this.employeeSecurityData.get('securityGroups').setValue(temp);
            }
          });
      } else {
        this.employeeSecurityData.get('securityGroupsTemp').setValue(groups);
      }
    }
  }

}
