import { Component, OnInit, ViewChild } from '@angular/core';
import { Subject } from 'rxjs';
import { ITableProperties } from '../../../../../shared/models/shared-table/table-properties.interface';
import { CoreSession } from '../../../../../core/core.session';
import { SharedTableResult } from '../../../../../shared/models/shared-table/shared-table-result.interface';
import { ItemService } from '../../../../../shared/services/data-definition/product/item.service';
import { TranslateService } from '@ngx-translate/core';
import { ConstantURLs } from '../../../../../shared/models/constants/constant-URL';
import { MenuActions } from '../../../../../shared/models/enums/menu-actions-enum';
import { RowOperation } from '../../../../../shared/models/enums/shared-table-operation.enum';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { ResponseModel } from '../../../../../shared/models/api-models/api-models';
import { BrandService } from '../../../../../shared/services/data-definition/product/brand.service';
import { NavBarService } from '../../../../../core/sidebar/sidebar.service';
import { SharedDialogComponent } from '../../../../../shared/components/shared-dialog/shared-dialog.component';

@Component({
  selector: 'app-brand-list',
  templateUrl: './brand-list.component.html',
  styleUrls: ['./brand-list.component.css']
})
export class BrandListComponent implements OnInit {
  saveSubject: Subject<void> = new Subject<void>();
  @ViewChild('ItemEntryDialog', { static: true }) ItemEntryDialog: SharedDialogComponent;

  isEditMode = false;
  brandObject: any = {};
  TabelData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: true,
    rowOperations: [

    ],
    multiSelectionOperations: [],
    columns: [
      {
        title: "Desc_Brand_Name",
        key: "brandName",
        isSortable: true,
        width: "33%"
      },
      {
        title: "Desc_Brand_Code",
        key: "brandCode",
        isSortable: true,
        width: "33%"
      },
      {
        title: "Desc_Organization",
        key: "organizationCodeName",
        isSortable: true,
        width: "33%"
      },
    ]
  };

  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  showSlider = false;
  isMinimized = false;

  constructor(private coreSession: CoreSession,
    private translateService: TranslateService,
    private itemService: ItemService,
    private brandService: BrandService,
    private navService:NavBarService) { }

    showSharedTable: boolean = false;

  ngOnInit() {
    this.navService.endtour.subscribe(() => {
      // Call the onTourEnd() function or perform any action
      this.navService.tourStatus = true;
      this.showSharedTable = this.navService.tourStatus;
    });

    this.showSharedTable = this.navService.tourStatus;
    this.populateBrandsList();
    this.TabelData.showNewBtn = this.coreSession.checkActivitiesAvailability(ConstantURLs.brandsURL ,MenuActions.Add);
    this.addDeleteAction();
    this.addEditAction();
  }

  addDeleteAction() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.brandsURL ,MenuActions.Delete)) {
      this.TabelData.rowOperations.push({
        operation: RowOperation.delete,
        title: "Desc_Delete",
        icon: "fa-solid fa-trash",
        color: "#f1685e"
      });
    }
  }

  openItemEntryDialog() {
    this.ItemEntryDialog.Show(true).then((res) => { });
  }

  addEditAction() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.brandsURL ,MenuActions.Edit)) {
      this.TabelData.rowOperations.push({
        operation: RowOperation.edit,
        title: "Desc_Edit",
        icon: "fa-regular fa-pen-to-square",
        color: "#12344d"
      });
    }
  }

  populateBrandsList() {
    this.coreSession.ModalLoading.Show();
    this.brandService.getAllBrands().subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          var sharedTableData = {
            data: response.data,
            totalItems: response.data.length
          };
          this.dataSource = sharedTableData;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }

  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.edit:
        if (this.coreSession.checkActivitiesAvailability(ConstantURLs.brandsURL, MenuActions.Edit)) {
          this.isEditMode = true;
          this.brandObject = event.object;
          this.showSlider = true;
          this.openItemEntryDialog()
        }
        break;
        case RowOperation.delete:
          (event.object);
          if (this.coreSession.checkActivitiesAvailability(ConstantURLs.brandsURL, MenuActions.Delete)) {
            this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption))
              .then(
                (result: DialogResult) => {
                  if (result === DialogResult.Yes) {
                    this.allowToDeleteBrand(event.object.brandId);
                  }
                }
              );
          }
          break;
    }
  }
  allowToDeleteBrand(brandId: number) {
    this.coreSession.ModalLoading.Show();
    this.brandService.allowToDeleteBrand(brandId).subscribe(
      (response: ResponseModel) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.deleteBrand(brandId);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  deleteBrand(brandId: number) {
    this.coreSession.ModalLoading.Show();
    this.brandService.deleteBrand(brandId).subscribe(
      (response: ResponseModel) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgDeletedSuccessfully));
          this.populateBrandsList();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  openEditBrand(object: any) {
    this.brandObject = object;
    this.showSlider = true;
  }

  onNewBtnClicked() {
    this.isEditMode = false;
    this.brandObject = undefined;
    this.showSlider = true;
    this.showSharedTable =false
    this.openItemEntryDialog()
  }

  closeSlider() {
    this.showSlider = false;
    this.showSharedTable =true
    this.ItemEntryDialog.Close()
  }

  onSaveClick() {
    this.saveSubject.next();
  }

  onMinimized() {
    this.isMinimized = !this.isMinimized;
    this.itemService.setIsMiniMized(this.isMinimized);
  }

  onBrandSaved() {
    this.closeSlider();
    this.populateBrandsList();
    this.showSharedTable =true

  }
}
