import { Component, OnInit, ViewChild } from "@angular/core";
import { Subject } from "rxjs";
import { ITableProperties } from "../../../../../shared/models/shared-table/table-properties.interface";
import { SharedTableResult } from "../../../../../shared/models/shared-table/shared-table-result.interface";
import { CoreSession } from "../../../../../core/core.session";
import { TranslateService } from "@ngx-translate/core";
import { ItemService } from "../../../../../shared/services/data-definition/product/item.service";
import { DialogMode } from "../../../../../shared/models/enums/dialog-mode.enum";
import { HttpErrorResponse } from "@angular/common/http";
import { ConstantMessages } from "../../../../../shared/models/constants/constant-message";
import { RowOperation } from "../../../../../shared/models/enums/shared-table-operation.enum";
import { ConstantURLs } from "../../../../../shared/models/constants/constant-URL";
import { DialogResult } from "../../../../../shared/models/enums/dialog-result.enum";
import { MenuActions } from '../../../../../shared/models/enums/menu-actions-enum';
import { ItemCategoryService } from "../../../../../shared/services/data-definition/product/item-category.service";
import { NavBarService } from "../../../../../core/sidebar/sidebar.service";
import { SharedDialogComponent } from "../../../../../shared/components/shared-dialog/shared-dialog.component";

@Component({
  selector: "app-category-list",
  templateUrl: "./category-list.component.html",
  styleUrls: ["./category-list.component.css"]
})
export class CategoryListComponent implements OnInit {
  saveSubject: Subject<void> = new Subject<void>();
  categoryObject: any = {};
  isEditMode = false;
  @ViewChild('CategoryEntryDialog', { static: true }) CategoryEntryDialog: SharedDialogComponent;

  TabelData: ITableProperties = {
    pageSize: 100,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: true,
    rowOperations: [

    ],
    multiSelectionOperations: [],
    columns: [
      {
        title: "Desc_Category_Name",
        key: "itemCategoryName",
        isSortable: true,
        width: "25%"
      },
      {
        title: "Desc_Category_Code",
        key: "itemCategoryCode",
        isSortable: true,
        width: "25%"
      },
      {
        title: "Desc_Division_Name",
        key: "divisionName",
        isSortable: true,
        width: "25%"
      },
      {
        title: "Desc_Vendor_Name",
        key: "organizationName",
        isSortable: true,
        width: "25%"
      }
    ]
  };

  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  showSlider = false;
  isMinimized = false;

  constructor(
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private itemService: ItemService,
    private itemCategoryService: ItemCategoryService,
    private navService:NavBarService

  ) {}

  showSharedTable: boolean = false;

  ngOnInit() {
    this.navService.endtour.subscribe(() => {
      // Call the onTourEnd() function or perform any action
      this.navService.tourStatus = true;
      this.showSharedTable = this.navService.tourStatus;
    });

    this.showSharedTable = this.navService.tourStatus;
    this.populateCategoriesList();
    this.TabelData.showNewBtn = this.coreSession.checkActivitiesAvailability(ConstantURLs.categoriesURL ,MenuActions.Add);
    this.addDeleteAction();
    this.addEditAction();
  }

  openCategoryEntryDialog() {
    this.CategoryEntryDialog.Show(true).then((res) => { });
  }


  addDeleteAction() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.categoriesURL ,MenuActions.Delete)) {
      this.TabelData.rowOperations.push({
        operation: RowOperation.delete,
        title: "Desc_Delete",
        icon: "fa-solid fa-trash",
        color: "#f1685e"
      });
    }
  }
  addEditAction() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.categoriesURL ,MenuActions.Edit)) {
      this.TabelData.rowOperations.push({
        operation: RowOperation.edit,
        title: "Desc_Edit",
        icon: "fa-regular fa-pen-to-square",
        color: "#12344d"
      });
    }
  }

  populateCategoriesList() {
    this.coreSession.ModalLoading.Show();
    this.itemCategoryService.getAllCategories(-1).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          var sharedTableData = {
            data: response.data,
            totalItems: response.data.length
          };
          this.dataSource = sharedTableData;
        } else {
          this.coreSession.showError(ConstantMessages.ErrorCaption,
            response.message,
          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.edit:
        if (this.coreSession.checkActivitiesAvailability(ConstantURLs.categoriesURL ,MenuActions.Edit))
        this.isEditMode = true;
          this.getCategoryData(event.object);
        break;
      case RowOperation.delete:
        this.DeleteCategory(event.object.itemCategoryId);
        this.isEditMode = false;
        break;
    }
  }

  DeleteCategory(itemCategoryId: any) {
    this.coreSession.ModalDialog.ShowMessage(
      this.translateService.instant(ConstantMessages.MsgDeleteConfirmation),
      DialogMode.YesNo,
      this.translateService.instant(ConstantMessages.Delete)
    ).then((result: DialogResult) => {
      if (result === DialogResult.Yes) {
        this.coreSession.ModalLoading.Show();
        this.itemCategoryService
          .DeleteCategory(itemCategoryId)
          .subscribe(
            response => {
              this.coreSession.ModalLoading.Hide();
              if (response.status != null && response.status >= 0) {
                this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption) , this.translateService.instant(ConstantMessages.MsgDeletedSuccessfully));
                this.populateCategoriesList();
              } else {
                this.coreSession.showError( this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant( response.message));
              }
            },
            error => {
              this.coreSession.ModalLoading.Hide();
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption),  this.translateService.instant(ConstantMessages.ErrorHappened));
            }
          );
      }
    });
  }

  getCategoryData(Category: any) {
    this.coreSession.ModalLoading.Show();
    this.itemCategoryService.getCategoryData(Category.itemCategoryId).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.openEditCategory(response.data);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(response.message));
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  openEditCategory(object: any) {
    this.categoryObject = object;
    this.showSlider = true;
    this.openCategoryEntryDialog()
  }

  openSliderToCreate() {
    this.categoryObject = undefined;
    this.isEditMode = false;
    this.showSlider = true;
    this.openCategoryEntryDialog()
  }

  closeSlider() {
    this.showSlider = false;
    this.CategoryEntryDialog.Close()
  }

  onSaveClick() {
    this.saveSubject.next();
  }

  onMinimized() {
    this.isMinimized = !this.isMinimized;
    this.itemService.setIsMiniMized(this.isMinimized);
  }

  onCategorySaved() {
    this.closeSlider();
    this.populateCategoriesList();
  }
}
