import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import { Observable, Subscription } from 'rxjs';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { ITextInput } from '../../../../../shared/models/shared-table/custom-list.interface';
import { CoreSession } from '../../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { ItemService } from '../../../../../shared/services/data-definition/product/item.service';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { MasterDataService } from '../../../master-data.service';
import { AuthService } from '../../../../../core/auth/auth.service';
import { ConstantStorage } from '../../../../../shared/models/constants/constant-stroage';
import { SessionDataProvider } from '../../../../../core/session-data-provider.service';
import { DivisionService } from '../../../../../shared/services/data-definition/product/division.service';
import { ShepherdService } from 'angular-shepherd';
import { Router } from "@angular/router";
import { TourService } from '../../../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../../../shared/shepherd-config/trackTour.service';
@Component({
  selector: 'app-division-entry',
  templateUrl: './division-entry.component.html',
  styleUrls: ['./division-entry.component.css']
})
export class DivisionEntryComponent implements OnInit {
  @Input() events: Observable<void>;
  @Input() divisionObject: any;
  @Input() organizationId : number;
  @Output() onSaveCompleted = new EventEmitter();
  saveBtnSubscription: any;
  isEditMood = false;
  form: FormGroup ;
  otherLanguages :any[] = [];
  organizationsList : any[] = [] ;

  selectedImage: File = null;
  hasImage = false;
  isImageChanged = false;
  imagePath: any = "";
  HasImageFromApi: any;

  isOrganizationLoading : boolean = false;
  divisionName: ITextInput ={
    formControlName:'name',
    placeHolder: 'Desc_Division_Name',
    label: 'Desc_Division_Name',
    isRequierd : true
  };
  divisionId = -1 ;
  constructor(
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private itemService: ItemService,
    private translate: TranslateService,
    private masterDataService : MasterDataService,
    private authService : AuthService,
    private sessionDataProvider: SessionDataProvider,
    private divisionService: DivisionService,
    private router : Router,
    private shepherdService : ShepherdService,
    private tourService: TourService,
    private componentVisitService: ComponentVisitService

  ) {}
  private tourStartTimeout: any;

  startTour(forceTour?:boolean){
    if(!forceTour)
    if (this.tourService.isTourCompletedForComponent('division-entry')) {
      return;
    }

    this.tourStartTimeout=  setTimeout((data=>{

      if(this.tourService.isFirstTour()||forceTour){

        const elementSelectors = ['#image','#def-division']
        const titles = [];
        const texts = [];
        for (let index = 0; index < elementSelectors.length; index++) {
          const { title, text } = this.getTitleAndText(index);
          titles.push(title);
          texts.push(text);
        }// Target each column by its unique ID
        const steps = this.tourService.generateSteps(elementSelectors,titles,texts);
        this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
        this.shepherdService.modal = true;
        this.shepherdService.addSteps(steps);
        this.shepherdService.start();
      }
      }),1000)

    }
    ngAfterViewInit() {
      this.startTour()
  }
  getTitleAndText(index: number): { title: string, text: string } {
    let title = '';
    let text = '';

    switch (index) {
      case 0:
        title = "Desc_Add_Image";
        text = 'Desc_content_Add_Image';
        break;
        case 1:
        title = "Desc_Division";
        text = "Desc_content_Division";
        break;
        default:
          title = `Step ${index + 1}`;
          text = `Content in default at bottom.`;
    }

    return { title, text };
  }

  ngOnInit() {
    this.tourSubscription = this.tourService.startTourEntry$.subscribe(() => {
        this.startTour(true)
    });
    this.checkIfEditMode();
    this.subscribeSaveClick();
    this.initForm();
    this.fillOrganizationList();
  }

  checkIfEditMode() {
    (this.divisionObject,"this.divisionObject");
    if (this.divisionObject) {
    ("Edit mood");
      this.isEditMood = true;
    } else {
      this.divisionObject = {};
    }
  }

  fillOrganizationList() {
    this.organizationsList = [];
    this.isOrganizationLoading = true;
    this.masterDataService.getOrganizationList().subscribe(result => {
      this.organizationsList = result;
      this.isOrganizationLoading = false;
    });
  }

  CheckIfDivisionHasImage(){
    this.divisionService.checkIfDivisionImage(this.divisionId).subscribe(
      response => {
        if (response.status >= 0) {
          this.hasImage = response.data;
          if (this.hasImage) {
            this.imagePath = document.getElementsByTagName("base")[0].href + "Resources/divisions-img/" + this.divisionObject.divisionId + ".png" + "?random=" + new Date().getTime();
          } else {
            this.setDefaultImage();
          }
        }
      },
      error =>{
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption) , this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  initForm() {
    let divisionCode = "";
    let divisionName = "";
    let active = true;

    if (this.isEditMood) {
      divisionCode = this.divisionObject.divisionCode;
      divisionName = this.divisionObject.description;
      active = this.divisionObject.active;
      this.divisionId = this.divisionObject.divisionId ;
      this.organizationId= this.divisionObject.organizationId
    }
    this.form = new FormGroup({
      code: new FormControl(divisionCode, Validators.required),
      name :new FormControl(divisionName ,  Validators.required),
      active: new FormControl(active, Validators.required),
      organizationId: new FormControl(this.organizationId)
    });
    if(this.isEditMood){
      this.CheckIfDivisionHasImage();
    }
    if (!this.isEditMood) {
      this.setDefaultImage();
    }
  }

  private tourSubscription: Subscription;
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.componentVisitService.markComponentVisited('division-entry');
    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }
  }

  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.onSaveClicked();
    });
  }

  onSaveClicked() {
    this.markAsTouched();
    if (this.form.invalid) {
      return;
    }
    this.checkDivisionCodeIfExist();
    this.fillDivisionObject();
  }

  checkDivisionCodeIfExist() {
    this.divisionService
      .checkIfDivisionCodeExist(this.form.value.code , this.divisionId)
      .subscribe(
        response => {
          if (response.status != null && response.status >= 0) {
            if (response.data.isExist) {
              this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgDivisionCode));
              return;
            } else {
              this.fillDivisionObject();
              (this.divisionObject,"OBject");
              if(this.isEditMood){
                this.editDivisionData();
              }else{
                this.saveDivisionData();
              }
            }
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.showError("", ConstantMessages.ErrorHappened);
        }
      );
  }

  fillDivisionObject(){
    this.divisionObject.hasImage = this.hasImage;
    this.divisionObject.isImageChanged = this.isImageChanged;
    this.divisionObject.divisionCode = this.form.value.code;
    this.divisionObject.description = this.form.value.name;
    this.divisionObject.active = this.form.value.active;
    this.divisionObject.organizationId = -1//this.form.value.organizationId;
    this.divisionObject.descriptionLanguages = this.otherLanguages;
    this.divisionObject.descriptionLanguages.push({
      languageId: this.coreSession.selectedLanguageId,
      description: this.form.value.name
    });
  }

  onOtherLanguagesTextSubmitted(event){
    this.otherLanguages = event;
  }

  saveDivisionData(){
    var formData: FormData = new FormData();
    if (this.divisionObject.hasImage && this.divisionObject.isImageChanged) {
      formData.append("image", this.selectedImage, this.selectedImage.name);
    }
    formData.append('division', JSON.stringify(this.divisionObject));
    // this.divisionObject.ExpirationDate = this.authService.getTokenExpirationDate();
    this.divisionService.saveDivision(formData).subscribe(
      response => {
        if(response.status != null && response.status >= 0){
          this.authService.logout();
          // localStorage.setItem(ConstantStorage.TokenName, response.data.tokenString);
          // localStorage.setItem(ConstantStorage.CurrentOperator, JSON.stringify(response.data.currentOperator));
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption) , this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
        }else{
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption) , this.translateService.instant(response.message));
        }
        this.onSaveCompleted.emit();
      },
      error =>{
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption) , this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  editDivisionData(){
    var formData: FormData = new FormData();
    if (this.divisionObject.hasImage && this.divisionObject.isImageChanged) {
      formData.append("image", this.selectedImage, this.selectedImage.name);
    }
    formData.append('division', JSON.stringify(this.divisionObject));
    this.divisionService.editDivision(formData).subscribe(
      response => {
        if(response.status != null && response.status >= 0){
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption) , this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
        }else{
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption) , this.translateService.instant(response.message));
        }
        this.onSaveCompleted.emit();
      },
      error =>{
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption) , this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  markAsTouched() {
    this.form.get("code").markAsTouched();
    this.form.get("name").markAsTouched();
    this.form.get("organizationId").markAsTouched();
  }

  onChangeOrganization(){
    this.organizationId =  this.form.get('organizationId').value;
  }
// entering an img
  onUploadFinished(event: any) {
    if (event.target.files && event.target.files[0]) {
      const reader = new FileReader();
      this.selectedImage = event.target.files[0];
      this.hasImage = true;
      this.isImageChanged = true;
      reader.onload = (event: ProgressEvent) => {
        this.imagePath = (<FileReader>event.target).result;
      };
      reader.readAsDataURL(event.target.files[0]);
    }
  }

  onClearImage() {
    this.isImageChanged = true;
    this.hasImage = false;
    this.selectedImage = null;
    this.setDefaultImage();
  }

  setDefaultImage() {
    this.imagePath = document.getElementsByTagName("base")[0].href + "Resources/NoProduct-Echo.jpg";
  }
}
