import { Router } from '@angular/router';
import { ShepherdService } from 'angular-shepherd';


export const STEPS_BUTTONS = {
  back: {
    classes: 'back-button',
    secondary: true,
    text: '<i class="fa fa-arrow-left"></i>',
    type: 'back',
  },
  cancel: {
    classes: 'cancel-button',
    secondary: true,
    text: 'Exit',
    type: 'cancel',
  },
  next: {
    classes: 'next-button',
    text: '<i class="fa fa-arrow-right"></i>',
    type: 'next',
  },
  defenition: {
    classes: 'next-button',
    text: 'defintion',
  },
};

export const defaultStepOptions = {
  classes: 'shepherd-theme-arrows custom-default-class',
  scrollTo: false,
  cancelIcon: {
    enabled: true,
  },
};

export const generateSteps = (elementSelectors: string[],router: Router,shepherdService:ShepherdService) => {
  debugger
  console.log("Router instance:", router); // Check if the router instance is available

  const steps = [];
debugger
  elementSelectors.forEach((selector, index) => {
    let title = '';
    let text = '';

    // Customize title and text based on the index using a switch statement
    switch(index) {
      case 0:
        title = "Let's go to define your item";
        text = 'Here you can define your items.';
        break;
      case 1:
        title = "Let's go to define your customer";
        text = "Here you can define your customer";
        break;
      case 2:
        title = "Step 3 Title";
        text = "Step 3 Content";
        break;
      case 3:
        title = "Step 4 Title";
        text = "Step 4 Content";
        break;
      case 4:
        title = "Step 5 Title";
        text = "Step 5 Content";
        break;
      case 5:
        title = "Step 6 Title";
        text = "Step 6 Content";
        break;
      default:
        title = `Step ${index + 1}`;
        text = `Content in ${selector} at bottom.`;
    }

    if (index == 2) {
      steps.push({
        attachTo: {
          element: `${selector}`, // Target the img element inside each .col-md-3 div
          on: 'bottom',
        },
        buttons: [
          STEPS_BUTTONS.back,
          {
            ...STEPS_BUTTONS.defenition,
            action: () => {
              // Handle navigation to the next route based on the index
              router.navigate(['/data-definition/master-data/organizations']);
              shepherdService.complete();
            }
          },
          STEPS_BUTTONS.next
        ],
        classes: 'custom-class-name-1 custom-class-name-2',
        id: `step-${index + 1}`,
        title: title,
        text: text,
      });
    } else {
      steps.push({
        attachTo: {
          element: `${selector}`, // Target the img element inside each .col-md-3 div
          on: 'bottom',
        },
        buttons: [STEPS_BUTTONS.back, STEPS_BUTTONS.next], // Here is the correction
        classes: 'custom-class-name-1 custom-class-name-2',
        id: `step-${index + 1}`,
        title: title,
        text: text,
      });
    }
    }

  );

  return steps;
};

