import { Component, OnInit, ViewChild } from "@angular/core";
import { Subject } from "rxjs";
import { ITableProperties } from "../../../../../shared/models/shared-table/table-properties.interface";
import { SharedTableResult } from "../../../../../shared/models/shared-table/shared-table-result.interface";
import { CoreSession } from "../../../../../core/core.session";
import { TranslateService } from "@ngx-translate/core";
import { ItemService } from "../../../../../shared/services/data-definition/product/item.service";
import { DialogMode } from "../../../../../shared/models/enums/dialog-mode.enum";
import { HttpErrorResponse } from "@angular/common/http";
import { ConstantMessages } from "../../../../../shared/models/constants/constant-message";
import { RowOperation } from "../../../../../shared/models/enums/shared-table-operation.enum";
import { ConstantURLs } from "../../../../../shared/models/constants/constant-URL";
import { DialogResult } from "../../../../../shared/models/enums/dialog-result.enum";
import { MenuActions } from '../../../../../shared/models/enums/menu-actions-enum';
import { ConstantStorage } from '../../../../../shared/models/constants/constant-stroage';
import { AuthService } from "../../../../../core/auth/auth.service";
import { DivisionService } from "../../../../../shared/services/data-definition/product/division.service";
import { NavBarService } from "../../../../../core/sidebar/sidebar.service";
import { SharedDialogComponent } from "../../../../../shared/components/shared-dialog/shared-dialog.component";

@Component({
  selector: "app-division-list",
  templateUrl: "./division-list.component.html",
  styleUrls: ["./division-list.component.css"]
})
export class DivisionListComponent implements OnInit {
  saveSubject: Subject<void> = new Subject<void>();
  @ViewChild('DivisionEntryDialog', { static: true }) DivisionEntryDialog: SharedDialogComponent;

  isMinimized = false;
  isEditMood = false ;
  divisionObject: any = {};
  TabelData: ITableProperties = {
    pageSize: 15,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: true,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      {
        title: "Desc_Division_Name",
        key: "description",
        isSortable: true,
        width: "33%"
      },
      {
        title: "Desc_Division_Code",
        key: "divisionCode",
        isSortable: true,
        width: "33%"
      },
      {
        title: "Desc_Vendor_Name",
        key: "organizationName",
        isSortable: true,
        width: "33%"
      }
    ]
  };

  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };

  showSlider = false;

  constructor(
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private itemService: ItemService,
    private authService : AuthService,
    private divisionService: DivisionService,
    private navService:NavBarService

  ) {}

  showSharedTable: boolean = false;

  ngOnInit() {
    this.navService.endtour.subscribe(() => {
      // Call the onTourEnd() function or perform any action
      this.navService.tourStatus = true;
      this.showSharedTable = this.navService.tourStatus;
    });
    this.showSharedTable = this.navService.tourStatus;

    this.populateDivisionsList();
    this.TabelData.showNewBtn = this.coreSession.checkActivitiesAvailability(ConstantURLs.divisionsURL ,MenuActions.Add);
    this.addDeleteAction();
    this.addEditAction();
  }


  openDivisionEntryDialog() {
    this.DivisionEntryDialog.Show(true).then((res) => { });
  }
  addDeleteAction() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.divisionsURL ,MenuActions.Delete)) {
      this.TabelData.rowOperations.push({
        operation: RowOperation.delete,
        title: "Desc_Delete",
        icon: "fa-solid fa-trash",
        color: "#f1685e"
      });
    }
  }
  addEditAction() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.divisionsURL ,MenuActions.Edit)) {
      this.TabelData.rowOperations.push({
        operation: RowOperation.edit,
        title: "Desc_Edit",
        icon: "fa-regular fa-pen-to-square",
        color: "#12344d"
      });
    }
  }

  populateDivisionsList() {
    this.coreSession.ModalLoading.Show();
    this.divisionService.getAllDivisions(-1).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          var x = {
            data: response.data,
            totalItems: response.data.length
          };
          this.dataSource = x;
          (this.dataSource, "Data");
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.edit:
        if (this.coreSession.checkActivitiesAvailability(ConstantURLs.divisionsURL ,MenuActions.Edit)) {
          this.divisionObject = event.object;
          this.isEditMood = true;
          this.showSlider = true;
          this.openDivisionEntryDialog()
        }
        break;
      case RowOperation.delete:
        this.isEditMood = false;
        this.AllowToDeleteDivision(event.object.divisionId);
        break;
    }
  }

  AllowToDeleteDivision(divisionId: any) {
    this.coreSession.ModalDialog.ShowMessage(
      this.translateService.instant("Desc_Confirmation_Delete"),
      DialogMode.YesNo,
      this.translateService.instant("Desc_Delete")
    ).then((result: DialogResult) => {
      if (result === DialogResult.Yes) {
        this.coreSession.ModalLoading.Show();
        this.divisionService.AllowToDeleteDivision(divisionId).subscribe(
          response => {
            this.coreSession.ModalLoading.Hide();
            if (response.status != null && response.status >= 0) {
              this.DeleteDivision(divisionId);
            } else {
              this.coreSession.showWarrning(
                ConstantMessages.WarningCaption,
                response.message
              );
            }
          },
          (error: HttpErrorResponse) => {
            this.coreSession.ModalLoading.Hide();
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
          }
        );
      }
    });
  }

  DeleteDivision(divisionId: any) {
    var expirationDate = this.authService.getTokenExpirationDate();
    this.coreSession.ModalLoading.Show();
    this.divisionService.DeleteDivision(divisionId, expirationDate).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          localStorage.setItem(ConstantStorage.TokenName, response.data.tokenString);
          localStorage.setItem(ConstantStorage.CurrentOperator, JSON.stringify(response.data.currentOperator));
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption) , this.translateService.instant(ConstantMessages.MsgDeletedSuccessfully));
          this.populateDivisionsList();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption) , this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      },
      error => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption) , this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  openEditDivision(division: any) {
    this.divisionObject = division;
    this.showSlider = true;
  }

  openSliderToCreate() {
    this.divisionObject = undefined;
    this.isEditMood = false;
    this.showSlider = true;
    this.openDivisionEntryDialog()
  }

  closeSlider() {
    this.showSlider = false;
    this.DivisionEntryDialog.Close()
  }

  onSaveClick() {
    this.saveSubject.next();
  }

  onMinimized() {
    this.isMinimized = !this.isMinimized;
    this.itemService.setIsMiniMized(this.isMinimized);
  }

  onDivisionSaved() {
    this.closeSlider();
    this.populateDivisionsList();
  }
}
