import { MasterDataService } from './../../../../master-data.service';
import { Component, EventEmitter, Input, OnInit, Output, ViewChild } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { TranslateService } from '@ngx-translate/core';
import { AngularMultiSelect } from 'angular2-multiselect-dropdown';
import { Observable, Subscription } from 'rxjs';
import { CoreSession } from '../../../../../../core/core.session';
import { SessionDataProvider } from '../../../../../../core/session-data-provider.service';
import { ItemService } from '../../../../../../shared/services/data-definition/product/item.service';
import { SelectItemsComponent } from '../../../../../../shared/components/items/select-items/select-items.component';
import { ConstantMessages } from '../../../../../../shared/models/constants/constant-message';
import { RowOperation } from '../../../../../../shared/models/enums/shared-table-operation.enum';
import { GeneralFilter } from '../../../../../../shared/models/general/generalFilter.model';
import { ITextInput } from '../../../../../../shared/models/shared-table/custom-list.interface';
import { SharedTableResult } from '../../../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../../../shared/models/shared-table/table-properties.interface';
import * as cloneDeep from 'lodash/cloneDeep';
import { DialogResult } from '../../../../../../shared/models/enums/dialog-result.enum';
import { DialogMode } from '../../../../../../shared/models/enums/dialog-mode.enum';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantConfigurations } from '../../../../../../shared/models/constants/constant-configuration';
import { ItemGroupService } from '../../../../../../shared/services/data-definition/product/item-group.service';
import { Router } from "@angular/router";
import { ShepherdService } from 'angular-shepherd';
import { TourService } from '../../../../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../../../../shared/shepherd-config/trackTour.service';

@Component({
  selector: 'app-item-group-entry',
  templateUrl: './item-group-entry.component.html',
  styleUrls: ['./item-group-entry.component.css']
})
export class ItemGroupEntryComponent implements OnInit {

  //#region [Declarations]
  selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
  unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
  searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
  @Input() events: Observable<void>;
  @Output() onSaveCompleted = new EventEmitter();
  @Input() isEditMode = false;
  @Input() isViewMode = false;
  @Input() itemGroupObject: any = new Object();
  @Input() itemGroupModeEntry: false;
  configValue: boolean;
  itemGroup: any = new Object();
  @ViewChild('dropdownElement', { static: true }) dropdownElement: AngularMultiSelect;
  @ViewChild("selectItemsDialog", { static: true }) selectItemsDialog: SelectItemsComponent;
  copyOfAddedItems: any[] = [];
  saveBtnSubscription: any;
  otherLanguages: any[] = [];
  itemGroupName: any[] = [];
  masterGroupDataSource: any[] = [];
  addedItemsList: any[] = [];
  showSelectItemsDialog = false;
  isMasterGroupLoading: boolean = false;
  itemGroupId = 0;
  organizationsList: any[] = [];
  masterItemGroupId: number = 0;
  allItems: boolean = false;
  itemGroupForm: FormGroup;
  itemList: any[] = [];
  loading: boolean = false;
  selectAllItems = false;
  itemFilter: GeneralFilter = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: 30,
    }
  };
  selectedImage: File = null;
  hasImage = false;
  isImageChanged = false;
  imagePath: any = "";
  allowCustomerAppLogin = false;

  itemsDataSource: SharedTableResult = {
    totalItems: 0,
    data: [],
  };

  itemsSharedTabel: ITableProperties = {
    pageSize: 50,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: false,
    showEditButton: false,
    showNewBtn: true,
    newBtnCaption: 'Desc_Add',
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa fa-close',
        color: '#f1685e'
      }
    ],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Items', key: 'itemCodeName', isSortable: true, width: '100%' }
    ]
  };


  settings = {
    singleSelection: false,
    text: "Select",
    selectAllText: this.selectAllText,
    unSelectAllText: this.unSelectAllText,
    enableSearchFilter: true,
    lazyLoading: true,
    searchPlaceholderText: this.searchPlaceholderText,
    badgeShowLimit: 1,
    primaryKey: 'itemId',
    searchBy: ['itemCodeName'],
    disabled: false,
    enableFilterSelectAll: false
  };
  organizationDropdownSettings = {
    singleSelection: false,
    idField: 'organizationId',
    textField: 'organizationCodeName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 3,
  };
  name: ITextInput = {
    formControlName: "name",
    placeHolder: "Desc_Item_Group_Name",
    label: "Desc_Item_Group_Name",
    isRequierd: true
  };

  constructor(private formBuilder: FormBuilder,
    private translateService: TranslateService,
    private itemService: ItemService,
    private coreSession: CoreSession,
    private sessionData: SessionDataProvider,
    private itemGroupService: ItemGroupService,
    private masterDataService: MasterDataService,
    private router: Router,
    private shepherdService: ShepherdService,
    private tourService: TourService,
    private componentVisitService: ComponentVisitService
  ) { }
  private tourStartTimeout: any;
  showSharedTable: boolean = false
  //#endregion

  startTour(forceTour?: boolean) {
    this.tourStartTimeout = setTimeout((data => {
      if (!this.tourService.isFirstTour()) {
        this.showSharedTable = true
      }
      else {
        if (!forceTour)
          if (this.tourService.isTourCompletedForComponent('item-group-entry')) {
            this.showSharedTable = true
            return;
          }
        const elementSelectors = ['#image', '#Item-Group-Name', '#Master_Item_Group', '#def-vendor']
        const titles = [];
        const texts = [];
        for (let index = 0; index < elementSelectors.length; index++) {
          const { title, text } = this.getTitleAndText(index);
          titles.push(title);
          texts.push(text);
        }
        const steps = this.tourService.generateSteps(elementSelectors, titles, texts);
        this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
        this.shepherdService.modal = true;
        this.shepherdService.addSteps(steps);
        this.shepherdService.start();
        this.shepherdService.tourObject.on('complete', () => {

          this.showSharedTable = true

        });
        this.shepherdService.tourObject.on('cancel', () => {

          this.showSharedTable = true

        });
      }
    }), 2000)
  }
  ngAfterViewInit() {
    this.startTour()

  }
  getTitleAndText(index: number): { title: string, text: string } {
    let title = '';
    let text = '';

    switch (index) {
      case 0:
        title = "Desc_Add_Image";
        text = 'Desc_content_Add_Image';
        break;
      case 1:
        title = "Desc_Item_Group";
        text = "Desc_Item_Group_Name";
        break;
      case 2:
        title = "Desc_Master_Item_Group";
        text = "Desc_content_Master_Item_Group";
        break;
      case 3:
        title = "Desc_Vendor";
        text = "Desc_content_Vendor";
        break;
      default:
        title = `Step ${index + 1}`;
        text = `Content in default at bottom.`;
    }


    return { title, text };
  }
  private tourSubscription: Subscription;
  //#region [Events]
  ngOnInit() {
    this.tourSubscription = this.tourService.startTourEntry$.subscribe(() => {

      this.startTour(true)
    });
    this.allowCustomerAppLogin = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowCustomerAppLogin).toLowerCase() === "true";
    this.organizationDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.organizationDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.organizationDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
    this.initForm();
    this.subscribeSaveClick();
    this.fillMasterItemGroupList();
    this.fillOrganizations();
    this.configValue = JSON.parse(this.sessionData.getConfigurationValue('EnableSplitOrder').toString().toLowerCase())
    if (this.isEditMode && this.itemGroupObject.hasImage) {
      this.hasImage = true;
      this.imagePath = document.getElementsByTagName("base")[0].href + "Resources/itemGroups-img/" + this.itemGroupObject.itemGroupId + ".png" + "?random=" + new Date().getTime();
    } else {
      this.setDefaultImage();
    }
    if (this.isEditMode) {
      this.itemGroupForm.get('name').setValue(this.itemGroupObject.itemGroupName);
      this.itemGroupId = this.itemGroupObject == undefined ? 0 : this.itemGroupObject.itemGroupId;
      this.addedItemsList = this.itemGroupObject.itemIdsList;
      this.itemGroupForm.get('organizationsList').setValue(this.itemGroupObject.organizationsList);


      this.itemsDataSource = {
        totalItems: this.itemGroupObject.itemIdsList.length,
        data: this.itemGroupObject.itemIdsList
      };
    }
    if (this.isViewMode) {
      this.itemGroupForm.disable();
    }
  }


  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.onSaveClick();
    });
  }
  ngOnDestroy(): void {
    this.saveBtnSubscription.unsubscribe();
    this.selectItemsDialog.closeSelectItemsDialog();
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.componentVisitService.markComponentVisited('item-group-entry');

  }

  onDeleteAppliedItems(deletedItem: any) {
    var index = this.addedItemsList.findIndex(x => x.itemId === deletedItem.itemId);
    if (index >= 0) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.addedItemsList.splice(index, 1);
            this.fillItemsList();
          }
        });
    }
  }

  afterAddingSelectedItems(selectedItems) {

    this.addedItemsList = selectedItems;
    this.fillItemsList();
    this.closeSelectItemsDialog();
  }

  onRowOperationForItems(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        this.onDeleteAppliedItems(event.object);
        break;
    }
  }

  closeSelectItemsDialog() {
    this.showSelectItemsDialog = false;
    if (this.isEditMode) {
      this.coreSession.SetTitle('Edit Item List');
    } else {
      this.coreSession.SetTitle('Add Item List');
    }
  }

  onSaveClick() {
    if (this.fillEntryObjectAndCheckValidation() != false) {
      var formData: FormData = new FormData();
      if (this.itemGroup.hasImage && this.itemGroup.isImageChanged) {
        formData.append("image", this.selectedImage, this.selectedImage.name);
      }
      formData.append('group', JSON.stringify(this.itemGroup));
      this.itemGroupService.InsertOrUpdateItemGroup(formData, this.isEditMode).subscribe(
        result => {
          this.coreSession.ModalLoading.Hide();
          if (result.status != null && result.status >= 0) {
            this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
            this.onSaveCompleted.emit();
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), result.message);
          }
        },
        error => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );

    } else {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
    }
  }
  onUploadFinished(event: any) {
    if (event.target.files && event.target.files[0]) {
      const reader = new FileReader();
      this.selectedImage = event.target.files[0];
      this.hasImage = true;
      this.isImageChanged = true;
      reader.onload = (event: ProgressEvent) => {
        this.imagePath = (<FileReader>event.target).result;
      };
      reader.readAsDataURL(event.target.files[0]);
    }
  }
  onClearImage() {
    this.isImageChanged = true;
    this.hasImage = false;
    this.selectedImage = null;
    this.setDefaultImage();
  }
  setDefaultImage() {
    this.imagePath = document.getElementsByTagName("base")[0].href + "Resources/noProduct.jpg";
  }

  openSelectItemsDialog() {
    this.copyOfAddedItems = null;
    this.copyOfAddedItems = cloneDeep(this.addedItemsList);
    this.showSelectItemsDialog = true;

    let selectedItemIds = [];
    this.configValue && this.isEditMode && this.itemGroupObject ? this.itemGroupObject.itemIdsList.forEach(res => { selectedItemIds.push(res.itemId) }) : [];

    this.selectItemsDialog.showDialog(selectedItemIds).then(
      (result) => {
        if (result != -1) {
          this.afterAddingSelectedItems(result)
        } else {
          this.closeSelectItemsDialog();
        }
      });
  }


  initForm() {
    this.itemGroupForm = this.formBuilder.group({
      name: new FormControl(this.isEditMode ? this.itemGroupName : null, Validators.required),
      masterItemGroupID: new FormControl(this.isEditMode ? this.itemGroupObject.masterItemGroupID : null, Validators.required),//itemId: new FormControl([], Validators.required),
      organizationsList: new FormControl(this.isEditMode ? this.itemGroupObject.organizationList : null, Validators.required),
    });
  }

  //#endregion

  //#region [Functions]
  fillEntryObjectAndCheckValidation() {
    let descriptions = this.otherLanguages;
    descriptions.splice(1, 1)
    if (descriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      descriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.itemGroupForm.value.name
      });
    }


    this.itemGroup.languageDescriptions = descriptions;
    this.itemGroup.allItems = false //this.dropdownElement.isSelectAll;
    this.itemGroup.itemIdsList = this.addedItemsList //this.itemGroupForm.get('itemId').value;
    this.itemGroup.ItemGroupId = this.itemGroupId;
    this.itemGroup.masterItemGroupID = this.itemGroupForm.get('masterItemGroupID').value
    this.itemGroup.hasImage = this.hasImage;
    this.itemGroup.isImageChanged = this.isImageChanged;
    if (this.itemGroupForm.get('organizationsList').value) {
      this.itemGroup.organizationsList = this.itemGroupForm.get('organizationsList').value;
    }
    if (this.itemGroup.itemIdsList.length > 0 && this.itemGroupForm.valid) {
      return true;
    } else {
      this.markAsTouched();
      return false;
    }

  }
  fillItemsList() {
    this.itemsDataSource = {
      totalItems: this.addedItemsList.length,
      data: this.addedItemsList
    };
  }
  fillOrganizations() {
    this.masterDataService.getOrganizationList().subscribe(result => {
      this.organizationsList = result;
    });
  }

  markAsTouched() {
    this.itemGroupForm.get("name").markAsTouched();
    this.itemGroupForm.get("masterItemGroupID").markAsTouched();
  }

  onOtherLanguagesTextSubmitted(event) {
    this.otherLanguages = event;
  }
  fillMasterItemGroupList() {
    this.coreSession.ModalLoading.Show();
    this.itemService.getAllMasterGroup().subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.masterGroupDataSource = response.data;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

}
