import { HttpErrorResponse } from '@angular/common/http';
import { Component, OnInit } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { Subject } from 'rxjs';
import { CoreSession } from '../../../../../core/core.session';
import { ItemService } from '../../../../../shared/services/data-definition/product/item.service';
import { ResponseModel } from '../../../../../shared/models/api-models/api-models';
import { ConstantMessages } from '../../../../../shared/models/constants/constant-message';
import { ConstantURLs } from '../../../../../shared/models/constants/constant-URL';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { MenuActions } from '../../../../../shared/models/enums/menu-actions-enum';
import { RowOperation } from '../../../../../shared/models/enums/shared-table-operation.enum';
import { SharedTableResult } from '../../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../../shared/models/shared-table/table-properties.interface';
import { ItemGroupService } from '../../../../../shared/services/data-definition/product/item-group.service';
import { NavBarService } from '../../../../../core/sidebar/sidebar.service';

@Component({
  selector: 'app-item-group-list',
  templateUrl: './item-group-list.component.html',
  styleUrls: ['./item-group-list.component.css']
})
export class ItemGroupListComponent implements OnInit {

//#region [Declarations]
  isEditMode = false;
  isViewMode = false;
  showSlider = false;
  menuURL = "";
  saveSubject: Subject<void> = new Subject<void>();
  itemGroupObject: any;
  itemGroupModeEntry = false;
  dataSource: SharedTableResult = { totalItems: 0, data: [] };
  TableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    isOnline: true,
    showSearch: true,
    showSearchBtn: false,
    showNewBtn: false,
    isMultiSelection: false,
    openFilterDirectly: false,
    rowOperations: [
    ],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Group_Name', key: 'itemGroupName', isSortable: true, width: '100%' }]
  };

  itemGroupFilter: any = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: this.coreSession.pageSize
    }
  };

  constructor(private coreSession: CoreSession,
    private itemService: ItemService,
    private translateService: TranslateService,
    private itemGroupService: ItemGroupService,
    private navService:NavBarService
  ) { }

//#endregion

//#region [Events]
showSharedTable: boolean = false;

  ngOnInit() {
    this.navService.endtour.subscribe(() => {
      // Call the onTourEnd() function or perform any action
      this.navService.tourStatus = true;
      this.showSharedTable = this.navService.tourStatus;
    });

    this.showSharedTable = this.navService.tourStatus;
    this.coreSession.SetTitle('Item Group');
    this.populateItemGroupList();
    this.menuURL = ConstantURLs.itemGroupUrl;
    this.TableData.showNewBtn = this.coreSession.checkActivitiesAvailability(this.menuURL, MenuActions.Add);
    this.addActions();
  }

  onSaveClick() {
    this.saveSubject.next();
  }

  onTableFilterChanged(query: any) {
    this.itemGroupFilter.customListFilter = query;
    this.populateItemGroupList();
  }

  onNewBtnClicked() {
    this.itemGroupModeEntry = true;
    this.showSlider = true;
    this.isEditMode = false;
    this.isViewMode = false;
    this.coreSession.SetTitle('Add Item Group');
    this.showSharedTable = false

  }

  onCloseEntrySlider() {
    this.showSlider = false;
    this.isEditMode = false;
    this.coreSession.SetTitle('Item Group');
    this.showSharedTable = true
  }

  afterSaveItem() {
    this.onCloseEntrySlider();
    this.populateItemGroupList();
    this.showSharedTable = true

  }

  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.edit:
        if (this.coreSession.checkActivitiesAvailability(this.menuURL, MenuActions.Edit)) {
          this.itemGroupModeEntry = true;
          this.isViewMode = false;
          this.getItemGrouphData(event.object);
        }
        break;
      case RowOperation.delete:
        this.onDeleteClicked(event.object);
        break;
      case RowOperation.View:
        this.isViewMode = true;
        this.itemGroupModeEntry = true;
        this.itemGroupModeEntry = false;
        this.getItemGrouphData(event.object);
    }

  }

  onDeleteClicked(event: any) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (result: DialogResult) => {
        if (result === DialogResult.Yes) {
          this.coreSession.ModalLoading.Show();
          this.itemGroupService
            .deleteItemGroupData(event.itemGroupId)
            .subscribe(
              response => {
                this.coreSession.ModalLoading.Hide();
                if (response.status != null && response.status >= 0) {
                  this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgDeletedSuccessfully));
                  this.populateItemGroupList();
                } else {
                  this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
                }
              },
              error => {
                this.coreSession.ModalLoading.Hide();
                this.coreSession.showError("", ConstantMessages.ErrorHappened);
              }
            );
        }
      });
  }

  //#endregion

  //#region [Functions]
  populateItemGroupList() {
    this.coreSession.ModalLoading.Show();
    this.itemGroupService.getAllItemGroupLazyLoading(this.itemGroupFilter).subscribe(
      (response: ResponseModel) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.dataSource = {
            totalItems: response.data.totalItems,
            data: response.data.data
          };
        } else {
          this.dataSource = {
            totalItems: 0,
            data: []
          };
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });

  }

  getItemGrouphData(object) {
    this.coreSession.ModalLoading.Show();
    this.itemGroupService.getItemGroupDataInEdit(object.itemGroupId).subscribe(
      response => {

        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.itemGroupObject = response.data;
          this.itemGroupObject.itemGroupName = object.itemGroupName;
          this.itemGroupObject.masterItemGroupID=object.masterItemGroupID;
          this.isEditMode = true;
          this.showSlider = true;

        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      error => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );

  }

  addActions() {

    if (this.coreSession.checkActivitiesAvailability(this.menuURL, MenuActions.Delete)) {
      this.TableData.rowOperations.push(
        {
          operation: RowOperation.delete,
          title: 'Desc_Delete',
          icon: 'fa fa-close',
          color: '#f1685e'
        });
    }

    if (this.coreSession.checkActivitiesAvailability(this.menuURL, MenuActions.Edit)) {
      this.TableData.rowOperations.push({
        operation: RowOperation.edit,
        title: "Desc_Edit",
        icon: "fa fa-pencil",
        color: "#12344d"
      });

    }

    if (this.coreSession.checkActivitiesAvailability(this.menuURL, MenuActions.View)) {
      this.TableData.rowOperations.push(
        {
          operation: RowOperation.View,
          title: "Desc_View",
          icon: "fa fa-eye",
          color: "#12344d"
        });
    }
  }
  //#endregion


}
