import { Component, OnInit, OnDestroy, AfterViewInit } from '@angular/core';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { ActivatedRoute, Router, NavigationEnd } from '@angular/router';
import { Subject, Subscription } from 'rxjs';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../../shared/models/constants/constant-configuration';
import { NavigationData } from '../../../../shared/models/navigation-data/navigation-data.model';
import { NavBarService } from '../../../../core/sidebar/sidebar.service';
import { ShepherdService } from 'angular-shepherd';
import { TourService } from '../../../../shared/shepherd-config/shepherd-config';
import { TranslateService } from '@ngx-translate/core';
import { ComponentVisitService } from '../../../../shared/shepherd-config/trackTour.service';

@Component({
  selector: 'app-item-main',
  templateUrl: './item-main.component.html',
  styleUrls: ['./item-main.component.css']
})
export class ItemMainComponent implements OnInit, OnDestroy, AfterViewInit {
  itemsSubModule: any[];
  isMinimized = false;
  minimizeSubscribtion: any;
  isApplyGS1TrackAndTraceTemp: boolean = true;
  navLinks: any[];
  hideTabs: boolean = false;
  moduleId: number;
  saveSubject: Subject<void> = new Subject<void>();
  indexCounter: number = -1;
  private tourStartTimeout: any;
  private endTour = false;

  constructor(
    private route: ActivatedRoute,
    private router: Router,
    private shepherdService: ShepherdService,
    private sessionDataProvider: SessionDataProvider,
    private navService: NavBarService,
    private translateService: TranslateService,
    private tourService: TourService,
    private componentVisitService: ComponentVisitService
  ) {
    router.events.subscribe(val => {
      if (val instanceof NavigationEnd) {
        this.hideTabs = val.url.includes(ConstantURLs.addItemURL);
      }
    });
  }

  private tourSubscription: Subscription;
  ngOnInit() {

    this.tourSubscription = this.tourService.startTourMain$.subscribe(() => {
      this.startTour(true);
    });

    this.isApplyGS1TrackAndTraceTemp = this.sessionDataProvider.getConfigurationValue(ConstantConfigurations.ApplyGS1TrackAndTraceTemplate).toLowerCase() === "true"
    this.prepareNavigation();
    var index = this.navLinks.findIndex(x => x.link == this.navService.searchMenuURL);
    if (index == -1) index = 0;

    this.navLinks[index].isActive = true;
    this.setNavigation(this.navLinks[index]);
  }

  ngAfterViewInit() {
    this.startTour()
  }
  startTour(forceTour?:boolean){
    this.tourStartTimeout = setTimeout(() => {
      if(!this.tourService.isFirstTour() && !forceTour){
          this.endTour = true;
          this.navService.endtour.next();
      }

      if(!forceTour)
        if (this.tourService.isTourCompletedForComponent('item-main')) {
          this.endTour = true;
          this.navService.endtour.next();
          return;
        }

              if(this.tourService.isFirstTour()||forceTour){
                const titles = [];
                const texts = [];
                const elementSelectors = this.navLinks.map((_, i) => `#column-${i}`);

                this.navLinks.forEach(item => {
                  let title = '';
                  let text = '';
                  switch (item.link) {
                    case 'brands':
                      title = 'Desc_Brand';
                      text = 'Desc_content_Brands';
                      break;
                    case 'item-group':
                      title = 'Desc_Item_Group';
                      text = 'Desc_content_Item-Group';
                      break;
                    case 'categories':
                      title = 'Desc_Categories';
                      text = 'Desc_content_Categories';
                      break;
                    case 'divisions':
                      title = 'Desc_Divisions';
                      text = 'Desc_content_Divisions';
                      break;
                    case 'items':
                      title = 'Desc_Products';
                      text = 'Desc_content_Products';
                      break;
                  }
                  titles.push(title);
                  texts.push(text);
                });

                const steps = this.tourService.generateSteps(
                  elementSelectors,
                  titles,
                  texts
                );

                this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
                this.shepherdService.modal = true;
                this.shepherdService.addSteps(steps);
                this.shepherdService.start();

                this.shepherdService.tourObject.on('complete', () => {
                  this.endTour = true;
                  this.navService.endtour.next();
                });

                this.shepherdService.tourObject.on('cancel', () => {
                  this.endTour = true;
                  this.navService.endtour.next();
                });

              }


    }, 1000);

  }

  ngOnDestroy() {
    this.navService.setNavigation([]);
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.navService.tourStatus = false;
    this.componentVisitService.markComponentVisited('item-main');
    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }
  }

  onSaveCustomer() {
    this.saveSubject.next();
  }

  prepareNavigation() {
    this.navLinks = [];
    for (let menu of this.sessionDataProvider.allMenusAvailable) {
      if (menu.menuId.includes('100-004-')) {
        this.indexCounter++;
        if (menu.menuId === '100-004-06' && !this.isApplyGS1TrackAndTraceTemp) {
          continue;
        }
        let newName = {
          label: menu.menuName,
          link: menu.url,
          isActive: false,
          index: this.indexCounter
        };
        this.navLinks.push(newName);
      }
    }
  }

  onChangeSeletedTab(tab) {
    this.setNavigation(tab);
  }

  setNavigation(tab) {
    if (this.endTour) {
      this.navService.endtour.next(true);
    }

    let navigationList: NavigationData[] = [
      {
        Name: 'Desc_Data_Definition',
        URL: ConstantURLs.dataDefinitionURL
      },
      {
        Name: 'Desc_Products',
        URL: undefined
      },
      {
        Name: tab.label,
        URL: undefined
      }
    ];
    this.navService.setNavigation(navigationList);
  }
}
