import {Component,OnInit,Input,Output,EventEmitter,OnDestroy
} from "@angular/core";
import { Observable } from "rxjs";
import { FormGroup, FormControl, Validators } from "@angular/forms";
import { CoreSession } from "../../../../../core/core.session";
import { ItemService } from "../../../../../shared/services/data-definition/product/item.service";
import { TranslateService } from "@ngx-translate/core";
import { ConstantMessages } from "../../../../../shared/models/constants/constant-message";
import { ITextInput } from '../../../../../shared/models/shared-table/custom-list.interface';

@Component({
  selector: "app-item-uom-entry",
  templateUrl: "./item-uom-entry.component.html",
  styleUrls: ["./item-uom-entry.component.css"]
})
export class ItemUomEntryComponent implements OnInit, OnDestroy {

  @Input() saveEvent: Observable<void>;
  @Output() onAddingNewUOM = new EventEmitter();
  saveBtnSubscription: any;
  otherLanguages: any[] = [];
  packTypeform: FormGroup;
  packTypeObject: any = {};
  packTypeInput: ITextInput = {
    formControlName: "packTypeName",
    placeHolder: "Desc_UOM",
    label: "Desc_UOM"
  };
  constructor(
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private itemService: ItemService) {
  }
  ngOnInit() {
    this.subscribeSaveClick();
    this.packTypeform = new FormGroup({
      packTypeName: new FormControl(null, Validators.required)
    });
  }
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.saveEvent.subscribe(() => {
      this.onSaveClicked();
    });
  }
  fillPackTypeObject() {
    this.packTypeObject.packTypeName = this.packTypeform.get('packTypeName').value;
    let descriptions = this.otherLanguages;
    if (descriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      descriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.packTypeObject.packTypeName
      });
    }
    this.packTypeObject.descriptionLanguages = descriptions;
  }
  onOtherLanguagesTextSubmitted(event) {
    this.otherLanguages = event;
  }
  onSaveClicked() {
    if (this.packTypeform.invalid) {
      this.coreSession.markFormGroupTouched(this.packTypeform);
      return;
    }
    this.fillPackTypeObject();
    this.coreSession.ModalLoading.Show();
    this.itemService.savePackType(this.packTypeObject).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.packTypeObject.packTypeId = response.data;
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
          this.onAddingNewUOM.emit(this.packTypeObject);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      error => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
}
