import { Component, OnInit, Input, Output, EventEmitter, OnDestroy, ViewChild } from "@angular/core";
import { Observable, Subject, Subscription, forkJoin } from "rxjs";
import { FormGroup, FormControl, Validators } from "@angular/forms";
import { ITextInput } from "../../../../../shared/models/shared-table/custom-list.interface";
import { CoreSession } from "../../../../../core/core.session";
import { TranslateService } from "@ngx-translate/core";
import { ItemService } from "../../../../../shared/services/data-definition/product/item.service";
import { ConstantMessages } from "../../../../../shared/models/constants/constant-message";
import { SharedTableResult } from "../../../../../shared/models/shared-table/shared-table-result.interface";
import { ITableProperties } from "../../../../../shared/models/shared-table/table-properties.interface";
import { RowOperation } from "../../../../../shared/models/enums/shared-table-operation.enum";
import { HttpClient, HttpErrorResponse } from "@angular/common/http";
import { DialogMode } from "../../../../../shared/models/enums/dialog-mode.enum";
import { ResponseModel } from "../../../../../shared/models/api-models/api-models";
import { DataActions } from '../../../../../shared/models/enums/data-actions.enum';
import { MasterDataService } from '../../../master-data.service';
import * as cloneDeep from 'lodash/cloneDeep';
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { ItemPackModel, PackModel } from '../../../../../shared/models/Item/item.model';
import { PackOperations } from '../../../../../shared/models/enums/pack-operation.enum';
import { TemplateFieldModel } from '../../../../../shared/models/barcodeTemplate/templateField.model';
import { SessionDataProvider } from '../../../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../../../shared/models/constants/constant-configuration';
import { IOTSensorModel } from '../../../../../shared/models/Item/iot-sensor.model';
import { NgbModal } from "@ng-bootstrap/ng-bootstrap";
import { SharedDialogComponent } from "../../../../../shared/components/shared-dialog/shared-dialog.component";
import { CompetitorModel } from '../../../../../shared/models/Item/competitor.model';
import { ItemTypes } from "../../../../../shared/models/enums/itemTypes.enum";
import { ItemProductionDateTypes } from "../../../../../shared/models/enums/item-production-date-types-enum";
import { PackGroupService } from "../../../../../shared/services/data-definition/product/pack-group.service";
import { BrandService } from "../../../../../shared/services/data-definition/product/brand.service";
import { MenuActions } from "../../../../../shared/models/enums/menu-actions-enum";
import { ConstantURLs } from "../../../../../shared/models/constants/constant-URL";
import { ImageFileModel } from "../../../../../shared/models/image/image-file.model";
import { map } from 'rxjs/operators';
import { ShepherdService } from 'angular-shepherd';
import { Router } from "@angular/router";
import { TourService } from "../../../../../shared/shepherd-config/shepherd-config";
import { ComponentVisitService } from "../../../../../shared/shepherd-config/trackTour.service";
import { IDateTimePickerProperties } from "../../../../../shared/models/dateTimeModel/date-time-properties.interface";
import { DateTimeModel } from "../../../../../shared/models/dateTimeModel/date-time.model";
@Component({
  selector: "app-items-entry",
  templateUrl: "./items-entry.component.html",
  styleUrls: ["./items-entry.component.css"]
})
export class ItemsEntryComponent implements OnInit, OnDestroy {
  @ViewChild("templateEntry", { static: true }) newUOM: SharedDialogComponent;
  @Input() isEditMode = false;
  @Input() events: Observable<void>;
  @Input() itemObject: ItemPackModel;
  @Output() onSaveCompleted = new EventEmitter();
  resetPackTypeList: EventEmitter<boolean> = new EventEmitter();
  saveBtnSubscription: any;

  saveUOMSubject: Subject<void> = new Subject<void>();

  showItemData: boolean = false;
  showPacksData: boolean = false;
  showBarcodeTemplateData: boolean = false;
  showIOTSensorsData: boolean = false;
  showBarcodeTemplateTab: boolean = false;

  navLinks: any[];
  itemDefinitionForm: FormGroup;
  packDefinitionForm: FormGroup;
  packDefinitionBasepackForm : FormGroup;
  iotSensorsForm: FormGroup;
  seletedPackTypeName = null;

  isBrandsLoading = false;
  isModelsLoading = false;
  isTypesLoading = false;
  isGroupLoading = false;
  isPackChildLoading = false;
  isTemplateLoading = false;

  allItemModelList: any[] = [];
  filteredItemModelList: any[] = [];
  itemBrandList: any[] = [];
  packGroupsList: any[] = [];
  packOperationList: any[] = [];
  packChildList: PackModel[] = [];
  allPackChildList: PackModel[] = [];
  hidePackChildList = false;
  childPack: PackModel = null;
  itemTypesList: any[] = [];
  packsList: PackModel[] = [];
  barcodeTemplateList: any[] = [];
  sensorTableList: IOTSensorModel[] = []; // Data table
  savedSensorTableList: IOTSensorModel[] = []; // Data table

  selectedPack: PackModel = null;
  isEditPackMode = false;
  maxPackIdForAdd: number = -1
  btnSavePackCaption = 'Desc_Add';
  btnSaveBasePackCaption = 'Desc_Add';

  imagePath: any = "";
  selectedVendor: number;
  otherLanguages: any[] = [];
  selectedImage: File = null;
  hasImage = false;
  isImageChanged = false;
  isHasSerial: Boolean = false;

  EnableProductionDate: boolean = false;
  attahcedImages: ImageFileModel[] = [];
  maxIndex: number = 0;
  direction: any;
  packGroupDropdownSettings = {
    singleSelection: false,
    idField: 'packGroupId',
    textField: 'packGroupCodeName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 2,
  };
  packOperationsDropdownSettings = {
    singleSelection: false,
    idField: 'operationId',
    textField: 'operation',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: false,
    itemsShowLimit: 3,
  };
  itemNameInput: ITextInput = {
    formControlName: "name",
    placeHolder: "Desc_Item_Name",
    label: "Desc_Item_Name",
    isRequierd: true
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  TabelData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: false,
    showSearch: false,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: false,
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: "Desc_Delete",
        icon: "fa-solid fa-trash",
        color: "#f1685e"
      }, {
        operation: RowOperation.edit,
        title: "Desc_Edit",
        icon: "fa-regular fa-pen-to-square",
        color: "#12344d"
      }
    ],
    multiSelectionOperations: [],
    columns: [
      {
        title: "Desc_UOM",
        key: "packTypeName",
        isSortable: true,
        width: "25%"
      },
      {
        title: "Desc_Quantity",
        key: "quantity",
        isSortable: true,
        width: "25%"
      },
      {
        title: "Desc_Barcode",
        key: "packBarcode",
        isSortable: false,
        width: "25%"
      }
    ]
  };
  isLoading: boolean = false;
  sensorsDataSourceTable: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  sensorsTableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: true,
    showOptionPerLine: true,
    //showOptionOnKey:'enabled',
    specificActionWhenCheckRow: true,
    specificActionWhenCheckAll: true,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      {
        title: 'Desc_Sensor_Name',
        key: 'sensorName',
        isSortable: true,
        width: '33%'
      },
      {
        title: 'Desc_Min_Value',
        key: 'sensorMinValue',
        isSortable: false,
        width: '33%',
        isEditablePerRow: true,
        numberOfDigits: true

      },
      {
        title: 'Desc_Max_Value',
        key: 'sensorMaxValue',
        isSortable: false,
        width: '33%',
        isEditablePerRow: true,
        numberOfDigits: true
      }
    ]
  };

  inputTextType: string = 'number';
  //#region [Secondary Packs]
  secondaryPackDefinitionForm: FormGroup;
  showSecondaryPacksData: boolean = false;
  showAttachments: boolean = false;
  secondaryPacksList = [];
  maxSecondaryPackIdForAdd: number = 0;
  selectedPackTypeId_secondary = -1;
  selectedPackType_secondary;
  selectedSecondaryPack: any = {};
  secondaryPacksDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  SecondaryPacksTableData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: false,
    showSearch: false,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: false,
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: "Desc_Delete",
        icon: "fa-solid fa-trash",
        color: "#f1685e"
      }
    ],
    multiSelectionOperations: [],
    columns: [
      {
        title: "Desc_UOM",
        key: "packType",
        isSortable: true,
        width: "25%"
      },
      {
        title: "Desc_Quantity",
        key: "quantity",
        isSortable: false,
        width: "25%",
        isEditable: true,
        numberOfStockDigits: true
      }
      ,
      {
        title: "Desc_Barcode",
        key: "barcode",
        isSortable: false,
        width: "25%",
        isEditable: true
      }
    ]
  };
  //#endregion
  //#region [Competitor item]
  showCompetitorList: boolean = false;
  showItemList: boolean = false;
  showCompItemMultiSelect: boolean = false;
  isCompetitorsLoading: boolean = false;
  isCompetitorItemsLoading: boolean = false;
  competitorsList: any[] = [];
  competitorItemList: CompetitorModel[] = [];
  selectedCompetitors: CompetitorModel[] = [];
  itemTypeId: number = -1;
  currentFormControlName = 'tradingItemId';
  competitorItemDropdownSettings = {
    singleSelection: false,
    idField: 'competitorItemId',
    textField: 'competitorItemName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: false,
    itemsShowLimit: 1,
  };
  selectedCompetitorItemId = -1;
  containsGTIN = false;
  showAddNewUom = false;
  showAddNewUomInBasePackUom = false
  excludedItemIdsList: any[] = [];
  //#endregion
  constructor(
    public coreSession: CoreSession,
    private translateService: TranslateService,
    private itemService: ItemService,
    private masterDataService: MasterDataService,
    private sessionData: SessionDataProvider,
    private modalService: NgbModal,
    private packGroupService: PackGroupService,
    private brandService: BrandService,
    private http: HttpClient,
    private shepherdService: ShepherdService,
    private router : Router,
    private tourService: TourService,
    private componentVisitService: ComponentVisitService
  ) { }


  ngAfterViewInit() {
    this.showEntrySection(0)
    }
    private tourStartTimeout: any;

    startTour(elementSelectors,type,forceTour?:boolean){

      if(!forceTour)
      if (this.tourService.isTourCompletedForComponent('item-entry')) {
        if(type=='pack'){
          this.sharedTablePack = true
        }
                return;
      }
      this.tourStartTimeout=setTimeout((data=>{
        if(!this.tourService.isFirstTour()){
          if(type=='pack'){
            this.sharedTablePack = true
          }
        }
         if(this.tourService.isFirstTour()||forceTour){
          var titles =[]
          var texts = []
          for (let i = 0; i < elementSelectors.length; i++) {
            const { title, text } = this.getTitleAndText(type, i);
            titles.push(title);
            texts.push(text);
          }
          const steps = this.tourService.generateSteps
          (elementSelectors,titles,texts);
          this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
          this.shepherdService.modal = true;
          this.shepherdService.addSteps(steps);
          this.shepherdService.start();
          this.shepherdService.tourObject.on('complete', () => {

            if(type=='pack'){
              this.sharedTablePack = true
            }
          });

          this.shepherdService.tourObject.on('cancel', () => {
            if(type=='pack'){
              this.sharedTablePack = true
            }
          });
        }

      }),500)
    }

    ExpireDateIsNewPreporty: IDateTimePickerProperties = {
      label: 'Desc_Expire_Date_For_Is_New',
      formControlName: 'ExpireisNewDate',
      isCalendarOnly:true
    };

    ExpireisNewDate: Date;

    getTitleAndText(type: string, index: number): { title: string, text: string } {
      let title = '';
      let text = '';

      if (type === 'item') {
        switch (index) {
          case 0:
            title = "Desc_Add_Image";
            text = "Desc_content_Add_Image";
            break;
          case 1:
            title = "Desc_Item_Definition";
            text = `Desc_content_Item_Definition`;
            break;
            case 2:
              title = "Desc_Brand_Description";
              text = "Desc_content_Brand_Description";
              break;
            case 3:
              title = "Desc_Inactive_Toggle";
              text = "Desc_content_Inactive_Toggle";
              break;
            case 4:
            case 5:
              title = "Desc_Is_New_Toggle";
              text = "Desc_content_Is_New_Toggle";
              break;
            default:
              title = "Desc_default";
              text = "Desc_content_default";
        }
      } else if (type === 'pack') {
        switch (index) {
          case 0:
              title = 'Desc_Base_Pack';
              text = 'Desc_Define_Base_Pack';
              break;
          case 1:
              title = 'Desc_Others_Pack';
              text = 'Desc_Define_Other_Packs';
              break;
          case 2:
              title = 'Desc_UOM';
              text = 'Desc_content_UOM';
              break;
          case 3:
              title = 'Desc_Quantity';
              text = 'Desc_content_Quantity';
              break;
          case 4:
              title = 'Desc_Barcode_OperationGroups';
              text = 'Desc_Barcode_OperationGroups';
              break;
          case 5:
              title = 'Desc_Clear';
              text = 'Desc_Clear_Button';
              break;
          case 6:
              title = 'Desc_Add';
              text = 'Desc_Add_Button';
              break;
      }


      }

      return { title, text };
    }
    private tourSubscription: Subscription;

  ngOnInit() {
    this.ExpireDateIsNewPreporty.min = new Date();
    this.tourSubscription = this.tourService.startTourEntry$.subscribe(() => {
      if(this.showPacksData){
        const elementSelectors = ['#base-pack-def','#others-pack-def','#UOM','#Quantity','#Barcode-OperationGroups','#clear-button','#add-button']
        this.startTour(elementSelectors,'pack',true)
      }
      if(this.showItemData) {
        const elementSelectors = ['#image','#item-def','#item-des-brand','#inactive','#newtoggle'] // Target each column by its unique ID
        this.startTour(elementSelectors,'item',true)
      }
    });
    this.direction = this.coreSession.isRTL;
    this.showAddNewUom = this.coreSession.checkActivitiesAvailability(ConstantURLs.itemsURL, MenuActions.Add);
    this.showAddNewUomInBasePackUom = this.showAddNewUom;
    this.EnableProductionDate = this.sessionData.getConfigurationValue(ConstantConfigurations.EnableProductionDate).toLowerCase() === "true";
    this.packGroupDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.packGroupDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.packGroupDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
    this.showBarcodeTemplateData = (this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyGS1TrackAndTraceTemplate).toLowerCase() === "true");
    this.showIOTSensorsData = (this.sessionData.getConfigurationValue(ConstantConfigurations.ShowIOTSensors).toLowerCase() === "true");
    this.packOperationsDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.packOperationsDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.competitorItemDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.competitorItemDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.subscribeSaveClick();
    this.prepareNavigation();
    this.navLinks[0].isActive = true;
    this.showItemData = true;
    if (this.isEditMode && this.itemObject.hasImage) {
      this.hasImage = true;
      this.imagePath = document.getElementsByTagName("base")[0].href + "Resources/items-img/" + this.itemObject.itemId + ".png" + "?random=" + new Date().getTime();
    } else {
      this.setDefaultImage();
    }
    if (this.isEditMode && this.itemObject) {
      this.itemTypeId = this.itemObject.itemTypeId;
     // this.coreSession.ModalLoading.Show();
      var itemObjResponse = this.itemService.getItemData(this.itemObject.itemId);
      var groupsResponse = this.packGroupService.getPackGroupsItemDefinition();
      var secondaryPacksResponse = this.itemService.getSecondaryPacks(this.itemObject.itemId);
      this.isPackChildLoading = true;
      forkJoin(itemObjResponse, groupsResponse, secondaryPacksResponse).subscribe(response => {
        this.coreSession.ModalLoading.Hide();

        if (response[1].status != null && response[1].status >= 0) {
          this.packGroupsList = response[1].data;
        }
        if (response[2].status != null && response[2].status >= 0) {
          this.secondaryPacksList = response[2].data;
          this.fillSecondaryPacksList();
        }
        this.fillItemData(response[0]);
      },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );
      if (this.itemObject.itemTypeId === ItemTypes.TradingItem.valueOf()) {
        this.populateAvailableCompetitorItemList(this.itemObject.itemId);
        this.showCompItemMultiSelect = true;
        this.showCompetitorList = false;
        this.showItemList = false;
      }
      if (this.itemObject.itemTypeId === ItemTypes.CompetitorItem.valueOf()) {
        this.populateCompetitorList();
        this.showCompetitorList = true;
        this.showItemList = true;
        this.showCompItemMultiSelect = false;
      }

    }
    this.populateItemTypesList();
    this.populateItemBrandsList();
    this.populateItemModelList();
    this.populatePackGroupsList();
    this.populatePackOperations();
    this.populateBarcodeTemplateList();
    this.initForm();
    this.initPacksForm();
    this.initSecondaryPacksForm();
    // this.populateCompetitorList();
  }
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.componentVisitService.markComponentVisited('item-entry');
    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.onSaveClicked();
    });
  }
  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_Item_Definition',
        index: 0,
        isActive: false
      },
      {
        label: 'Desc_Packs',
        index: 1,
        isActive: false
      }
    ];
  }

  sharedTablePack =false;

  showEntrySection(selectedIndex: number) {
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }

    this.clearSelection();
    if (selectedIndex == 0) {
      this.showItemData = true;
      const elementSelectors = ['#image','#item-def','#item-des-brand','#inactive','#newtoggle'] // Target each column by its unique ID
      this.startTour(elementSelectors,'item')
    } else if (selectedIndex == 1) {
      const elementSelectors = ['#base-pack-def','#others-pack-def','#UOM','#Quantity','#Barcode-OperationGroups','#clear-button','#add-button']
      // Target each column by its unique ID
      this. startTour(elementSelectors,'pack')
      this.showPacksData = true;
    } else if (selectedIndex == 2) {
      this.showBarcodeTemplateTab = true;
    } else if (selectedIndex == 3) {
      this.showSecondaryPacksData = true;
    } else if (selectedIndex == 4) {
      this.showAttachments = true;
    }
    if (this.itemDefinitionForm.invalid && selectedIndex !=0) {
      this.itemDefinitionForm.markAllAsTouched()
      this.showEntrySection(0);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
    this.navLinks[selectedIndex].isActive = true;
  }
  clearSelection() {
    this.showItemData = false;
    this.showPacksData = false;
    this.showBarcodeTemplateTab = false;
    this.showSecondaryPacksData = false;
    this.showAttachments = false;
    this.navLinks.forEach(a => a.isActive = false);
  }


  initForm() {
    if (!this.isEditMode) {
      this.itemObject = new ItemPackModel();

    }else{
      if(this.itemObject.isNew)
        this.showIsNewExpireDate =true

      this.ExpireisNewDate =  new Date(this.itemObject.isNewExpireDateModel.date) ;
      this.ExpireDateIsNewPreporty.dateValue = this.ExpireisNewDate;
    }
    this.itemDefinitionForm = new FormGroup({
      name: new FormControl(this.isEditMode ? this.itemObject.itemName : null, Validators.required),
      code: new FormControl(this.isEditMode ? this.itemObject.itemCode : null, Validators.required),
      itemType: new FormControl(this.isEditMode ? this.itemObject.itemTypeId : null,),
      itemCategoryId: new FormControl(this.isEditMode ? this.itemObject.itemCategoryId : null,  Validators.required),
      brandId: new FormControl(this.isEditMode && this.itemObject.brandId && this.itemObject.brandId != -1 ? this.itemObject.brandId : null),
      modelId: new FormControl(this.isEditMode && this.itemObject.modelId && this.itemObject.modelId != -1 ? this.itemObject.modelId : null),
      definition: new FormControl(this.isEditMode && this.itemObject.packDefinition ? this.itemObject.packDefinition : null),
      shelfLifeTime: new FormControl(this.isEditMode && this.itemObject.shelfLifeTime && this.itemObject.shelfLifeTime != -1 ? this.itemObject.shelfLifeTime : null),
      inactive: new FormControl(this.isEditMode ? this.itemObject.inactive : false),
      isInitiative: new FormControl(this.isEditMode ? this.itemObject.isInitiative : false),
      isBatchPriced: new FormControl(this.isEditMode ? this.itemObject.isBatchPriced : false),
      isTempCredit: new FormControl(this.isEditMode ? this.itemObject.temporaryCredit : false),
      isDefultBatch: new FormControl(this.isEditMode ? this.itemObject.isDefaultBatchNo : false),
      isPowerSKU: new FormControl(this.isEditMode ? this.itemObject.isPowerSKU : false),
      isNew: new FormControl(this.isEditMode ? this.itemObject.isNew : false),
      ExpireisNewDate: new FormControl({ value: this.isEditMode ? this.itemObject.isNewExpireDateModel.date : null, disabled: false }, this.itemObject.isNewExpireDateModel.date? Validators.required:null),
      isPriceProtected: new FormControl(this.isEditMode ? this.itemObject.isPriceProtected : false),
      forceDefaultPack: new FormControl(this.isEditMode ? this.itemObject.forceDefaultPack : false),
      hasSerialNumber: new FormControl(this.isEditMode ? this.itemObject.hasSerialNumber : false),
      autoGenerateSubSerials: new FormControl({ value: this.isEditMode ? this.itemObject.autoGenerateSubSerials : false, disabled: false }),
      enableBatchForSerial: new FormControl({ value: this.isEditMode ? this.itemObject.enableBatchForSerial : false, disabled: false }),
      inSCS: new FormControl({ value: this.isEditMode ? this.itemObject.inSCS : true, disabled: false }),
      requiredByLiter: new FormControl(this.isEditMode ? this.itemObject.requiredByLiter : false),
      inStock: new FormControl(this.isEditMode ? this.itemObject.inStock : true),
      competitorId: new FormControl(null, this.isEditMode && this.itemObject.itemTypeId === ItemTypes.CompetitorItem.valueOf() ? Validators.required : null),
      tradingItemId: new FormControl(),
      competitorItems: new FormControl(),
      lowStockQty: new FormControl(this.isEditMode && this.itemObject.lowStockQty!=-1 ?  this.itemObject.lowStockQty: null),
      vendorId: new FormControl(this.isEditMode && this.itemObject.vendorId !== -1 ? this.itemObject.vendorId : null),
      isDate: new FormControl(this.isEditMode && this.itemObject.productionDateType === ItemProductionDateTypes.Date.valueOf() ? true : false),
      isText: new FormControl(this.isEditMode && this.itemObject.productionDateType === ItemProductionDateTypes.Text.valueOf() ? true : false),
      sequence: new FormControl(this.isEditMode && this.itemObject.sequence && this.itemObject.sequence != -1 ? this.itemObject.sequence : null),
      stockTolerance: new FormControl(this.isEditMode && this.itemObject.stockTolerance && this.itemObject.stockTolerance > 0 ? this.itemObject.stockTolerance : null),
      storageTolerance: new FormControl(this.isEditMode && this.itemObject.storageTolerance && this.itemObject.storageTolerance > 0 ? this.itemObject.storageTolerance : null),
      weightTolerance: new FormControl(this.isEditMode && this.itemObject.weightTolerance && this.itemObject.weightTolerance > 0 ? this.itemObject.weightTolerance : null)
    });
  }

  onIsNewExpireDateSelected(date) {
    this.ExpireisNewDate =new Date(date.date) ;

  }

  onisNew(){
    setTimeout(() => {
      var isNew = this.itemDefinitionForm.get("isNew").value
      if(isNew){
        this.showIsNewExpireDate = true
        this.itemDefinitionForm.get("ExpireisNewDate").setValidators(Validators.required)
        this.itemDefinitionForm.get("ExpireisNewDate").updateValueAndValidity
      }
      else{
        this.showIsNewExpireDate = false
        this.itemDefinitionForm.get("ExpireisNewDate").clearValidators();

        this.itemDefinitionForm.get("ExpireisNewDate").setValidators(Validators.nullValidator)
        //this.itemDefinitionForm.get("ExpireisNewDate").setValidators(Validators.nullValidator)
        this.itemDefinitionForm.get("ExpireisNewDate").updateValueAndValidity
         this.itemDefinitionForm.get("ExpireisNewDate").reset();
        // this.ExpireisNewDate = new Date();
      }
    }, 500);
  }
  showIsNewExpireDate =false;
  isValidbasePack = false;
  initPacksForm() {
    this.packDefinitionBasepackForm = new FormGroup({
      packTypeId: new FormControl(null, Validators.required),
      quantity: new FormControl(1, [Validators.required, Validators.min(1)]),
      packBarcode: new FormControl(null, Validators.required),
      packGroups: new FormControl([]),
      serialSeparator: new FormControl({ value: null, disabled: true }),
      templateId: new FormControl(null),
      gtin: new FormControl(null),
      isWeightPriced: new FormControl(false),
      isDefaultPack: new FormControl(false),
      allowFractionInQty: new FormControl(false),
      packOperations: new FormControl([]),
      packChildId: new FormControl(null),
      height: new FormControl(null),
      width: new FormControl(null),
      dipth: new FormControl(null),
      weight: new FormControl(null),
      companyPrefix: new FormControl(null),
      equivalencyFactor: new FormControl(null)
    });
    this.packDefinitionBasepackForm.get('quantity').disable()
    if(this.isEditMode){
      this.packDefinitionBasepackForm.disable()
      this.isValidbasePack = true
      this.showAddNewUomInBasePackUom =  false;
    }
    this.packDefinitionForm = new FormGroup({
      packTypeId: new FormControl(null, Validators.required),
      quantity: new FormControl(null, [Validators.required, Validators.min(1)]),
      packBarcode: new FormControl(null, Validators.required),
      packGroups: new FormControl([]),
      serialSeparator: new FormControl({ value: null, disabled: true }),
      templateId: new FormControl(null),
      gtin: new FormControl(null),
      isWeightPriced: new FormControl(false),
      isDefaultPack: new FormControl(false),
      allowFractionInQty: new FormControl(false),
      packOperations: new FormControl([]),
      packChildId: new FormControl(null),
      height: new FormControl(null),
      width: new FormControl(null),
      dipth: new FormControl(null),
      weight: new FormControl(null),
      companyPrefix: new FormControl(null),
      equivalencyFactor: new FormControl(null)
    });
    if(!this.isValidbasePack && !this.isEditMode ){
    this.packDefinitionForm.disable()
    this.showAddNewUom = false;
    }
    this.packDefinitionForm.get('packOperations').setValue(this.packOperationList);
  }

  fillItemData(response) {
    if (response.status != null && response.status >= 0) {
      this.hidePackChildList = false;
      this.packChildList = [];
      this.packsList = response.data.packs ? response.data.packs : [];
      this.itemObject.descriptionLanguages = response.data.descriptionLanguages;
      this.savedSensorTableList = response.data.sensors;
      if (response.data.competitorsList && response.data.competitorsList.length > 0 && response.data.itemTypeId === ItemTypes.TradingItem.valueOf()) {
        this.itemObject.competitorsList = response.data.competitorsList;
        this.selectedCompetitors = [];
        response.data.competitorsList.forEach(i => {
          var comp = new CompetitorModel();
          comp = {
            competitorItemId: i.competitorItemId,
            competitorItemName: i.competitorItemName
          }
          this.selectedCompetitors.push(comp);
        });
      }
      if (response.data.competitor && response.data.itemTypeId === ItemTypes.CompetitorItem.valueOf()) {
        var itemId;
        if (response.data.competitor.itemId === -1 || response.data.competitor.itemId === null) {
          itemId = null;
        } else {
          itemId = response.data.competitor.itemId;
          this.selectedCompetitorItemId = response.data.competitor.itemId;
        }
        this.itemDefinitionForm.get('tradingItemId').setValue(itemId);
        this.itemDefinitionForm.get('competitorId').setValue(response.data.competitor.competitorId);
      }
      this.itemTypeId = response.data.itemTypeId;
      // To handle case when pack is assigned to pack group that linked to promotion and have distinct pack quantities
      // this group must not shown in selection list, so we delete it from this pack and set data action for pack as [Edit]
      // to reflect DB with this change
      this.packsList.forEach(pack => {
        if (pack.packGroupsList && pack.packGroupsList.length > 0) {
          pack.packGroupsList.forEach(addedGroup => {
            var index = this.packGroupsList.findIndex(x => x.packGroupId === addedGroup.packGroupId);
            if (index === -1) {
              pack.packGroupsList.splice(index, 1);
              pack.dataAction = DataActions.Edit;
            }
          })
        }
        if (pack.packOperationsList && pack.packOperationsList.length > 0) {
          pack.packOperationsList.forEach(operation => {
            if (operation.operationId == PackOperations.Sales.valueOf())
              operation.operation = this.translateService.instant("Desc_Sales");
            else if (operation.operationId == PackOperations.Order.valueOf())
              operation.operation = this.translateService.instant("Desc_Order_Operation");
            else if (operation.operationId == PackOperations.Return.valueOf())
              operation.operation = this.translateService.instant("Desc_Return");
            else if (operation.operationId == PackOperations.Exchange.valueOf())
              operation.operation = this.translateService.instant("Desc_Exchange");
            else if (operation.operationId == PackOperations.Load.valueOf())
              operation.operation = this.translateService.instant("Desc_Load");
            else if (operation.operationId == PackOperations.Offload.valueOf())
              operation.operation = this.translateService.instant("Desc_Offload");
            else if (operation.operationId == PackOperations.InputVoucher.valueOf())
              operation.operation = this.translateService.instant("Desc_Input_Voucher");
            else if (operation.operationId == PackOperations.OutputVoucher.valueOf())
              operation.operation = this.translateService.instant("Desc_Output_Voucher");
            else if (operation.operationId == PackOperations.IncomingStock.valueOf())
              operation.operation = this.translateService.instant("Desc_Incoming");
            else if (operation.operationId == PackOperations.IncomingReturns.valueOf())
              operation.operation = this.translateService.instant("Desc_Incoming_Returns");
            else if (operation.operationId == PackOperations.ManufacturingDefects.valueOf())
              operation.operation = this.translateService.instant("Desc_Manufacturing_Defects");
            else if (operation.operationId == PackOperations.DamagedStock.valueOf())
              operation.operation = this.translateService.instant("Desc_Damaged_Stock");
            else if (operation.operationId == PackOperations.ReturnOrder.valueOf())
              operation.operation = this.translateService.instant("Desc_Return_Order");
            else if (operation.operationId == PackOperations.CreditNoteRequest.valueOf())
              operation.operation = this.translateService.instant("Desc_Doc_Seq_Credit_Note_Request");
          });
        }
        this.childPack = new PackModel();
        this.childPack.packId = pack.packId;
        this.childPack.packTypeId = pack.packTypeId;
        this.childPack.packTypeName = pack.packTypeName;
        this.childPack.quantity = pack.quantity;
        this.childPack.uom = pack.packTypeName;
        this.packChildList.push(this.childPack);
        this.packChildList = [...this.packChildList];
        this.packDefinitionForm.get('packChildId').updateValueAndValidity();
        this.isPackChildLoading = false;
      });
      this.allPackChildList = this.packChildList;
      this.isLoading = true;
      for (const sensor of this.sensorTableList) {
        const fieldIndex = this.savedSensorTableList.findIndex(x => x.sensorId === sensor.sensorId);
        if (fieldIndex > -1) {
          sensor.sensorMinValue = +this.savedSensorTableList[fieldIndex].sensorMinValue;
          sensor.sensorMaxValue = +this.savedSensorTableList[fieldIndex].sensorMaxValue;
          sensor.isChecked = true;
        }
      }
      this.isLoading = false;
      this.fillPacksList();
      this.onChangeHasSerialFlag();
      this.onChangeAutoGenerateSubSerials();

      var imagesNames = response.data.attachmentList;
      if (imagesNames && imagesNames.length > 0) {
        for (let imageName of imagesNames) {
          var currentPath = document.getElementsByTagName("base")[0].href + "Resources/attachements/Items/" + this.itemObject.itemId + "/" + imageName + "?random=" + new Date().getTime();
          let imageFile = new ImageFileModel();
          imageFile.name = imageName;
          imageFile.path = currentPath;
          this.getImage(currentPath, imageName).subscribe(response => imageFile.file = response);
          this.attahcedImages.push(imageFile);
        }
      }
    } else {
      this.itemDefinitionForm.reset();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(response.message));
    }
  }

  getImage(url, imageName) {
    return this.http
      .get(url, {
        responseType: "blob"
      })
      .pipe(
        map(response => {
          return new File([response], imageName);
        })
      );
  }
  populateItemBrandsList() {
   // this.coreSession.ModalLoading.Show();
    this.isBrandsLoading = true;
    this.brandService.getItemBrand().subscribe(result => {
      this.itemBrandList = result.data;
      this.isBrandsLoading = false;
      this.coreSession.ModalLoading.Hide();
    });
  }
  populateItemModelList() {
    //this.coreSession.ModalLoading.Show();
    this.isModelsLoading = true;
    this.itemService.getItemModel().subscribe(result => {
      this.allItemModelList = result.data;
      this.filteredItemModelList = [];
      if (this.isEditMode && this.itemObject.brandId && this.itemObject.brandId != -1) {
        this.fillBrandModelsList(this.itemObject.brandId);
      }
      this.isModelsLoading = false;
      this.coreSession.ModalLoading.Hide();
    });
  }
  populateBarcodeTemplateList() {
    //this.coreSession.ModalLoading.Show();
    this.isTemplateLoading = true;
    this.itemService.getItemsTemplate().subscribe(result => {
      this.barcodeTemplateList = result.data;
      this.isTemplateLoading = false;
      this.coreSession.ModalLoading.Hide();
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  fillBrandModelsList(brandId) {
    this.filteredItemModelList = [];
    this.filteredItemModelList = this.allItemModelList.filter(model => model.brandId === brandId);
  }
  populateItemTypesList() {
    //this.coreSession.ModalLoading.Show();
    this.isTypesLoading = true;
    this.itemService.getItemTypes().subscribe(result => {
      this.itemTypesList = result.data;
      this.isTypesLoading = false;
      this.coreSession.ModalLoading.Hide();
    });
  }
  populatePackGroupsList() {
    //this.coreSession.ModalLoading.Show();
    this.packGroupService.getPackGroupsItemDefinition().subscribe(result => {
      this.packGroupsList = result.data;
      this.coreSession.ModalLoading.Hide();
    });
  }
  populatePackOperations() {
    this.packOperationList = [
      { operationId: PackOperations.Sales.valueOf(), operation: this.translateService.instant("Desc_Sales") },
      { operationId: PackOperations.Order.valueOf(), operation: this.translateService.instant("Desc_Order_Operation") },
      { operationId: PackOperations.Return.valueOf(), operation: this.translateService.instant("Desc_Return") },
      { operationId: PackOperations.Exchange.valueOf(), operation: this.translateService.instant("Desc_Exchange") },
      { operationId: PackOperations.Load.valueOf(), operation: this.translateService.instant("Desc_Load") },
      { operationId: PackOperations.Offload.valueOf(), operation: this.translateService.instant("Desc_Offload") },
      { operationId: PackOperations.InputVoucher.valueOf(), operation: this.translateService.instant("Desc_Input_Voucher") },
      { operationId: PackOperations.OutputVoucher.valueOf(), operation: this.translateService.instant("Desc_Output_Voucher") },
      { operationId: PackOperations.IncomingStock.valueOf(), operation: this.translateService.instant("Desc_Incoming") },
      { operationId: PackOperations.IncomingReturns.valueOf(), operation: this.translateService.instant("Desc_Incoming_Returns") },
      { operationId: PackOperations.ManufacturingDefects.valueOf(), operation: this.translateService.instant("Desc_Manufacturing_Defects") },
      { operationId: PackOperations.DamagedStock.valueOf(), operation: this.translateService.instant("Desc_Damaged_Stock") },
      { operationId: PackOperations.ReturnOrder.valueOf(), operation: this.translateService.instant("Desc_Return_Order") },
      { operationId: PackOperations.CreditNoteRequest.valueOf(), operation: this.translateService.instant("Desc_Doc_Seq_Credit_Note_Request") },
    ]
  }

  fillItemObject() {
    this.itemObject.hasImage = this.hasImage;
    this.itemObject.isImageChanged = this.isImageChanged;
    this.itemObject.itemName = this.itemDefinitionForm.value.name;
    this.itemObject.itemCode = this.itemDefinitionForm.value.code;
    this.itemObject.itemTypeId = this.itemDefinitionForm.value.itemType? this.itemDefinitionForm.value.itemType : -1;;
    this.itemObject.itemCategoryId = this.itemDefinitionForm.value.itemCategoryId;
    this.itemObject.lowStockQty = this.itemDefinitionForm.value.lowStockQty?this.itemDefinitionForm.value.lowStockQty:-1;
    this.itemObject.brandId = this.itemDefinitionForm.value.brandId ? this.itemDefinitionForm.value.brandId : -1;
    this.itemObject.modelId = this.itemDefinitionForm.value.modelId ? this.itemDefinitionForm.value.modelId : -1;
    this.itemObject.packDefinition = this.itemDefinitionForm.value.definition ? this.itemDefinitionForm.value.definition : '';
    this.itemObject.shelfLifeTime = this.itemDefinitionForm.value.shelfLifeTime ? +this.itemDefinitionForm.value.shelfLifeTime : -1;
    this.itemObject.sequence = this.itemDefinitionForm.value.sequence ? +this.itemDefinitionForm.value.sequence : -1;
    this.itemObject.stockTolerance = this.itemDefinitionForm.value.stockTolerance ? +this.itemDefinitionForm.value.stockTolerance : 0;
    this.itemObject.storageTolerance = this.itemDefinitionForm.value.storageTolerance ? +this.itemDefinitionForm.value.storageTolerance : 0;
    this.itemObject.weightTolerance = this.itemDefinitionForm.value.weightTolerance ? +this.itemDefinitionForm.value.weightTolerance : 0;

    this.itemObject.inactive = this.itemDefinitionForm.value.inactive;
    this.itemObject.isInitiative = this.itemDefinitionForm.value.isInitiative;
    this.itemObject.isBatchPriced = this.itemDefinitionForm.value.isBatchPriced;
    this.itemObject.temporaryCredit = this.itemDefinitionForm.value.isTempCredit;
    this.itemObject.isDefaultBatchNo = this.itemDefinitionForm.value.isDefultBatch;
    this.itemObject.isPowerSKU = this.itemDefinitionForm.value.isPowerSKU;
    this.itemObject.isPriceProtected = this.itemDefinitionForm.value.isPriceProtected;
    this.itemObject.isNew = this.itemDefinitionForm.value.isNew;
    this.itemObject.forceDefaultPack = this.itemDefinitionForm.value.forceDefaultPack;
    this.itemObject.hasSerialNumber = this.itemDefinitionForm.value.hasSerialNumber;
    this.itemObject.autoGenerateSubSerials = this.itemDefinitionForm.value.autoGenerateSubSerials;
    this.itemObject.enableBatchForSerial = this.itemDefinitionForm.value.enableBatchForSerial;
    this.itemObject.inSCS = this.itemObject.hasSerialNumber ? this.itemDefinitionForm.value.inSCS : false;
    this.itemObject.packs = this.packsList;
    this.itemObject.secondaryPacks = this.secondaryPacksList;
    this.itemObject.requiredByLiter = this.itemDefinitionForm.value.requiredByLiter;
    this.itemObject.inStock = this.itemDefinitionForm.value.inStock;
    this.itemObject.vendorId = this.itemDefinitionForm.value.vendorId ? this.itemDefinitionForm.value.vendorId : -1;
    this.itemObject.productionDateType = this.itemDefinitionForm.value.isDate ? ItemProductionDateTypes.Date.valueOf() : this.itemDefinitionForm.value.isText ? ItemProductionDateTypes.Text.valueOf() : ItemProductionDateTypes.None.valueOf();

     if(!this.itemObject.isNewExpireDate)
      this.itemObject.isNewExpireDateModel = new DateTimeModel()

     this.itemObject.isNewExpireDateModel = this.ExpireisNewDate?this.coreSession.getDateTimeModel(this.ExpireisNewDate):this.coreSession.getDateTimeModel(new Date(0))
      if(this.isEditMode){
        // const date = new Date(this.ExpireisNewDate);

         this.itemObject.isNewExpireDate =  new Date(this.ExpireisNewDate)
      }


    let descriptions = this.otherLanguages;
    if (descriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      descriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.itemDefinitionForm.value.name
      });
    }
    this.itemObject.descriptionLanguages = descriptions;
    if (this.sensorTableList && this.sensorTableList.length > 0) {
      this.sensorTableList.forEach(sensor => {
        if (!sensor.sensorMaxValue) {
          sensor.sensorMaxValue = 0;
        }
        if (!sensor.sensorMinValue) {
          sensor.sensorMinValue = 0;
        }
      });
    }
    this.itemObject.sensors = this.sensorTableList;
    //competitor Item:
    if (this.itemObject.itemTypeId === ItemTypes.CompetitorItem.valueOf()) {
      this.itemObject.competitor = {
        competitorId: this.itemDefinitionForm.value.competitorId ? this.itemDefinitionForm.value.competitorId : -1,
        itemId: this.itemDefinitionForm.value.tradingItemId ? this.itemDefinitionForm.value.tradingItemId : -1,
        organizationId: -1
      }
    }
    if (this.itemObject.itemTypeId === ItemTypes.TradingItem.valueOf()) {
      this.itemObject.competitorsList = [];
      this.selectedCompetitors.forEach(c => {
        var comp = new CompetitorModel();
        var result = this.competitorItemList.filter(i => i.competitorItemName === c.competitorItemName
          && i.competitorItemId === c.competitorItemId);
        comp = {
          competitorItemId: result[0].competitorItemId,
          competitorName: result[0].competitorName,
          competitorId: result[0].competitorId
        }
        this.itemObject.competitorsList.push(comp);
      });
    }
    this.onChangeAutoGenerateSubSerials();
  }
  saveItemToDB() {
    var formData: FormData = new FormData();
    if (this.itemObject.hasImage && this.itemObject.isImageChanged) {
      formData.append("image", this.selectedImage, this.selectedImage.name);
    }
    formData.append('item', JSON.stringify(this.itemObject));
    for (let file of this.attahcedImages) {
      formData.append('attahcedImages', file.file, file.name);
    }
    //this.coreSession.ModalLoading.Show();
    console.log(this.itemObject);
    this.itemService.saveItem(formData, this.isEditMode).subscribe(
      result => {
        this.coreSession.ModalLoading.Hide();
        if (result.status != null && result.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
          this.onSaveCompleted.emit();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), result.message);
        }
      },
      error => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  onChangeItemBrand() {
    this.itemDefinitionForm.get('modelId').reset();
    if (this.itemDefinitionForm.get('brandId').value) {
      this.fillBrandModelsList(this.itemDefinitionForm.get('brandId').value);
    }
  }
  onChangePackType(selectedUOM) {
    this.seletedPackTypeName = null;
    if (selectedUOM) {
      this.seletedPackTypeName = selectedUOM.packTypeName;
    }
    if (!this.isEditMode) {
      this.hidePackChildList = false;
      this.packChildList = [];
      this.packsList.forEach(pack => {
        if (pack.packTypeName != selectedUOM.packTypeName) {
          this.packChildList = [];
          this.packsList.forEach(pack => {
            this.childPack = new PackModel();
            this.childPack.packId = pack.packId;
            this.childPack.packTypeId = pack.packTypeId;
            this.childPack.packTypeName = pack.packTypeName;
            this.childPack.quantity = pack.quantity;
            this.childPack.uom = pack.packTypeName;
            this.packChildList.push(this.childPack);
            this.packChildList = [...this.packChildList];
            this.packDefinitionForm.get('packChildId').updateValueAndValidity();
          });
        }
      });
      this.allPackChildList = this.packChildList;
    }
  }
  onUploadFinished(event: any) {
    if (event.target.files && event.target.files[0]) {
      const reader = new FileReader();
      this.selectedImage = event.target.files[0];
      this.hasImage = true;
      this.isImageChanged = true;
      reader.onload = (event: ProgressEvent) => {
        this.imagePath = (<FileReader>event.target).result;
      };
      reader.readAsDataURL(event.target.files[0]);
    }
  }
  onClearImage() {
    this.isImageChanged = true;
    this.hasImage = false;
    this.selectedImage = null;
    this.setDefaultImage();
  }
  setDefaultImage() {
    this.imagePath = document.getElementsByTagName("base")[0].href + "Resources/NoProduct-Echo.jpg";
  }
  onOtherLanguagesTextSubmitted(event) {
    this.otherLanguages = event;
  }
  onChangeHasSerialFlag() {
    this.isHasSerial = this.itemDefinitionForm.get('hasSerialNumber').value;
    if (this.itemDefinitionForm.get('hasSerialNumber').value) {
      this.packDefinitionForm.get('serialSeparator').enable({ onlySelf: true, emitEvent: false });
      this.packDefinitionForm.get('serialSeparator').updateValueAndValidity();
      this.packDefinitionForm.get('templateId').enable({ onlySelf: true, emitEvent: false });
      this.packDefinitionForm.get('templateId').updateValueAndValidity();
    }
    else {
      this.packDefinitionForm.get('serialSeparator').reset();
      this.packDefinitionForm.get('serialSeparator').disable({ onlySelf: true, emitEvent: false });
      this.packDefinitionForm.get('serialSeparator').updateValueAndValidity();
      this.packDefinitionForm.get('templateId').reset();
      this.packDefinitionForm.get('templateId').disable({ onlySelf: true, emitEvent: false });
      this.packDefinitionForm.get('templateId').setValue(null);
      this.packDefinitionForm.get('templateId').updateValueAndValidity();
      this.packsList.forEach(pack => {
        pack.templateId = -1;
      });
    }
  }
  onChangeAutoGenerateSubSerials() {
    if (this.isHasSerial && !this.itemDefinitionForm.get('autoGenerateSubSerials').value) {
      this.packDefinitionForm.get('templateId').enable({ onlySelf: true, emitEvent: false });
      this.packDefinitionForm.get('templateId').updateValueAndValidity();
    }
    else {
      this.packDefinitionForm.get('templateId').reset();
      this.packDefinitionForm.get('templateId').disable({ onlySelf: true, emitEvent: false });
      this.packDefinitionForm.get('templateId').setValue(null);
      this.packDefinitionForm.get('templateId').updateValueAndValidity();
      this.packsList.forEach(pack => {
        pack.templateId = -1;
      });
    }
  }
  onSaveClicked() {
    this.coreSession.markFormGroupTouched(this.itemDefinitionForm);
    if (this.itemDefinitionForm.invalid) {
      this.showEntrySection(0);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
    if (!this.packsList.filter(pack => pack.dataAction != DataActions.Delete) || this.packsList.filter(pack => pack.dataAction != DataActions.Delete).length === 0) {
      this.showEntrySection(1);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgDefineItemPacks));
      return;
    }
    if (!this.packsList.filter(pack => pack.quantity === 1 && pack.dataAction != DataActions.Delete) || this.packsList.filter(pack => pack.quantity === 1 && pack.dataAction != DataActions.Delete).length === 0) {
      this.showEntrySection(1);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgDefineMinPackQty));
      return;
    }

    if (
      this.packsList.filter(pack => pack.packTypeId == null || pack.packTypeId == 0).length > 0 ||
      this.packsList.filter(pack => pack.quantity == null || pack.quantity == 0).length > 0 ||
      this.packsList.filter(pack => pack.packBarcode == null || pack.packBarcode == "").length > 0) {
      this.showEntrySection(1);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatoryForPacks));
      return;
    }
    if (this.itemDefinitionForm.value.forceDefaultPack && (!this.packsList.filter(pack => pack.isDefaultPack === true && pack.dataAction != DataActions.Delete) || this.packsList.filter(pack => pack.isDefaultPack === true && pack.dataAction != DataActions.Delete).length === 0)) {
      this.showEntrySection(1);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgDefineDefaultPack));
      return;
    }
    if (this.sensorTableList && this.sensorTableList.length > 0) {
      if (this.sensorTableList.filter(sensor => sensor.isChecked && +sensor.sensorMinValue > +sensor.sensorMaxValue).length > 0) {
        this.showEntrySection(2);
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgMinExceedsMax));
        return;
      }
    }
    // Validate item code
    let codeFilter = {
      tableName: 'Item',
      columnName: 'ItemCode',
      insertedValue: this.itemDefinitionForm.value.code,
      excludedString: ' And ItemId != ' + this.itemObject.itemId,
    }
    //this.coreSession.ModalLoading.Show();
    this.masterDataService.checkIfUniqueValue(codeFilter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        if (!response.data) {
          this.showEntrySection(0);
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueCode));
          return;
        }
        else {
          this.fillItemObject();
          this.saveItemToDB();
        }
      }
      else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });
  }
  //#region[Packs]
  fillPacksList() {
    if(this.isValidbasePack)
    this.resetPackDefinition(false);
  else
  this.resetPackDefinition(true);

    if (this.packsList.filter(x => x.dataAction != DataActions.Delete)) {
      this.dataSource = {
        data: this.packsList.filter(x => x.dataAction != DataActions.Delete),
        totalItems: this.packsList.filter(x => x.dataAction != DataActions.Delete).length,
      }
    } else {
      this.dataSource = {
        data: [],
        totalItems: 0,
      }
    }

  }
  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
          (res: DialogResult) => {
            if (res === DialogResult.Yes) {
              if (event.object.packId > 0) {
                //this pack is saved before so must check if it's used or not.
                this.isValidToDeletePack(event.object);
              }
              else {
                // this pack is not save before, so no need to validate delete it's never used.
                this.deleteSelectedPack(event.object);
              }
            }
          });
        break;
      case RowOperation.edit:
        this.fillPackDefinitionToEdit(event.object);
        break;
    }
  }
  fillPackDefinitionToEdit(selectedPack: any) {
    // if(this.editMode)
    if(this.packDefinitionForm.status=="DISABLED" && this.packDefinitionBasepackForm.status!="INVALID"){
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.Desc_Edit_Base_Quantity_First));
    return ;
    }




    if(selectedPack.quantity==1){

      if(this.packDefinitionBasepackForm.status=="DISABLED" && this.packDefinitionForm.status!="INVALID"){
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.Desc_Finish_Editing_Field_First));//
      return ;
      }
      this.showAddNewUomInBasePackUom = true;
      this.showAddNewUom=false

      this.isValidbasePack = false;
      this.packDefinitionForm.disable()
      this.packDefinitionBasepackForm.enable()
      this.packDefinitionBasepackForm.get('quantity').disable()
      this.hidePackChildList = false;
      this.packDefinitionBasepackForm.get('packChildId').enable();
      this.packDefinitionBasepackForm.get('packChildId').updateValueAndValidity();
      this.packChildList = this.allPackChildList;
      this.packChildList = this.allPackChildList.filter(pack => pack.quantity < selectedPack.quantity);
      if (this.packChildList && (this.packChildList.length == 0 || this.packChildList.length == 1)) {
        this.hidePackChildList = true;
      }
      if (selectedPack.childPackId && selectedPack.childPackId != -1) {
        this.packDefinitionBasepackForm.get('packChildId').setValue(selectedPack.childPackId);
      }
      // selectedPack.packOperationsList = selectedPack.packOperationsList.filter(item => (item.operationId !== 6 && item.operationId !== 8));
      this.packDefinitionBasepackForm.get('packTypeId').setValue(selectedPack.packTypeId);
      this.packDefinitionBasepackForm.get('serialSeparator').setValue(selectedPack.serialSeparator != "Null" ? selectedPack.serialSeparator : '');
      this.packDefinitionBasepackForm.get('quantity').setValue(selectedPack.quantity);
      this.packDefinitionBasepackForm.get('packBarcode').setValue(selectedPack.packBarcode);
      this.packDefinitionBasepackForm.get('isWeightPriced').setValue(selectedPack.isWeightPriced);
      this.packDefinitionBasepackForm.get('isDefaultPack').setValue(selectedPack.isDefaultPack);
      this.packDefinitionBasepackForm.get('allowFractionInQty').setValue(selectedPack.allowFractionInQty);
      this.packDefinitionBasepackForm.get('packGroups').setValue(selectedPack.packGroupsList);
      this.packDefinitionBasepackForm.get('packOperations').setValue(selectedPack.packOperationsList);
      this.packDefinitionBasepackForm.get('height').setValue(selectedPack.height);
      this.packDefinitionBasepackForm.get('equivalencyFactor').setValue(selectedPack.equivalencyFactor);
      this.packDefinitionBasepackForm.get('width').setValue(selectedPack.width);
      this.packDefinitionBasepackForm.get('dipth').setValue(selectedPack.dipth);
      this.packDefinitionBasepackForm.get('weight').setValue(selectedPack.weight);
      this.packDefinitionBasepackForm.get('templateId').setValue(selectedPack.templateId && selectedPack.templateId != -1 && !this.itemDefinitionForm.get('autoGenerateSubSerials').value ? selectedPack.templateId : null);
      this.packDefinitionBasepackForm.get('gtin').setValue(selectedPack.gtin ? selectedPack.gtin : null);
      this.packDefinitionBasepackForm.get('companyPrefix').setValue(selectedPack.companyPrefix >= 0 ? selectedPack.companyPrefix : null);

      this.onChangeHasSerialFlag();
      this.onChangeAutoGenerateSubSerials();
      this.isEditPackMode = true;
      this.btnSaveBasePackCaption = 'Desc_Edit';
      this.selectedPack = cloneDeep(selectedPack);
      this.seletedPackTypeName = this.selectedPack.packTypeName;

    }
    else{
      this.showAddNewUomInBasePackUom = false;
      this.showAddNewUom=true
      this.hidePackChildList = false;
      this.packDefinitionForm.get('packChildId').enable();
      this.packDefinitionForm.get('packChildId').updateValueAndValidity();
      this.packChildList = this.allPackChildList;
      this.packChildList = this.allPackChildList.filter(pack => pack.quantity < selectedPack.quantity);
      if (this.packChildList && (this.packChildList.length == 0 || this.packChildList.length == 1)) {
        this.hidePackChildList = true;
      }
      if (selectedPack.childPackId && selectedPack.childPackId != -1) {
        this.packDefinitionForm.get('packChildId').setValue(selectedPack.childPackId);
      }
      // selectedPack.packOperationsList = selectedPack.packOperationsList.filter(item => (item.operationId !== 6 && item.operationId !== 8));
      this.packDefinitionForm.get('packTypeId').setValue(selectedPack.packTypeId);
      this.packDefinitionForm.get('serialSeparator').setValue(selectedPack.serialSeparator != "Null" ? selectedPack.serialSeparator : '');
      this.packDefinitionForm.get('quantity').setValue(selectedPack.quantity);
      this.packDefinitionForm.get('packBarcode').setValue(selectedPack.packBarcode);
      this.packDefinitionForm.get('isWeightPriced').setValue(selectedPack.isWeightPriced);
      this.packDefinitionForm.get('isDefaultPack').setValue(selectedPack.isDefaultPack);
      this.packDefinitionForm.get('allowFractionInQty').setValue(selectedPack.allowFractionInQty);
      this.packDefinitionForm.get('packGroups').setValue(selectedPack.packGroupsList);
      this.packDefinitionForm.get('packOperations').setValue(selectedPack.packOperationsList);
      this.packDefinitionForm.get('height').setValue(selectedPack.height);
      this.packDefinitionForm.get('equivalencyFactor').setValue(selectedPack.equivalencyFactor);
      this.packDefinitionForm.get('width').setValue(selectedPack.width);
      this.packDefinitionForm.get('dipth').setValue(selectedPack.dipth);
      this.packDefinitionForm.get('weight').setValue(selectedPack.weight);
      this.packDefinitionForm.get('templateId').setValue(selectedPack.templateId && selectedPack.templateId != -1 && !this.itemDefinitionForm.get('autoGenerateSubSerials').value ? selectedPack.templateId : null);
      this.packDefinitionForm.get('gtin').setValue(selectedPack.gtin ? selectedPack.gtin : null);
      this.packDefinitionForm.get('companyPrefix').setValue(selectedPack.companyPrefix >= 0 ? selectedPack.companyPrefix : null);

      this.onChangeHasSerialFlag();
      this.onChangeAutoGenerateSubSerials();
      this.isEditPackMode = true;
      this.btnSavePackCaption = 'Desc_Edit';
      this.selectedPack = cloneDeep(selectedPack);
      this.seletedPackTypeName = this.selectedPack.packTypeName;

    }



    // var index = this.barcodeTemplateList.findIndex(x => x.templateId == selectedPack.templateId);
    // if (index > -1)
    //   this.onBarcodeTemplateChange(this.barcodeTemplateList[index]);

  }

  resetPackDefinition(basePack:boolean) {
    if(basePack){
      this.hidePackChildList = false;
      this.packChildList = this.allPackChildList;
      this.packDefinitionBasepackForm.get('packTypeId').reset();
    this.packDefinitionBasepackForm.get('packBarcode').reset();
    this.packDefinitionBasepackForm.get('packGroups').reset();
    this.packDefinitionBasepackForm.get('templateId').reset();
    this.packDefinitionBasepackForm.get('packChildId').reset();
    this.packDefinitionBasepackForm.get('equivalencyFactor').reset();
    this.packDefinitionBasepackForm.get('gtin').reset();
    this.packDefinitionBasepackForm.get('packGroups').setValue([], { emitEvent: false });
    this.packDefinitionBasepackForm.get('packGroups').updateValueAndValidity();
    var groups = cloneDeep(this.packGroupsList);
    this.packGroupsList = [];
    this.packGroupsList = groups;
    this.packDefinitionBasepackForm.get('serialSeparator').reset();
    // this.packDefinitionForm.get('serialSeparator').disable({ onlySelf: true, emitEvent: false });
    this.packDefinitionBasepackForm.get('isWeightPriced').setValue(false);
    this.packDefinitionBasepackForm.get('isDefaultPack').setValue(false);
    this.packDefinitionBasepackForm.get('allowFractionInQty').setValue(false);
    this.packDefinitionBasepackForm.get('height').setValue(0);
    this.packDefinitionBasepackForm.get('width').setValue(0);
    this.packDefinitionBasepackForm.get('dipth').setValue(0);
    this.packDefinitionBasepackForm.get('weight').setValue(0);
    this.packDefinitionBasepackForm.get('packOperations').reset();
    this.packDefinitionBasepackForm.get('packOperations').setValue([], { emitEvent: false });
    this.packDefinitionBasepackForm.get('packOperations').updateValueAndValidity();
    var operations = cloneDeep(this.packOperationList);
    this.packOperationList = [];
    this.packOperationList = operations;
    this.packDefinitionBasepackForm.get('packOperations').setValue(this.packOperationList);
    this.packDefinitionBasepackForm.get('companyPrefix').reset();

    this.isEditPackMode = false;
    this.btnSaveBasePackCaption = 'Desc_Add';
    this.selectedPack = null;
    }
    else{
      this.hidePackChildList = false;
      this.packChildList = this.allPackChildList;
      this.packDefinitionForm.get('packTypeId').reset();
      this.packDefinitionForm.get('quantity').reset();
    this.packDefinitionForm.get('packBarcode').reset();
    this.packDefinitionForm.get('packGroups').reset();
    this.packDefinitionForm.get('templateId').reset();
    this.packDefinitionForm.get('packChildId').reset();
    this.packDefinitionForm.get('equivalencyFactor').reset();
    this.packDefinitionForm.get('gtin').reset();
    this.packDefinitionForm.get('packGroups').setValue([], { emitEvent: false });
    this.packDefinitionForm.get('packGroups').updateValueAndValidity();
    var groups = cloneDeep(this.packGroupsList);
    this.packGroupsList = [];
    this.packGroupsList = groups;
    this.packDefinitionForm.get('serialSeparator').reset();
    // this.packDefinitionForm.get('serialSeparator').disable({ onlySelf: true, emitEvent: false });
    this.packDefinitionForm.get('isWeightPriced').setValue(false);
    this.packDefinitionForm.get('isDefaultPack').setValue(false);
    this.packDefinitionForm.get('allowFractionInQty').setValue(false);
    this.packDefinitionForm.get('height').setValue(0);
    this.packDefinitionForm.get('width').setValue(0);
    this.packDefinitionForm.get('dipth').setValue(0);
    this.packDefinitionForm.get('weight').setValue(0);
    this.packDefinitionForm.get('packOperations').reset();
    this.packDefinitionForm.get('packOperations').setValue([], { emitEvent: false });
    this.packDefinitionForm.get('packOperations').updateValueAndValidity();
    var operations = cloneDeep(this.packOperationList);
    this.packOperationList = [];
    this.packOperationList = operations;
    this.packDefinitionForm.get('packOperations').setValue(this.packOperationList);
    this.packDefinitionForm.get('companyPrefix').reset();

    this.isEditPackMode = false;
    this.btnSavePackCaption = 'Desc_Add';
    this.selectedPack = null;
  }
  }
  onAddEditPack() {

    this.coreSession.markFormGroupTouched(this.packDefinitionForm);
    if (this.packDefinitionBasepackForm.invalid) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));

      if (this.packDefinitionForm.invalid) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
        return;
      }

}else{
  if(!this.isValidbasePack)
  this.submitForms(true)
else
this.submitForms(false)
}


  }
  submitForms(basePack:boolean){
var form :FormGroup =this.packDefinitionForm
    if(basePack)
     form =this.packDefinitionBasepackForm

    if (!this.isEditPackMode) {
      this.selectedPack = new PackModel();
      this.selectedPack.packId = this.maxPackIdForAdd - 1;
      this.selectedPack.dataAction = DataActions.Add;
    }

    // Validate packBarcode with current added packs
    var packBarcode = form.get('packBarcode').value;
    if (this.packsList.findIndex(x => x.packBarcode === packBarcode && x.dataAction != DataActions.Delete && x.packId != this.selectedPack.packId) >= 0) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueBarcode));
      return;
    }

    // Validate Quantity with current added packs
    var quantity = +form.get('quantity').value;
    if (this.packsList.findIndex(x => x.quantity === quantity && x.dataAction != DataActions.Delete && x.packId != this.selectedPack.packId) >= 0) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniquePackQuantity));
      return;
    }

    // Validate Child Pack with CurrentPack
    if (form.get('packChildId') && form.get('packChildId').value) {
      var index = -1;
      index = this.packChildList.findIndex(x => x.packId == form.get('packChildId').value);
      if (index > -1) {
        if (quantity <= this.packChildList[index].quantity) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgPackChildQuantity));
          return;
        }
      }
    }

    // Validate UOM with current added packs
    var packTypeId = form.get('packTypeId').value;
    if (this.packsList.findIndex(x => x.packTypeId === packTypeId && x.dataAction != DataActions.Delete && x.packId != this.selectedPack.packId) >= 0) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniquePackType));
      return;
    }

    // Validate Assigned groups quantity
    var isValidPackGroup = true;
    var selectedGroups = !form.get('packGroups').value ? [] : form.get('packGroups').value;
    selectedGroups.forEach(addedGroup => {
      if (isValidPackGroup && this.packGroupsList.findIndex(orginalGroup => orginalGroup.packGroupId === addedGroup.packGroupId && orginalGroup.hasPromotion && orginalGroup.groupPackQuantity != quantity) >= 0) {
        isValidPackGroup = false;
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), addedGroup.packGroupCodeName + ' : ' + this.translateService.instant(ConstantMessages.MsgPackGroupNotMatchPackQuantity));
        return;
      }
    });
    if (!isValidPackGroup) {
      return;
    }
    if (this.containsGTIN && (!form.value.gtin || form.value.gtin == '')) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgEmptyGTINConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (res: DialogResult) => {
          if (res == DialogResult.No) {
            return;
          }
          // DB Check => Validate packBarcode with saved packs for other items
          let codeFilter = {
            tableName: 'Pack',
            columnName: 'Barcode',
            insertedValue: packBarcode,
            excludedString: ' And ItemId != ' + this.itemObject.itemId,
          }
          if (this.selectedPack != null) {
            //this.coreSession.ModalLoading.Show();
            this.masterDataService.checkIfUniqueValue(codeFilter).subscribe(response => {

              this.coreSession.ModalLoading.Hide();
              if (response.status != null && response.status >= 0) {
                if (!response.data) {
                  this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueBarcode));
                  return;
                }
                else {

                  this.fillPackObject(this.selectedPack,form);
                  var currentPack = cloneDeep(this.selectedPack);
                  var index = this.packsList.findIndex(x => x.packId === currentPack.packId);
                  if (index >= 0) {
                    if (currentPack.packId > 0) {
                      currentPack.DataAction = DataActions.Edit;
                    }
                    this.packsList[index] = currentPack;
                  } else {
                    this.packsList.push(currentPack);
                    this.childPack = new PackModel();
                    this.childPack.packId = currentPack.packId;
                    this.childPack.packTypeId = currentPack.packTypeId;
                    this.childPack.packTypeName = currentPack.packTypeName;
                    this.childPack.quantity = currentPack.quantity;
                    this.childPack.uom = currentPack.packTypeName;
                    this.packChildList.push(this.childPack);
                    this.packChildList = [...this.packChildList];
                    this.packDefinitionForm.get('packChildId').updateValueAndValidity();
                    this.allPackChildList = this.packChildList;
                    this.maxPackIdForAdd = currentPack.packId;
                  }
                  this.fillPacksList();
                  if(basePack){
                    this.isValidbasePack = true;
                    this.packDefinitionForm.enable()
                    this.showAddNewUomInBasePackUom = false;
                    this.showAddNewUom=true
                    this.packDefinitionBasepackForm.disable()
                  }

                }
              }
              else {
                this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
              }
            }, (error: HttpErrorResponse) => {
              this.coreSession.ModalLoading.Hide();
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
            });
          }
        });
    }
    else {
      // DB Check => Validate packBarcode with saved packs for other items
      let codeFilter = {
        tableName: 'Pack',
        columnName: 'Barcode',
        insertedValue: packBarcode,
        excludedString: ' And ItemId != ' + this.itemObject.itemId,
      }
      if (this.selectedPack != null) {
        //this.coreSession.ModalLoading.Show();
        this.masterDataService.checkIfUniqueValue(codeFilter).subscribe(response => {
          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            if (!response.data) {
              this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniqueBarcode));
              return;
            }
            else {
              this.fillPackObject(this.selectedPack,form);
              var currentPack = cloneDeep(this.selectedPack);
              var index = this.packsList.findIndex(x => x.packId === currentPack.packId);
              if (index >= 0) {
                if (currentPack.packId > 0) {
                  currentPack.DataAction = DataActions.Edit;
                }
                this.packsList[index] = currentPack;
              } else {
                this.packsList.push(currentPack);
                this.childPack = new PackModel();
                this.childPack.packId = currentPack.packId;
                this.childPack.packTypeId = currentPack.packTypeId;
                this.childPack.packTypeName = currentPack.packTypeName;
                this.childPack.quantity = currentPack.quantity;
                this.childPack.uom = currentPack.packTypeName;
                this.packChildList.push(this.childPack);
                this.packChildList = [...this.packChildList];
                this.packDefinitionForm.get('packChildId').updateValueAndValidity();
                this.allPackChildList = this.packChildList;
                this.maxPackIdForAdd = currentPack.packId;
              }
              this.fillPacksList();
              if(basePack){
                this.isValidbasePack = true;
                this.packDefinitionForm.enable()
                this.showAddNewUomInBasePackUom = false;
                this.showAddNewUom=true

                this.packDefinitionBasepackForm.disable()
              }
            }
          }
          else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        }, (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        });
      }
    }
  }
  fillPackObject(pack,form:FormGroup) {
    pack.packTypeId = form.get('packTypeId').value;
    pack.quantity = +form.get('quantity').value;
    pack.height = +form.get('height').value;
    pack.width = +form.get('width').value;
    pack.dipth = +form.get('dipth').value;
    pack.weight = +form.get('weight').value;
    pack.packBarcode = form.get('packBarcode').value;
    pack.equivalencyFactor = form.get('equivalencyFactor').value ? form.get('equivalencyFactor').value : 0;
    pack.packGroupsList = form.get('packGroups').value ? form.get('packGroups').value : [];
    pack.packOperationsList = form.get('packOperations').value ? form.get('packOperations').value : [];
    pack.serialSeparator = form.get('serialSeparator').value ? form.get('serialSeparator').value : '';
    pack.isWeightPriced = form.get('isWeightPriced').value ? form.get('isWeightPriced').value : false;
    var isDefaultPack = form.get('isDefaultPack').value ? form.get('isDefaultPack').value : false;
    pack.allowFractionInQty = form.get('allowFractionInQty').value ? form.get('allowFractionInQty').value : false;
    if (isDefaultPack) {
      this.packsList.forEach(pack => pack.isDefaultPack = false);
    }
    pack.isDefaultPack = isDefaultPack;
    pack.packTypeName = this.seletedPackTypeName;
    pack.templateId = form.value.templateId ? form.value.templateId : -1;
    pack.childPackId = form.value.packChildId ? form.value.packChildId : -1;
    pack.gtin = form.value.gtin ? this.packDefinitionForm.value.gtin : '';
    pack.companyPrefix = form.value.companyPrefix != null && form.value.companyPrefix != "" && +form.value.companyPrefix >= 0 ? +form.value.companyPrefix : -1;
  }
  isValidToDeletePack(selectedPack: any) {
    //this.coreSession.ModalLoading.Show();
    this.itemService.IsPackValidToErase(selectedPack.packId).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.deleteSelectedPack(selectedPack);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      error => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  deleteSelectedPack(selectedPack) {

    var index = this.packsList.findIndex(pack => pack.packId === selectedPack.packId);
    if (index != -1) {
      if (selectedPack.dataAction === DataActions.Add) {
        this.packsList.splice(index, 1);
      } else {
        this.packsList[index].dataAction = DataActions.Delete;
      }
      this.packChildList = this.allPackChildList;
      var index = this.packChildList.findIndex(x => x.packId === selectedPack.packId);
      if (index > -1) {
        this.packChildList.splice(index, 1);
        this.packChildList = [...this.packChildList];
        this.allPackChildList = this.packChildList;
      }
      var index = this.packsList.findIndex(x => x.childPackId === selectedPack.packId);
      if (index > -1) {
        this.packsList[index].childPackId = -1;
      }
      this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgDeletedSuccessfully));
      if(selectedPack.quantity==1){
        this.showAddNewUomInBasePackUom = true;
        this.showAddNewUom=false
        this.isValidbasePack = false;
        this.packDefinitionForm.disable()
        this.packDefinitionBasepackForm.enable()
        this.packDefinitionBasepackForm.get('quantity').disable()
        this.packDefinitionBasepackForm.get('quantity').setValue(1);
      }
      this.fillPacksList();
    }
  }
  onBarcodeTemplateChange(selectedTemplate) {
    this.containsGTIN = false;
    if (selectedTemplate) {
      this.containsGTIN = selectedTemplate.containsGTIN;
    }
  }
  //#region[Packs]
  onSaveUOMClick() {
    this.saveUOMSubject.next();
  }
  onCloseUOM() {
    this.newUOM.Close();
  }
  afterSaveNewUOM(uom) {
    if (uom) {
      this.resetPackTypeList.emit(true);
      this.packDefinitionForm.get('packTypeId').setValue(uom.packTypeId);
      this.seletedPackTypeName = uom.packTypeName;
    }
    this.onCloseUOM();
  }

  showUOMModal() {
    this.newUOM.Show(true).then(
      (res) => {
      }
    );
  }
  onDialogResult(event) {
    if (event && event.saveCLicked) {
      this.onSaveUOMClick();
    }
  }
  //#endregion

  //#region [Secondary Packs]
  initSecondaryPacksForm() {
    this.secondaryPackDefinitionForm = new FormGroup({
      packTypeId: new FormControl(null, Validators.required),
      secondaryPackQuantity: new FormControl(null, Validators.required),
      secondaryPackBarcode: new FormControl(null)
    });
  }
  fillSecondaryPacksList() {
    if (this.secondaryPacksList) {
      this.secondaryPacksDataSource = {
        data: this.secondaryPacksList,
        totalItems: this.secondaryPacksList.length,
      }
    } else {
      this.secondaryPacksDataSource = {
        data: [],
        totalItems: 0,
      }
    }

  }
  onAddSecondaryPack() {
    this.coreSession.markFormGroupTouched(this.secondaryPackDefinitionForm);
    if (this.secondaryPackDefinitionForm.invalid) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }

    // Validate Quantity with current added packs
    var quantity = +this.secondaryPackDefinitionForm.get('secondaryPackQuantity').value;
    if (this.secondaryPacksList.findIndex(x => x.quantity === quantity) >= 0) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgUniquePackQuantity));
      return;
    }
    let secondaryPack: any = {};
    // Validate UOM with current added packs
    var packTypeId = this.secondaryPackDefinitionForm.get('packTypeId').value;
    if (this.secondaryPacksList.findIndex(x => x.packTypeId === packTypeId) >= 0) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.Desc_UOM_Already_Added));
      return;
    }
    secondaryPack.packTypeId = this.selectedPackTypeId_secondary;
    secondaryPack.packType = this.selectedPackType_secondary;
    secondaryPack.secondaryPackId = this.maxSecondaryPackIdForAdd - 1;
    secondaryPack.quantity = quantity;
    secondaryPack.barcode = this.secondaryPackDefinitionForm.get('secondaryPackBarcode').value;
    this.secondaryPacksList.push(secondaryPack);
    this.fillSecondaryPacksList();

  }
  onChangeSecondaryPackType(selectedUOM) {

    if (selectedUOM) {
      this.selectedPackTypeId_secondary = selectedUOM.packTypeId;
      this.selectedPackType_secondary = selectedUOM.packTypeName;
    }
  }
  onRowOperationSecondaryPack(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
          (res: DialogResult) => {
            if (res === DialogResult.Yes) {
              if (event.object.secondaryPackId > 0) {
                //this pack is saved before so must check if it's used or not.
                this.isValidToDeleteSecondaryPack(event.object);
              }
              else {
                // this pack is not save before, so no need to validate delete it's never used.
                this.deleteSelectedSecondaryPack(event.object);
              }
            }
          });
        break;
      case RowOperation.edit:
        this.fillPackDefinitionToEdit(event.object);
        break;
    }
  }
  isValidToDeleteSecondaryPack(secondaryPack) {
    //this.coreSession.ModalLoading.Show();
    this.itemService.isSecondaryPackValidToDelete(secondaryPack.secondaryPackId).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.deleteSelectedSecondaryPack(secondaryPack);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      error => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  deleteSelectedSecondaryPack(secondaryPack) {
    var index = this.secondaryPacksList.findIndex(pack => pack.packId === secondaryPack.packId);
    if (index != -1) {
      // if (secondaryPack.dataAction === DataActions.Add) {
      this.secondaryPacksList.splice(index, 1);
      //  } else {
      //   this.secondaryPacksList[index].dataAction = DataActions.Delete;
      // }
      this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgDeletedSuccessfully));
      this.fillSecondaryPacksList();
    }

  }
  onValueChangeInSecondary(value: any) {
    const fieldIndex = this.secondaryPacksList.findIndex(x => x.secondaryPackId === value.secondaryPackId);
    if (fieldIndex > -1) {
      this.secondaryPacksList[fieldIndex].quantity = +value.quantity;
      this.secondaryPacksList[fieldIndex].barcode = value.barcode;
    }
  }
  //#endregion
  onValueChange(value: any) {
    const fieldIndex = this.sensorTableList.findIndex(x => x.sensorId === value.sensorId);
    if (fieldIndex > -1) {
      this.sensorTableList[fieldIndex].sensorMinValue = +value.sensorMinValue;
      this.sensorTableList[fieldIndex].sensorMaxValue = +value.sensorMaxValue;
    }
  }
  onCheckRowOperation(object: any) {
    const fieldIndex = this.sensorTableList.findIndex(x => x.sensorId === object.sensorId);
    if (fieldIndex > -1)
      this.sensorTableList[fieldIndex].isChecked = object.isChecked
  }
  onItemTypeDataChanged($event) {
    this.excludedItemIdsList = [];
    this.itemDefinitionForm.get('competitorId').setValidators(null);
    if ($event) {
      if ($event.itemTypeId === ItemTypes.CompetitorItem.valueOf()) {
        if (this.isEditMode && this.itemObject.itemId > -1) {
          this.excludedItemIdsList.push(this.itemObject.itemId);
        }
        this.populateCompetitorList();
        this.showCompetitorList = true;
        this.showItemList = true;
        this.showCompItemMultiSelect = false;
        this.itemDefinitionForm.get('competitorId').setValidators(Validators.required);
      } else if ($event.itemTypeId === ItemTypes.TradingItem.valueOf()) {
        this.populateAvailableCompetitorItemList($event.itemId);
        this.showCompItemMultiSelect = true;
        this.showCompetitorList = false;
        this.showItemList = false;
      } else {
        this.showCompItemMultiSelect = false;
        this.showCompetitorList = false;
        this.showItemList = false;
      }
    } else {
      this.showCompetitorList = false;
      this.showItemList = false;
      this.showCompItemMultiSelect = false;
    }
    this.itemDefinitionForm.get('competitorId').updateValueAndValidity();
  }

  populateCompetitorList() {
    //this.coreSession.ModalLoading.Show();
    this.isCompetitorsLoading = true;
    this.itemService.getCompetitorsList().subscribe(result => {
      this.competitorsList = result.data;
      this.isCompetitorsLoading = false;
      this.coreSession.ModalLoading.Hide();
    });
  }
  populateAvailableCompetitorItemList(itemId?: number) {
    //this.coreSession.ModalLoading.Show();
    this.isCompetitorItemsLoading = true;
    this.itemService.getAvailableCompetitorItemList(itemId).subscribe(result => {
      this.competitorItemList = result.data;
      this.isCompetitorItemsLoading = false;
      this.coreSession.ModalLoading.Hide();
    });
  }
  onVendorSelected(vendor: any) {
    if (vendor) {
      this.selectedVendor = vendor.vendorId;
    } else {
      this.selectedVendor = -1;
    }
  }

  onIsProductionDateSelected() {
    if (this.itemDefinitionForm.get('isDate').value) {
      this.itemDefinitionForm.get('isText').setValue(false);
    }
  }

  onIsProductionTextSelected() {
    if (this.itemDefinitionForm.get('isText').value) {
      this.itemDefinitionForm.get('isDate').setValue(false);
    }
  }

  onUploadImages(event) {
    if (event) {
      let files = event.srcElement.files;
      if (files && files.length > 0) {
        for (let index = 0; index < files.length; index++) {
          let imageFile = new ImageFileModel();
          imageFile.file = files[index];
          imageFile.name = files[index].name;
          const reader = new FileReader();
          reader.onload = (event: ProgressEvent) => {
            imageFile.path = (<FileReader>event.target).result;
          };
          reader.readAsDataURL(event.target.files[index]);
          this.attahcedImages.push(imageFile);
        }
      }
    }
  }

  onDeleteImage(imageIndex) {
    this.attahcedImages.splice(imageIndex, 1);
  }

}
