import { Component, OnInit, ViewChild } from "@angular/core";
import { Subject } from "rxjs";
import { ITableProperties } from "../../../../../shared/models/shared-table/table-properties.interface";
import { SharedTableResult } from "../../../../../shared/models/shared-table/shared-table-result.interface";
import { FormGroup, FormControl } from "@angular/forms";
import { ItemService } from "../../../../../shared/services/data-definition/product/item.service";
import { CoreSession } from "../../../../../core/core.session";
import { MultiSelectionOperation, RowOperation } from "../../../../../shared/models/enums/shared-table-operation.enum";
import { ConstantURLs } from "../../../../../shared/models/constants/constant-URL";
import { TranslateService } from "@ngx-translate/core";
import { ConstantMessages } from "../../../../../shared/models/constants/constant-message";
import { HttpErrorResponse } from "@angular/common/http";
import { DialogResult } from '../../../../../shared/models/enums/dialog-result.enum';
import { DialogMode } from '../../../../../shared/models/enums/dialog-mode.enum';
import { MenuActions } from '../../../../../shared/models/enums/menu-actions-enum';
import { ItemPackModel } from '../../../../../shared/models/Item/item.model';
import { ImportDataTypes } from '../../../../../shared/models/import/ImportDataTypes';
import { BrandService } from "../../../../../shared/services/data-definition/product/brand.service";
import { CommonButtonStyles } from "../../../../../shared/models/enums/common-button-styles.enum";
import { NavBarService } from "../../../../../core/sidebar/sidebar.service";
import { SharedDialogComponent } from "../../../../../shared/components/shared-dialog/shared-dialog.component";

@Component({
  selector: "app-items-list",
  templateUrl: "./items-list.component.html",
  styleUrls: ["./items-list.component.css"]
})
export class ItemsListComponent implements OnInit {
  itemFilterForm: FormGroup;
  isBrandsLoading = false;
  isModelsLoading = false;

  itemBrandList: any[] = [];
  allItemModelList: any[] = [];
  filteredItemModelList: any[] = [];
  saveSubject: Subject<void> = new Subject<void>();
  menuAction :MenuActions;
  TabelData: ITableProperties = {
    pageSize: 50,
    showPaginator: true,
    showSearch: true,
    isOnline: true,
    showSearchBtn: true,
    showNewBtn: false,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      {
        title: "Desc_Item_Name",
        key: "itemName",
        isSortable: true,
        width: "30%"
      },
      {
        title: "Desc_Item_Code",
        key: "itemCode",
        isSortable: true,
        width: "30%"
      },
      {
        title: "Desc_Item_Description",
        key: "packDefinition",
        isSortable: true,
        width: "20%"
      },
      {
        title: "Desc_Category_Name",
        key: "categoryNameCode",
        isSortable: true,
        width: "20%"
      }
    ]
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  itemsFilter: any = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: 50
    },
    itemCategoryId: -1,
    divisionId: -1,
    brandId: -1,
    modelId: -1,
    includeInactive: false,
    includePowerSKU:false,
    includeNew:false,
    includeInitiative: false,
    itemGroupMode:false,
    checkExpireIsNew :false
  };
  isEditMode = false;
  showSlider = false;
  itemObject: ItemPackModel;
  dataType:ImportDataTypes = ImportDataTypes.Items;

  constructor(
    private itemService: ItemService,
    private brandService: BrandService,
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private navService:NavBarService
  ) { }

  showSharedTable: boolean = false;

  ngOnInit() {
    this.navService.endtour.subscribe(() => {
      // Call the onTourEnd() function or perform any action
      this.navService.tourStatus = true;
      this.showSharedTable = this.navService.tourStatus;
    });

    this.showSharedTable = this.navService.tourStatus;
    this.coreSession.SetTitle("Items");
    this.fillItemBrandsList();
    this.fillItemModelList();
    this.initForm();
    this.populateItemsList();
    //this.checkExpireIsNewItemsList()
    this.TabelData.showNewBtn = this.coreSession.checkActivitiesAvailability(ConstantURLs.itemsURL, MenuActions.Add);
    this.TabelData.showImport=this.TabelData.showNewBtn;
    this.addMultiSelectActions();
    this.addEditAction()

  }

  addMultiSelectActions() {
    // if (this.coreSession.checkActivitiesAvailability(ConstantURLs.itemsURL, MenuActions.SetAsNew)) {
    //   this.TabelData.multiSelectionOperations.push({
    //     operation: MultiSelectionOperation.setAsNew,
    //     title: "Desc_Set_AS_New",
    //     icon: 'fa fa-tag',
    //     color: '#f1685e',
    //     style: CommonButtonStyles.Neutral.valueOf()
    //   })}

      // if (this.coreSession.checkActivitiesAvailability(ConstantURLs.itemsURL, MenuActions.SetAsPowerSKU)) {
      //   this.TabelData.multiSelectionOperations.push({
      //   operation: MultiSelectionOperation.setAsPowerSKU,
      //   title: "Desc_Set_As_PowerSKU",
      //   icon: 'fa fa-lightbulb-o',
      //   color: '#f1685e',
      //   style: CommonButtonStyles.Neutral.valueOf()
      // })}
      // if (this.coreSession.checkActivitiesAvailability(ConstantURLs.itemsURL, MenuActions.SetAsInitiative)) {
      //   this.TabelData.multiSelectionOperations.push({
      //   operation: MultiSelectionOperation.setAsInitiative,
      //   title: "Desc_Set_AS_Initiative",
      //   icon: 'fa fa-bolt',
      //   color: '#f1685e',
      //   style: CommonButtonStyles.Neutral.valueOf()
      //   })
    // }
    if (this.TabelData.multiSelectionOperations && this.TabelData.multiSelectionOperations.length > 0) {
      this.TabelData.isMultiSelection = true;
    }
  }
  addEditAction() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.itemsURL, MenuActions.Edit)) {
      this.TabelData.rowOperations.push(
        {
          operation: RowOperation.Deactivate,
          title: 'Desc_Deactivate',
          icon: 'fa-solid fa-ban',
          color: '#f1685e',
          showWhenKeyValueFalse: true,
          showHideOptionPerLine: true,
          controlKeyName: 'inactive'
        },
        // {
        //   operation: RowOperation.Activate,
        //   title: "Desc_Reactivate",
        //   icon: "fa fa-toggle-on",
        //   color: '#02b875',
        //   showWhenKeyValueTrue: true,
        //   showHideOptionPerLine: true,
        //   controlKeyName: 'inactive'
        // },
        {
          operation: RowOperation.edit,
          title: "Desc_Edit",
          icon: "fa-regular fa-pen-to-square",
          color: "#12344d"
        });

    }
  }
  initForm() {
    this.itemFilterForm = new FormGroup({
      divisionId: new FormControl(),
      itemCategoryId: new FormControl(),
      brandId: new FormControl(),
      modelId: new FormControl(),
      includeInactive: new FormControl(false),
      includePowerSKU: new FormControl(false),
      includeNew: new FormControl(false),
      includeInitiative: new FormControl(false)
    });
  }
  populateItemsList() {
    this.itemsFilter.divisionId = this.itemFilterForm.get("divisionId").value ? this.itemFilterForm.get("divisionId").value : -1;
    this.itemsFilter.itemCategoryId = this.itemFilterForm.get("itemCategoryId").value ? this.itemFilterForm.get("itemCategoryId").value : -1;
    this.itemsFilter.brandId = this.itemFilterForm.get("brandId").value ? this.itemFilterForm.get("brandId").value : -1;
    this.itemsFilter.modelId = this.itemFilterForm.get("modelId").value ? this.itemFilterForm.get("modelId").value : -1;
    this.itemsFilter.includeInactive = this.itemFilterForm.get("includeInactive").value ? this.itemFilterForm.get("includeInactive").value : false;
    this.itemsFilter.includePowerSKU = this.itemFilterForm.get("includePowerSKU").value ? this.itemFilterForm.get("includePowerSKU").value : false;
    this.itemsFilter.includeNew = this.itemFilterForm.get("includeNew").value ? this.itemFilterForm.get("includeNew").value : false;
    this.itemsFilter.includeInitiative = this.itemFilterForm.get("includeInitiative").value ? this.itemFilterForm.get("includeInitiative").value : false;
    this.itemsFilter.itemGroupMode = false;

    // this.coreSession.ModalLoading.Show();
    this.itemService.getItemsListSharedTable(this.itemsFilter).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.dataSource = {
            totalItems: response.data.totalItems,
            data: response.data.data,
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      error => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  checkExpireIsNewItemsList() {
    this.itemsFilter.checkExpireIsNew =  true;

    this.coreSession.ModalLoading.Show();
    this.itemService.getItemsListSharedTable(this.itemsFilter).subscribe(
      response => {

        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
       var itemsList = response.data.data;
       var isExpireNewItemList = []
       itemsList.forEach(item => {
        if (new Date() > new Date(item.isNewExpireDate))
          isExpireNewItemList.push(item);
       });
       this.itemService.UpdateItemsListIsNewExpireDate(isExpireNewItemList).subscribe((response)=>{
        console.log(response);
        if (response.status != null && response.status >= 0) {

        }


       })
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      error => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
    this.itemsFilter.checkExpireIsNew =  false;
  }
  fillItemBrandsList() {
    this.coreSession.ModalLoading.Show();
    this.isBrandsLoading = true;
    this.brandService.getItemBrand().subscribe(result => {
      this.itemBrandList = result.data;
      this.isBrandsLoading = false;
      this.coreSession.ModalLoading.Hide();
    });
  }
  fillItemModelList() {
    this.coreSession.ModalLoading.Show();
    this.isModelsLoading = true;
    this.itemService.getItemModel().subscribe(result => {
      this.allItemModelList = result.data;
      this.filteredItemModelList = [];
      if (this.isEditMode && this.itemObject.brandId && this.itemObject.brandId != -1) {
        this.fillBrandModelsList(this.itemObject.brandId);
      }
      this.isModelsLoading = false;
      this.coreSession.ModalLoading.Hide();
    });
  }
  fillBrandModelsList(brandId) {
    this.filteredItemModelList = [];
    this.filteredItemModelList = this.allItemModelList.filter(model => model.brandId === brandId);
  }
  onChangeItemBrand() {
    this.itemFilterForm.get('modelId').reset();
    if (this.itemFilterForm.get('brandId').value) {
      this.fillBrandModelsList(this.itemFilterForm.get('brandId').value);
    }
  }
  onChangeDivision() {
    this.itemFilterForm.get('itemCategoryId').reset();
  }
  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.edit:
        if (this.coreSession.checkActivitiesAvailability(ConstantURLs.itemsURL, MenuActions.Edit)) {
          this.openEditItem(event.object);
        }
        break;
      case RowOperation.Deactivate: {
        this.deactivateItem(event.object);
        break;
      }
      case RowOperation.Activate: {
        this.activateItem(event.object);
        break;
      }
    }
  }
  deactivateItem(item) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeactivateConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          this.coreSession.ModalLoading.Show();
          this.itemService.deactivateItem(item.itemId).subscribe(response => {
            this.coreSession.ModalLoading.Hide();
            if (response.status != null && response.status >= 0) {
              this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly));
              this.populateItemsList();
            } else {
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
            }
          },
            (error: HttpErrorResponse) => {
              this.coreSession.ModalLoading.Hide();
              this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
            }
          );
        }
      });
  }
  activateItem(item) {
    this.coreSession.ModalLoading.Show();
    this.itemService.activateItem(item.itemId).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly));
        this.populateItemsList();
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  openEditItem(object: any) {
    this.itemObject = object;
    this.isEditMode = true;
    this.showSlider = true;
    this.openItemEntryDialog()
  }
  @ViewChild('ItemEntryDialog', { static: true }) ItemEntryDialog: SharedDialogComponent;

  openItemEntryDialog() {
    this.ItemEntryDialog.Show(true).then((res) => { });
  }
  onMultiSelectionOperation(event: any) {
    switch (event.operation) {
      case MultiSelectionOperation.setAsNew: {
        this.menuAction = MenuActions.SetAsNew;
        this.onUpdateMultiSelectedItemsProparties(event.object , this.menuAction);
        break;
      }
      case MultiSelectionOperation.setAsPowerSKU: {
        this.menuAction = MenuActions.SetAsPowerSKU;
        this.onUpdateMultiSelectedItemsProparties(event.object, this.menuAction);
        break;
      }
      case MultiSelectionOperation.setAsInitiative: {
        this.menuAction = MenuActions.SetAsInitiative;
        this.onUpdateMultiSelectedItemsProparties(event.object, this.menuAction);
        break;
      }
    }
  }
  itemObj:object;
  onUpdateMultiSelectedItemsProparties(ItemActions, menuAction){
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgConfirmConfirmation),
    DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then((result: DialogResult) => {
      if (result === DialogResult.Yes) {
        const itemIds: string = ItemActions.map((item) => item.itemId.toString()).join(',');
        const itemObj = {
          itemIds: itemIds,
          selectedAction: menuAction,
        };

        this.itemService.updateSelectedItemsProperties(itemObj, menuAction)
        .subscribe(response => {
          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly));
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        },
          (error: HttpErrorResponse) => {
            this.coreSession.ModalLoading.Hide();
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
          }
        );
        this.populateItemsList()
      }
    })
  }

  onNewBtnClicked() {
    this.itemObject = null;
    this.isEditMode = false;
    this.showSlider = true;
    this.openItemEntryDialog()
  }
  closeSlider() {
    this.coreSession.SetTitle("Items");
    this.itemObject = null;
    this.isEditMode = false;
    this.showSlider = false;
    this.ItemEntryDialog.Close()

  }
  onSaveClick() {
    this.saveSubject.next();
  }
  afterSaveItem() {
    this.closeSlider();
    this.populateItemsList();

  }
  afterImportItem(){
    this.populateItemsList();
  }
  onTableFilterChanged(query: any) {
    this.itemsFilter.customListFilter = query;
    this.populateItemsList();
  }
  applySerachFilterOnFind() {
    this.itemsFilter.customListFilter.page = 0;
    this.populateItemsList();
  }


  onReset() {
    this.itemFilterForm.reset();
    this.itemFilterForm.get("includeInactive").setValue(false);
    this.itemFilterForm.get("includePowerSKU").setValue(false);
    this.itemFilterForm.get("includeNew").setValue(false);
    this.itemFilterForm.get("includeInitiative").setValue(false);
  }
}
