import { Routes, RouterModule } from "@angular/router";
import { AuthGuard } from "../../../core/auth/auth.gurad";
import { NgModule } from "@angular/core";
import { ConstantURLs } from "../../../shared/models/constants/constant-URL";
import { ItemMainComponent } from "./item-main/item-main.component";
import { DivisionListComponent } from "./division/division-list/division-list.component";
import { CategoryListComponent } from "./category/category-list/category-list.component";
import { BrandListComponent } from "./brand/brand-list/brand-list.component";
import { ItemsListComponent } from "./item/items-list/items-list.component";

const ItemsManagmentRouting: Routes = [
    {
        path: "",
        canActivate: [AuthGuard],
        component: ItemMainComponent,
        children: [
          {
            path: ConstantURLs.itemsURL,
            canActivate: [AuthGuard],
            component: ItemsListComponent,
        },
            {
                path: ConstantURLs.divisionsURL,
                canActivate: [AuthGuard],
                component: DivisionListComponent,
            },
            {
                path: ConstantURLs.categoriesURL,
                canActivate: [AuthGuard],
                component: CategoryListComponent,
            },
            {
                path: ConstantURLs.brandsURL,
                canActivate: [AuthGuard],
                component: BrandListComponent,
            },


            {
                path: "",
                canActivate: [AuthGuard],
                redirectTo: "/" + ConstantURLs.customerAppPropertiesURL + "/" + "items-Definition" + "/" + ConstantURLs.itemsURL, pathMatch: "full"
            }
        ]
    }
];
@NgModule({
    imports: [RouterModule.forChild(ItemsManagmentRouting)],
    exports: [RouterModule]
})
export class ItemsManagmentRoutingModule {
}
