import { NgModule } from "@angular/core";
import { SharedModule } from "../../../shared/shared.module";
import { TranslateModule } from "@ngx-translate/core";
import { FormsModule, ReactiveFormsModule } from "@angular/forms";
import { CommonModule } from "@angular/common";
import { NgSelectModule } from "@ng-select/ng-select";
import { NgMultiSelectDropDownModule } from "ng-multiselect-dropdown";
import { ItemsManagmentRoutingModule } from "./items-managment-routing.module";
import { ItemsEntryComponent } from "./item/items-entry/items-entry.component";
import { ItemsListComponent } from "./item/items-list/items-list.component";
import { ItemMainComponent } from "./item-main/item-main.component";
import { DivisionEntryComponent } from "./division/division-entry/division-entry.component";
import { CategoryListComponent } from "./category/category-list/category-list.component";
import { DivisionListComponent } from "./division/division-list/division-list.component";
import { CategoryEntryComponent } from "./category/category-entry/category-entry.component";
import { BrandEntryComponent } from "./brand/brand-entry/brand-entry.component";
import { BrandListComponent } from "./brand/brand-list/brand-list.component";
import { ItemUomEntryComponent } from "./item/item-uom-entry/item-uom-entry.component";
import { OwlDateTimeModule, OwlNativeDateTimeModule } from "ng-pick-datetime";
import { NgbModule } from "@ng-bootstrap/ng-bootstrap";
import { DragDropModule } from "@angular/cdk/drag-drop";
import { MatExpansionModule } from "@angular/material/expansion";
import { TabsModule } from "ngx-bootstrap/tabs";
import { NgxEchartsModule } from "ngx-echarts";
import { NgOptionHighlightModule } from "@ng-select/ng-option-highlight";

@NgModule({
  declarations: [
    ItemMainComponent,
    DivisionListComponent,
    DivisionEntryComponent,
    CategoryListComponent,
    CategoryEntryComponent,
    BrandListComponent,
    BrandEntryComponent,
    ItemsListComponent,
    ItemsEntryComponent,

    ItemUomEntryComponent,
  ],
  imports: [
    NgSelectModule,
    NgMultiSelectDropDownModule,
    ItemsManagmentRoutingModule,
    CommonModule,
    ReactiveFormsModule,
    FormsModule,
    SharedModule,
    OwlDateTimeModule,
    OwlNativeDateTimeModule,
    NgbModule,
    DragDropModule,
    MatExpansionModule,
    TranslateModule.forChild(),
    TabsModule.forRoot(),
    NgSelectModule,
    NgxEchartsModule,
    NgOptionHighlightModule,
  ],
  exports: [],
})
export class ItemsManagmentModule {}
