import { Component, OnDestroy, OnInit, ViewChild } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { CoreSession } from '../../../../core/core.session';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { NavBarService } from '../../../../core/sidebar/sidebar.service';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { NavigationData } from '../../../../shared/models/navigation-data/navigation-data.model';
import { TranslateService } from "@ngx-translate/core";
import { MenuModel } from '../../../../shared/models/menu/menu.model';
import { Subject, Subscription } from 'rxjs';
import { ShepherdService } from 'angular-shepherd';
import { TourService } from '../../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../../shared/shepherd-config/trackTour.service';
import { SharedDialogComponent } from '../../../../shared/components/shared-dialog/shared-dialog.component';
@Component({
  selector: 'app-dynamic-form-card',
  templateUrl: './dynamic-form-card.component.html',
  styleUrls: ['./dynamic-form-card.component.css']
})
export class DynamicFormCardComponent implements OnInit, OnDestroy {
  @ViewChild('DynamicEntryDialog', { static: true }) DynamicEntryDialog: SharedDialogComponent;
  showSaveEntry:boolean = true;
  masterDataMainMenus: any[];
  fullRoute : string;
  customerAppBannersComponent = false;
  showSlider = false;
  sliderDescription: String = '';
  isCustAppBannersMenuVisible: boolean = true;
  MobileSettingMenuVisible:boolean = true;
  saveSubject: Subject<void> = new Subject<void>();
  notificationManagementComponent = false;
  isSendNotificationMenuVisible: boolean = true;
  isCustAppSettingMenuVisible : boolean = true;
  customerAppSettingsComponent: boolean = false;
  isCompanyDetailsMenuVisible: boolean = true;
  constructor(private sessionDataProvider: SessionDataProvider,
    public coreSession: CoreSession,
    private router: Router,
    private navService: NavBarService,
  private translateService : TranslateService,
  private readonly shepherdService: ShepherdService,
  private tourService: TourService,
  private componentVisitService: ComponentVisitService
  ) {
  }

  tourSubscription:Subscription
  ngOnInit() {
    this.fullRoute = '/' + ConstantURLs.dataDefinitionURL + '/' + ConstantURLs.masterURL + '/' ;
    this.prepareMasterDataMenus();
    this.setNavigation(undefined);
    this.checkExistedMenus()

    this.tourSubscription = this.tourService.startTourMain$.subscribe(() => {
      this.startTour(true);
    });
  }
  ngOnDestroy() {
    if (this.tourStartTimeout) {

      clearTimeout(this.tourStartTimeout);
    }
    if(this.shepherdService.tourObject)
      this.shepherdService.cancel()

    this.componentVisitService.markComponentVisited('employee-dynamic-card-entry');

    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }
    // this.navService.setNavigation([]);
  }
  private tourStartTimeout: any;

  startTour(forceTour?){
    this.tourStartTimeout = setTimeout(() => {

      if(!forceTour)
      if (this.tourService.isTourCompletedForComponent('employee-dynamic-card-entry')) {

        return;
}

if(this.tourService.isFirstTour() || forceTour){

  const titles = [];
  const texts = [];
  const elementSelectors = [];

      // Generate titles and texts based on main menus and their child menus
      this.masterDataMainMenus.forEach((mainMenu, index) => {
        elementSelectors.push(`#column-${index}`);

        let mainMenuTitle = '';
        let mainMenuText = '';

        switch (mainMenu.menuName) {
          case 'Finance':
            mainMenuTitle = 'Finance Overview';
            mainMenuText = 'Manage financial settings and data.';
            break;
            case 'General':
              mainMenuTitle = 'General Settings';
              mainMenuText = 'Manage general settings and information.';
              break;
              // Add cases for other main menus as needed
              default:
                mainMenuTitle = mainMenu.menuName;
                mainMenuText = `Manage ${mainMenu.menuName.toLowerCase()} settings.`;
                break;
              }

              titles.push(mainMenuTitle);
              texts.push(mainMenuText);

              mainMenu.childMenus.forEach((menu, childIndex) => {
                elementSelectors.push(`#column-child-${index}-${childIndex}`);

                let title = '';
                let text = '';

          // Use a switch case to generate title and text based on the child menu's url
          switch (mainMenu.menuName) {
            case 'Finance':
              switch (menu.url) {
                case 'currencies':
                  title = 'Currencies';
                  text = 'Manage the different currencies used in transactions.';
                  break;
                case 'currency-rates':
                  title = 'Currency Rates';
                  text = 'Define and manage exchange rates for different currencies.';
                  break;
                  case 'banks':
                    title = 'Banks';
                    text = 'Manage information about banks.';
                    break;
                    case 'branches':
                      title = 'Branches';
                  text = 'Manage information about bank branches.';
                  break;
                case 'tax-type':
                  title = 'Tax Type';
                  text = 'Define different tax types applicable to transactions.';
                  break;
                default:
                  title = menu.menuName;
                  text = `Manage ${menu.menuName.toLowerCase()}.`;
                  break;
              }
              break;
            case 'General':
              switch (menu.url) {
                case 'organizations':
                  title = 'Vendor';
                  text = 'Manage vendor information.';
                  break;
                  case 'organization-type':
                    title = 'Vendor Type';
                    text = 'Define different types of vendors.';
                    break;
                    case 'master-item-group':
                      title = 'Master Item Group';
                      text = 'Manage groups of master items.';
                  break;
                default:
                  title = menu.menuName;
                  text = `Manage ${menu.menuName.toLowerCase()}.`;
                  break;
                }
              break;
            default:
              title = mainMenu.menuName;
              text = `Manage ${mainMenu.menuName.toLowerCase()} settings.`;
              break;
            }

            titles.push(title);
          texts.push(text);
        });
      });



      // Add additional element selectors and corresponding titles and texts if necessary
      if (this.MobileSettingMenuVisible) {
        elementSelectors.push('#mobile-setting');
        titles.push('Mobile Setting');
        texts.push('Configure mobile application settings.');

        if (this.isCustAppBannersMenuVisible) {
          elementSelectors.push('#banner');
          titles.push('Customer App Banners');
          texts.push('Manage banners for the customer app.');
        }

        if (this.isSendNotificationMenuVisible) {
          elementSelectors.push('#send-notification');
          titles.push('Send Notification');
          texts.push('Send notifications to app users.');
        }

        if (this.isCustAppSettingMenuVisible) {
          elementSelectors.push('#customer-app');
          titles.push('Customer App Setting');
          texts.push('Configure settings for the customer app.');
        }

        if (this.isCompanyDetailsMenuVisible) {
          elementSelectors.push('#company');
          titles.push('Company Details');
          texts.push('Manage company details.');
        }
      }

      const steps = this.tourService.generateSteps(elementSelectors, titles, texts);
      this.tourService.defaultStepOptions.scrollTo = true;
      this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
      this.shepherdService.modal = true;
      this.shepherdService.addSteps(steps);
      this.shepherdService.start();
    }
    }, 1000);
  }
  ngAfterViewInit() {
    this.startTour()
  }


  checkIfCustAppBannersMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '100-010-03-01').length < 1) {
      this.isCustAppBannersMenuVisible = false;
    }

  }
   checkIfCustMobileSettingMenuVisible(menu: MenuModel[]) {
      if (menu.filter(x => x.menuId === '100-010-03').length < 1) {
        this.MobileSettingMenuVisible = false;
      }
    }

    checkIfCustAppPropertiesMenuVisible(menu: MenuModel[]) {
      if (menu.filter(x => x.menuId === '100-010-03-02').length < 1) {
        this.isSendNotificationMenuVisible = false;
      }
    }

    checkIfCustAppSettingMenuVisible(menu: MenuModel[]) {
      if (menu.filter(x => x.menuId === '100-010-03-03').length < 1) {
        this.isCustAppSettingMenuVisible = false;
      }
    }
    checkIfCompanyDetailsMenuVisible(menu: MenuModel[]) {
      if (menu.filter(x => x.menuId === '100-010-03-04').length < 1) {
        this.isCompanyDetailsMenuVisible = false;
      }

    }
    openCompanyDetailsMenu() {

      this.router.navigate(['/' + ConstantURLs.dataDefinitionURL + '/' + ConstantURLs.masterURL + '/' + ConstantURLs.companyDetailsURL]);
       var menu = {
        menuName : 'Desc_Company_Details'
       }
      this.setNavigation(menu);

    }
    openDynamicEntryDialog() {
      this.DynamicEntryDialog.Show(true).then((res) => { });
    }
  openCustomerAppBannersMenu() {
    this.customerAppBannersComponent = true;
    this.showSlider = true;
    this.sliderDescription = this.translateService.instant('Desc_Banners');
    this.showSaveEntry= false
    this.openDynamicEntryDialog()

  }
  openSendNotificationMenu() {
    this.coreSession.SetTitle("Notification Management");
    this.showSlider = true;
    this.notificationManagementComponent = true;
    this.sliderDescription = this.translateService.instant('Desc_Send_Notification');
    this.showSaveEntry = true
    this.openDynamicEntryDialog()
  }
  openCustomerSettingsMenu() {
    this.customerAppSettingsComponent = true;
    this.showSlider = true;
    this.sliderDescription = this.translateService.instant('Desc_Customer_App_Settings');
    this.showSaveEntry = true;
    this.openDynamicEntryDialog()
  }
  close() {
    this.showSlider = false;
    // this.changeLanguageComponent = false;
    // this.customerAppPropertiesComponent = false;
    this.customerAppBannersComponent = false;
    this.notificationManagementComponent = false;
    // this.customerAppItemsComponent = false;
    // this.isFQAsComponent = false;
    // this.customerAppFirstOrderItemsComponent = false;
     this.customerAppSettingsComponent = false;
     this.DynamicEntryDialog.Close()
  }
  onSendCompleted() {
    this.notificationManagementComponent = false;
    this.close();
  }
  onSaveDescriptions() {
    this.saveSubject.next();
  }
  onCustomerAppSettingsSaved() {
    this.customerAppSettingsComponent = false;
    this.showSlider = false;
  }
  setNavigation(menu) {
    let navigationList: NavigationData[] = [];
    if (menu) {
      navigationList.push(
        {
          Name: 'Desc_Data_Definition',
          URL: ConstantURLs.dataDefinitionURL
        },
        {
          Name: 'Desc_Advance_Settings',
          URL: ConstantURLs.dataDefinitionURL + '/' + ConstantURLs.masterURL
        },
        {
          Name: menu.menuName,
          URL: undefined//ConstantURLs.dataDefinitionURL + '/' + ConstantURLs.masterURL + '/' + this.url
        }
      );
    }
    else {
      navigationList.push(
        {
          Name: 'Desc_Data_Definition',
          URL: ConstantURLs.dataDefinitionURL
        },
        {
          Name: 'Desc_Data_Definition',
          URL: undefined //ConstantURLs.dataDefinitionURL + '/' + ConstantURLs.masterURL
        }
      );
    }
    this.navService.setNavigation(navigationList);
  }
  prepareMasterDataMenus() {
    this.masterDataMainMenus = [];

    for (let masterDataCategory of this.sessionDataProvider.allMenusAvailable.filter(x => x.parentMenuId === '100-010')) {
      let mainMenu = {
        menuName: masterDataCategory.menuName,
        childMenus: []
      };
      for (let menu of this.sessionDataProvider.allMenusAvailable.filter(x => x.parentMenuId === masterDataCategory.menuId &&  x.parentMenuId !== '100-010-03')) {
        let subMenu = {
          menuName: menu.menuName,
          url: menu.url,
          icon: menu.icon,
        };
        mainMenu.childMenus.push(subMenu);
      }
      if (mainMenu.childMenus && mainMenu.childMenus.length > 0) {
        this.masterDataMainMenus.push(mainMenu);
      }
    }
  }
  onChangeSeletedMenu(menu) {
    this.router.navigate(['/' + ConstantURLs.dataDefinitionURL + '/' + ConstantURLs.masterURL + '/' + menu.url]);
    menu.isActive = true;
    this.setNavigation(menu);
  }

  checkExistedMenus() {
    this.checkIfCustMobileSettingMenuVisible(this.sessionDataProvider.allMenusAvailable)
    this.checkIfCustAppPropertiesMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfCustAppBannersMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfCustAppSettingMenuVisible(this.sessionDataProvider.allMenusAvailable);
     this.checkIfCompanyDetailsMenuVisible(this.sessionDataProvider.allMenusAvailable);

  }
}
