import { HttpErrorResponse } from '@angular/common/http';
import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, NavigationEnd, Router } from '@angular/router';
import { TranslateService } from '@ngx-translate/core';
import { CoreSession } from '../../../../core/core.session';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { NavBarService } from '../../../../core/sidebar/sidebar.service';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { MasterDataService } from '../../master-data.service';

@Component({
  selector: 'app-master-data-dynami-main',
  templateUrl: './master-data-dynami-main.component.html',
  styleUrls: ['./master-data-dynami-main.component.css']
})
export class MasterDataDynamiMainComponent implements OnInit {
  masterDataCategoryList: any[] = [];
  constructor(private sessionDataProvider: SessionDataProvider,
    public coreSession: CoreSession,
    private navService: NavBarService) {
  }
  ngOnInit() {
  }
  ngOnDestroy() {
    this.navService.setNavigation([]);
  }
}
